/*
%%% copyright-cmetz-98
This software is Copyright 1998 by Craig Metz, All Rights Reserved.
The Inner Net License Version 2 applies to this software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

*/
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>
#ifdef AF_LINK
#include <net/if_dl.h>
#endif /* AF_LINK */
#include <errno.h>

#include "support.h"

struct if_nameindex *if_nameindex(void)
{
  int i, j, fd;
  struct if_nameindex *nameindex = NULL;
  struct ifconf ifconf;
  void *p;
  int len;
  char lastname[IFNAMSIZ + 1];

  if ((fd = socket(PF_INET, SOCK_DGRAM, 0)) < 0)
    return NULL;

  if (__siocgifconf(fd, &ifconf)) {
    close(fd);
    return NULL;
  };

  i = sizeof(struct if_nameindex);
  j = 0;
  p = ifconf.ifc_buf;
  len = ifconf.ifc_len;
  lastname[0] = 0;
  lastname[IFNAMSIZ] = 0;

  while(len > 0) {
    if (len < (IFNAMSIZ + sizeof(struct sockaddr)))
      goto ret;
    if (strncmp(lastname, p, IFNAMSIZ)) {
      memcpy(lastname, p, IFNAMSIZ);
      i += sizeof(struct if_nameindex);
      j += strlen(lastname) + 1; 
    };
    len -= IFNAMSIZ;
    p += IFNAMSIZ;

    if (len < SA_LEN((struct sockaddr *)p))
      goto ret;
    len -= SA_LEN((struct sockaddr *)p);
    p += SA_LEN((struct sockaddr *)p);
  };

  if (!(nameindex = malloc(i + j))) {
    errno = ENOMEM;
    goto ret;
  };
  memset(nameindex, 0, i + j);

  {
#ifdef SIOCGIFINDEX
  struct ifreq ifreq;
#endif /* SIOCGIFINDEX */
  struct if_nameindex *n;
  char *c;

  n = nameindex;
  p = ifconf.ifc_buf;
  c = (void *)nameindex + i;
  i = 0;
  len = ifconf.ifc_len;
  lastname[0] = 0;

  while(len > 0) {
    if (len < (IFNAMSIZ + sizeof(struct sockaddr)))
      goto ret;
    if (strncmp(lastname, p, IFNAMSIZ)) {
      if (i) {
	if (!n->if_index) {
#ifdef SIOCGIFINDEX
	strcpy(ifreq.ifr_name, lastname);
	if (ioctl(fd, SIOCGIFINDEX, &ifreq))
	  goto ret;
	n->if_index = ifreq.ifr_ifindex;
#else /* SIOCGIFINDEX */
	n->if_index = i;
#endif /* SIOCGIFINDEX */
	};
	n++;
      };
      i++;
      memcpy(lastname, p, IFNAMSIZ);
      strcpy(n->if_name = c, lastname);
      c += strlen(c) + 1;
    };
    len -= IFNAMSIZ;
    p += IFNAMSIZ;

    if (len < SA_LEN((struct sockaddr *)p))
      goto ret;
#ifdef AF_LINK
    if (((struct sockaddr *)p)->sa_family == AF_LINK)
      n->if_index = ((struct sockaddr_dl *)p)->sdl_index;
#endif /* AF_LINK */
    len -= SA_LEN((struct sockaddr *)p);
    p += SA_LEN((struct sockaddr *)p);
  };

  if (!n->if_index) {
#ifdef SIOCGIFINDEX
    strcpy(ifreq.ifr_name, lastname);
    if (ioctl(fd, SIOCGIFINDEX, &ifreq))
      goto ret;
    n->if_index = ifreq.ifr_ifindex;
#else /* SIOCGIFINDEX */
    n->if_index = i;
#endif /* SIOCGIFINDEX */
  };
  };

ret:
  close(fd);
  free(ifconf.ifc_buf);
  return nameindex;
};
