/*
%%% copyright-cmetz-98
This software is Copyright 1998 by Craig Metz, All Rights Reserved.
The Inner Net License Version 2 applies to this software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

*/
#include <sys/types.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>
#ifdef AF_LINK
#include <net/if_dl.h>
#endif /* AF_LINK */
#include <errno.h>

#include "support.h"

static char __name[IFNAMSIZ + 1];

/* #undef SIOCGIFNAME */

char *if_indextoname(unsigned int index, char *name)
{
  int i, fd;
#ifdef SIOCGIFNAME
  struct ifreq ifreq;
#else /* SIOCGIFNAME */
  struct ifconf ifconf;
  void *p;
  int len;
  char lastname[IFNAMSIZ + 1];
  char iname[IFNAMSIZ + 1];
  char *retname = NULL;
#endif /* SIOCGIFNAME */

  if ((fd = socket(PF_INET, SOCK_DGRAM, 0)) < 0)
    return 0;

  if (!name)
    name = __name;

#ifdef SIOCGIFNAME
  ifreq.ifr_ifindex = index;
  i = ioctl(fd, SIOCGIFNAME, &ifreq);
  close(fd);
  if (i)
    return NULL;

  strcpy(name, ifreq.ifr_name);
  return name;
#else /* SIOCGIFNAME */
  if (__siocgifconf(fd, &ifconf)) {
    close(fd);
    return NULL;
  };

  i = 0;
  p = ifconf.ifc_buf;
  len = ifconf.ifc_len;
  lastname[0] = 0;
  lastname[IFNAMSIZ] = 0;
  iname[0] = 0;

  while(len > 0) {
    if (len < (IFNAMSIZ + sizeof(struct sockaddr)))
      goto ret;
    if (strncmp(lastname, p, IFNAMSIZ)) {
      if (i == index)
	strcpy(iname, lastname);
      memcpy(lastname, p, IFNAMSIZ);
      i++;
    };
    len -= IFNAMSIZ;
    p += IFNAMSIZ;

#ifdef AF_LINK
    if (((struct sockaddr *)p)->sa_family == AF_LINK)
      if (((struct sockaddr_dl *)p)->sdl_index == index) {
	strcpy(retname = name, lastname);
	goto ret;
      };
#endif /* AF_LINK */

    if (len < SA_LEN((struct sockaddr *)p))
      goto ret;
    len -= SA_LEN((struct sockaddr *)p);
    p += SA_LEN((struct sockaddr *)p);
  };

  if (i == index)
    strcpy(iname, lastname);

  if (iname[0])
    strcpy(retname = name, iname);

ret:
  close(fd);
  free(ifconf.ifc_buf);
  return retname;
#endif /* SIOCGIFNAME */
};
