/*
%%% copyright-cmetz-97
This software is Copyright 1997-1998 by Craig Metz, All Rights Reserved.
The Inner Net License Version 2 applies to this software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

*/

#include <sys/types.h>
#include <netdb.h>
#include <errno.h>

#define THREAD_SAFE 0

#if !THREAD_SAFE
static char buffer[256];
#endif /* !THREAD_SAFE */

char *gai_strerror(int errnum)
{
  switch(errnum) {
    case 0:
      return "no error";
    case EAI_BADFLAGS:
      return "invalid value for ai_flags";
    case EAI_NONAME:
      return "name or service is not known";
    case EAI_AGAIN:
      return "temporary failure in name resolution";
    case EAI_FAIL:
      return "non-recoverable failure in name resolution";
    case EAI_NODATA:
      return "no address associated with name";
    case EAI_FAMILY:
      return "ai_family not supported";
    case EAI_SOCKTYPE:
      return "ai_socktype not supported";
    case EAI_SERVICE:
      return "service not supported for ai_socktype";
    case EAI_ADDRFAMILY:
      return "address family for name not supported";
    case EAI_MEMORY:
      return "memory allocation failure";
    case EAI_SYSTEM:
#if THREAD_SAFE
      return "system error";
#else /* THREAD_SAFE */
      snprintf(buffer, sizeof(buffer)-1, "system error: %s(%d)", strerror(errno), errno);
      buffer[sizeof(buffer)-1] = 0;
      return buffer;
#endif /* THREAD_SAFE */
    default:
#if THREAD_SAFE
      return "unknown/invalid error";
#else /* THREAD_SAFE */
      snprintf(buffer, sizeof(buffer)-1, "unknown/invalid error %d", errnum);
      buffer[sizeof(buffer)-1] = 0;
      return buffer;
#endif /* THREAD_SAFE */
  };
};
