/*
%%% portions-copyright-cmetz-98
Portions of this software are Copyright 1998 by Craig Metz, All Rights
Reserved. The Inner Net License Version 2 applies to these portions of
the software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

*/
#include <sys/types.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <net/if.h>
#include <sys/ioctl.h>
#include <errno.h>

int __siocgifconf(int fd, struct ifconf *ifconf)
{
  int i, j;

  ifconf->ifc_len = 0;
  ifconf->ifc_buf = 0;
  if (!ioctl(fd, SIOCGIFCONF, (void *)ifconf) && ifconf->ifc_len) {
    if (!(ifconf->ifc_buf = malloc(ifconf->ifc_len))) {
      errno = ENOMEM;
      return -1;
    };
    if (ioctl(fd, SIOCGIFCONF, (void *)ifconf)) {
      free(ifconf->ifc_buf);
      return -1;
    };
    return 0;
  };

  for (i = 5; i < 12; i++) {
    if (!(ifconf->ifc_buf = malloc(ifconf->ifc_len = j = sizeof(struct ifconf) * (1 << i)))) {
      errno = ENOMEM;
      return -1;
    };
    if (ioctl(fd, SIOCGIFCONF, (void *)ifconf)) {
      free(ifconf->ifc_buf);
      return -1;
    };
    if ((ifconf->ifc_len > IFNAMSIZ + sizeof(struct sockaddr))
        && (ifconf->ifc_len < j))
      return 0;
    free(ifconf->ifc_buf);
  };
  return -1;
};

