/*
%%% copyright-cmetz-98
This software is Copyright 1998 by Craig Metz, All Rights Reserved.
The Inner Net License Version 2 applies to this software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

*/
#ifndef _INET6APPS_TYPES_H
#define _INET6APPS_TYPES_H 1

#include_next <sys/types.h>

#ifndef _INET6APPS_SKIP_GENERIC_TYPES_H
#if !HAVE_POSIX1G_TYPES
#if (~0UL) == 0xffffffff
#define uint8_t unsigned char
#define int16_t short
#define uint16_t unsigned short
#define int32_t long
#define uint32_t unsigned long
#define int64_t long long
#define uint64_t unsigned long long
#else /* (~0UL) == 0xffffffff */
#if (~0UL) == 0xffffffffffffffff
#define uint8_t unsigned char
#define int16_t short
#define uint16_t unsigned short
#define int32_t int
#define uint32_t unsigned int
#define int64_t long
#define uint64_t unsigned long
#else /* (~0UL) == 0xffffffffffffffff */
#error Neither 32 bit nor 64 bit word size detected.
#error You need to define the bit types manually.
#endif /* (~0UL) == 0xffffffffffffffff */
#endif /* (~0UL) == 0xffffffff */
#define HAVE_POSIX1G_TYPES 1
#endif /* !HAVE_POSIX1G_TYPES */

#endif /* _INET6APPS_SKIP_GENERIC_TYPES_H */
#endif /* _INET6APPS_TYPES_H */
