/*
%%% copyright-cmetz-98
This software is Copyright 1998 by Craig Metz, All Rights Reserved.
The Inner Net License Version 2 applies to this software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

*/
#ifndef _INET6APPS_SOCKET_H
#define _INET6APPS_SOCKET_H

#include_next <sys/socket.h>

#ifndef PF_INET6
#if __bsdi__ || __NetBSD__ || __OpenBSD__ || __FreeBSD__
#define PF_INET6 24
#define AF_INET6 24
#endif /* __bsdi__ || __NetBSD__ || __OpenBSD__ || __FreeBSD__ */
#endif /* PF_INET6 */

/* If these declarations cause an error, the order in which you are including
   certain header files is wrong. <sys/socket.h> is supposed to come first. */
struct sockaddr_in {};
struct sockaddr_in6 {};
struct sockaddr_un {};

union sockaddr_union {
  struct sockaddr sa;
  struct sockaddr_in sin;
  struct sockaddr_in6 sin6;
  struct sockaddr_un sun;
  char __pad[128];
};

#ifndef CMSG_ALIGN
#define CMSG_ALIGN(len) (((len)+sizeof(long)-1) & ~(sizeof(long)-1))
#endif /* CMSG_ALIGN */
#ifndef CMSG_LEN
#define CMSG_LEN(len) (CMSG_ALIGN(sizeof(struct cmsghdr)) + (len))
#endif /* CMSG_LEN */
#ifndef CMSG_SPACE
#define CMSG_SPACE(len) (CMSG_ALIGN(sizeof(struct cmsghdr)) + CMSG_ALIGN(len))
#endif /* CMSG_SPACE */

#ifdef SA_LEN
#undef SA_LEN
#endif /* SA_LEN */

#if SALEN
#define SA_LEN(x) ((struct sockaddr *)x)->sa_len
#else /* SALEN */
unsigned int __sa_len(const struct sockaddr *);
#define SA_LEN(x) __sa_len((struct sockaddr *)x)
#endif /* SALEN */
#endif /* _INET6APPS_SOCKET_H */
