/*
%%% copyright-cmetz-96
Portions of this software are Copyright 1996-1998 by Craig Metz, All Rights
Reserved. The Inner Net License Version 2 applies to these portions of
the software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

*/

#ifndef _INET6APPS_NETDB_H
#define _INET6APPS_NETDB_H 1

#include_next <netdb.h>

#ifndef _INET6APPS_SKIP_GENERIC_NETDB_H
#include <sys/types.h>

#undef AI_PASSIVE
#undef AI_CANONNAME
#undef AI_NUMERICHOST
#undef AI_EXT
#define AI_PASSIVE     1 /* Socket address is intended for bind() */
#define AI_CANONNAME   2 /* Request for canonical name */
#define AI_NUMERICHOST 4 /* Don't ever try nameservice */
#define AI_EXT         8 /* Enable extensions, be more useful but less strictly
			    POSIX compliant. */

#undef EAI_BADFLAGS
#undef EAI_NONAME
#undef EAI_AGAIN
#undef EAI_FAIL
#undef EAI_NODATA
#undef EAI_FAMILY
#undef EAI_SOCKTYPE
#undef EAI_ADDRFAMILY
#undef EAI_MEMORY
#undef EAI_SYSTEM
#define EAI_BADFLAGS     -1 /* invalid value for ai_flags */
#define EAI_NONAME       -2 /* name or service is not known */
#define EAI_AGAIN        -3 /* temporary failure in name resolution */
#define EAI_FAIL         -4 /* non-recoverable failure in name resolution */
#define EAI_NODATA       -5 /* no address associated with name */
#define EAI_FAMILY       -6 /* ai_family not supported */
#define EAI_SOCKTYPE     -7 /* ai_socktype not supported */
#define EAI_SERVICE      -8 /* service not supported for ai_socktype */
#define EAI_ADDRFAMILY   -9 /* address family for name not supported */
#define EAI_MEMORY      -10 /* memory allocation failure */
#define EAI_SYSTEM      -11 /* system error (code indicated in errno) */

struct addrinfo {
  int ai_flags;             /* input flags */
  int ai_family;            /* protocol family for socket */
  int ai_socktype;          /* socket type */
  int ai_protocol;          /* protocol for socket */
  int ai_addrlen;           /* length of socket-address */
  struct sockaddr *ai_addr; /* socket-address for socket */
  char *ai_canonname;       /* canonical name for service location (iff req) */
  struct addrinfo *ai_next; /* pointer to next in list */
};

int getaddrinfo(const char *name, const char *service,
		const struct addrinfo *req, struct addrinfo **pai);

void freeaddrinfo(struct addrinfo *ai);

char *gai_strerror(int ecode);

#undef NI_MAXHOST
#undef NI_MAXSERV
#define NI_MAXHOST 1025
#define NI_MAXSERV 32

#undef NI_NUMERICHOST
#undef NI_NUMERICSERV
#undef NI_NOFQDN
#undef NI_NAMEREQD
#undef NI_DGRAM
#define NI_NUMERICHOST 1
#define NI_NUMERICSERV 2
#define NI_NOFQDN 4
#define NI_NAMEREQD 8
#define NI_DGRAM 16

int getnameinfo(const struct sockaddr *sa, size_t addrlen, char *host, size_t hostlen, char *serv, size_t servlen, int flags);

int inet_pton(int af, const char *cp, void *ap);
const char *inet_ntop(int af, const void *ap, char *cp, size_t len);
#endif /* _INET6APPS_SKIP_GENERIC_NETDB_H */
#endif /* _INET6APPS_NETDB_H_ */
