/*
%%% portions-copyright-cmetz-96
Portions of this software are Copyright 1996-1998 by Craig Metz, All Rights
Reserved. The Inner Net License Version 2 applies to these portions of
the software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

*/
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#include "support.h"

int satoport(char *port, int portlen, struct sockaddr *sa)
{
  switch(sa->sa_family) {
    case AF_INET:
      snprintf(port, portlen, "%u,%u,%u,%u,%u,%u",
	      ((uint8_t *)(&((struct sockaddr_in *)sa)->sin_addr))[0],
	      ((uint8_t *)(&((struct sockaddr_in *)sa)->sin_addr))[1],
	      ((uint8_t *)(&((struct sockaddr_in *)sa)->sin_addr))[2],
	      ((uint8_t *)(&((struct sockaddr_in *)sa)->sin_addr))[3],
	      ((uint8_t *)(&((struct sockaddr_in *)sa)->sin_port))[0],
	      ((uint8_t *)(&((struct sockaddr_in *)sa)->sin_port))[1]);
      return 0;
#if INET6
    case AF_INET6:
      if (IN6_IS_ADDR_V4MAPPED(&((struct sockaddr_in6 *)sa)->sin6_addr)) {
	snprintf(port, portlen, "%u,%u,%u,%u,%u,%u",
		((uint8_t *)(&((struct sockaddr_in6 *)sa)->sin6_addr))[12],
		((uint8_t *)(&((struct sockaddr_in6 *)sa)->sin6_addr))[13],
		((uint8_t *)(&((struct sockaddr_in6 *)sa)->sin6_addr))[14],
		((uint8_t *)(&((struct sockaddr_in6 *)sa)->sin6_addr))[15],
		((uint8_t *)(&((struct sockaddr_in6 *)sa)->sin6_port))[0],
		((uint8_t *)(&((struct sockaddr_in6 *)sa)->sin6_port))[1]);
	return 0;
      }
      return 1;
#endif /* INET6 */
  }
  return 1;
}

int porttosa(struct sockaddr *sa, char *port, struct sockaddr *protosa)
{
  int proto, i;
  char *c, *c2;
  uint8_t *p;

  c = port;

#define GET(x) c2 = c; while(*c2 && isdigit(*c2)) c2++; if (*c2 != ',') return -1; *(c2++) = 0; x = atoi(c); c = c2;

  memcpy(sa, protosa, SA_LEN(protosa));

  i = 4;

  switch(sa->sa_family) {
#if INET6
    case AF_INET6:
      if (!IN6_IS_ADDR_V4MAPPED(&((struct sockaddr_in6 *)sa)->sin6_addr))
	return -2;
      p = (uint8_t *)&((struct sockaddr_in6 *)sa)->sin6_addr + 12;
      break;
#endif /* INET6 */
    case AF_INET:
      p = (uint8_t *)&((struct sockaddr_in *)sa)->sin_addr;
      break;
    default:
      return -2;
  }

  while(i--) {
    GET(*(p++));
  }

  if (inner_addrcmp(sa, protosa))
    return -3;

  switch(sa->sa_family) {
#if INET6
    case AF_INET6:
      p = (uint8_t *)&((struct sockaddr_in6 *)sa)->sin6_port;
      break;
#endif /* INET6 */
    case AF_INET:
      p = (uint8_t *)&((struct sockaddr_in *)sa)->sin_port;
      break;
  }

  GET(*(p++));
  c2 = c; while(*c2 && isdigit(*c2)) c2++; if (*c2) return -1; *p = atoi(c);

  switch(sa->sa_family) {
  case AF_INET:
    if (ntohs(((struct sockaddr_in *)sa)->sin_port) < 1024)
      return -3;
    break;
#if INET6
  case AF_INET6:
    if (ntohs(((struct sockaddr_in6 *)sa)->sin6_port) < 1024)
      return -3;
    break;
#endif /* INET6 */
  }
  return 0;
}

#if !INNER
int satolport(char *lport, int lportlen, struct sockaddr *sa)
{
  switch(sa->sa_family) {
    case AF_INET:
      snprintf(lport, lportlen, "4,4,%u,%u,%u,%u,2,%u,%u",
	      ((uint8_t *)(&((struct sockaddr_in *)sa)->sin_addr))[0],
	      ((uint8_t *)(&((struct sockaddr_in *)sa)->sin_addr))[1],
	      ((uint8_t *)(&((struct sockaddr_in *)sa)->sin_addr))[2],
	      ((uint8_t *)(&((struct sockaddr_in *)sa)->sin_addr))[3],
	      ((uint8_t *)(&((struct sockaddr_in *)sa)->sin_port))[0],
	      ((uint8_t *)(&((struct sockaddr_in *)sa)->sin_port))[1]);
      return 0;
#if INET6
    case AF_INET6:
      if (IN6_IS_ADDR_V4MAPPED(&((struct sockaddr_in6 *)sa)->sin6_addr)) {
	struct sockaddr_in sin;
	memset(&sin, 0, sizeof(struct sockaddr_in));
	sin.sin_family = AF_INET;
	sin.sin_port = ((struct sockaddr_in6 *)sa)->sin6_port;
	memcpy(&sin.sin_addr, (uint8_t *)&((struct sockaddr_in6 *)sa)->sin6_addr + 12, sizeof(struct in_addr));

	return satolport(lport, lportlen, (struct sockaddr *)&sin);
      }

      snprintf(lport, lportlen, "6,16,%u,%u,%u,%u,%u,%u,%u,%u,%u,%u,%u,%u,%u,%u,%u,%u,2,%u,%u",
	      ((uint8_t *)(&((struct sockaddr_in6 *)sa)->sin6_addr))[0],
	      ((uint8_t *)(&((struct sockaddr_in6 *)sa)->sin6_addr))[1],
	      ((uint8_t *)(&((struct sockaddr_in6 *)sa)->sin6_addr))[2],
	      ((uint8_t *)(&((struct sockaddr_in6 *)sa)->sin6_addr))[3],
	      ((uint8_t *)(&((struct sockaddr_in6 *)sa)->sin6_addr))[4],
	      ((uint8_t *)(&((struct sockaddr_in6 *)sa)->sin6_addr))[5],
	      ((uint8_t *)(&((struct sockaddr_in6 *)sa)->sin6_addr))[6],
	      ((uint8_t *)(&((struct sockaddr_in6 *)sa)->sin6_addr))[7],
	      ((uint8_t *)(&((struct sockaddr_in6 *)sa)->sin6_addr))[8],
	      ((uint8_t *)(&((struct sockaddr_in6 *)sa)->sin6_addr))[9],
	      ((uint8_t *)(&((struct sockaddr_in6 *)sa)->sin6_addr))[10],
	      ((uint8_t *)(&((struct sockaddr_in6 *)sa)->sin6_addr))[11],
	      ((uint8_t *)(&((struct sockaddr_in6 *)sa)->sin6_addr))[12],
	      ((uint8_t *)(&((struct sockaddr_in6 *)sa)->sin6_addr))[13],
	      ((uint8_t *)(&((struct sockaddr_in6 *)sa)->sin6_addr))[14],
	      ((uint8_t *)(&((struct sockaddr_in6 *)sa)->sin6_addr))[15],
	      ((uint8_t *)(&((struct sockaddr_in6 *)sa)->sin6_port))[0],
	      ((uint8_t *)(&((struct sockaddr_in6 *)sa)->sin6_port))[1]);
      return 0;
#endif /* INET6 */
  }
  return 1;
}

int lporttosa(struct sockaddr *sa, char *lport, struct sockaddr *protosa)
{
  int proto, i;
  char *c, *c2;
  uint8_t *p;

  c = lport;

#define GET(x) c2 = c; while(*c2 && isdigit(*c2)) c2++; if (*c2 != ',') return -1; *(c2++) = 0; x = atoi(c); c = c2;

  GET(proto);
  GET(i);

  memcpy(sa, protosa, SA_LEN(protosa));

  switch(proto) {
#if INET6
    case 6:
      if (i != sizeof(struct in6_addr))
	return -1;

      switch(sa->sa_family) {
        case AF_INET6:
	  p = (uint8_t *)&((struct sockaddr_in6 *)sa)->sin6_addr;
	  break;
        default:
	  return -2;
      }
      break;
#endif /* INET6 */
    case 4:
      if (i != sizeof(struct in_addr))
	return -1;

      switch(sa->sa_family) {
#if INET6
        case AF_INET6:
	  if (!IN6_IS_ADDR_V4MAPPED(&((struct sockaddr_in6 *)sa)->sin6_addr))
	    return -2;
	  p = (uint8_t *)&((struct sockaddr_in6 *)sa)->sin6_addr + 12;
	  break;
#endif /* INET6 */
        case AF_INET:
	  p = (uint8_t *)&((struct sockaddr_in *)sa)->sin_addr;
	  break;
        default:
	  return -2;
      }
      break;
    default:
      return -1;
  }

  while(i--) {
    GET(*(p++));
  }

  GET(i);

  switch(proto) {
#if INET6
    case 6:
      if (i != 2)
	return -1;

      switch(sa->sa_family) {
        case AF_INET6:
	  p = (uint8_t *)&((struct sockaddr_in6 *)sa)->sin6_port;
	  break;
      }
      break;
#endif /* INET6 */
    case 4:
      if (i != 2)
	return -1;

      switch(sa->sa_family) {
#if INET6
        case AF_INET6:
	  p = (uint8_t *)&((struct sockaddr_in6 *)sa)->sin6_port;
	  break;
#endif /* INET6 */
        case AF_INET:
	  p = (uint8_t *)&((struct sockaddr_in *)sa)->sin_port;
	  break;
      }
      break;
  }

  if (inner_addrcmp(sa, protosa))
    return -3;

  while(i-- > 1)
    GET(*(p++));

  c2 = c; while(*c2 && isdigit(*c2)) c2++; if (*c2) return -1; *p = atoi(c);

  switch(sa->sa_family) {
  case AF_INET:
    if (ntohs(((struct sockaddr_in *)sa)->sin_port) < 1024)
      return -3;
    break;
#if INET6
  case AF_INET6:
    if (ntohs(((struct sockaddr_in6 *)sa)->sin6_port) < 1024)
      return -3;
    break;
#endif /* INET6 */
  }
  return 0;
}
#endif /* !INNER */

int satosport(char *sport, int sportlen, struct sockaddr *sa)
{
#if 1
  if (getnameinfo(sa, SA_LEN(sa), NULL, 0, sport, sportlen, NI_NUMERICSERV))
    return 1;
  return 0;
#else /* 1 */
  switch(sa->sa_family) {
    case AF_INET:
      snprintf(sport, sportlen, "%u,%u",
	      ((uint8_t *)(&((struct sockaddr_in *)sa)->sin_port))[0],
	      ((uint8_t *)(&((struct sockaddr_in *)sa)->sin_port))[1]);
      return 0;
#if INET6
    case AF_INET6:
      snprintf(sport, sportlen, "%u,%u",
	      ((uint8_t *)(&((struct sockaddr_in6 *)sa)->sin6_port))[0],
	      ((uint8_t *)(&((struct sockaddr_in6 *)sa)->sin6_port))[1]);
      return 0;
#endif /* INET6 */
  }
  return 1;
#endif /* 1 */
}

#if INNER
int sporttosa_old(struct sockaddr *sa, char *sport, struct sockaddr *protosa)
{
  int i;
  char *c, *c2;
  uint8_t *p;

  c = sport;

#define GET(x) c2 = c; while(*c2 && isdigit(*c2)) c2++; if (*c2 != ',') return -1; *(c2++) = 0; x = atoi(c); c = c2;

  memcpy(sa, protosa, SA_LEN(protosa));

  switch(sa->sa_family) {
    case AF_INET:
      p = (uint8_t *)&((struct sockaddr_in *)sa)->sin_port;
      break;
#if INET6
    case AF_INET6:
      p = (uint8_t *)&((struct sockaddr_in6 *)sa)->sin6_port;
      break;
#endif /* INET6 */
     default:
       return -1;
  }

  GET(*(p++));
  c2 = c; while(*c2 && isdigit(*c2)) c2++; if (*c2) return -1; *p = atoi(c);

  switch(sa->sa_family) {
  case AF_INET:
    if (ntohs(((struct sockaddr_in *)sa)->sin_port) < 1024)
      return -3;
    break;
#if INET6
  case AF_INET6:
    if (ntohs(((struct sockaddr_in6 *)sa)->sin6_port) < 1024)
      return -3;
    break;
#endif /* INET6 */
  }
  return 0;
}
#endif /* INNER */

int sporttosa(struct sockaddr *sa, char *sport, struct sockaddr *protosa)
{
  struct addrinfo req, *ai;
  char hbuf[NI_MAXHOST];

#if INNER
  if (strchr(sport, ','))
    return sporttosa_old(sa, sport, protosa);
#endif /* INNER */

  if (getnameinfo(protosa, SA_LEN(protosa), hbuf, sizeof(hbuf), NULL, 0, NI_NUMERICHOST))
    return 1;

  memset(&req, 0, sizeof(struct addrinfo));
  req.ai_family = protosa->sa_family;
  req.ai_socktype = SOCK_STREAM;

  if (getaddrinfo(hbuf, sport, &req, &ai))
    return 1;

  memcpy(sa, ai->ai_addr, ai->ai_addrlen);
  freeaddrinfo(ai);

  return 0;
};

int satoeport(char *eport, int eportlen, struct sockaddr *sa, int passive)
{
  char sbuf[NI_MAXSERV];

  if (passive) {
    if (getnameinfo(sa, SA_LEN(sa), NULL, 0, sbuf, NI_MAXSERV, NI_NUMERICSERV))
      return 1;

    snprintf(eport, eportlen, "|||%s|", sbuf);
  } else {
    char hbuf[NI_MAXHOST];
    int netprt;

    switch(sa->sa_family) {
      case AF_INET:
        netprt = 1;
        break;
#if INET6
      case AF_INET6:
        if (IN6_IS_ADDR_V4MAPPED(&((struct sockaddr_in6 *)sa)->sin6_addr)) {
          struct sockaddr_in sin;

          memset(&sin, 0, sizeof(struct sockaddr_in));
          sin.sin_family = AF_INET;
          sin.sin_port = ((struct sockaddr_in6 *)sa)->sin6_port;
          memcpy(&sin.sin_addr, (uint8_t *)&((struct sockaddr_in6 *)sa)->sin6_addr + 12, sizeof(struct in_addr));

          return satoeport(eport, eportlen, (struct sockaddr *)&sin, passive);
        };
        netprt = 2;
        break;
#endif /* INET6 */
      default:
        return 1;
    };

    if (getnameinfo(sa, SA_LEN(sa), hbuf, NI_MAXHOST, sbuf, NI_MAXSERV, NI_NUMERICHOST | NI_NUMERICSERV))
      return 1;

    snprintf(eport, eportlen, "|%d|%s|%s|", netprt, hbuf, sbuf);
  };

  return 0;
}

int eporttosa(struct sockaddr *sa, char *eport, struct sockaddr *protosa, int passive)
{
  struct addrinfo *ai, req;
  char d, *c;
  char *netprt, *host, *serv;

  memset(&req, 0, sizeof(struct addrinfo));
  req.ai_socktype = SOCK_STREAM;
  req.ai_flags |= AI_NUMERICHOST;

  c = eport;
  d = *(c++);

#define ADVANCE while(*c != d) if (!*(c++)) return -1; *(c++) = 0;

  netprt = c;
  ADVANCE;

  if (passive) {
    if (*netprt)
      return -3;
  } else {
    switch(atoi(netprt)) {
      case 1:
        req.ai_family = AF_INET;
        break;
#if INET6
      case 2:
        req.ai_family = AF_INET6;
        break;
#endif /* INET6 */
      default:
        return -2;
    };
  };

  host = c;
  ADVANCE;
  serv = c;
  ADVANCE;

  if (passive ^ !*host)
    return -3;

  if (!*serv)
    return -1;

  if (passive) {
    char hbuf[NI_MAXHOST];

    if (getnameinfo(protosa, SA_LEN(protosa), hbuf, sizeof(hbuf), NULL, 0, NI_NUMERICHOST))
      return -1;

    if (getaddrinfo(hbuf, serv, &req, &ai))
      return -1;
  } else {
    if (getaddrinfo(host, serv, &req, &ai))
      return -1;

    if (inner_addrcmp(ai->ai_addr, protosa)) {
      freeaddrinfo(ai);
      return -3;
    };
  }

  memcpy(sa, ai->ai_addr, ai->ai_addrlen);
  freeaddrinfo(ai);

  return 0;
}
