# %%% copyright-cmetz-96
# This software is Copyright 1996-1998 by Craig Metz, All Rights Reserved.
# The Inner Net License Version 2 applies to this software.
# You should have received a copy of the license with this software. If
# you didn't get a copy, you may request one from <license@inner.net>.
#

# Directories in which to install things.  If these are not specified
# the default values used would overwrite most of the corresponding
# IPv4 only utilities.
#

INSTALLED=0

ifneq ($(INSTALLED), 0)
ifndef CONFIG_DIR
CONFIG_DIR=@CONFIG_DIR@
endif # CONFIG_DIR

include $(CONFIG_DIR)/GNUmakefile.config
else # INSTALLED
ifndef DOTS
DOTS=../
endif # DOTS

include ${DOTS}GNUmakefile.config
endif # INSTALLED

ifneq ($(SEGREGATE_EXECUTABLES), 0)
LIBEXECDIR=	/libexec
USR_BINDIR=	/bin
USR_SBINDIR=	/sbin
SBINDIR=	/sbin
SCRIPTDIR=	/bin
else # SEGREGATE_EXECUTABLES
LIBEXECDIR=	/bin
USR_BINDIR=	/bin
USR_SBINDIR=	/bin
SBINDIR=	/bin
SCRIPTDIR=	/bin
endif # SEGREGATE_EXECUTABLES

INCDIR=		/include
LIBDIR= 	/lib
MANDIR=		/man

# C flags common to all the utilities.
#
ifneq ($(DEBUG), 0)
CFLAGS+=-g -DDEBUG=1
endif

ifneq ($(INSTALLED), 0)
CFLAGS+=-I$(DESTDIR)$(INCDIR)
else # INSTALLED
CFLAGS+=-I$(DOTS)include
ifeq ($(LIBCAPI), 0)
ifeq ($(OS), Linux)
OSINC=linux
SALEN=0
endif # OS = Linux
ifeq ($(OS), BSD)
OSINC=bsd
SALEN=1
endif # OS = BSD
ifeq ($(OS), Solaris)
OSINC=solaris
SALEN=0
endif # OS = Solaris

CFLAGS+=-I$(DOTS)include/$(OSINC) -I$(DOTS)include/generic
endif # !LIBCAPI
endif # INSTALLED

ifneq ($(INET6), 0)
DINET6=-DINET6=$(INET6)
endif # INET6
ifneq ($(NETPROC), 0)
DNETPROC=-DNETPROC=$(NETPROC)
endif # NETPROC
ifneq ($(FASTCTO), 0)
DFASTCTO=-DFASTCTO=$(FASTCTO)
endif # FASTCTO
ifneq ($(INNER), 0)
DINNER=-DINNER=$(INNER)
endif # INNER
ifeq ($(SALEN), 1)
CFLAGS+=-DSALEN=$(SALEN)
endif # SALEN
ifneq ($(HAVE_POSIX1G_TYPES), 0)
CFLAGS+=-DHAVE_POSIX1G_TYPES=$(HAVE_POSIX1G_TYPES)
endif # HAVE_POSIX1G_TYPES
CFLAGS+=$(RESOLVINC)

# Libraries used by the utilities.
#
ifneq ($(INSTALLED), 0)
LOADLIBES+=-L$(DESTDIR)$(LIBDIR) -linet6
else # INSTALLED
LOADLIBES+=-L${DOTS}lib -linet6
endif # INSTALLED

ifeq ($(OS), Solaris)
LOADLIBES+=-lsocket -lnsl
endif # Solaris

ifneq ($(LIBRESOLV), "")
LOADLIBES+=$(LIBRESOLV)
endif # LIBRESOLV
ifneq ($(LIBEFENCE), 0)
LOADLIBES+=-lefence
endif # LIBEFENCE
