/* Modified from the in-kernel versions in ext2_fs_c.h.
 *
 * Parameters:
 *   nb = clu_nblk
 *   bs = block size (in bytes) 
 *   sz = st_size
 *
 */

# define ext2fs_first_cluster_nblocks(clu_nblocks, blksz) \
	((clu_nblocks > 4 && blksz < 4096) 	\
	 ? 12 	\
	 : 4)

# define ext2fs_block_to_cluster(nb, bs,_b) \
	((_b) < ext2fs_first_cluster_nblocks(nb, bs) \
	 ? 0 	\
	 : (((_b) - ext2fs_first_cluster_nblocks(nb, bs)) 	\
	    / nb) + 1)

# define ext2fs_offset_to_cluster(nb, bs,_o) \
	ext2fs_block_to_cluster(nb, bs, ((_o) / bs))

# define ext2fs_n_clusters(clu_nblocks, blk_nchars, st_size) \
	(st_size 	\
	 ? ext2fs_offset_to_cluster(clu_nblocks, blk_nchars, st_size - 1) + 1 	\
	 : 0)
