/************************************************************************/
/*									*/
/*   Ce programme est un produit de la societe DASSAULT ELECTRONIQUE,	*/
/* protege par les lois sur le droit d'auteur et sur le copyright et	*/
/* transmis en licence dans les conditions et termes specifiques	*/
/* indiques dans l'accord de licence qui l'accompagne. DASSAULT		*/
/* ELECTRONIQUE garde la propriete du programme et toutes les 		*/
/* prerogatives qui l'accompagnent. Ce programme ne peut etre modifie	*/
/* en aucune maniere sans l'autorisation ecrite prealable de DASSAULT	*/
/* ELECTRONIQUE.							*/
/*									*/
/* Nom: V2dIdent.h							*/
/*									*/
/* Version: 1.3								*/
/*									*/
/* Role: Gestion des identifiants DIS et SSTH				*/
/*									*/
/* Historique:								*/
/*	Auteur: D.DULAC							*/
/*	Date: 97/11/21							*/
/*	Creation: 97/03/24						*/
/*									*/
/************************************************************************/


#ifndef V2D_IDENT_H
#define V2D_IDENT_H


static char v2didenthsccsid[] = " @(#) V2dIdent.h 1.3 97/11/21 - Copyright (c) DE 1997 ";


#include "ScnScenario.h"
#include "ScnActeur.h"


class V2dIdent
{
public:
    int*	SSTHId;			// tableau des id SSTH
    int*	entityId;		// tableau des id entite DIS
    int*	applicationId;		// tableau des id entite DIS
    int*	siteId;			// tableau des id site DIS
    int		nbIdent;		// nombre total d'id
    int		supIdent;		// maximum des identifiants SSTH

public:
    V2dIdent (ScnScenario*);
   ~V2dIdent (void);

    void initIdent(ScnActeur*);
    int addIdent(int, int, int);
    void suppIdent(int, int, int);
    int verifIdent(int, int, int);
    void printIdent(void);

};


#endif


/************/
/* The End. */
/************/

