static char v2didentsccsid[] = " @(#) V2dIdent.cc 1.3 97/11/21 - Copyright (c) DE 1997 ";
/************************************************************************/
/*									*/
/*   Ce programme est un produit de la societe DASSAULT ELECTRONIQUE,	*/
/* protege par les lois sur le droit d'auteur et sur le copyright et	*/
/* transmis en licence dans les conditions et termes specifiques	*/
/* indiques dans l'accord de licence qui l'accompagne. DASSAULT		*/
/* ELECTRONIQUE garde la propriete du programme et toutes les 		*/
/* prerogatives qui l'accompagnent. Ce programme ne peut etre modifie	*/
/* en aucune maniere sans l'autorisation ecrite prealable de DASSAULT	*/
/* ELECTRONIQUE.							*/
/*									*/
/* Nom: V2dIdent.cc							*/
/*									*/
/* Version: 1.3								*/
/*									*/
/* Historique:								*/
/*	Auteur: D.DULAC							*/
/*	Date: 97/11/21							*/
/*	Creation: 97/03/24						*/
/*									*/
/************************************************************************/

/***********/
/* INCLUDE */
/***********/

#include "ScnEntite.h"

#include "V2dIdent.h"


#define MAX_ID_NUMBER 1000


/************************************************************************/
/*									*/
/* Nom: V2dIdent							*/
/*									*/
/* Role: Constructeur							*/
/*									*/
/************************************************************************/

V2dIdent::V2dIdent(ScnScenario* scenario)
{
  ScnEntite	*entite;
  ScnActeur	*acteur;

  SSTHId = new int[MAX_ID_NUMBER];
  entityId = new int[MAX_ID_NUMBER];
  applicationId = new int[MAX_ID_NUMBER];
  siteId = new int[MAX_ID_NUMBER];
  nbIdent = 0;
  supIdent = 0;

  acteur = scenario->premierActeur();
  while (acteur != 0)
  {
    if (acteur->getEntite() != 0)
    {
      entityId[nbIdent] = acteur->getEntite()->getEntityId();
      applicationId[nbIdent] = acteur->getEntite()->getApplicationId();
      siteId[nbIdent] = acteur->getEntite()->getSiteId();
      if (supIdent < entityId[nbIdent])
        supIdent = entityId[nbIdent];
      else
        supIdent++;
      SSTHId[nbIdent] = supIdent;
      nbIdent++;
    }
    else
      initIdent(acteur->premierConstituant());
    acteur = acteur->suivant();
  }
}


/************************************************************************/
/*									*/
/* Nom: V2dIdent							*/
/*									*/
/* Role: Destructeur							*/
/*									*/
/************************************************************************/

V2dIdent::~V2dIdent()
{
  delete SSTHId;
  delete entityId;
  delete applicationId;
  delete siteId;
}

/************************************************************************/
/*									*/
/* Nom: initIdent							*/
/*									*/
/* Role: initialiser la liste des identifiants.		 		*/
/*									*/
/************************************************************************/

void
V2dIdent::initIdent(ScnActeur *acteur)
{
  while (acteur != 0)
  {
    if (acteur->getEntite() != 0)
    {
      entityId[nbIdent] = acteur->getEntite()->getEntityId();
      applicationId[nbIdent] = acteur->getEntite()->getApplicationId();
      siteId[nbIdent] = acteur->getEntite()->getSiteId();
      if (supIdent < entityId[nbIdent])
        supIdent = entityId[nbIdent];
      else
        supIdent++;
      SSTHId[nbIdent] = supIdent;
      nbIdent++;
    }
    else
      initIdent(acteur->premierConstituant());
    acteur = acteur->suivant();
  }
}


/************************************************************************/
/*									*/
/* Nom: addIdent							*/
/*									*/
/* Role: ajouter un identifiant a la liste.		 		*/
/*									*/
/************************************************************************/

int
V2dIdent::addIdent(int entId, int appId, int sitId)
{
  entityId[nbIdent] = entId;
  applicationId[nbIdent] = appId;
  siteId[nbIdent] = sitId;
  SSTHId[nbIdent] = ++supIdent;
  nbIdent++;
  return supIdent;
}


/************************************************************************/
/*									*/
/* Nom: suppIdent							*/
/*									*/
/* Role: supprimer un identifiant de la liste.		 		*/
/*									*/
/************************************************************************/

void
V2dIdent::suppIdent (int entId, int appId, int sitId)
{
  int	i, j;

  j = -1;
  for (i = 0; i < nbIdent; i++)
  {
    if ( (entityId[i] == entId) &&
         (applicationId[i] == appId) &&
         (siteId[i] == sitId) )
    {
      j = i;
      i = nbIdent;
    }
  }

  if (j != -1)
  {
    for (i = j; i < nbIdent-1; i++)
    {
      entityId[i] = entityId[i+1];
      applicationId[i] = applicationId[i+1];
      siteId[i] = siteId[i+1];
      SSTHId[i] = SSTHId[i+1];
    }
  }
  nbIdent--;
}


/************************************************************************/
/*									*/
/* Nom: verifIdent							*/
/*									*/
/* Role: verification de l'existence d'un identifiant dans la liste.	*/
/*									*/
/************************************************************************/

int
V2dIdent::verifIdent (int entId, int appId, int sitId)
{
  int	i, j;

  j = -1;
  for (i = 0; i < nbIdent; i++)
  {
    if ( (entityId[i] == entId) &&
         (applicationId[i] == appId) &&
         (siteId[i] == sitId) )
    {
      j = SSTHId[i];
      i = nbIdent;
    }
  }
  return j;
}


/************************************************************************/
/*									*/
/* Nom: printIdent							*/
/*									*/
/* Role: impression des identifiants de la liste.			*/
/*									*/
/************************************************************************/

void
V2dIdent::printIdent ()
{
  int	i;

  cout << " TABLEAU DES IDENTIFIANTS" << endl << endl;

  cout << "  NB  : " << nbIdent << endl;
  cout << "  SUP : " << supIdent << endl << endl;

  for (i = 0; i < nbIdent; i++)
  {
    cout << "  SSTH : " << SSTHId[i];
    cout << "  ENT  : " << entityId[i];
    cout << "  APP  : " << applicationId[i];
    cout << "  SITE : " << siteId[i];
    cout << endl;
  }
  cout << endl;
}


/************/
/* The End. */
/************/

