static char v2dihmsccsid[] = " @(#) V2dIHM.cc 1.8 97/11/21 - Copyright (c) DE 1997 ";
/************************************************************************/
/*									*/
/*   Ce programme est un produit de la societe DASSAULT ELECTRONIQUE,	*/
/* protege par les lois sur le droit d'auteur et sur le copyright et	*/
/* transmis en licence dans les conditions et termes specifiques	*/
/* indiques dans l'accord de licence qui l'accompagne. DASSAULT		*/
/* ELECTRONIQUE garde la propriete du programme et toutes les 		*/
/* prerogatives qui l'accompagnent. Ce programme ne peut etre modifie	*/
/* en aucune maniere sans l'autorisation ecrite prealable de DASSAULT	*/
/* ELECTRONIQUE.							*/
/*									*/
/* Nom: V2dIHM.cc							*/
/*									*/
/* Version: 1.8								*/
/*									*/
/* Historique:								*/
/*	Auteur: D.DULAC							*/
/*	Date: 97/11/21							*/
/*	Creation: 97/03/24						*/
/*									*/
/************************************************************************/

/***********/
/* INCLUDE */
/***********/

#include <fstream.h>
#include <math.h>

#include <ilviews/ilvgif.h>
#include <ilviews/stdialog.h>
#include <ilviews/rectscmg.h>

#include "DisRemoteEntity.h"

#include "V2dIHM.h"

/**********/
/* DEFINE */
/**********/

const int			_CARTE_RASTER_100 = 1;



/************************************************************************/
/*									*/
/* Nom: V2dIHM								*/
/*									*/
/* Role: Constructeur							*/
/*									*/
/************************************************************************/

V2dIHM::V2dIHM(IlvDisplay* display)
{
    // SITAC 2D

    sitac = new S2dSitac (display);

    // AUTRES

    positionEst = 0.0;
    positionNord = 0.0;

    firstTime = 0.0;

    IdCentre = -1;

    cptId2D = 100;

    _cligno = IlvFalse;
    _sound = IlvFalse;
    _alizee = IlvFalse;

    _record = IlvFalse;
    _carte = IlvTrue;
    _wfz = IlvTrue;
    _symbole = IlvTrue;
    _etat = IlvFalse;
    _trajectoire = IlvFalse;
    _echelle = _CARTE_RASTER_100;
}


/************************************************************************/
/*									*/
/* Nom: V2dIHM								*/
/*									*/
/* Role: Destructeur							*/
/*									*/
/************************************************************************/

V2dIHM::~V2dIHM()
{
}


/************************************************************************/
/*									*/
/* Nom: miseAJour							*/
/*									*/
/* Role: Callback appelee regulierement et mettant a jour les positions	*/
/*       des entites DIS sur la carte.					*/
/*									*/
/************************************************************************/

void
V2dIHM::miseAJour ()
{
  DisRemoteEntity*	entity;
  int			SSTHId;
  int			entityId;
  int			applicationId;
  int			siteId;
  float			x, y, z;
  float			heading;
  double		vx, vy, vz;
  float			v;

  // lecture des informations DIS

  //DtSetSimTime (DtGetElapsedRealTime());

  exercise->drainInput();

  remoteEntities->deadReckonAllEntities();

  entity = (DisRemoteEntity*) remoteEntities->first();

  // mise a jour des etats des entites SSTH

  while (entity)
  {
    entityId = entity->getID().entity;
    applicationId = entity->getID().address.host;
    siteId = entity->getID().address.site;
    SSTHId = ident->verifIdent(entityId, applicationId, siteId);

    // si l'entite SSTH existe, on met a jour son etat
    if (SSTHId != -1)
    {
      // on met a jour la couleur et le menu selon l'etat (detruit ou non)

      if (entity->isDamageDestroyedAppearance())
      {
        sitac->acteur_couleur(SSTHId, NEUTRE);	// pour maj icone
        sitac->acteur_detruit(SSTHId, 1);	// pour maj menu
      }
      else
      {
        int camp = entity->getCamp();
        if (camp == 1)
          camp = AMI;
        else if (camp == 2)
          camp = ENI;
        else
          camp = NEUTRE;
        sitac->acteur_couleur(SSTHId, camp);	// pour maj icone
        sitac->acteur_detruit(SSTHId, 0);	// pour maj menu
      }

      x = entity->getLocation().x;
      y = entity->getLocation().y;
      z = entity->getLocation().z;

      heading = entity->getOrientation().psi * 180.0 / 3.14159;

      // on calcule la vitesse (et on convertit de m/s en km/h)

      vx = entity->getVelocity().x;
      vy = entity->getVelocity().y;
      vz = entity->getVelocity().z;
      v = sqrt (vx*vx+vy*vy+vz*vz) * 3.6;

      sitac->acteur_position(SSTHId, x, y, z, heading, v);
    }

    entity = (DisRemoteEntity*) entity->next();
  }

  // affichage

  sitac->acteurs_position ();
  sitac->reDraw ();
}


/************************************************************************/
/*									*/
/* Nom: fireDIS								*/
/*									*/
/* Role: Methode a appeler en cas de reception d'un PDU Fire.		*/
/*									*/
/************************************************************************/

char*
V2dIHM::fireDIS (FirePDU* firePdu)
{
  char			path[256];
  char			path2[256];

  if (typeCompare(firePdu->burst_descriptor.munition, DisHotType) == TRUE)
  {
    sprintf(path, "/usr/sbin/sfplay %s/DATA/bruitages/missle.aiff &", getenv("ELISA_HOME"));
    sprintf(path2, "PDU Fire (Hot Gazelle).");
  }
  else if (typeCompare(firePdu->burst_descriptor.munition, DisSA7Type) == TRUE)
  {
    sprintf(path, "/usr/sbin/sfplay %s/DATA/bruitages/missle.aiff &", getenv("ELISA_HOME"));
    sprintf(path2, "PDU Fire (SA7).");
  }
  else if (typeCompare(firePdu->burst_descriptor.munition, Dis105mmAMX10RCType) == TRUE)
  {
    sprintf(path, "/usr/sbin/sfplay %s/DATA/bruitages/explosion.aiff &", getenv("ELISA_HOME"));
    sprintf(path2, "PDU Fire (105 mm AMX10).");
  }
  else if (typeCompare(firePdu->burst_descriptor.munition, Dis125mmT80Type) == TRUE)
  {
    sprintf(path, "/usr/sbin/sfplay %s/DATA/bruitages/explosion.aiff &", getenv("ELISA_HOME"));
    sprintf(path2, "PDU Fire (125 mm T80).");
  }
  else if (typeCompare(firePdu->burst_descriptor.munition, Dis12_7mmT80Type) == TRUE)
  {
    sprintf(path, "/usr/sbin/sfplay %s/DATA/bruitages/cannon.aiff &", getenv("ELISA_HOME"));
    sprintf(path2, "PDU Fire (12.7 mm T80).");
  }
  else if (typeCompare(firePdu->burst_descriptor.munition, Dis23mmZSU23_4Type) == TRUE)
  {
    sprintf(path, "/usr/sbin/sfplay %s/DATA/bruitages/cannon.aiff &", getenv("ELISA_HOME"));
    sprintf(path2, "PDU Fire (23 mm ZSU).");
  }
  else
  {
    sprintf(path, "/usr/sbin/sfplay %s/DATA/bruitages/explosion.aiff &", getenv("ELISA_HOME"));
    sprintf(path2, "PDU Fire.");
  }

  // on fait du bruit

  if (_sound == IlvTrue)
    system(path);

  return (path2);
}


/************************************************************************/
/*									*/
/* Nom: detonationDIS							*/
/*									*/
/* Role: Methode a appeler en cas de reception d'un PDU Detonation.	*/
/*									*/
/************************************************************************/

char*
V2dIHM::detonationDIS (DetonationPDU* detonationPdu)
{
  char			path[256];
  char			path2[256];
  int			typeTir;

  if (typeCompare(detonationPdu->burst_descriptor.munition, DisHotType) == TRUE)
  {
    sprintf(path, "/usr/sbin/sfplay %s/DATA/bruitages/explosion.aiff &", getenv("ELISA_HOME"));
    sprintf(path2, "PDU Detonation (Hot Gazelle).");
    typeTir = 0;
  }
  else if (typeCompare(detonationPdu->burst_descriptor.munition, DisSA7Type) == TRUE)
  {
    sprintf(path, "/usr/sbin/sfplay %s/DATA/bruitages/explosion.aiff &", getenv("ELISA_HOME"));
    sprintf(path2, "PDU Detonation.");
    typeTir = 1;
  }
  else if (typeCompare(detonationPdu->burst_descriptor.munition, Dis105mmAMX10RCType) == TRUE)
  {
    sprintf(path, "/usr/sbin/sfplay %s/DATA/bruitages/explosion.aiff &", getenv("ELISA_HOME"));
    sprintf(path2, "PDU Detonation.");
    typeTir = 1;
  }
  else if (typeCompare(detonationPdu->burst_descriptor.munition, Dis125mmT80Type) == TRUE)
  {
    sprintf(path, "/usr/sbin/sfplay %s/DATA/bruitages/explosion.aiff &", getenv("ELISA_HOME"));
    sprintf(path2, "PDU Detonation (125 mm T80).");
    typeTir = 0;
  }
  else if (typeCompare(detonationPdu->burst_descriptor.munition, Dis12_7mmT80Type) == TRUE)
  {
    sprintf(path, "/usr/sbin/sfplay %s/DATA/bruitages/shot.aiff &", getenv("ELISA_HOME"));
    sprintf(path2, "PDU Detonation (12.7 mm T80).");
    typeTir = 0;
  }
  else if (typeCompare(detonationPdu->burst_descriptor.munition, Dis23mmZSU23_4Type) == TRUE)
  {
    sprintf(path, "/usr/sbin/sfplay %s/DATA/bruitages/explosion.aiff &", getenv("ELISA_HOME"));
    sprintf(path2, "PDU Detonation (23 mm ZSU).");
    typeTir = 0;
  }
  else
  {
    sprintf(path, "/usr/sbin/sfplay %s/DATA/bruitages/explosion.aiff &", getenv("ELISA_HOME"));
    sprintf(path2, "PDU Detonation.");
    typeTir = 1;
  }

  // on fait du bruit

  if (_sound == IlvTrue)
    system(path);

  return (path2);
}


/************************************************************************/
/*									*/
/* Nom: ajouteEntiteDIS							*/
/*									*/
/* Role: Callback appelee en cas de reception d'un PDU State pour une	*/
/*       nouvelle entite.						*/
/*									*/
/************************************************************************/

void
V2dIHM::ajouteEntiteDIS (DisRemoteEntity* remote)
{
  int			SSTHId;
  int			entityId;
  int			applicationId;
  int			siteId;
  int			camp;
  int			type;
  int			tope;
  float			x, y, z;
  float			heading;
  double		vx, vy, vz;
  float			v;


  entityId = remote->getID().entity;
  applicationId = remote->getID().address.host;
  siteId = remote->getID().address.site;
  SSTHId = ident->verifIdent(entityId, applicationId, siteId);

  // si l'entite n'existe pas deja
  if (SSTHId == -1)
  {
    // on analyse le type :

    if (remote->getType().entity_kind == 1)
    { // plateforme

      if (remote->getType().domain == 1)
      { // plateforme terrestre

        if (remote->getType().category == 1)
        { // 111... = plateforme terrestre char
          type = 111;
        }
        else if (remote->getType().category == 2)
        { // 112... = plateforme terrestre blinde attaque
          type = 112;
        }
        else if (remote->getType().category == 3)
        { // 113... = plateforme terrestre blinde utiliaire
          type = 113;
        }
        else
          type = 110;

      }
      else if (remote->getType().domain == 2)
      { // plateforme aerienne

        if (remote->getType().category == 1)
        { // 121... = plateforme aerienne chasseur
          type = 121;
        }
        else if (remote->getType().category == 2)
        { // 122... = plateforme aerienne attaque
          type = 122;
        }
        else if (remote->getType().category == 3)
        { // 123... = plateforme aerienne bombardier
          type = 123;
        }
        else if (remote->getType().category == 20)
        { // 12... = plateforme aerienne helicoptere d'attaque
          type = 120;
        }
        else if (remote->getType().category == 21)
        { // 12... = plateforme aerienne helicoptere utilitaire
          type = 120;
        }
        else
          type = 120;

      }
      else if (remote->getType().domain == 3)
      { // plateforme marine
        type = 130;
      }
      else
        type = -1;

    }
    else if (remote->getType().entity_kind == 2)
    { // munition

      if (remote->getType().domain == 1)
      { // munition anti aerienne

        if (remote->getType().category == 1)
        { // 211... = munition anti aerienne guidee
          type = 211;
        }
        else if (remote->getType().category == 2)
        { // 212... = munition anti aerienne ballistique
          type = 212;
        }
        else
          type = -1;

      }
      else if (remote->getType().domain == 2)
      { // munition anti char

        if (remote->getType().category == 1)
        { // 221... = munition anti char guidee
          type = 221;
        }
        else if (remote->getType().category == 2)
        { // 222... = munition anti char ballistique
          type = 222;
        }
        else if (remote->getType().category == 3)
        { // 223... = munition anti char fixe = mines
          type = 223;
        }
        else
          type = -1;
      }
      else
        type = -1;
    }
    else
      type = -1;

    // on analyse le camp : 1=AMI, 2=ENI, 3=NEUTRE, par defaut ENI

    camp = remote->getCamp();
    if (camp == 1)
    {
      type = 1000 + type;
      camp = AMI;
    }
    else if (camp == 2)
    {
      type = 2000 + type;
      camp = ENI;
    }
    else
    {
      type = -1;
      camp = NEUTRE;
    }

    if (typeCompare(remote->getType(), DisGazelleType))
    {
      tope = SA342;
    }
    else if (typeCompare(remote->getType(), DisMI24Type))
    {
      tope = MI24;
    }
    else if (typeCompare(remote->getType(), DisT80Type))
    {
      tope = T80;
    }
    else if (typeCompare(remote->getType(), DisT72Type))
    {
      tope = T72;
    }
    else if (typeCompare(remote->getType(), DisZSU23_4Type))
    {
      tope = ZSU23_4;
    }
    else if (typeCompare(remote->getType(), DisBMP1Type))
    {
      tope = BMP1;
    }
    else if (typeCompare(remote->getType(), DisBMP2Type))
    {
      tope = BMP2;
    }
    else if (typeCompare(remote->getType(), DisZIL131Type))
    {
      tope = ZIL131;
    }
    else if (typeCompare(remote->getType(), DisAMX30B2Type))
    {
      tope = AMX30B2;
    }
    else
    {
      tope = AUTRE;
    }

    // on cree un identifiant SSTH

    SSTHId = ident->addIdent(entityId, applicationId, siteId);
    //IlvPrint("AJOUT %d %d %d %d", SSTHId, entityId, applicationId, siteId);

    // on cree le nom de l'objet

    char	comment[80];
    sprintf (comment, "%d:%d:%d", siteId, applicationId, entityId);

    // on ajoute l'objet graphique associe

    S2dActeur	*a;
    ScnEntite	*e;

    if (camp == AMI)
      a = sitac->acteur_creer(SSTHId, camp, comment, type, ENTITE, S2DSITAC_LAYER_ACTEUR_H);
    else
      a = sitac->acteur_creer(SSTHId, camp, comment, type, ENTITE, S2DSITAC_LAYER_ACTEUR_PA);

    e = new ScnEntite(entityId, camp, NIV_III, tope);
    e->setMarking(remote->getMarking());

    a->scn_entite(e);
    a->desagregable(IlvFalse);

    // on le positionne

    x = remote->getLocation().x;
    y = remote->getLocation().y;
    z = remote->getLocation().z;

    heading = 0;

    vx = remote->getVelocity().x;
    vy = remote->getVelocity().y;
    vz = remote->getVelocity().z;
    v = sqrt (vx*vx+vy*vy+vz*vz);

    sitac->acteur_position(SSTHId, x, y, z, heading, v);

    // on le dessine

    sitac->reDraw();
  }
}


/************************************************************************/
/*									*/
/* Nom: supprimeEntiteDIS						*/
/*									*/
/* Role: Callback appelee en cas d'arret d'emission de PDU State d'une	*/
/*       entite depassant le time out fixe.				*/
/*									*/
/************************************************************************/

int
V2dIHM::supprimeEntiteDIS (DisRemoteEntity* remote)
{
  int			SSTHId;
  int			entityId;
  int			applicationId;
  int			siteId;
  int			rep;

  rep = 0;

  entityId = remote->getID().entity;
  applicationId = remote->getID().address.host;
  siteId = remote->getID().address.site;
  SSTHId = ident->verifIdent(entityId, applicationId, siteId);

  // si l'entite SSTH existe
  if (SSTHId != -1)
  {
    // on supprime l'identifiant SSTH

    ident->suppIdent(entityId, applicationId, siteId);
    //IlvPrint("RETRAIT %d %d %d %d", SSTHId, entityId, applicationId, siteId);

    // si on a le centrage sur cet objet, on l'inhibe

    if (IdCentre == SSTHId)
    {
      rep = 1;
      sitac->acteur_centre (S2D_NOS);
    }

    // on supprime l'objet graphique associe

    sitac->acteur_detruire(SSTHId);
  }

  // on le dessine
  sitac->reDraw();

  return (rep);
}


/************************************************************************/
/*									*/
/* Nom: getTimer							*/
/*									*/
/* Role: renvoie un pointeur vers le timer ILOG				*/
/*									*/
/************************************************************************/

IlvTimer*
V2dIHM::getTimer(void)
{
  return timer;
}


/************/
/* The End. */
/************/

