static char v2danimationsccsid[] = " %Z% %M% %I% %E% - Copyright (c) DE 1997 ";
/************************************************************************/
/*									*/
/*   Ce programme est un produit de la societe DASSAULT ELECTRONIQUE,	*/
/* protege par les lois sur le droit d'auteur et sur le copyright et	*/
/* transmis en licence dans les conditions et termes specifiques	*/
/* indiques dans l'accord de licence qui l'accompagne. DASSAULT		*/
/* ELECTRONIQUE garde la propriete du programme et toutes les 		*/
/* prerogatives qui l'accompagnent. Ce programme ne peut etre modifie	*/
/* en aucune maniere sans l'autorisation ecrite prealable de DASSAULT	*/
/* ELECTRONIQUE.							*/
/*									*/
/* Nom: %M%							*/
/*									*/
/* Version: %I%							*/
/*									*/
/* Historique:								*/
/*	Auteur: D.DULAC							*/
/*	Date: %E%							*/
/*	Creation: 97/03/24						*/
/*									*/
/************************************************************************/

/***********/
/* INCLUDE */
/***********/

#include <unistd.h>
#include <fstream.h>
#include <math.h>

#include <ilviews/ilvgif.h>
#include <ilviews/stdialog.h>

#include "ScnRoute.h"
#include "ScnZone.h"
#include "ScnTrajectoire.h"

#include "V2dKiller.h"
#include "V2dCopie.h"
#include "V2dRenomme.h"
#include "V2dModificationScenario.h"
#include "V2dEditionScenario.h"
#include "V2dApropos.h"
#include "V2dSuppActeur.h"
#include "V2dModifActeur.h"
#include "V2dEditeur.h"
#include "V2dTexte.h"
#include "V2dAnimation.h"


/**********/
/* EXTERN */
/**********/

extern char* VERSION_ANIMATION;
extern int   ID_ANIMATION;
extern char* INTERF_ANIMATION;
extern char* ADRESSE_ANIMATION;

/**********/
/* DEFINE */
/**********/

V2dAnimation*			monIHMAnimation;

V2dTexte*			monTexte;

const int			CARTE_RASTER_50 = 2;
const int			CARTE_RASTER_100 = 1;

float				firstTime;	// date de debut d'exercice

int				cptId2D = 100;	// compteur des id des objets 2D

double				positionEst;	// derniere position UTM
double				positionNord;	// cliquee a la souris


/************************************************************************/
/*									*/
/* Nom: DetonationCB							*/
/*									*/
/* Role: Callback appelee en cas de reception de PDU Detonation.	*/
/*									*/
/************************************************************************/

void
DetonationCB (DetonationPDU* pdu)
{
  char	truc[32];

  sprintf(truc, "Detonation de %d:%d:%d sur %d:%d:%d", 
	pdu->firing_entity_id.address.site,
	pdu->firing_entity_id.address.host,
	pdu->firing_entity_id.entity,
	pdu->target_entity_id.address.site,
	pdu->target_entity_id.address.host,
	pdu->target_entity_id.entity);

  monTexte->gettexte()->insertLabel(0, truc);
  monIHMAnimation->reDrawObj(monTexte->gettexte());
  monTexte->draw();
  monIHMAnimation->detonationDIS(pdu);
}


/************************************************************************/
/*									*/
/* Nom: FireCB								*/
/*									*/
/* Role: Callback appelee en cas de reception de PDU Fire.		*/
/*									*/
/************************************************************************/

void
FireCB (FirePDU* pdu)
{
  char	truc[32];

  sprintf(truc, "Fire de %d:%d:%d sur %d:%d:%d", 
	pdu->firing_entity_id.address.site,
	pdu->firing_entity_id.address.host,
	pdu->firing_entity_id.entity,
	pdu->target_entity_id.address.site,
	pdu->target_entity_id.address.host,
	pdu->target_entity_id.entity);

  monTexte->gettexte()->insertLabel(0, truc);
  monIHMAnimation->reDrawObj(monTexte->gettexte());
  monTexte->draw();
  monIHMAnimation->fireDIS(pdu);
}


/************************************************************************/
/*									*/
/* Nom: ActionCB							*/
/*									*/
/* Role: Callback appelee en cas de reception de PDU Action Response.	*/
/*									*/
/************************************************************************/

void
ActionCB (ActionResponsePDU*)
{
  monTexte->gettexte()->insertLabel(0, "Action response");
  monIHMAnimation->reDrawObj(monTexte->gettexte());
  monTexte->draw();
}


/************************************************************************/
/*									*/
/* Nom: StartCB								*/
/*									*/
/* Role: Callback appelee en cas de reception de PDU Start. 		*/
/*									*/
/************************************************************************/

void
StartCB (StartResumePDU*)
{
  monIHMAnimation->getstart()->setSensitive (IlvFalse);
  monIHMAnimation->getstop()->setSensitive (IlvTrue);
  monIHMAnimation->reDrawObj(monIHMAnimation->getstart());
  monIHMAnimation->reDrawObj(monIHMAnimation->getstop());
}


/************************************************************************/
/*									*/
/* Nom: StopCB								*/
/*									*/
/* Role: Callback appelee en cas de reception de PDU Stop. 		*/
/*									*/
/************************************************************************/

void
StopCB (StopFreezePDU* stopPdu)
{
  if (stopPdu->stop_reason == StopReason_Termination)
  {
    IlvButton* button;

    static IlvIWarner* warner = 0;
    if (!warner) warner =
      new IlvIWarner (monIHMAnimation->getDisplay(), "Exercice termine par un tiers.");
    button = (IlvButton*) warner->getObject("apply");
    if (button) button->setLabel("Fermer");
    warner->setTitle("Message");
    warner->moveToMouse();
    warner->get();

    monIHMAnimation->getstart()->setSensitive (IlvTrue);
    monIHMAnimation->getstop()->setSensitive (IlvTrue);
    monIHMAnimation->reDrawObj(monIHMAnimation->getstart());
    monIHMAnimation->reDrawObj(monIHMAnimation->getstop());
  }
  else
  {
    monIHMAnimation->getstart()->setSensitive (IlvTrue);
    monIHMAnimation->getstop()->setSensitive (IlvFalse);
    monIHMAnimation->reDrawObj(monIHMAnimation->getstart());
    monIHMAnimation->reDrawObj(monIHMAnimation->getstop());
  }
}


/************************************************************************/
/*									*/
/* Nom: CommentCB							*/
/*									*/
/* Role: Callback appelee en cas de reception de PDU Comment. 		*/
/*									*/
/************************************************************************/

void
CommentCB (CommentPDU* commentPdu)
{
  if (commentPdu->num_variable_datum == 1)
  {
    monTexte->gettexte()->insertLabel(0, commentPdu->comment);
    monIHMAnimation->reDrawObj(monTexte->gettexte());
    monTexte->draw();
  }
}

/************************************************************************/
/*									*/
/* Nom: AjouteEntiteCB							*/
/*									*/
/* Role: Callback appelee en cas d'apparition d'une nouvelle entite	*/
/*       DIS sur le reseau.						*/
/*									*/
/************************************************************************/

void
AjouteEntiteCB (DisRemoteEntity* remote)
{
  monIHMAnimation->ajouteEntiteDIS(remote);
}


/************************************************************************/
/*									*/
/* Nom: SupprimeEntiteCB						*/
/*									*/
/* Role: Callback appelee en cas de suppression d'une entite existante	*/
/*       DIS.								*/
/*									*/
/************************************************************************/

void
SupprimeEntiteCB (DisRemoteEntity* remote)
{
  monIHMAnimation->supprimeEntiteDIS(remote);
}


/************************************************************************/
/*									*/
/* Nom: Click								*/
/*									*/
/* Role: Interacteur donnant la position utm du point designe. 		*/
/*									*/
/************************************************************************/

static void
Click(IlvManager* manager, IlvView* view, IlvEvent& event, IlvAny)
{
  IlvTransformer	*t = manager->getTransformer(view);
  IlvPoint		 p;
  char			 position[64];

  p.x(event.x());
  p.y(event.y());
  if (t) t->inverse(p);
  positionEst = p.x();
  positionNord = p.y();

  sprintf(position, "E %d - N %d", (int) positionEst, (int) positionNord);
  monIHMAnimation->getposition()->setLabel(position);
  monIHMAnimation->reDrawObj(monIHMAnimation->getposition());
}


/************************************************************************/
/*									*/
/* Nom: MiseAJour							*/
/*									*/
/* Role: Callback appelee regulierement et mettant a jour les positions	*/
/*       des entites DIS sur la carte.					*/
/*									*/
/************************************************************************/

static void ILVCALLBACK
MiseAJour (IlvTimer*, IlvAny arg)
{
  V2dAnimation*		animation = (V2dAnimation*) arg;
  static char		timec[64];
  static int		time = 0;

  // affichage du temps de simulation sur sitac
  // ------------------------------------------

  if ((time % 5) == 0)
  {
    char		*ptr;
    char		 date[48];
    FILE		*datum;
    datum = popen("date '+le %d/%m/%y a %H:%M:%S'", "r");
    fgets(date,48,datum);
    if ((ptr = strrchr(date, '\n')) != NULL) *ptr = '\0';
    pclose(datum);

    sprintf(timec, "%c%c:%c%c:%c%c", date[14], date[15], date[17], date[18], date[20], date[21]);
    animation->getheure()->setLabel(timec);
    animation->reDrawObj(animation->getheure());
    sprintf(timec, "recu %s ", date);
  }
  time++;

  animation->miseAJour();
}


/************************************************************************/
/*									*/
/* Nom: V2dAnimation							*/
/*									*/
/* Role: Constructeur							*/
/*									*/
/************************************************************************/

V2dAnimation::V2dAnimation(IlvDisplay* display, const char* name,
		 const char* title, IlvRect* size,
		 IlvBoolean useAccelerators, IlvBoolean visible)
 : Animation (display, name, title, size, useAccelerators, visible)
 , V2dIHM (display)
{
  initialize (display);
}


/************************************************************************/
/*									*/
/* Nom: V2dAnimation							*/
/*									*/
/* Role: Constructeur							*/
/*									*/
/************************************************************************/

V2dAnimation::V2dAnimation(IlvCompositeAbstractView* aview, IlvRect* size)
 : Animation (aview, size)
 , V2dIHM (aview->getDisplay())
{
  initialize (aview->getDisplay());
}


/************************************************************************/
/*									*/
/* Nom: V2dAnimation							*/
/*									*/
/* Role: Destructeur							*/
/*									*/
/************************************************************************/

V2dAnimation::~V2dAnimation()
{
  //delete monTexte;
  if (ident) delete ident;
  if (exercise) delete exercise;
  if (remoteEntities) delete remoteEntities;
  if (timer) delete timer;
  if (table_des_symboles) delete table_des_symboles;
}


/************************************************************************/
/*									*/
/* Nom: initialize							*/
/*									*/
/* Role: Initialisation de la classe					*/
/*									*/
/************************************************************************/

void
V2dAnimation::initialize(IlvDisplay* display)
{
    char	path[256];
    IlvBitmap*  bitmap;
    IlvButton*	button;

    monIHMAnimation = this;

    firstTime = 0.0;

    // ENVIRONNEMENT

    if (!getenv("SSTH_HOME"))
    {
      static IlvIWarner* warner = 0;
      if (!warner) warner =
        new IlvIWarner (display, "Mettre a jour la variable SSTH_HOME.");
      button = (IlvButton*) warner->getObject("apply");
      if (button) button->setLabel("Fermer");
      warner->setTitle("Probleme d'initialisation");
      warner->moveToMouse();
      warner->get();
      delete display;
      IlvExit(0);
    }

    monTexte = new V2dTexte (display, "Messages DIS", "Messages DIS");
    monTexte->move(IlvPoint(0,820));
    monTexte->show();

    // LOGO D.E.

    sprintf(path, "%s/DATA/logo/logoDE.gif", getenv ("SSTH_HOME"));
    ifstream file1 (path);
    bitmap = IlvReadGIFBitmap (display, file1);
    if (bitmap)
    {
      getlogoDE()->setBitmap(bitmap);
    }

    // SYMBOLES 2D

    table_des_symboles = 0;

    sprintf(path, "%s/DATA/tta106/acteur_tta106", getenv ("SSTH_HOME"));
    if (access(path, R_OK) == 0)
    {
      IlvPrint ("Chargement de la table %s", path);
      table_des_symboles = new S2dSymboles(path, display);
      IlvPrint ("Table des symboles chargee.");
    }
    else table_des_symboles = 0;

    // SITAC 2D

    IlvSCManagerRectangle* rectmgr = getscroll();

    view = rectmgr->getView();

    rectmgr->setManager(sitac, IlvFalse);

    sitac->graphique_interacteur (view);

    sitac->setDoubleBuffering(view, IlvTrue);

    // INITIALISATIONS DIVERSES

    nbTraj = 0;

    ident = 0;
    exercise = 0;
    remoteEntities = 0;
    timer = 0;

    getechelle()->setLabel("1/100.000");
    reDrawObj(getechelle());

    getstart()->setSensitive (IlvFalse);
    getstop()->setSensitive (IlvFalse);
    getend()->setSensitive (IlvFalse);
    getchange()->setSensitive (IlvFalse);
    getremove()->setSensitive (IlvFalse);
    getdetonate()->setSensitive (IlvFalse);
    reDrawObj(getstart());
    reDrawObj(getstop());
    reDrawObj(getend());
    reDrawObj(getchange());
    reDrawObj(getremove());
    reDrawObj(getdetonate());
}


/************************************************************************/
/*									*/
/* Nom: charger_scn							*/
/*									*/
/* Role: chargement d'un scenario et initialisation de son affichage	*/
/*									*/
/************************************************************************/

void
V2dAnimation::charger_scn(IlvGraphic* g)
{
  char			path[256];
  IlvContainer*		container = IlvContainer::getContainer(g);
  IlvDisplay*		display = container->getDisplay();
  const char*		fileName;
  IlvIFileSelector*	selecteur;
  IlvButton*		button;
  IlvMessageLabel*	label;

  if (exercise)
  {
      static IlvIWarner* warner = 0;
      if (!warner) warner =
        new IlvIWarner (display, "Deja un scenario de charge.");
      button = (IlvButton*) warner->getObject("apply");
      if (button) button->setLabel("Fermer");
      warner->setTitle("Branlon !");
      warner->moveToMouse();
      warner->get();
  }
  else
  {
    sprintf(path, "%s/DATA/scenario", getenv("SSTH_HOME"));
    selecteur = new IlvIFileSelector (display, path, "*.scn");
    selecteur->setTitle("Selection de scenario");

    // francisation

    label = (IlvMessageLabel*) selecteur->getObject("dirtitle");
    if (label) label->setLabel("Filtre");
    label = (IlvMessageLabel*) selecteur->getObject("title");
    if (label) label->setLabel("Choix");
    button = (IlvButton*) selecteur->getObject("ok");
    if (button) button->setLabel("Oui");
    button = (IlvButton*) selecteur->getObject("reset");
    if (button) button->setLabel("Efface");
    button = (IlvButton*) selecteur->getObject("cancel");
    if (button) button->setLabel("Annule");

    selecteur->moveToMouse();
    fileName = selecteur->get();
    if (fileName)
    {
      int			disPort;
      int			exerciseId;
      int			siteId;
      int			applicationNumber;
      float			timeThreshold;
      float			translationThreshold;
      float			rotationThreshold;
      float			timeOutInterval;
      char*			nomReseau;

      // On change de type de curseur (wait) pour le chargement :

      IlvCursor* cursor = display->getCursor("wait");
      setCursor(cursor);
      view->setCursor(cursor);
      display->flush();

      // On affiche le nom du fichier selectionne dans le champ fichier

      getfichier()->setLabel(fileName);
      getfichier()->setTextPosition(strlen(path)-8);
      reDrawObj(getfichier());

      // on charge le fichier scenario

      IlvPrint ("Chargement du scenario %s", fileName);
      sitac->scenario((char*) fileName);
      IlvPrint ("Scenario charge");

      sitac->echelle(view, CARTE_RASTER_100);

      sitac->addAccelerator(Click, IlvDoubleClick, IlvLeftButton);

      sitac->draw();

      // On n'affiche pas les routes

      sitac->routes_efface();

      // on charge et on dessine le reseau routier

      nomReseau = sitac->scenario()->getNomReseau();
      IlvPrint ("Chargement du reseau %s", nomReseau);
      dessineReseau(nomReseau);
      delete nomReseau;
      IlvPrint ("Reseau routier charge");

      // on initialise le tableau des identifiants

      ident = new V2dIdent(sitac->scenario());

      // pas de temps en ms

      float dt = 100.0;

      // on cree et initialise les objets DIS : exercise et remoteEntities
      // on depose les callbacks

      disPort = sitac->scenario()->getDisPort ();
      exerciseId = sitac->scenario()->getExerciseId ();
      siteId = sitac->scenario()->getSiteId ();
      applicationNumber = ID_ANIMATION;
      timeThreshold = sitac->scenario()->getSeuilTemps();
      translationThreshold = sitac->scenario()->getSeuilTran();
      rotationThreshold = sitac->scenario()->getSeuilRot();
      timeOutInterval = sitac->scenario()->getSeuilTemps();

      exercise = new DisExercise (disPort, exerciseId, siteId, 
				  applicationNumber, INTERF_ANIMATION, ADRESSE_ANIMATION);

      if (exercise->creationOK() == FALSE)
      {
        static IlvIWarner* warner = 0;
        if (!warner) warner =
          new IlvIWarner (display, "Port DIS deja utilise ?");
        button = (IlvButton*) warner->getObject("apply");
        if (button) button->setLabel("Fermer");
        warner->setTitle("Probleme d'initialisation");
        warner->moveToMouse();
        warner->get();
        delete display;
        IlvExit(0);
      }

      IlvPrint("");
      IlvPrint(" Port reseau DIS		: %d", disPort);
      IlvPrint(" Numero d'exercice DIS		: %d", exerciseId);
      IlvPrint(" Numero de site DIS		: %d", siteId);
      IlvPrint(" Numero d'application DIS	: %d", applicationNumber);
      IlvPrint(" Pas de temps			: %f ms", dt);
      IlvPrint(" Seuil temps			: %f ", timeThreshold);
      IlvPrint(" Seuil trans			: %f ", translationThreshold);
      IlvPrint(" Seuil rot			: %f ", rotationThreshold);
      IlvPrint(" Time out			: %f ", timeOutInterval);
      IlvPrint(" ");
      IlvPrint(" Interface reseau		: %s ", INTERF_ANIMATION);
      IlvPrint(" Adresse multicast		: %s ", ADRESSE_ANIMATION);
      IlvPrint("");

      exercise->setTimeThreshold(timeThreshold);
      exercise->setTranslationThreshold(translationThreshold);
      exercise->setRotationThreshold(rotationThreshold);

      exercise->detonationCB = &DetonationCB;
      exercise->fireCB = &FireCB;
      exercise->startCB = &StartCB;
      exercise->stopCB = &StopCB;
      exercise->commentCB = &CommentCB;
      exercise->actionResponseCB = &ActionCB;

      remoteEntities = new DisRemoteEntities (exercise);

      remoteEntities->setAddEntity(&AjouteEntiteCB);
      remoteEntities->setDeleteEntity(&SupprimeEntiteCB);

      // on cree le timer pour l'interrogation reguliere du reseau DIS

      timer = new IlvTimer (display, 0, dt, MiseAJour, this);

      // On reprend le curseur normal :

      cursor = display->getCursor("default");
      setCursor(cursor);
      view->setCursor(cursor);
      display->flush();

      // On rend les boutons start/stop/end sensibles :

      getstart()->setSensitive (IlvTrue);
      getstop()->setSensitive (IlvFalse);
      getend()->setSensitive (IlvTrue);
      getchange()->setSensitive (IlvTrue);
      getremove()->setSensitive (IlvTrue);
      getdetonate()->setSensitive (IlvTrue);
      reDrawObj(getstart());
      reDrawObj(getstop());
      reDrawObj(getend());
      reDrawObj(getchange());
      reDrawObj(getremove());
      reDrawObj(getdetonate());

      getechelle()->setSensitive (IlvTrue);
      getcarte()->setSensitive (IlvTrue);
      getsymboles()->setSensitive (IlvTrue);
      getacteurs()->setSensitive (IlvTrue);
      gettrajectoires()->setSensitive (IlvTrue);
      getroutes()->setSensitive (IlvTrue);
      getcentrage()->setSensitive (IlvTrue);
      reDrawObj(getechelle());
      reDrawObj(getcarte());
      reDrawObj(getsymboles());
      reDrawObj(getacteurs());
      reDrawObj(gettrajectoires());
      reDrawObj(getroutes());
      reDrawObj(getcentrage());

      // on se met a l'ecoute de DIS

      timer->run();
    }

    delete selecteur;
  }  
}


/************************************************************************/
/*									*/
/* Nom: copier_scn							*/
/*									*/
/* Role: Copie d'un scenario						*/
/*									*/
/************************************************************************/

void
V2dAnimation::copier_scn(IlvGraphic* g)
{
  char			path[256];
  IlvContainer*		container = IlvContainer::getContainer(g);
  IlvDisplay*		display = container->getDisplay();
  const char*		fileName;
  IlvIFileSelector*	selecteur;
  IlvButton*		button;
  IlvMessageLabel*	label;

  sprintf(path, "%s/DATA/scenario", getenv("SSTH_HOME"));
  selecteur = new IlvIFileSelector (display, path, "*.scn");
  selecteur->setTitle("Selection de scenario");

  // francisation

  label = (IlvMessageLabel*) selecteur->getObject("dirtitle");
  if (label) label->setLabel("Filtre");
  label = (IlvMessageLabel*) selecteur->getObject("title");
  if (label) label->setLabel("Choix");
  button = (IlvButton*) selecteur->getObject("ok");
  if (button) button->setLabel("Oui");
  button = (IlvButton*) selecteur->getObject("reset");
  if (button) button->setLabel("Efface");
  button = (IlvButton*) selecteur->getObject("cancel");
  if (button) button->setLabel("Annule");

  selecteur->moveToMouse();
  fileName = selecteur->get();
  if (fileName)
  {
    V2dCopie*	copie = new V2dCopie (path, (char *) fileName, display, "Copie de scenario", "Copie de scenario");
    copie->moveToMouse();
    copie->show();
  }
  delete selecteur;
}


/************************************************************************/
/*									*/
/* Nom: creer_scn							*/
/*									*/
/* Role: Creation d'un scenario						*/
/*									*/
/************************************************************************/

void
V2dAnimation::creer_scn(IlvGraphic* g)
{
  char			path[256];
  IlvContainer*		 container = IlvContainer::getContainer(g);
  IlvDisplay*		 display = container->getDisplay();
  IlvIPromptString*	 prompt;
  IlvButton*		 button;
  const char*		 comment;

  prompt = new IlvIPromptString (display);
  prompt->setTitle("Saisie du nom du scenario");
  prompt->setString("Nom");
  button = (IlvButton*) prompt->getObject("apply");
  if (button) button->setLabel("Creer");
  button = (IlvButton*) prompt->getObject("cancel");
  if (button) button->setLabel("Annuler");
  prompt->moveToMouse();
  comment = prompt->get();
  if (comment)
  {
    sprintf(path, "%s/DATA/scenario/%s", getenv("SSTH_HOME"), comment);
    if (access(path, R_OK) == 0)
    {
      static IlvIWarner* warner = 0;
      if (!warner) warner =
        new IlvIWarner (display, "Deja un scenario avec ce nom.");
      button = (IlvButton*) warner->getObject("apply");
      if (button) button->setLabel("Fermer");
      warner->setTitle("Probleme de creation");
      warner->moveToMouse();
      warner->get();
    }
    else
    {
      ScnVector		point1(276450, 4800900, 0);
      ScnVector		point2(276450, 4777700, 0);
      ScnVector		point3(311940, 4777700, 0);
      ScnVector		point4(311940, 4800900, 0);
      ScnZone		maZone(point1, point2, point3, point4);
      ScnScenario	scen("","?","?",maZone);

      scen.sauvegarde(path);

      V2dModificationScenario* modif =
      new V2dModificationScenario (display, "Creation de scenario", "Creation de scenario");

      modif->moveToMouse();

      modif->setModeCreation();

      modif->setFichierScenario((char *) path);
      modif->setPort(scen.getDisPort());
      modif->setExercice(scen.getExerciseId());
      modif->setSite(scen.getSiteId());
      modif->setPas(scen.getPas());
      modif->setTerrain(scen.getNomTerrain());
      modif->setReseau(scen.getNomReseau());

      modif->show();
    }
  }
  delete prompt;
}


/************************************************************************/
/*									*/
/* Nom: editer_scn							*/
/*									*/
/* Role: Edition d'un scenario						*/
/*									*/
/************************************************************************/

void
V2dAnimation::editer_scn(IlvGraphic* g)
{
  char			path[256];
  IlvContainer*		container = IlvContainer::getContainer(g);
  IlvDisplay*		display = container->getDisplay();
  const char*		fileName;
  IlvIFileSelector*	selecteur;
  IlvButton*		button;
  IlvMessageLabel*	label;

  sprintf(path, "%s/DATA/scenario", getenv("SSTH_HOME"));
  selecteur = new IlvIFileSelector (display, path, "*.scn");
  selecteur->setTitle("Selection de scenario");

  // francisation

  label = (IlvMessageLabel*) selecteur->getObject("dirtitle");
  if (label) label->setLabel("Filtre");
  label = (IlvMessageLabel*) selecteur->getObject("title");
  if (label) label->setLabel("Choix");
  button = (IlvButton*) selecteur->getObject("ok");
  if (button) button->setLabel("Oui");
  button = (IlvButton*) selecteur->getObject("reset");
  if (button) button->setLabel("Efface");
  button = (IlvButton*) selecteur->getObject("cancel");
  if (button) button->setLabel("Annule");

  selecteur->moveToMouse();
  fileName = selecteur->get();
  if (fileName)
  {
    ScnScenario		scen((char*) fileName);
    ScnActeur*		acteur;

    V2dEditionScenario* edit =
      new V2dEditionScenario (display, "Edition de scenario", "Edition de scenario");

    edit->moveToMouse();

    edit->setFichierScenario((char *) fileName);
    edit->setPort(scen.getDisPort());
    edit->setExercice(scen.getExerciseId());
    edit->setSite(scen.getSiteId());
    edit->setPas(scen.getPas());
    edit->setTerrain(scen.getNomTerrain());
    edit->setReseau(scen.getNomReseau());

    acteur = scen.premierActeur();
    while (acteur)
    {
      edit->addActeur(acteur->getNom());
      acteur = acteur->suivant();
    }
    edit->show();
  }
  delete selecteur;
}


/************************************************************************/
/*									*/
/* Nom: modifier_scn							*/
/*									*/
/* Role: Modification d'un scenario					*/
/*									*/
/************************************************************************/

void
V2dAnimation::modifier_scn(IlvGraphic* g)
{
  char			path[256];
  IlvContainer*		container = IlvContainer::getContainer(g);
  IlvDisplay*		display = container->getDisplay();
  const char*		fileName;
  IlvIFileSelector*	selecteur;
  IlvButton*		button;
  IlvMessageLabel*	label;

  sprintf(path, "%s/DATA/scenario", getenv("SSTH_HOME"));
  selecteur = new IlvIFileSelector (display, path, "*.scn");
  selecteur->setTitle("Selection de scenario");

  // francisation

  label = (IlvMessageLabel*) selecteur->getObject("dirtitle");
  if (label) label->setLabel("Filtre");
  label = (IlvMessageLabel*) selecteur->getObject("title");
  if (label) label->setLabel("Choix");
  button = (IlvButton*) selecteur->getObject("ok");
  if (button) button->setLabel("Oui");
  button = (IlvButton*) selecteur->getObject("reset");
  if (button) button->setLabel("Efface");
  button = (IlvButton*) selecteur->getObject("cancel");
  if (button) button->setLabel("Annule");

  selecteur->moveToMouse();
  fileName = selecteur->get();
  if (fileName)
  {
    if (access(fileName, W_OK) == 0)
    {
      ScnScenario		scen((char*) fileName);
      ScnActeur*		acteur;

      V2dModificationScenario* modif =
        new V2dModificationScenario (display, "Modification de scenario", "Modification de scenario");

      modif->moveToMouse();

      modif->setFichierScenario((char *) fileName);
      modif->setPort(scen.getDisPort());
      modif->setExercice(scen.getExerciseId());
      modif->setSite(scen.getSiteId());
      modif->setPas(scen.getPas());
      modif->setTerrain(scen.getNomTerrain());
      modif->setReseau(scen.getNomReseau());

      acteur = scen.premierActeur();
      while (acteur)
      {
        modif->addActeur(acteur->getNom());
        acteur = acteur->suivant();
      }
      modif->show();
    }
    else
    {
      static IlvIWarner* warner = 0;
      if (!warner) warner =
        new IlvIWarner (display, "Scenario protege en ecriture.");
      button = (IlvButton*) warner->getObject("apply");
      if (button) button->setLabel("Fermer");
      warner->setTitle("Modification impossible");
      warner->moveToMouse();
      warner->get();
    }
  }
  delete selecteur;
}


/************************************************************************/
/*									*/
/* Nom: supprimer_scn							*/
/*									*/
/* Role: Supprimer un scenario						*/
/*									*/
/************************************************************************/

void
V2dAnimation::supprimer_scn(IlvGraphic* g)
{
  char			path[256];
  IlvContainer*		container = IlvContainer::getContainer(g);
  IlvDisplay*		display = container->getDisplay();
  const char*		fileName;
  IlvIFileSelector*	selecteur;
  IlvButton*		button;
  IlvMessageLabel*	label;

  sprintf(path, "%s/DATA/scenario", getenv("SSTH_HOME"));
  selecteur = new IlvIFileSelector (display, path, "*.scn");
  selecteur->setTitle("Selection de scenario");

  // francisation

  label = (IlvMessageLabel*) selecteur->getObject("dirtitle");
  if (label) label->setLabel("Filtre");
  label = (IlvMessageLabel*) selecteur->getObject("title");
  if (label) label->setLabel("Choix");
  button = (IlvButton*) selecteur->getObject("ok");
  if (button) button->setLabel("Oui");
  button = (IlvButton*) selecteur->getObject("reset");
  if (button) button->setLabel("Efface");
  button = (IlvButton*) selecteur->getObject("cancel");
  if (button) button->setLabel("Annule");

  selecteur->moveToMouse();
  fileName = selecteur->get();
  if (fileName)
  {
    static IlvIQuestionDialog* questiondialog = 0;
    if (!questiondialog) questiondialog =
      new IlvIQuestionDialog (display, "Voulez-vous vraiment detruire ce fichier ?");
    questiondialog->setTitle("Confirmation de destruction");
    button = (IlvButton*) questiondialog->getObject("apply");
    if (button) button->setLabel("Oui");
    button = (IlvButton*) questiondialog->getObject("cancel");
    if (button) button->setLabel("Non");
    questiondialog->moveToMouse();
    if (questiondialog->get())
    {
      char		commande[256];

      sprintf(commande, "rm %s", fileName);
      system (commande);
    }
  }
  delete selecteur;
}


/************************************************************************/
/*									*/
/* Nom: renommer_scn							*/
/*									*/
/* Role: Renommer un scenario						*/
/*									*/
/************************************************************************/

void
V2dAnimation::renommer_scn(IlvGraphic* g)
{
  char			path[256];
  IlvContainer*		container = IlvContainer::getContainer(g);
  IlvDisplay*		display = container->getDisplay();
  const char*		fileName;
  IlvIFileSelector*	selecteur;
  IlvButton*		button;
  IlvMessageLabel*	label;

  sprintf(path, "%s/DATA/scenario", getenv("SSTH_HOME"));
  selecteur = new IlvIFileSelector (display, path, "*.scn");
  selecteur->setTitle("Selection de scenario");

  // francisation

  label = (IlvMessageLabel*) selecteur->getObject("dirtitle");
  if (label) label->setLabel("Filtre");
  label = (IlvMessageLabel*) selecteur->getObject("title");
  if (label) label->setLabel("Choix");
  button = (IlvButton*) selecteur->getObject("ok");
  if (button) button->setLabel("Oui");
  button = (IlvButton*) selecteur->getObject("reset");
  if (button) button->setLabel("Efface");
  button = (IlvButton*) selecteur->getObject("cancel");
  if (button) button->setLabel("Annule");

  selecteur->moveToMouse();
  fileName = selecteur->get();
  if (fileName)
  {
    V2dRenomme*	renomme = new V2dRenomme (path, (char *) fileName, display, "Renommage de scenario", "Renommage de scenario");
    renomme->moveToMouse();
    renomme->show();
  }
  delete selecteur;
}


/************************************************************************/
/*									*/
/* Nom: affiche_traj							*/
/*									*/
/* Role: Affiche une trajectoire					*/
/*									*/
/************************************************************************/

void
V2dAnimation::affiche_traj(IlvGraphic* g)
{
  char			path[256];
  IlvContainer*		container = IlvContainer::getContainer(g);
  IlvDisplay*		display = container->getDisplay();
  const char*		fileName;
  IlvIFileSelector*	selecteur;
  IlvButton*		button;
  IlvMessageLabel*	label;
  IlvPalette*		palette;

  if (ident)
  {
    sprintf(path, "%s/DATA/trajectoire", getenv("SSTH_HOME"));
    selecteur = new IlvIFileSelector (display, path, "*.traj");
    selecteur->setTitle("Selection de trajectoire");

    // francisation

    label = (IlvMessageLabel*) selecteur->getObject("dirtitle");
    if (label) label->setLabel("Filtre");
    label = (IlvMessageLabel*) selecteur->getObject("title");
    if (label) label->setLabel("Choix");
    button = (IlvButton*) selecteur->getObject("ok");
    if (button) button->setLabel("Oui");
    button = (IlvButton*) selecteur->getObject("reset");
    if (button) button->setLabel("Efface");
    button = (IlvButton*) selecteur->getObject("cancel");
    if (button) button->setLabel("Annule");

    selecteur->moveToMouse();
    fileName = selecteur->get();
    if (fileName)
    {
      ScnTrajectoire		trajectoire;
      int			ret;

      ret = trajectoire.lire((char *) fileName);
      if (ret == 1)
      {
        IlvPoint	*liste;
        ScnPoint	*ptr;
        int		 taille;
        int		 j;

        taille = trajectoire.getNbPoints();
        ptr = trajectoire.premier();
        liste = new IlvPoint[taille];

        for (j = 0; j < taille; j++)
        {
          liste[j].x((int) ptr->x);
          liste[j].y((int) ptr->y);
          ptr = ptr->suiv;
        }

        palette = display->getPalette(0, display->getColor("blue"), 0, 0, 0, 0, 2);
        if ((palette) && (nbTraj < NB_TRAJ_MAX))
        {
          sitac->graphique_creer(cptId2D, taille, liste, S2D_GRAPHIQUE_TYPE_LIGNE, palette);
          tabTraj[nbTraj++] = cptId2D++;
        }
        sitac->reDraw();
      }
      else
      {
        static IlvIWarner* warner = 0;
        if (!warner) warner =
          new IlvIWarner (display, "Probleme de chargement !");
        warner->setTitle("Probleme");
        button = (IlvButton*) warner->getObject("apply");
        if (button) button->setLabel("Fermer");
        warner->moveToMouse();
        warner->get();
      }
    }
    delete selecteur;
  }
  else
  {
    static IlvIQuestionDialog* questiondialog = 0;
    if (!questiondialog) questiondialog =
      new IlvIQuestionDialog (display, "Charger un scenario avant !");
    questiondialog->setTitle("Probleme");
    button = (IlvButton*) questiondialog->getObject("apply");
    if (button) button->setLabel("Oui");
    button = (IlvButton*) questiondialog->getObject("cancel");
    if (button) button->setLabel("Oui !");
    questiondialog->moveToMouse();
    questiondialog->get();
  }
}


/************************************************************************/
/*									*/
/* Nom: efface_traj							*/
/*									*/
/* Role: Efface les trajectoires affichees				*/
/*									*/
/************************************************************************/

void
V2dAnimation::efface_traj(IlvGraphic*)
{
  for (int i = 0; i < nbTraj; i++)
  {
    sitac->graphique_detruire(tabTraj[i], S2D_GRAPHIQUE_TYPE_LIGNE);
  }
  nbTraj = 0;
}


/************************************************************************/
/*									*/
/* Nom: version								*/
/*									*/
/* Role: cree et affiche la fenetre "A propos"				*/
/*									*/
/************************************************************************/

void
V2dAnimation::version(IlvGraphic* g)
{
  IlvContainer*		container = IlvContainer::getContainer(g);
  IlvDisplay*		display = container->getDisplay();

  V2dApropos* propos =
    new V2dApropos (display, "Version", "Version");
  propos->moveToMouse();
  propos->legende("SSTH Animation", VERSION_ANIMATION);
  propos->show();
}


/************************************************************************/
/*									*/
/* Nom: browser								*/
/*									*/
/* Role: lance l'application viewer HTML sur l'aide			*/
/*									*/
/************************************************************************/

void
V2dAnimation::browser(IlvGraphic*)
{
  char	commande[128];
  sprintf(commande, "%s/HTML/bin/viewer -F r&", getenv("SSTH_HOME"));
  system (commande);
}


/************************************************************************/
/*									*/
/* Nom: aide								*/
/*									*/
/* Role: cree et affiche la fenetre "Aide"				*/
/*									*/
/************************************************************************/

void
V2dAnimation::aide(IlvGraphic* g)
{
  char			fichier[256];
  IlvContainer*		container = IlvContainer::getContainer(g);
  IlvDisplay*		display = container->getDisplay();

  sprintf(fichier, "%s/DATA/aide/animation.txt", getenv("SSTH_HOME"));

  V2dEditeur* editeur =
    new V2dEditeur (display, "Aide du poste animation", "Aide du poste animation");
  ifstream	file(fichier);
  char		ligne[256];

  if (!file)
    IlvPrint("Impossible d'ouvrir le fichier : %s", fichier);
  else
    while (file.getline(ligne, 80, '\n'))
    {
      editeur->gettext()->addLabel(ligne);
    }
  editeur->moveToMouse();
  editeur->show();
}


/************************************************************************/
/*									*/
/* Nom: echelle								*/
/*									*/
/* Role: cb du bouton activant le changement de niveau d'echelle	*/
/*									*/
/************************************************************************/

void
V2dAnimation::echelle(IlvGraphic*)
{
/*
  if (_echelle == CARTE_RASTER_50)
  {
    _echelle = CARTE_RASTER_100;
    getechelle()->setLabel("1/100.000");
  }
  else
  {
    _echelle = CARTE_RASTER_50;
    getechelle()->setLabel("ZOOM");
  }
  reDrawObj(getechelle());
  sitac->echelle(view,  _echelle);
  reDraw();
*/
}


/************************************************************************/
/*									*/
/* Nom: carte								*/
/*									*/
/* Role: cb du bouton activant le filtre carte				*/
/*									*/
/************************************************************************/

void
V2dAnimation::carte(IlvGraphic*)
{
  if (_carte == IlvFalse)
    sitac->carte_affiche();
  else
    sitac->carte_efface();

  _carte = !_carte;
}


/************************************************************************/
/*									*/
/* Nom: symboles							*/
/*									*/
/* Role: cb du bouton activant le filtre symboles			*/
/*									*/
/************************************************************************/

void
V2dAnimation::symboles(IlvGraphic*)
{
  if (_wfz == IlvFalse)
    sitac->graphiques_affiche();
  else
    sitac->graphiques_efface();

  _wfz = !_wfz;
}


/************************************************************************/
/*									*/
/* Nom: acteurs								*/
/*									*/
/* Role: cb du bouton activant le filtre acteurs			*/
/*									*/
/************************************************************************/

void
V2dAnimation::acteurs(IlvGraphic*)
{
  if (_symbole == IlvFalse)
    sitac->symboles_affiche();
  else
    sitac->symboles_efface();

  _symbole = !_symbole;
}


/************************************************************************/
/*									*/
/* Nom: trajectoires							*/
/*									*/
/* Role: cb du bouton activant le filtre trajectoires			*/
/*									*/
/************************************************************************/

void
V2dAnimation::trajectoires(IlvGraphic*)
{
  if (_trajectoire == IlvFalse)
    sitac->trajectoires_affiche();
  else
    sitac->trajectoires_efface();

  _trajectoire = !_trajectoire;
}


/************************************************************************/
/*									*/
/* Nom: routes								*/
/*									*/
/* Role: cb du bouton activant le filtre routes				*/
/*									*/
/************************************************************************/

void
V2dAnimation::routes(IlvGraphic*)
{
  if (_etat == IlvFalse)
  {
    sitac->etats_affiche();
    sitac->routes_affiche();
  }
  else
  {
    sitac->etats_efface();
    sitac->routes_efface();
  }

  _etat = !_etat;
}


/************************************************************************/
/*									*/
/* Nom: centrage							*/
/*									*/
/* Role: cb du centrage sur un acteur					*/
/*									*/
/************************************************************************/

void
V2dAnimation::centrage(IlvGraphic* g)
{
  IlvOptionMenu*	menu = (IlvOptionMenu*) g;
  const char*		option = menu->getLabel();
  const int		numero = menu->whichSelected ();
  IlvContainer*		container = IlvContainer::getContainer(g);
  IlvDisplay*		display = container->getDisplay();

  if (numero == 0)
  {
    IlvPrint("Centrage sur %s", option);
    IdCentre = -1;
    sitac->acteur_centre (S2D_NOS);
  }
  else if (numero == 1)
  {
    int		id;
    id = 0; //sitac->scenario()->helicoByRole(LEADER_BLEU);
    if (id == -1)
    {
      IlvPrint("Pas d'helicoptere %s", option);
      IdCentre = -1;
      sitac->acteur_centre (S2D_NOS);
      getcentrage()->setSelected(0);
      reDrawObj(getcentrage());
    }
    else
    {
      IlvPrint("Centrage sur %s", option);
      IdCentre = id;
      sitac->acteur_centre (id);
    }
  }
  else if (numero == 2)
  {
    int		id;
    id = 0; //sitac->scenario()->helicoByRole(AILIER_ROUGE);
    if (id == -1)
    {
      IlvPrint("Pas d'helicoptere %s", option);
      IdCentre = -1;
      sitac->acteur_centre (S2D_NOS);
      getcentrage()->setSelected(0);
      reDrawObj(getcentrage());
    }
    else
    {
      IlvPrint("Centrage sur %s", option);
      IdCentre = id;
      sitac->acteur_centre (id);
    }
  }
  else if (numero == 3)
  {
    int		id;
    id = 0; //sitac->scenario()->helicoByRole(LEADER_JAUNE);
    if (id == -1)
    {
      IlvPrint("Pas d'helicoptere %s", option);
      IdCentre = -1;
      sitac->acteur_centre (S2D_NOS);
      getcentrage()->setSelected(0);
      reDrawObj(getcentrage());
    }
    else
    {
      IlvPrint("Centrage sur %s", option);
      IdCentre = id;
      sitac->acteur_centre (id);
    }
  }
  else if (numero == 4)
  {
    int		id;
    id = 0; //sitac->scenario()->helicoByRole(AILIER_VERT);
    if (id == -1)
    {
      IlvPrint("Pas d'helicoptere %s", option);
      IdCentre = -1;
      sitac->acteur_centre (S2D_NOS);
      getcentrage()->setSelected(0);
      reDrawObj(getcentrage());
    }
    else
    {
      IlvPrint("Centrage sur %s", option);
      IdCentre = id;
      sitac->acteur_centre (id);
    }
  }
  else if (numero == 5)
  {
    int		id;
    id = 0; //sitac->scenario()->helicoByRole(AILIER_NOIR);
    if (id == -1)
    {
      IlvPrint("Pas d'helicoptere %s", option);
      IdCentre = -1;
      sitac->acteur_centre (S2D_NOS);
      getcentrage()->setSelected(0);
      reDrawObj(getcentrage());
    }
    else
    {
      IlvPrint("Centrage sur %s", option);
      IdCentre = id;
      sitac->acteur_centre (id);
    }
  }
  else
  {
    IdCentre = -1;
    sitac->acteur_centre (S2D_NOS);
    getcentrage()->setSelected(0);
    reDrawObj(getcentrage());
  }
}


/************************************************************************/
/*									*/
/* Nom: start								*/
/*									*/
/* Role: cb pour envoie d'un START					*/
/*									*/
/************************************************************************/

void
V2dAnimation::start(IlvGraphic*)
{
  exercise->sendStartPDU(1);
  getstart()->setSensitive (IlvFalse);
  getstop()->setSensitive (IlvTrue);
  reDrawObj(getstart());
  reDrawObj(getstop());
}


/************************************************************************/
/*									*/
/* Nom: stop								*/
/*									*/
/* Role: cb pour envoie d'un STOP/recess				*/
/*									*/
/************************************************************************/

void
V2dAnimation::stop(IlvGraphic*)
{
  exercise->sendStopPDU(1);
  getstart()->setSensitive (IlvTrue);
  getstop()->setSensitive (IlvFalse);
  reDrawObj(getstart());
  reDrawObj(getstop());
}


/************************************************************************/
/*									*/
/* Nom: end								*/
/*									*/
/* Role: cb pour envoie d'un STOP/termination				*/
/*									*/
/************************************************************************/

void
V2dAnimation::end(IlvGraphic* g)
{
    IlvContainer*	container = IlvContainer::getContainer(g);
    IlvDisplay*		display = container->getDisplay();
    IlvButton*		button;

    static IlvIQuestionDialog* questiondialog = 0;
    if (!questiondialog) questiondialog =
      new IlvIQuestionDialog (display, "Voulez-vous vraiment terminer la simulation ?");
    questiondialog->setTitle("Confirmation de terminaison");
    button = (IlvButton*) questiondialog->getObject("apply");
    if (button) button->setLabel("Oui");
    button = (IlvButton*) questiondialog->getObject("cancel");
    if (button) button->setLabel("Non");
    questiondialog->moveToMouse();
    if (questiondialog->get())
    {
      exercise->sendEndPDU(1);
      getstart()->setSensitive (IlvTrue);
      getstop()->setSensitive (IlvTrue);
      reDrawObj(getstart());
      reDrawObj(getstop());
    }
}


/************************************************************************/
/*									*/
/* Nom: change 								*/
/*									*/
/* Role: cb pour envoie d'une modif sur acteur				*/
/*									*/
/************************************************************************/

void
V2dAnimation::change(IlvGraphic* g)
{
  IlvContainer* container = IlvContainer::getContainer(g);
  IlvDisplay* display = container->getDisplay();

  V2dModifActeur* mod =
      new V2dModifActeur (sitac, this, display, "Modification", "Modification");
  mod->moveToMouse();
  mod->show();
}


/************************************************************************/
/*									*/
/* Nom: remove 								*/
/*									*/
/* Role: cb pour envoie d'une suppression d'acteur			*/
/*									*/
/************************************************************************/

void
V2dAnimation::remove(IlvGraphic* g)
{
  IlvContainer*		container = IlvContainer::getContainer(g);
  IlvDisplay*		display = container->getDisplay();

  V2dSuppActeur* suppActeur =
      new V2dSuppActeur (sitac, this, display, "Suppression d'entite", "Suppression d'entite");
  suppActeur->moveToMouse();
  suppActeur->show();
  if (IdCentre == -1)
  {
    getcentrage()->setSelected(0);
    reDrawObj(getcentrage());
  }
}


/************************************************************************/
/*									*/
/* Nom: detonate							*/
/*									*/
/* Role: cb pour envoie d'une detonation sur acteur			*/
/*									*/
/************************************************************************/

void
V2dAnimation::detonate(IlvGraphic* g)
{
  IlvContainer*		container = IlvContainer::getContainer(g);
  IlvDisplay*		display = container->getDisplay();

  V2dKiller* killer =
      new V2dKiller (display, "Detonation sur entite", "Detonation sur entite");
  killer->setExercise(exercise);
  killer->setRemoteEntities(remoteEntities);
  killer->setTexte(monTexte);
  killer->moveToMouse();
  killer->show();
}


/************************************************************************/
/*									*/
/* Nom: dessineTir							*/
/*									*/
/* Role: Fonction dessinant un symbole de tir. 				*/
/*									*/
/************************************************************************/

void
V2dAnimation::dessineTir (int x, int y, int type)
{
  IlvDisplay*		 display;
  IlvPalette*		 palette;
  IlvPoint		*liste;
  int			 taille;

  display = getDisplay();
  palette = display->getPalette(0, display->getColor("yellow"), 0, 0, 0, 0, 2);

  if (type == 1)
  {
    taille = 4;
    liste = new IlvPoint[taille];

    liste[0].x((int) x+70);
    liste[0].y((int) y+150);
    liste[1].x((int) x);
    liste[1].y((int) y+150);
    liste[2].x((int) x);
    liste[2].y((int) y-150);
    liste[3].x((int) x+70);
    liste[3].y((int) y-150);

    if (palette)
      sitac->graphique_creer(cptId2D++, taille, liste, S2D_GRAPHIQUE_TYPE_LIGNE, palette);
  }
  else
  {
    taille = 2;
    liste = new IlvPoint[taille];

    liste[0].x((int) x+50);
    liste[0].y((int) y);
    liste[1].x((int) x-50);
    liste[1].y((int) y);

    if (palette)
      sitac->graphique_creer(cptId2D++, taille, liste, S2D_GRAPHIQUE_TYPE_LIGNE, palette);

    liste[0].x((int) x);
    liste[0].y((int) y+50);
    liste[1].x((int) x);
    liste[1].y((int) y-50);

    if (palette)
      sitac->graphique_creer(cptId2D++, taille, liste, S2D_GRAPHIQUE_TYPE_LIGNE, palette);
  }

  sitac->reDraw();

  delete liste;
}


/************************************************************************/
/*									*/
/* Nom: dessineReseau							*/
/*									*/
/* Role: Fonction dessinant le reseau routier. 				*/
/*									*/
/************************************************************************/

void
V2dAnimation::dessineReseau (char* nomFichier)
{
  ScnRoute		 route(0,0,0);
  IlvDisplay*		 display = getDisplay();
  IlvPalette*		 palette;
  int			 i, j, n;
  IlvPoint		*liste;


  IlvPrint("Dessin du reseau d'apres : %s", nomFichier);

  route.lireRoute(nomFichier);

  n = route.getNbSegments();

  for (i = 0; i < n; i++)
  {
    int			 taille;
    int			 type;

    taille = route.segment(i)->getNbPoints();
    liste = new IlvPoint[taille];

    for (j = 0; j < taille; j++)
    {
      liste[j].x((int) route.segment(i)->pointx(j));
      liste[j].y((int) route.segment(i)->pointy(j));
    }

   type = route.segment(i)->getType();

    if (type == 1)
    {
      palette = display->getPalette(0, display->getColor("red"), 0, 0, 0, 0, 3);
      if (palette)
        sitac->route_creer(cptId2D++, taille, liste, palette);
    }
    else if (type == 2)
    {
      palette = display->getPalette(0, display->getColor("yellow"), 0, 0, 0, 0, 2);
      if (palette)
        sitac->route_creer(cptId2D++, taille, liste, palette);
    }
    else if (type == 3)
    {
      palette = display->getPalette(0, display->getColor("white"), 0, 0, 0, 0, 1);
      if (palette)
        sitac->route_creer(cptId2D++, taille, liste, palette);
    }

    delete liste;
  }
  sitac->reDraw();
}


/************************************************************************/
/*									*/
/* Nom: quit								*/
/*									*/
/* Role: cb pour quitter l'application.					*/
/*									*/
/************************************************************************/

void
V2dAnimation::quit(IlvGraphic* g)
{
    IlvContainer*	container = IlvContainer::getContainer(g);
    IlvDisplay*		display = container->getDisplay();
    IlvButton*		button;

    static IlvIQuestionDialog* questiondialog = 0;
    if (!questiondialog) questiondialog =
      new IlvIQuestionDialog (display, "Voulez-vous vraiment quitter ?");
    questiondialog->setTitle("Confirmation de sortie");
    button = (IlvButton*) questiondialog->getObject("apply");
    if (button) button->setLabel("Oui");
    button = (IlvButton*) questiondialog->getObject("cancel");
    if (button) button->setLabel("Non");
    questiondialog->moveToMouse();
    if (questiondialog->get())
    {
      delete container->getParent();
      delete display;
      IlvExit(0);
    }
}


/************************************************************************/
/*									*/
/* Nom: cebo								*/
/*									*/
/* Role: PLACEBO C'EST BEAU.						*/
/*									*/
/************************************************************************/

void
V2dAnimation::cebo(IlvGraphic*)
{
  static int	titi = 1;

  if (titi == 1)
  {
    getlogoATMDIS()->setLabel("C'EST BO");
    titi = 0;
  }
  else
  {
    getlogoATMDIS()->setLabel("PLACEBO");
    titi = 1;
  }
  reDrawObj(getlogoATMDIS());
}

/************/
/* The End. */
/************/

