static char modelesccsid[] = " @(#) modele.cc 1.8 97/11/21 - Copyright (c) DE 1995 ";
/************************************************************************/
/*									*/
/*   Ce programme est un produit de la societe DASSAULT ELECTRONIQUE,	*/
/* protege par les lois sur le droit d'auteur et sur le copyright et	*/
/* transmis en licence dans les conditions et termes specifiques	*/
/* indiques dans l'accord de licence qui l'accompagne. DASSAULT		*/
/* ELECTRONIQUE garde la propriete du programme et toutes les 		*/
/* prerogatives qui l'accompagnent. Ce programme ne peut etre modifie	*/
/* en aucune maniere sans l'autorisation ecrite prealable de DASSAULT	*/
/* ELECTRONIQUE.							*/
/*									*/
/* Nom: modele.cc							*/
/*									*/
/* Version: 1.8								*/
/*									*/
/* Historique:								*/
/*	Auteur: T. MARET						*/
/*	Date: 97/11/21							*/
/*	Creation: 97/07/04						*/
/*									*/
/************************************************************************/

/***********/
/* INCLUDE */
/***********/

#include <stream.h>
#include <string.h>

#include "TactScenario.h"
#include "TactGlobal.h"
#include "TactModeleAmiEni.h"

#include "TactModele.h"

/***********/
/* GLOBALE */
/***********/

char* VERSION_MODELE = "Version 1.8";
int   ID_MODELE = 2;
char* INTERF_MODELE;
char* ADRESSE_MODELE;
char* SCENARIO_MODELE;

TactModele* IHM_MODELE = 0;


static void ILVCALLBACK
Quit (IlvView* top, IlvAny)
{
  ((TactModele*) top)->quit (((TactModele*) top)->getquit());
}


/************************************************************************/
/*									*/
/* Nom: main            		 				*/
/*									*/
/* Role: main du processus						*/
/*									*/
/************************************************************************/

main (int argc, char * argv[])
{

    SCENARIO_MODELE = 0;
    INTERF_MODELE = 0;
    ADRESSE_MODELE = 0;

    int c;
    while ((c = getopt(argc, argv, "S:I:A:F:M:h:H")) != -1) {
	switch (c) {
	  case 'S':
	    SCENARIO_MODELE = new char[strlen(optarg)+1];
	    strcpy (SCENARIO_MODELE, optarg);
	    break;
	  case 'A':
	    ID_MODELE = atoi(optarg);
	    break;
	  case 'F':
	    INTERF_MODELE = new char[strlen(optarg)+1];
	    strcpy (INTERF_MODELE, optarg);
            break;
	  case 'M':
	    ADRESSE_MODELE = new char[strlen(optarg)+1];
	    strcpy (ADRESSE_MODELE, optarg);
            break;
	  case 'I':
	    fprintf(stderr, "SSTH modele %s\n", VERSION_MODELE);
	    exit(1);
	    break;
	  case 'h':
	  case 'H':
	  default:
	    fprintf(stderr, "usage: modele [-S scenario] [-A appliID] [-F interf] [-M adresse multicast]\n");
	    exit(1);
	    break;
	}
    }

    if (SCENARIO_MODELE == 0)
    {
	  fprintf(stderr, "usage: modele [-S scenario] [-A appliID] [-F interf] [-I info]\n");
	  fprintf(stderr, "       scenario a renseigner obligatoirement.\n");
	  exit(1);
    }

    if (INTERF_MODELE == 0)
    {
	   INTERF_MODELE = new char[strlen("et0")+1];
	   strcpy (INTERF_MODELE, "et0");
    }

    if (ADRESSE_MODELE == 0)
    {
	   ADRESSE_MODELE = new char[strlen("224.68.73.83")+1];
	   strcpy (ADRESSE_MODELE, "224.68.73.83");
    }

    char nomFicScenario [TACT_LONG_MAX_NOM_FIC]; // Nom du fichier scenario
    TactScenario scenario;			 // Scenario de la simulation

    cout << "Lancement du processus AMI/ENI " << endl;

    // Nom du fichier decrivant le scenario.

    strncpy(nomFicScenario, SCENARIO_MODELE, TACT_LONG_MAX_NOM_FIC);

    // Chargement du scenario.

    if (scenario.charger (nomFicScenario) == FALSE)
    {
      IlvFatalError("Erreur : Port DIS deja utilise ?");
      return -1;
    }

    // Creation des acteurs AMI/ENI du scenario.

    scenario.creerLesActeurs ();

    cout << "Liste des acteurs : " << endl;
    TactGlobalListeActeurs.lister();
    cout << "***" << endl;

    cout << "Liste des systemes d'armes : " << endl;
    TactGlobalListeSystemesArmes.lister();
    cout << "***" << endl;

    // On rentre dans la boucle de simulation.

    char	toto[64];
    sprintf(toto, "SSTH Modele %d", ID_MODELE);

    IlvDisplay* display = new IlvDisplay(toto, 0, argc, argv);
    if (!display || display->isBad())
    {
      IlvFatalError("Probleme d'ouverture du display");
      delete display;
      return -1;
    }

    IlvRect taille (400, 400, 825, 700);
    TactModele* top = 
	new TactModele(display, toto, toto, &taille);

    IHM_MODELE = top;

    float dt;
    TactGlobalBoucleSimu.lirePasCalcul(dt);

    top->setScenario(nomFicScenario);
    top->setApplication(ID_MODELE);
    top->setPasCalcul(dt);

    top->setDestroyCallback(Quit, 0);

    top->show();

    IlvMainLoop();

    return 0;
}






/************/
/* The End. */
/************/
