static char tactmodelesccsid[] = " @(#) TactModele.cc 1.7 97/09/08 - Copyright (c) DE 1997 ";
/************************************************************************/
/*									*/
/*   Ce programme est un produit de la societe DASSAULT ELECTRONIQUE,	*/
/* protege par les lois sur le droit d'auteur et sur le copyright et	*/
/* transmis en licence dans les conditions et termes specifiques	*/
/* indiques dans l'accord de licence qui l'accompagne. DASSAULT		*/
/* ELECTRONIQUE garde la propriete du programme et toutes les 		*/
/* prerogatives qui l'accompagnent. Ce programme ne peut etre modifie	*/
/* en aucune maniere sans l'autorisation ecrite prealable de DASSAULT	*/
/* ELECTRONIQUE.							*/
/*									*/
/* Nom: TactModele.cc							*/
/*									*/
/* Version: 1.7								*/
/*									*/
/* Historique:								*/
/*	Auteur: T. MARET						*/
/*	Date: 97/09/08							*/
/*	Creation: 97/07/04						*/
/*									*/
/************************************************************************/

/***********/
/* INCLUDE */
/***********/


#include <ilviews/stdialog.h>

#include "TactGlobal.h"

#include "TactModele.h"


/**********/
/* EXTERN */
/**********/

extern int   ID_MODELE;
extern char* SCENARIO_MODELE;


/**********/
/* DEFINE */
/**********/

TactModele*			monModele;


/************************************************************************/
/*									*/
/* Nom: StartCB								*/
/*									*/
/* Role: Callback appelee en cas de reception de PDU Start. 		*/
/*									*/
/************************************************************************/

void
StartCB (StartResumePDU* pdu)
{
  EntityID		receiver;
  EntityID		sender;

  receiver.entity = pdu->receiving_entity.entity;
  receiver.address.site = pdu->receiving_entity.address.site;
  receiver.address.host = pdu->receiving_entity.address.host;

  sender.entity = pdu->originating_entity.entity;
  sender.address.site = pdu->originating_entity.address.site;
  sender.address.host = pdu->originating_entity.address.host;

  monModele->etat = 1;
  IlvPrint("start");

  TactGlobalDis.envoyerMessageAck(receiver, sender, AckFlag_StartResume);
}


/************************************************************************/
/*									*/
/* Nom: StopCB								*/
/*									*/
/* Role: Callback appelee en cas de reception de PDU Stop. 		*/
/*									*/
/************************************************************************/

void
StopCB (StopFreezePDU* pdu)
{
  EntityID		receiver;
  EntityID		sender;

  receiver.entity = pdu->receiving_entity.entity;
  receiver.address.site = pdu->receiving_entity.address.site;
  receiver.address.host = pdu->receiving_entity.address.host;

  sender.entity = pdu->originating_entity.entity;
  sender.address.site = pdu->originating_entity.address.site;
  sender.address.host = pdu->originating_entity.address.host;

  TactGlobalDis.envoyerMessageAck(receiver, sender, AckFlag_StopFreeze);

  if (pdu->stop_reason == StopReason_Termination)
  {
    IlvContainer* container = IlvContainer::getContainer(monModele->getquit());
    IlvDisplay* display = container->getDisplay();

    TactGlobalBoucleSimu.quitterLaSimulation();
    TactGlobalDis.detruireExercice();
    delete container->getParent();
    delete display;
    IlvExit(0);
  }
  else
  {
    monModele->etat = 0;
    IlvPrint("stop");
  }
}


/************************************************************************/
/*									*/
/* Nom: FireCB								*/
/*									*/
/* Role: Callback appelee en cas de reception de PDU Fire. 		*/
/*									*/
/************************************************************************/

void
FireCB (FirePDU* )
{
  IlvPrint("fire");
}


/************************************************************************/
/*									*/
/* Nom: DetonationCB							*/
/*									*/
/* Role: Callback appelee en cas de reception de PDU Detonation. 	*/
/*									*/
/************************************************************************/

void
DetonationCB (DetonationPDU* pdu)
{
  double		posDetonationX;
  double		posDetonationY;
  double		posDetonationZ;
  EventID		eventId;
  EntityType		typeMunition;
  DetonationResult	typeImpact;
  EntityID		idMunition;
  EntityID		idCible;
  EntityID		idTireur;

  posDetonationX = pdu->location_in_world.x;
  posDetonationY = pdu->location_in_world.y;
  posDetonationZ = pdu->location_in_world.z;

  eventId.event = pdu->event_id.event;
  eventId.address.site = pdu->event_id.address.site;
  eventId.address.host = pdu->event_id.address.host;

  typeMunition.entity_kind = pdu->burst_descriptor.munition.entity_kind;
  typeMunition.domain = pdu->burst_descriptor.munition.domain;
  typeMunition.country = pdu->burst_descriptor.munition.country;
  typeMunition.category = pdu->burst_descriptor.munition.category;
  typeMunition.subcategory = pdu->burst_descriptor.munition.subcategory;
  typeMunition.specific = pdu->burst_descriptor.munition.specific;
  typeMunition.extra = pdu->burst_descriptor.munition.extra;

  typeImpact = pdu->detonation_result;

  idMunition.entity = pdu->munition_id.entity;
  idMunition.address.site = pdu->munition_id.address.site;
  idMunition.address.host = pdu->munition_id.address.host;
  idCible.entity = pdu->target_entity_id.entity;
  idCible.address.site = pdu->target_entity_id.address.site;
  idCible.address.host = pdu->target_entity_id.address.host;
  idTireur.entity = pdu->firing_entity_id.entity;
  idTireur.address.site = pdu->firing_entity_id.address.site;
  idTireur.address.host = pdu->firing_entity_id.address.host;

  IlvPrint("detonation");

  TactSystemeArmes*	pSystemeArmes;		// Pointeur sur le SA 
  TactSystemeArmesDis*	pSystemeArmesDIS;	// Pointeur sur le SA DIS
  TACT_BOOLEAN		detruit;		// Booleen indiquant si le
						// SA est detruit

  // On recupere le pointeur sur le systeme d'armes.

  pSystemeArmes = 0;
  TactGlobalListeSystemesArmes.recupererSystemeArmesParDis (idCible, pSystemeArmes);

  if (pSystemeArmes != 0)
  {
    // On evalue les dommages dus a la detonation et on change 
    // eventuellement l'apparence du systeme d'armes.

    pSystemeArmes->traiterDetonation (posDetonationX,
  				      posDetonationY,
				      posDetonationZ,
				      typeMunition,
				      typeImpact,
				      idCible,
				      detruit);

    if (detruit == TACT_VRAI)
    {
      // on recupere l'entite systeme d'armes DIS

      pSystemeArmesDIS = pSystemeArmes->entiteDIS();

      // D'apres le modele de vulnerabilite du systeme d'armes, la detonation
      // a detruit le systeme d'armes.

      // On donne a l'entite systeme d'armes DIS son apparence detruite

      pSystemeArmesDIS->donnerApparenceDetruite();

      // on met l'entite systeme d'armes DIS dans le cimetiere

      TactGlobalListeEntitesDisDetruites.ajouterUneEntiteDis (pSystemeArmesDIS);

      // on deconnecte l'entite DIS du pSystemeArmes pour pas que la
      // destruction du systeme d'armes ne detruise l'entite DIS

      pSystemeArmes->deconnecteEntiteDIS();

      // On detruit le systeme d'armes.

      TactGlobalListeSystemesArmes.detruireUnSystemeArmes (pSystemeArmes);
    }
  }
}


/************************************************************************/
/*									*/
/* Nom: ActionCB							*/
/*									*/
/* Role: Callback appelee en cas de reception de PDU ActionRequest. 	*/
/*									*/
/************************************************************************/

void
ActionCB (ActionRequestPDU* pdu)
{
  int			idScnActeur;
  float			vitesse;
  EntityID		receiver;
  EntityID		sender;

  receiver.entity = pdu->receiving_entity.entity;
  receiver.address.site = pdu->receiving_entity.address.site;
  receiver.address.host = pdu->receiving_entity.address.host;

  sender.entity = pdu->originating_entity.entity;
  sender.address.site = pdu->originating_entity.address.site;
  sender.address.host = pdu->originating_entity.address.host;

  TactGlobalDis.envoyerActionResponse(receiver, sender);

  idScnActeur = pdu->receiving_entity.entity;
  vitesse = pdu->action_id;

  IlvPrint("action");

  TACT_BOOLEAN existe; // Bollen indiquant si l'acteur existe
  TactActeur * pActeur; // Pointeur sur l'acteur concerne

  // La seule entite DIS qui traite le PDU de changement de vitesse, c'est
  // le controleur DIS du modele tactique (les autres s'en fichent).

  // Recuperation de l'acteur concerne.

  TactGlobalListeActeurs.recupererUnActeur (idScnActeur,
					    existe, 
					    pActeur);

  if (existe == TACT_VRAI)
  {
     // L'acteur concerne par le changement de vitesse existe.
     // On lui donne la nouvelle vitesse a suivre.

     pActeur->donnerVitesse (vitesse);
  }
}


/************************************************************************/
/*									*/
/* Nom: RemoveCB							*/
/*									*/
/* Role: Callback appelee en cas de reception de PDU Remove.	 	*/
/*									*/
/************************************************************************/

void
RemoveCB (RemoveEntityPDU* pdu)
{
  EntityID		receiver;
  EntityID		sender;

  receiver.entity = pdu->receiving_entity.entity;
  receiver.address.site = pdu->receiving_entity.address.site;
  receiver.address.host = pdu->receiving_entity.address.host;

  sender.entity = pdu->originating_entity.entity;
  sender.address.site = pdu->originating_entity.address.site;
  sender.address.host = pdu->originating_entity.address.host;

  TactGlobalDis.envoyerMessageAck(receiver, sender, AckFlag_RemoveEntity);

  IlvPrint("remove");

  TactSystemeArmes * pSystemeArmes;
  TactSystemeArmesDis * pSystemeArmesDIS;

  // On recupere le pointeur sur le systeme d'armes a detruire.

  TactGlobalListeSystemesArmes.recupererSystemeArmesParDis (receiver, pSystemeArmes);

  if (pSystemeArmes != 0)
  {
    // On affiche un message de trace

    pSystemeArmes->traiterRemove ();

    // on recupere l'entite systeme d'armes  DIS

    pSystemeArmesDIS = pSystemeArmes->entiteDIS();

    // On donne a l'entite systeme d'armes DIS son apparence finale
    // et on emet le PDU sur le reseau DIS.

    pSystemeArmesDIS->supprimer();

    // on met l'entite systeme d'armes DIS dans la liste des entites
    // DIS a supprimer

    TactGlobalListeEntitesDisASupprimer.ajouterUneEntiteDis (pSystemeArmesDIS);

    // on deconnecte l'entite DIS du pSystemeArmes pour pas que la
    // destruction du systeme d'armes ne detruise l'entite DIS car
    // sera fait par TactGlobalListeEntitesDisASupprimer

    pSystemeArmes->deconnecteEntiteDIS();

    // On detruit le systeme d'armes.

    TactGlobalListeSystemesArmes.detruireUnSystemeArmes (pSystemeArmes);
  }
}


/************************************************************************/
/*									*/
/* Nom: MiseAJour							*/
/*									*/
/* Role: Callback appelee regulierement et mettant a jour les positions	*/
/*       des entites DIS sur la carte.					*/
/*									*/
/************************************************************************/

static void ILVCALLBACK
MiseAJour (IlvTimer*, IlvAny arg)
{
  TactModele*	mod = (TactModele*) arg;

  //IlvPrint("tps = %f", mod->dateSimulation);

  // On lit les buffers DIS et on interpole l'etat de toutes les entites
  // DIS de la simulation.

  TactGlobalDis.majPasSimulation();

  // Destruction des entites DIS qui veulent se suicider ou a qui on impose
  // la destruction (PDU remove).

  TactGlobalListeEntitesDisASupprimer.detruireLesEntitesDis ();

  // Mise a jour des entites DIS qui sont detruites donc plus simulees
  // mais dont le cadavre doit etre entretenu sur DIS.

  TactGlobalListeEntitesDisDetruites.emettreLesEntitesDis ();

  if (mod->etat == 1)
  {
    // On est en cours de simulation. Le temps de simulation
    // s'incremente.

    // On calcul le nouvel etat de tous les acteurs AMI / ENI
    // par rapport a l'etat precedent
    // apres une variation elementaire de temps de dt.

    TactGlobalListeActeurs.passerEtatSuivant();

    // Incrementation du temps de simulation.

    mod->dateSimulation = mod->dateSimulation + mod->pas;
  }
  else
  {
    // On ne calcule pas de nouvel etat. La simulation
    // est gelee. On reemet le dernier etat calcule.

    TactGlobalListeSystemesArmes.emettreDernierEtat();
  }
}

/************************************************************************/
/*									*/
/* Nom: TactModele     			 				*/
/*									*/
/* Role: Constructeur 							*/
/*									*/
/************************************************************************/

TactModele::TactModele(IlvDisplay* display, const char* name, const char* title,
			IlvRect* size, IlvBoolean useAccelerators,
			IlvBoolean visible)
 : Modele (display, name, title, size, useAccelerators, visible)
{
  initialize (display);
}


/************************************************************************/
/*									*/
/* Nom: TactModele     			 				*/
/*									*/
/* Role: Constructeur 							*/
/*									*/
/************************************************************************/

TactModele::TactModele(IlvCompositeAbstractView* aview, IlvRect* size)
 : Modele (aview, size)
{
  initialize (aview->getDisplay());
}


/************************************************************************/
/*									*/
/* Nom: ~TactModele    	 						*/
/*									*/
/* Role: Destructeur 							*/
/*									*/
/************************************************************************/

TactModele::~TactModele ()
{
  if (timer) delete timer;
}


/************************************************************************/
/*									*/
/* Nom: initialize							*/
/*									*/
/* Role: initialisation dans les constructeurs				*/
/*									*/
/************************************************************************/

void
TactModele::initialize(IlvDisplay*)
{
  monModele = this;

  etat = 0;

  dateSimulation = 0.0;

  TactGlobalDis.attacheStartCB(&StartCB);
  TactGlobalDis.attacheStopCB(&StopCB);
  TactGlobalDis.attacheFireCB(&FireCB);
  TactGlobalDis.attacheDetonationCB(&DetonationCB);
  TactGlobalDis.attacheActionRequestCB(&ActionCB);
  TactGlobalDis.attacheRemoveCB(&RemoveCB);
}


/************************************************************************/
/*									*/
/* Nom: setScenario							*/
/*									*/
/* Role: mise a jour du champ scenario					*/
/*									*/
/************************************************************************/

void
TactModele::setScenario(char * n)
{
  getscenario()->setLabel(n);
}


/************************************************************************/
/*									*/
/* Nom: setApplication							*/
/*									*/
/* Role: mise a jour du champ id					*/
/*									*/
/************************************************************************/

void
TactModele::setApplication(int n)
{
  char	buf[32];

  sprintf(buf, "%d", n);
  getid()->setLabel(buf);
}


/************************************************************************/
/*									*/
/* Nom: addMessage							*/
/*									*/
/* Role: mise a jour du champ contenu					*/
/*									*/
/************************************************************************/

void
TactModele::addMessage(char * n)
{
  getcontenu()->insertLabel(0, n);
  reDrawObj(getcontenu());
}


/************************************************************************/
/*									*/
/* Nom: setPasCalcul							*/
/*									*/
/* Role: creation du timer et lancement					*/
/*									*/
/************************************************************************/

void
TactModele::setPasCalcul(float p)
{
  IlvContainer*	container = IlvContainer::getContainer(getquit());
  IlvDisplay*	display = container->getDisplay();
  char		buf[32];

  pas = p;

  int dt = pas * 1000.0;

  sprintf(buf, "%d ms", dt);
  getpas()->setLabel(buf);
  reDrawObj(getpas());

  timer = new IlvTimer (display, 0, dt, MiseAJour, this);
  timer->run();
}


/************************************************************************/
/*									*/
/* Nom: quit								*/
/*									*/
/* Role: sortie de l'application					*/
/*									*/
/************************************************************************/

void
TactModele::quit(IlvGraphic* g)
{
    IlvContainer* container = IlvContainer::getContainer(g);
    IlvDisplay* display = container->getDisplay();
    IlvButton*		button;

    static IlvIQuestionDialog* questiondialog = 0;
    if (!questiondialog) questiondialog =
      new IlvIQuestionDialog (display, "Voulez-vous vraiment quitter ?");
    questiondialog->setTitle("Confirmation de sortie");
    button = (IlvButton*) questiondialog->getObject("apply");
    if (button) button->setLabel("Oui");
    button = (IlvButton*) questiondialog->getObject("cancel");
    if (button) button->setLabel("Non");
    questiondialog->moveToMouse();
    if (questiondialog->get())
    {
      TactGlobalBoucleSimu.quitterLaSimulation();
      TactGlobalDis.detruireExercice();
      delete container->getParent();
      delete display;
      IlvExit(0);
    }
}


/************/
/* The End. */
/************/
