static char tactdissccsid[] = " @(#) TactDis.cc 1.12 97/08/07 - Copyright (c) DE 1995 ";
/************************************************************************/
/*									*/
/*   Ce programme est un produit de la societe DASSAULT ELECTRONIQUE,	*/
/* protege par les lois sur le droit d'auteur et sur le copyright et	*/
/* transmis en licence dans les conditions et termes specifiques	*/
/* indiques dans l'accord de licence qui l'accompagne. DASSAULT		*/
/* ELECTRONIQUE garde la propriete du programme et toutes les 		*/
/* prerogatives qui l'accompagnent. Ce programme ne peut etre modifie	*/
/* en aucune maniere sans l'autorisation ecrite prealable de DASSAULT	*/
/* ELECTRONIQUE.							*/
/*									*/
/* Nom: TactDis.cc							*/
/*									*/
/* Version: 1.12							*/
/*									*/
/* Historique:								*/
/*	Auteur: T. MARET						*/
/*	Date: 97/08/07							*/
/*	Creation: 95/12/12						*/
/*									*/
/************************************************************************/

/***********/
/* INCLUDE */
/***********/

#include <stream.h>

#include "DisRemoteEntity.h"

#include "TactDis.h"
#include "TactTraitPdu.h"
#include "TactProjectileDis.h"
#include "TactGlobal.h"
#include "TactModele.h"

/**********/
/* EXTERN */
/**********/

extern int   ID_MODELE;
extern char* INTERF_MODELE;
extern char* ADRESSE_MODELE;

extern TactModele* IHM_MODELE;

/**************/
/* CONSTANTES */
/**************/

// Decalage utilise pour calculer l'identifiant DIS d'un projectile tire
// par un systeme d'armes.

const int TACT_DIS_DECALAGE_ID_DIS_PROJECTILE = 500;


/************************************************************************/
/*									*/
/* Nom: TactDis      			 				*/
/*									*/
/* Role: Constructeur 							*/
/*									*/
/* Parametres:								*/
/*	Entrees:							*/
/*	Sorties:							*/
/*	Entrees/Sorties:						*/
/*									*/
/* Pre-conditions: 							*/
/*									*/
/* Post-conditions: 							*/
/*									*/
/* Traitement des erreurs:						*/
/*									*/
/*									*/
/************************************************************************/

TactDis::TactDis ()
{
  // Il n'y a encore aucun exercice DIS.

  pExercice = 0;


  // Il n'y a pas de remote entities.

  pRemoteEntities = 0;


  // Il n'y a pas de weapon manager.

  pWeaponManager = 0;


  // Aucun projectile n'a encore ete tire par les systemes d'armes.

  nbProjectilesTires = 0;
}


/************************************************************************/
/*									*/
/* Nom: ~TactDis    	 						*/
/*									*/
/* Role: Destructeur 							*/
/*									*/
/* Parametres:								*/
/*	Entrees:							*/
/*	Sorties:							*/
/*	Entrees/Sorties:						*/
/*									*/
/* Pre-conditions: 							*/
/*									*/
/* Post-conditions: 							*/
/*									*/
/* Traitement des erreurs:						*/
/*									*/
/*									*/
/************************************************************************/

TactDis::~TactDis ()
{
  if (pRemoteEntities != 0)
   {
     // Destruction des remote entities.

     delete pRemoteEntities;
   }

  if (pWeaponManager != 0)
   {
     // Destruction de weapon manager.

     delete pWeaponManager;
   }

  if (pExercice != 0)
   {
     // Destruction de l'exercice DIS.

     delete pExercice;
   }
}


/************************************************************************/
/*                                                                      */
/* Nom: chargerInfosEntiteDis                                           */
/*                                                                      */
/* Role: Chargement des informations d'une entite DIS distante dans une */
/*       structure "TACT".                                              */
/*                                                                      */
/* Parametres:                                                          */
/*      Entrees: . Pointeur vers l'entite DIS distante.                 */
/*      Sorties: . Structure contenant les informations sur l'entite DIS*/
/*      Entrees/Sorties:                                                */
/*                                                                      */
/* Pre-conditions:                                                      */
/*                                                                      */
/* Post-conditions:                                                     */
/*                                                                      */
/* Traitement des erreurs:                                              */
/*                                                                      */
/*                                                                      */
/************************************************************************/

void
TactDis::chargerInfosEntiteDis (DisRemoteEntity * pEntiteDistante,
                                TACT_ENTITE_PERCUE_VIA_DIS & infosEntite)
{
  // Recuperation de l'identifiant DIS de l'entite.

  infosEntite.idDis.entity = pEntiteDistante->getID().entity;
  infosEntite.idDis.address.site = pEntiteDistante->getID().address.site;
  infosEntite.idDis.address.host = pEntiteDistante->getID().address.host;


  // Recuperation de la position de l'entite.

  infosEntite.position.x = pEntiteDistante->getLocation().x;
  infosEntite.position.y = pEntiteDistante->getLocation().y;
  infosEntite.position.z = pEntiteDistante->getLocation().z;


  // Recuperation du vecteur vitesse de l'entite.

  infosEntite.vitesse.x = pEntiteDistante->getVelocity().x;
  infosEntite.vitesse.y = pEntiteDistante->getVelocity().y;
  infosEntite.vitesse.z = pEntiteDistante->getVelocity().z;


  // Recuperation du camp de l'entite.

  infosEntite.camp = pEntiteDistante->getCamp();


  // Recuperation du type de l'entite.

  infosEntite.typeDis.entity_kind = pEntiteDistante->getType().entity_kind;
  infosEntite.typeDis.domain = pEntiteDistante->getType().domain;
  infosEntite.typeDis.country = pEntiteDistante->getType().country;
  infosEntite.typeDis.category = pEntiteDistante->getType().category;
  infosEntite.typeDis.subcategory = pEntiteDistante->getType().subcategory;
  infosEntite.typeDis.specific = pEntiteDistante->getType().specific;
  infosEntite.typeDis.extra = pEntiteDistante->getType().extra;
}


/************************************************************************/
/*                                                                      */
/* Nom: lireInfosPremiereEntiteDis                                      */
/*                                                                      */
/* Role: Lecture des informations sur la premiere entite DIS percue au  */
/*       travers du reseau DIS.                                         */
/*                                                                      */
/* Parametres:                                                          */
/*	Entrees:							*/
/*      Sorties: . booleen valant VRAI s'il y a une entite DIS.         */
/*		 . informations sur la premiere entite DIS.		*/
/*      Entrees/Sorties:                                                */
/*                                                                      */
/* Pre-conditions:                                                      */
/*                                                                      */
/* Post-conditions:                                                     */
/*                                                                      */
/* Traitement des erreurs:                                              */
/*                                                                      */
/*                                                                      */
/************************************************************************/

void
TactDis::lireInfosPremiereEntiteDis (TACT_BOOLEAN & existe,
                                     TACT_ENTITE_PERCUE_VIA_DIS & infosEntite)
{
  // Initialisation a "Il n'y a aucune entite DIS".

  existe = TACT_FAUX;


  // Recuperation de la premiere entite DIS presente dans le monde DIS.

  pEntiteCourante = pRemoteEntities->first();


  if (pEntiteCourante != 0)
    {
      // Il y a une entite DIS.

      existe = TACT_VRAI;


      // Chargement des informations dur l'entite DIS dans la structure.

      chargerInfosEntiteDis (pEntiteCourante,
			     infosEntite);
    }
}



/************************************************************************/
/*                                                                      */
/* Nom: lireInfosEntiteDisSuivante                                      */
/*                                                                      */
/* Role: Lecture des informations sur la prochaine entite DIS percue au */
/*       travers du reseau DIS.                                         */
/*                                                                      */
/* Parametres:                                                          */
/*      Entrees:                                                        */
/*      Sorties: . booleen valant VRAI s'il y a une entite DIS.         */
/*               . informations sur la prochaine entite DIS.            */
/*      Entrees/Sorties:                                                */
/*                                                                      */
/* Pre-conditions:                                                      */
/*                                                                      */
/* Post-conditions:                                                     */
/*                                                                      */
/* Traitement des erreurs:                                              */
/*                                                                      */
/*                                                                      */
/************************************************************************/

void
TactDis::lireInfosEntiteDisSuivante (TACT_BOOLEAN & existe,
                                     TACT_ENTITE_PERCUE_VIA_DIS & infosEntite)
{
  // Initialisation a "Il n'y a plus aucune entite DIS".

  existe = TACT_FAUX;


  if (pEntiteCourante != 0)
    {
       // Recuperation de l'entite DIS courante.

       pEntiteCourante = (DisRemoteEntity *) pEntiteCourante->next();


      if (pEntiteCourante != 0)
        {
           // Il y a une entite DIS.

           existe = TACT_VRAI;


           // Chargement des informations dur l'entite DIS dans la structure.

           chargerInfosEntiteDis (pEntiteCourante,
                                  infosEntite);
        }
    }
}


/************************************************************************/
/*                                                                      */
/* Nom: creerIdentifiantDisProjectile                                   */
/*                                                                      */
/* Role: Creation d'un nouvel identifiant DIS de projectile.            */
/*                                                                      */
/* Parametres:                                                          */
/*      Entrees:                                                        */
/*      Sorties: . Nouvel identifiant DIS de projectile.                */
/*      Entrees/Sorties:                                                */
/*                                                                      */
/* Pre-conditions:                                                      */
/*                                                                      */
/* Post-conditions:                                                     */
/*                                                                      */
/* Traitement des erreurs:                                              */
/*                                                                      */
/*                                                                      */
/************************************************************************/

void
TactDis::creerIdentifiantDisProjectile (EntityID & idDis)
{
 int identifiantProjectile; // Identifiant SCN du projectile


  // Identifiant SCN du nouveau projectile.

  identifiantProjectile = TACT_DIS_DECALAGE_ID_DIS_PROJECTILE + nbProjectilesTires;


  // Creation d'un nouvel identifiant DIS.

  idDis.entity = identifiantProjectile;
  idDis.address.site = pExercice->getSiteID ();
  idDis.address.host = pExercice->getAppNumber ();


  // On incremente le nombre de projectiles tires par les systemes d'armes.

  nbProjectilesTires = nbProjectilesTires + 1;
}


/************************************************************************/
/*                                                                      */
/* Nom: localiserUneEntiteDis                                           */
/*                                                                      */
/* Role: Recuperer les informations de localisation d'une entite DIS    */
/*       connue par son identifiant DIS.                                */
/*                                                                      */
/* Parametres:                                                          */
/*      Entrees: . Identifiant DIS de l'entite                          */
/*      Sorties: . booleen valant VRAI si l'entite DIS existe.          */
/*               . position de l'entite DIS.                            */
/*               . vitesse de l'entite DIS.                             */
/*      Entrees/Sorties:                                                */
/*                                                                      */
/* Pre-conditions:                                                      */
/*                                                                      */
/* Post-conditions:                                                     */
/*                                                                      */
/* Traitement des erreurs:                                              */
/*                                                                      */
/*                                                                      */
/************************************************************************/

void
TactDis::localiserUneEntiteDis (EntityID idDis,
                                TACT_BOOLEAN & existe,
                                TACT_POSITION & position,
                                TACT_POSITION & vitesse)
{
  DisRemoteEntity * pEntiteDistante; // Pointeur vers une entite DIS distante
  TACT_ENTITE_PERCUE_VIA_DIS infosEntite; // Infos sur l'entite recherchee


  // Initialisation a "L'entite recherchee n'existe pas".

  existe = TACT_FAUX;


  // Recuperation de l'entite DIS recherchee.

  pEntiteDistante = pRemoteEntities->getEntity (idDis);


  if (pEntiteDistante != 0)
    {
       // L'entite recherchee existe.

       existe = TACT_VRAI;


       // Recuperations des informations sur l'entite recherchee.

       chargerInfosEntiteDis (pEntiteDistante, infosEntite);


       // Renvoi de la vitesse et de la position.

       position = infosEntite.position;
       vitesse = infosEntite.vitesse;
    }
}


/************************************************************************/
/*                                                                      */
/* Nom: initAlgoDR                                                      */
/*                                                                      */
/* Role: Initialisation de l'algorithme de dead reckonning.             */
/*                                                                      */
/* Parametres:                                                          */
/*      Entrees: . Type d'algorithme d'extrapolation.                   */
/*      Sorties:                                                        */
/*      Entrees/Sorties:                                                */
/*                                                                      */
/* Pre-conditions:                                                      */
/*                                                                      */
/* Post-conditions:                                                     */
/*                                                                      */
/* Traitement des erreurs:                                              */
/*                                                                      */
/*                                                                      */
/************************************************************************/

void
TactDis::initAlgoDR (int typeAlgoDR)
{
 // Initialisation du type d'algorithme d'extrapolation.

 drAlgo = typeAlgoDR;
}


/************************************************************************/
/*                                                                      */
/* Nom: creerExercice                                                   */
/*                                                                      */
/* Role: Constructeur                                                   */
/*                                                                      */
/* Parametres:                                                          */
/*      Entrees: . Adresse du port DIS                                  */
/*		 . Numero de l'exercice.				*/
/*		 . Numero du site.					*/
/*		 . Numero de l'application.				*/
/*      Sorties:                                                        */
/*      Entrees/Sorties:                                                */
/*                                                                      */
/* Pre-conditions:                                                      */
/*                                                                      */
/* Post-conditions:                                                     */
/*                                                                      */
/* Traitement des erreurs:                                              */
/*                                                                      */
/*                                                                      */
/************************************************************************/

int
TactDis::creerExercice (int portDis,
                        int numeroExercice,
                        int numeroSite)
{
  printf("\n");
  printf(" Port reseau DIS		: %d\n", portDis);
  printf(" Numero d'exercice DIS		: %d\n", numeroExercice);
  printf(" Numero de site DIS		: %d\n", numeroSite);
  printf(" Numero d'application DIS	: %d\n", ID_MODELE);
  printf(" \n");
  printf(" Interface reseau		: %s \n", INTERF_MODELE);
  printf(" Adresse multicast		: %s \n", ADRESSE_MODELE);
  printf("\n");

  // Creation de l'exercice DIS.

  pExercice = new DisExercise (portDis, numeroExercice, numeroSite,
			       ID_MODELE, INTERF_MODELE, ADRESSE_MODELE);


  // Creation des remote entities.

  pRemoteEntities = new DisRemoteEntities (pExercice);


  // Creation du weapon manager.

  pWeaponManager = new DisWeaponManager (pExercice);


  return pExercice->creationOK();
}


/************************************************************************/
/*                                                                      */
/* Nom: detruireExercice                                                */
/*                                                                      */
/* Role: Destructeur                                                    */
/*                                                                      */
/************************************************************************/

void
TactDis::detruireExercice ()
{
  if (pRemoteEntities != 0)
   {
     // Destruction des remote entities.

     delete pRemoteEntities;
     pRemoteEntities = 0;
   }

  if (pWeaponManager != 0)
   {
     // Destruction de weapon manager.

     delete pWeaponManager;
     pWeaponManager = 0;
   }

  if (pExercice != 0)
   {
     // Destruction de l'exercice DIS.

     delete pExercice;
     pExercice = 0;
   }
}


/************************************************************************/
/*                                                                      */
/* Nom: attacheStartCB                                                  */
/*                                                                      */
/* Role: Associe la callback en argument au PDU Start.                  */
/*                                                                      */
/************************************************************************/

void
TactDis::attacheStartCB (void	(*callback) (StartResumePDU*))
{
  pExercice->startCB = callback;
}


/************************************************************************/
/*                                                                      */
/* Nom: attacheStopCB                                                   */
/*                                                                      */
/* Role: Associe la callback en argument au PDU Stop.                   */
/*                                                                      */
/************************************************************************/

void
TactDis::attacheStopCB (void	(*callback) (StopFreezePDU*))
{
  pExercice->stopCB = callback;
}


/************************************************************************/
/*                                                                      */
/* Nom: attacheFireCB                                                   */
/*                                                                      */
/* Role: Associe la callback en argument au PDU Fire.                   */
/*                                                                      */
/************************************************************************/

void
TactDis::attacheFireCB (void	(*callback) (FirePDU*))
{
  pExercice->fireCB = callback;
}


/************************************************************************/
/*                                                                      */
/* Nom: attacheDetonationCB                                             */
/*                                                                      */
/* Role: Associe la callback en argument au PDU Detonation.             */
/*                                                                      */
/************************************************************************/

void
TactDis::attacheDetonationCB (void	(*callback) (DetonationPDU*))
{
  pExercice->detonationCB = callback;
}


/************************************************************************/
/*                                                                      */
/* Nom: attacheActionRequestCB                                          */
/*                                                                      */
/* Role: Associe la callback en argument au PDU ActionRequest.          */
/*                                                                      */
/************************************************************************/

void
TactDis::attacheActionRequestCB (void	(*callback) (ActionRequestPDU*))
{
  pExercice->actionRequestCB = callback;
}


/************************************************************************/
/*                                                                      */
/* Nom: attacheRemoveCB                                                 */
/*                                                                      */
/* Role: Associe la callback en argument au PDU Remove.                 */
/*                                                                      */
/************************************************************************/

void
TactDis::attacheRemoveCB (void	(*callback) (RemoveEntityPDU*))
{
  pExercice->removeEntityCB = callback;
}


/************************************************************************/
/*                                                                      */
/* Nom: creerSystemeArmesDis                                            */
/*                                                                      */
/* Role: Creation d'un systeme d'armes DIS.                             */
/*                                                                      */
/* Parametres:                                                          */
/*      Entrees: . Identifiant du systeme d'armes                       */
/*		 . Camp du systeme d'armes.				*/
/*		 . Pointeur sur le type de systeme d'armes.		*/
/*      Sorties: . Pointeur sur l'entite DIS creee.                     */
/*      Entrees/Sorties:                                                */
/*                                                                      */
/* Pre-conditions:                                                      */
/*                                                                      */
/* Post-conditions:                                                     */
/*                                                                      */
/* Traitement des erreurs:                                              */
/*                                                                      */
/*                                                                      */
/************************************************************************/

void
TactDis::creerSystemeArmesDis (int identifiantSystemeArmes,
                               int camp,
                               EntityType * pType,
                               TactSystemeArmesDis * & pEntiteDis,
                               char* nom)
{
  EntityID			idDis;		// Identifiant DIS de l'entite
  TACT_TYPE_SYSTEME_ARMES	typeTactique;

  // Conversion du type DIS au type "tactique".

  TactCommunsConvTypeSystemeArmes (pType, typeTactique);

  // Creation d'un nouvel identifiant DIS.

  idDis.entity = identifiantSystemeArmes;
  idDis.address.site = pExercice->getSiteID ();
  idDis.address.host = pExercice->getAppNumber ();

  // Creation de l'entite DIS.

  pEntiteDis = new TactSystemeArmesDis (pExercice,
                                        &idDis,
                                        drAlgo,
                                        camp,
                                        pType, pWeaponManager);

  // Mise a jour du marking

  pEntiteDis->ecrireMarking (nom);

}


/************************************************************************/
/*                                                                      */
/* Nom: creerProjectileDis                                              */
/*                                                                      */
/* Role: Creation d'un projectile DIS.                                  */
/*                                                                      */
/* Parametres:                                                          */
/*      Entrees: . Camp du projectile.                                  */
/*               . Type de projectile tire.                             */
/*      Sorties: . Pointeur sur l'entite DIS creee.                     */
/*      Entrees/Sorties:                                                */
/*                                                                      */
/* Pre-conditions:                                                      */
/*                                                                      */
/* Post-conditions:                                                     */
/*                                                                      */
/* Traitement des erreurs:                                              */
/*                                                                      */
/*                                                                      */
/************************************************************************/

void
TactDis::creerProjectileDis (int camp,
                             EntityType * pTypeDis,
                             TactProjectileDis * & pEntiteDis)
{
  EntityID idDis; // Identifiant DIS du projectile

  // Creation d'un nouvel identifiant DIS.

  creerIdentifiantDisProjectile (idDis);

  // Creation de l'entite DIS.

  pEntiteDis = new TactProjectileDis (pExercice,
                                      &idDis,
                                      DRAlgo_Static,
                                      camp,
                                      pTypeDis,
                                      pWeaponManager);
}


/************************************************************************/
/*                                                                      */
/* Nom: initExercice                                                    */
/*                                                                      */
/* Role: Initialisation de l'exercice.                                  */
/*                                                                      */
/* Parametres:                                                          */
/*      Entrees: . timeThreshold                                        */
/*		 . translationThreshold					*/
/*		 . rotationThreshold					*/
/*		 . timeOutInterval					*/
/*      Sorties:                                                        */
/*      Entrees/Sorties:                                                */
/*                                                                      */
/* Pre-conditions:                                                      */
/*                                                                      */
/* Post-conditions:                                                     */
/*                                                                      */
/* Traitement des erreurs:                                              */
/*                                                                      */
/*                                                                      */
/************************************************************************/

void
TactDis::initExercice (float timeThreshold,
                       float translationThreshold,
                       float rotationThreshold,
                       float timeOutInterval)
{
  pExercice->setTimeThreshold(timeThreshold);
  pExercice->setTranslationThreshold(translationThreshold);
  pExercice->setRotationThreshold(rotationThreshold);

  pRemoteEntities->setTimeOutInterval(timeOutInterval);
}


/************************************************************************/
/*                                                                      */
/* Nom: majPasSimulation                                                */
/*                                                                      */
/* Role: Lecture des buffers DIS et extrapolation de l'etat de toutes   */
/*	 les entites du monde DIS.					*/
/*       Mise a jour de la base dynamique des objets graphiques du mon- */
/*       -de virtuel.							*/
/*       Mise a jour de la liste de toutes les entites presentes sur le */
/*       reseau DIS.							*/
/*                                                                      */
/* Parametres:                                                          */
/*      Entrees:                                                        */
/*      Sorties:                                                        */
/*      Entrees/Sorties:                                                */
/*                                                                      */
/* Pre-conditions:                                                      */
/*                                                                      */
/* Post-conditions:                                                     */
/*                                                                      */
/* Traitement des erreurs:                                              */
/*                                                                      */
/*                                                                      */
/************************************************************************/

void
TactDis::majPasSimulation (void)
{
  // Lecture des buffers DIS.

  pExercice->drainInput();


  // Extrapolation de l'etat de toutes les entites DIS du monde DIS.

  pRemoteEntities->deadReckonAllEntities();


  // Mise a jour de la base dynamique des objets graphiques du monde virtuel (pour pouvoir
  // faire les calcul de collision avec les carcasses des vehicules detruits).

  TactGlobalEnv.updateBDD(pExercice, pRemoteEntities);
}





/************************************************************************/
/*                                                                      */
/* Nom: lireEtatEntite                                                  */
/*                                                                      */
/* Role: Lecture de l'etat d'une entite, c'est a dire si elle est detrui*/
/*       -te ou non.                                                    */
/*                                                                      */
/* Parametres:                                                          */
/*      Entrees: . Identifiant DIS de l'entite                          */
/*      Sorties: . booleen valant VRAI si l'entite DIS detruite.        */
/*      Entrees/Sorties:                                                */
/*                                                                      */
/* Pre-conditions:                                                      */
/*                                                                      */
/* Post-conditions:                                                     */
/*                                                                      */
/* Traitement des erreurs:                                              */
/*                                                                      */
/*                                                                      */
/************************************************************************/

void
TactDis::lireEtatEntite (EntityID idDis,
                         TACT_BOOLEAN & detruite)
{
  DisRemoteEntity * pEntiteDistante; // Pointeur vers une entite DIS distante


  // Recuperation de l'entite DIS recherchee.

  pEntiteDistante = pRemoteEntities->getEntity (idDis);


  if (pEntiteDistante != 0)
    {
       // L'entite recherchee existe.

       detruite = TACT_FAUX;
    }
  else
    {
       // L'entite a ete detruite.

       detruite = TACT_VRAI;
    }
}


/************************************************************************/
/*                                                                      */
/* Nom: rechercheObstacleDis                                            */
/*                                                                      */
/* Role: Recherche d'une entite DIS arretee dans la direction ou va     */
/*	 l'entite.							*/
/*                                                                      */
/* Parametres:                                                          */
/*      Entrees: . ...    	                                        */
/*      Sorties:                                                        */
/*      Entrees/Sorties:                                                */
/*                                                                      */
/* Pre-conditions:                                                      */
/*                                                                      */
/* Post-conditions:                                                     */
/*                                                                      */
/* Traitement des erreurs:                                              */
/*                                                                      */
/*                                                                      */
/************************************************************************/

void
TactDis::rechercheObstacleDis (TACT_POSITION pos, float distance, TACT_BOOLEAN & obstacle, TACT_POSITION & positionObstacle)
{
  DisRemoteEntity*  remoteEntity;
  double	dx, dy, dz, d2;

  obstacle = TACT_FAUX;

  // on itere sur les entites DIS
  // on considere la distance sans consideration
  // de la direction ou l'on va mais c'est pour
  // la seconde etape ...

  remoteEntity = pRemoteEntities->first();
  while (remoteEntity)
  {
    // on calcule la distance a chaque entite

    dx = pos.x - remoteEntity->getLocation().x;
    dy = pos.y - remoteEntity->getLocation().y;
    dz = pos.z - remoteEntity->getLocation().z;
    d2 = dx*dx+dy*dy+dz*dz;

    // si la distance est plus petite que la distance de collision
    // et plus grande que 1.0 (pour etre sur que ce n'est pas moi)

    if ((d2 < distance*distance) && (d2 > 1.0))
    {
      obstacle = TACT_VRAI;
      remoteEntity = 0;
      positionObstacle.x = remoteEntity->getLocation().x;
      positionObstacle.y = remoteEntity->getLocation().y;
      positionObstacle.z = remoteEntity->getLocation().z;
    }
    else
      remoteEntity = remoteEntity->next();
  }
  // DD bouchon pour test
  obstacle = TACT_FAUX;
}


/************************************************************************/
/*                                                                      */
/* Nom: envoyerMessageAck                                               */
/*                                                                      */
/* Role: Envoi d'un message d'acquittement sur le reseau DIS par le	*/
/*	 controleur DIS du modele tactique.				*/
/*                                                                      */
/* Parametres:                                                          */
/*      Entrees: . id DIS.                                              */
/*      Sorties:                                                        */
/*      Entrees/Sorties:                                                */
/*                                                                      */
/* Pre-conditions:                                                      */
/*                                                                      */
/* Post-conditions:                                                     */
/*                                                                      */
/* Traitement des erreurs:                                              */
/*                                                                      */
/*                                                                      */
/************************************************************************/

void
TactDis::envoyerMessageAck (EntityID sender, EntityID receiver, AcknowledgeFlag flag)
{
  sender.address.site = pExercice->getSiteID();
  sender.address.host = pExercice->getAppNumber();
  pExercice->sendAcknowledgePDU (sender, receiver, flag);

  if (IHM_MODELE) IHM_MODELE->addMessage("Envoie Acknowledge");
}


/************************************************************************/
/*                                                                      */
/* Nom: envoyerActionResponse                                           */
/*                                                                      */
/* Role: Envoi d'un message action resp sur le reseau DIS par le	*/
/*	 controleur DIS du modele tactique.				*/
/*                                                                      */
/* Parametres:                                                          */
/*      Entrees: . id DIS.                                              */
/*      Sorties:                                                        */
/*      Entrees/Sorties:                                                */
/*                                                                      */
/* Pre-conditions:                                                      */
/*                                                                      */
/* Post-conditions:                                                     */
/*                                                                      */
/* Traitement des erreurs:                                              */
/*                                                                      */
/*                                                                      */
/************************************************************************/

void
TactDis::envoyerActionResponse (EntityID sender, EntityID receiver)
{
  sender.address.site = pExercice->getSiteID();
  sender.address.host = pExercice->getAppNumber();
  pExercice->sendActionResponsePDU (sender.entity, receiver.address.host, receiver.entity);

  if (IHM_MODELE) IHM_MODELE->addMessage("Envoie ActionResponse");
}


/************************************************************************/
/*                                                                      */
/* Nom: envoyerMessageTrace                                             */
/*                                                                      */
/* Role: Envoi d'un message de trace sur le reseau DIS par le controleur*/
/*	 DIS du modele tactique.					*/
/*                                                                      */
/* Parametres:                                                          */
/*      Entrees: . Message.                                             */
/*      Sorties:                                                        */
/*      Entrees/Sorties:                                                */
/*                                                                      */
/* Pre-conditions:                                                      */
/*                                                                      */
/* Post-conditions:                                                     */
/*                                                                      */
/* Traitement des erreurs:                                              */
/*                                                                      */
/*                                                                      */
/************************************************************************/

void
TactDis::envoyerMessageTrace (char message[TACT_LONG_MAX_MESSAGE_TRACE])
{
  // Envoi du message de trace sur le reseau DIS par le controleur DIS.

  pExercice->sendCommentPDU (1, message);

  if (IHM_MODELE) IHM_MODELE->addMessage(message);
}


/************************************************************************/
/*                                                                      */
/* Nom: envoyerMessageTrace                                             */
/*                                                                      */
/* Role: Envoi d'un message de trace sur le reseau DIS par une entite   */
/*	 DIS.								*/
/*                                                                      */
/* Parametres:                                                          */
/*      Entrees: . Identifiant DIS de celui qui emet le message.        */
/*		 . Message.						*/
/*      Sorties:                                                        */
/*      Entrees/Sorties:                                                */
/*                                                                      */
/* Pre-conditions:                                                      */
/*                                                                      */
/* Post-conditions:                                                     */
/*                                                                      */
/* Traitement des erreurs:                                              */
/*                                                                      */
/*                                                                      */
/************************************************************************/

void
TactDis::envoyerMessageTrace (EntityID idDis,
			      char message[TACT_LONG_MAX_MESSAGE_TRACE])
{
  // Envoi du message de trace sur le reseau DIS.

  pExercice->sendCommentPDU (idDis.entity, message);

  if (IHM_MODELE) IHM_MODELE->addMessage(message);
}


/************************************************************************/
/*                                                                      */
/* Nom: envoyerMessageAccrochage                                        */
/*                                                                      */
/* Role: Envoi d'un message d'accrochage sur le reseau DIS par une      */
/*	 entite DIS.							*/
/*                                                                      */
/* Parametres:                                                          */
/*      Entrees: . Identifiant DIS de celui qui emet le message.        */
/*		 . Message.						*/
/*      Sorties:                                                        */
/*      Entrees/Sorties:                                                */
/*                                                                      */
/* Pre-conditions:                                                      */
/*                                                                      */
/* Post-conditions:                                                     */
/*                                                                      */
/* Traitement des erreurs:                                              */
/*                                                                      */
/*                                                                      */
/************************************************************************/

void
TactDis::envoyerMessageAccrochage (int type,
				   EntityID idCapteur,
			           EntityID idCible)
{
  // Envoi du message de trace sur le reseau DIS.

  //DD pExercice->sendAccrochagePdu (idCapteur, idCible, type);
}


/************/
/* The End. */
/************/
