static char helicosccsid[] = " @(#) helico.cc 1.6 97/11/25  - Copyright (c) DE 1997 ";
/************************************************************************/
/*									*/
/*   Ce programme est un produit de la societe DASSAULT ELECTRONIQUE,	*/
/* protege par les lois sur le droit d'auteur et sur le copyright et	*/
/* transmis en licence dans les conditions et termes specifiques	*/
/* indiques dans l'accord de licence qui l'accompagne. DASSAULT		*/
/* ELECTRONIQUE garde la propriete du programme et toutes les 		*/
/* prerogatives qui l'accompagnent. Ce programme ne peut etre modifie	*/
/* en aucune maniere sans l'autorisation ecrite prealable de DASSAULT	*/
/* ELECTRONIQUE.							*/
/*									*/
/* Nom: helico.cc							*/
/*									*/
/* Version: 1.6								*/
/*									*/
/* Historique:								*/
/*	Auteur: D.DULAC							*/
/*	Date: 97/11/25							*/
/*	Creation: 97/08/04						*/
/*									*/
/************************************************************************/

/***********/
/* INCLUDE */
/***********/

#include "HloHelico.h"

/***********/
/* GLOBALE */
/***********/

int disPort = 3002;
int exerciseId = 1;
int entityId = 1;
int applicationId = 3;
int siteId = 1;
float pasDeTemps = 100.0;

char* VERSION_HELICO = "Version 1.6";
char* ADRESSE_HELICO;
char* INTERF_HELICO;


static void ILVCALLBACK
Quit (IlvView* top, IlvAny)
{
  ((HloHelico*) top)->quit (((HloHelico*) top)->getquit());
}


main(int argc, char* argv[])
{

    INTERF_HELICO = 0;
    ADRESSE_HELICO = 0;

    int c;
    while ((c = getopt(argc, argv, "T:P:E:I:S:A:F:M:h:H")) != -1) {
	switch (c) {
	  case 'T':
	    pasDeTemps = atof(optarg);
	    break;
	  case 'P':
	    disPort = atoi(optarg);
	    break;
	  case 'E':
	    exerciseId = atoi(optarg);
	    break;
	  case 'I':
	    entityId = atoi(optarg);
	    break;
	  case 'S':
	    siteId = atoi(optarg);
	    break;
	  case 'A':
	    applicationId = atoi(optarg);
	    break;
	  case 'F':
            INTERF_HELICO = new char [strlen (optarg) + 1];
            strcpy (INTERF_HELICO, optarg);
	    break;
	  case 'M':
            ADRESSE_HELICO = new char [strlen (optarg) + 1];
            strcpy (ADRESSE_HELICO, optarg);
	    break;
	  case 'h':
	  case 'H':
	  default:
	    fprintf(stderr, "usage:	helico [-T pas de temps] [-P port] [-E exercice id] \n		[-I entity id] [-S site id] [-A application id] \n		[-F interface] [-M adresse multicast]\n");
	    exit(1);
	    break;
	}
    }

    if (INTERF_HELICO == 0)
    {
      INTERF_HELICO = new char [strlen ("ec0") + 1];
      strcpy (INTERF_HELICO, "ec0");
    }

    if (ADRESSE_HELICO == 0)
    {
      ADRESSE_HELICO = new char [strlen ("224.68.73.83") + 1];
      strcpy (ADRESSE_HELICO, "224.68.73.83");
    }

    char	title[64];
    sprintf(title, "SSTH Helico %d:%d:%d", siteId, applicationId, entityId);

    IlvDisplay* display = new IlvDisplay(title, 0, argc, argv);
    if (!display || display->isBad()) {
        IlvFatalError("Probleme d'ouverture du display");
        delete display;
        return -1;
    }

    IlvRect taille (50, 50, 825, 700);
    HloHelico* top =
	new HloHelico(display, title, title, &taille);

    top->setDestroyCallback(Quit, 0);

    top->show();

    IlvMainLoop();

    return 0;

}

