/************************************************************************/
/*									*/
/*   Ce programme est un produit de la societe DASSAULT ELECTRONIQUE,	*/
/* protege par les lois sur le droit d'auteur et sur le copyright et	*/
/* transmis en licence dans les conditions et termes specifiques	*/
/* indiques dans l'accord de licence qui l'accompagne. DASSAULT		*/
/* ELECTRONIQUE garde la propriete du programme et toutes les 		*/
/* prerogatives qui l'accompagnent. Ce programme ne peut etre modifie	*/
/* en aucune maniere sans l'autorisation ecrite prealable de DASSAULT	*/
/* ELECTRONIQUE.							*/
/*									*/
/* Nom: HloHelico.h							*/
/*									*/
/* Version: 1.4								*/
/*									*/
/* Role: Helicoptere pilote DIS						*/
/*									*/
/* Historique:								*/
/*	Auteur: D.DULAC							*/
/*	Date: 97/11/25							*/
/*	Creation: 97/08/04						*/
/*									*/
/************************************************************************/


#ifndef HLO_HELICO_H
#define HLO_HELICO_H


static char hlohelicohsccsid[] = " @(#) HloHelico.h 1.4 97/11/25 - Copyright (c) DE 1997 ";


#include "DisExercise.h"
#include "DisRemoteEntities.h"
#include "DisLocalEntity.h"

#include "Helico.h"


class HloHelico : public Helico
{
public:
    int			etat;
    double		v;
    double		x, y, z;
    double		xx, yy, zz;
    double		direction;
    double		alti;
    DisExercise*	exercise;
    DisRemoteEntities*	remoteEntities;
    DisLocalEntity*	monHelico;
    DisLocalEntity*	maMunition;
    EntityID		helicoId;
    EntityID		munitionId;
    EntityID		targetId;
    DeadReckAlgorithm	dra;
    ForceID		force;
    EntityType		helicoType;
    EntityType		munitionType;
    IlvTimer*		timer;
    float		dt;
    float		temps;
    float		tempsDeVol;
    EventID		eventId;
    BurstDescriptor	burst;
    double		mx, my, mz;
    double		mvx, mvy, mvz;
    int			cpt;

protected:
    void		initialize(IlvDisplay*);

public:
    HloHelico (IlvDisplay*, const char* name, const char* title,
	     IlvRect* size = 0, IlvBoolean useAccelerators = IlvFalse,
	     IlvBoolean visible = IlvFalse);
    HloHelico (IlvCompositeAbstractView*, IlvRect* size = 0);
   ~HloHelico (void);

    virtual void algo(IlvGraphic*);
    virtual void orientation(IlvGraphic*);
    virtual void vitesse(IlvGraphic*);
    virtual void altitude(IlvGraphic*);
    virtual void tir(IlvGraphic*);
    virtual void id(IlvGraphic*);
    virtual void quit(IlvGraphic*);

};


#endif


/************/
/* The End. */
/************/

