static char hlohelicosccsid[] = " @(#) HloHelico.cc 1.8 97/11/26 - Copyright (c) DE 1997 ";
/************************************************************************/
/*									*/
/*   Ce programme est un produit de la societe DASSAULT ELECTRONIQUE,	*/
/* protege par les lois sur le droit d'auteur et sur le copyright et	*/
/* transmis en licence dans les conditions et termes specifiques	*/
/* indiques dans l'accord de licence qui l'accompagne. DASSAULT		*/
/* ELECTRONIQUE garde la propriete du programme et toutes les 		*/
/* prerogatives qui l'accompagnent. Ce programme ne peut etre modifie	*/
/* en aucune maniere sans l'autorisation ecrite prealable de DASSAULT	*/
/* ELECTRONIQUE.							*/
/*									*/
/* Nom: HloHelico.cc							*/
/*									*/
/* Version: 1.8								*/
/*									*/
/* Historique:								*/
/*	Auteur: D.DULAC							*/
/*	Date: 97/11/26							*/
/*	Creation: 97/08/04						*/
/*									*/
/************************************************************************/

/***********/
/* INCLUDE */
/***********/

#include <math.h>
#include <ilviews/stdialog.h>

#include "DisRemoteEntity.h"
#include "HloHelico.h"

/**********/
/* EXTERN */
/**********/

extern char* VERSION_HELICO;
extern char* INTERF_HELICO;
extern char* ADRESSE_HELICO;

extern int disPort;
extern int exerciseId;
extern int siteId;
extern int entityId;
extern int applicationId;
extern float pasDeTemps;

/**********/
/* GLOBAL */
/**********/

int			dead = 0;
int			targetentityId = -1;
int			targetsiteId = -1;
int			targethostId = -1;
HloHelico*		monIHM;
DisRemoteEntities*	monRemote;

/************************************************************************/
/*									*/
/* Nom: DetonationCB							*/
/*									*/
/* Role: Callback appelee en cas de reception de PDU Detonation.	*/
/*									*/
/************************************************************************/

void
DetonationCB (DetonationPDU* pdu)
{
  // deja on regarde si c'est pour nous
  if (  (pdu->target_entity_id.address.site == siteId) &&
	(pdu->target_entity_id.address.host == applicationId) &&
	(pdu->target_entity_id.entity == entityId) )
  {
    // ensuite on regarde si ca explose assez pres
    double x,y,z, dist;

    x = monIHM->x - pdu->location_in_world.x;
    y = monIHM->y - pdu->location_in_world.y;
    z = monIHM->z - pdu->location_in_world.z;

    dist = x*x+y*y+z*z;	// carre de la distance cible - explosion
/*
    IlvPrint("detonation CB sur %d:%d:%d, dist au carre = %f",
		pdu->target_entity_id.address.site,
		pdu->target_entity_id.address.host,
		pdu->target_entity_id.entity,
		dist);
*/
    if (dist < 300.0)	// si distance au carre < 300.0
    {
      monIHM->gettir()->setLabel("Detruit");
      monIHM->gettir()->setSensitive(IlvFalse);
      monIHM->reDrawObj(monIHM->gettir());
      dead = 1;
    }
  }
}


/************************************************************************/
/*									*/
/* Nom: EntityAddedCB							*/
/*									*/
/* Role: Callback appelee en cas de creation d'entite DIS.		*/
/*									*/
/************************************************************************/

void
EntityAddedCB (DisRemoteEntity*)
{
  char	truc[32];
  int	eid, hid, sid;

  targetentityId = -1;
  targethostId = -1;
  targetsiteId = -1;

  monIHM->getcible()->setLabel("id:id:id");
  monIHM->reDrawObj(monIHM->getcible());

  // on vide la liste
  for (int k = 0; k < monIHM->getid()->getCardinal(); k++)
    monIHM->getid()->removeLabel(0);

  // recomposition de la liste
  DisRemoteEntity* iter = monRemote->first();
  while (iter)
  {
    eid = iter->getID().entity;
    hid = iter->getID().address.host;
    sid = iter->getID().address.site;
    // on ne se rajoute pas
    if ((eid != entityId) || (hid != applicationId) || (sid != siteId))
    {
      sprintf(truc, "%d:%d:%d ", sid, hid, eid);
      monIHM->getid()->insertLabel(0, truc);
    }
    iter = iter->next();
  }

  // redessin de la liste
  monIHM->reDrawObj(monIHM->getid ());
}

/************************************************************************/
/*									*/
/* Nom: RemoveAndDeleteCB						*/
/*									*/
/* Role: Callback appelee en cas de suppression d'entite DIS.		*/
/*									*/
/************************************************************************/

void
RemoveAndDeleteCB (DisRemoteEntity*)
{
  char	truc[32];
  int	eid, hid, sid;

  targetentityId = -1;
  targethostId = -1;
  targetsiteId = -1;

  monIHM->getcible()->setLabel("id:id:id");
  monIHM->reDrawObj(monIHM->getcible());

  // on vide la liste
  for (int k = 0; k < monIHM->getid()->getCardinal(); k++)
    monIHM->getid()->removeLabel(0);

  // recomposition de la liste
  DisRemoteEntity* iter = monRemote->first();
  while (iter)
  {
    eid = iter->getID().entity;
    hid = iter->getID().address.host;
    sid = iter->getID().address.site;
    // on ne se rajoute pas
    if ((eid != entityId) || (hid != applicationId) || (sid != siteId))
    {
      sprintf(truc, "%d:%d:%d ", sid, hid, eid);
      monIHM->getid()->insertLabel(0, truc);
    }
    iter = iter->next();
  }

  // redessin de la liste
  monIHM->reDrawObj(monIHM->getid ());
}

/************************************************************************/
/*									*/
/* Nom: MiseAJour							*/
/*									*/
/* Role: Callback appelee regulierement et mettant a jour 		*/
/*									*/
/************************************************************************/

static void ILVCALLBACK
MiseAJour (IlvTimer*, IlvAny arg)
{
  HloHelico*		ihm = (HloHelico*) arg;
  DisExercise*		exercise = ihm->exercise;
  DisRemoteEntities*	remote = ihm->remoteEntities;
  DisLocalEntity*	helico = ihm->monHelico;
  DisLocalEntity*	munition = ihm->maMunition;
  double		pas;
  double		vx, vy, vz;
  int			altitude;
  char			toto[80];

  pas = ihm->dt / 1000.0;	// on passe de ms en sec

  exercise->drainInput ();

  remote->deadReckonAllEntities();

  if (dead)
    helico->setDamageAppearanceDestroyed();

  if ((ihm->etat == 1) && (dead == 0))
  {
    // on enregistre l'ancienne position UTM

    ihm->xx = ihm->x;
    ihm->yy = ihm->y;
    ihm->zz = ihm->z;

    // on calcule les composantes UTM x et y de la vitesse

    vx = ihm->v * cos (ihm->direction);
    vy = ihm->v * sin (ihm->direction);

    // on calcule la nouvelle position UTM

    ihm->x = ihm->xx + vx * pas;
    ihm->y = ihm->yy + vy * pas;

    // on prend la hauteur de vol du slider comme altitude

    ihm->z = ihm->alti;
    altitude = (int) (ihm->z);

    // mise a jour des champs texte

    sprintf (toto, "%d m", altitude);
    ihm->getvalaltitude ()->setLabel (toto);
    ihm->reDrawObj(ihm->getvalaltitude ());

    // on calcule la composante UTM z de la vitesse

    vz = (ihm->z - ihm->zz) / pas;

    // on met a jour l'objet DIS

    helico->setLocation (ihm->x, ihm->y, ihm->z);

    helico->setVelocity (vx, vy, vz);

    helico->setAcceleration (0.0, 0.0, 0.0);

    helico->setOrientation (-(ihm->direction-3.14159/2), 0.0, 0.0);

    helico->setAngularVelocity (0.0, 0.0, 0.0);

    if (ihm->tempsDeVol > 0.0) 
    {
      // mise a jour de la munition

      ihm->mx = ihm->mx + ihm->mvx * pas;
      ihm->my = ihm->my + ihm->mvy * pas;
      ihm->mz = ihm->mz + ihm->mvz * pas;

      munition->setLocation(ihm->mx, ihm->my, ihm->mz);
      munition->setVelocity(ihm->mvx, ihm->mvy, ihm->mvz);

      munition->Tick();

      ihm->tempsDeVol -= (ihm->dt/1000.0);

      if (ihm->tempsDeVol <= 0.0)
      {
        EntityLocation		location;
        VelocityVector		linVelocity;
        EntityRelativeLoc	location_in_entity;

        location.x = ihm->mx;
        location.y = ihm->my;
        location.z = ihm->mz;

        linVelocity.x = ihm->mvx;
        linVelocity.y = ihm->mvy;
        linVelocity.z = ihm->mvz;

        location_in_entity.x = 0.0;
        location_in_entity.y = 0.0;
        location_in_entity.z = 0.0;

        // envoie du PDU Deto

        exercise->sendDetonationPDU(ihm->helicoId,
				    ihm->targetId,
				    ihm->munitionId,
				    ihm->eventId,
				    ihm->burst,
				    location,
				    linVelocity,
				    location_in_entity,
				    DetResult_EntityImpact);

        munition->setFinalAppearance();
        munition->ForceEntityStateTransmission();
        munition->Tick();
        delete munition;
        ihm->tempsDeVol = -1.0;

        ihm->gettir()->setSensitive (IlvTrue);
        ihm->reDrawObj(ihm->gettir());
      }
    }
  }

  helico->Tick();
}


/************************************************************************/
/*									*/
/* Nom: HloHelico							*/
/*									*/
/* Role: Constructeur 							*/
/*									*/
/************************************************************************/

HloHelico::HloHelico (IlvDisplay* display, const char* name, const char* title,
	     IlvRect* size, IlvBoolean useAccelerators,
	     IlvBoolean visible)
 : Helico (display, name, title, size, useAccelerators, visible)
{
  initialize (display);
}

/************************************************************************/
/*									*/
/* Nom: HloHelico							*/
/*									*/
/* Role: Constructeur 							*/
/*									*/
/************************************************************************/

HloHelico::HloHelico(IlvCompositeAbstractView* aview, IlvRect* size)
 : Helico (aview, size)
{
  initialize (aview->getDisplay());
}


/************************************************************************/
/*									*/
/* Nom: HloHelico							*/
/*									*/
/* Role: Destructeur 							*/
/*									*/
/************************************************************************/

HloHelico::~HloHelico()
{
  delete monHelico;
  delete remoteEntities;
  delete exercise;
  delete timer;
}

/************************************************************************/
/*									*/
/* Nom: initialize							*/
/*									*/
/* Role: initialisation dans les constructeurs				*/
/*									*/
/************************************************************************/

void
HloHelico::initialize(IlvDisplay* display)
{
  IlvButton*		button;
  float			timeThreshold;
  float			translationThreshold;
  float			rotationThreshold;
  float			timeOutInterval;

  // ENVIRONNEMENT

  if (!getenv("SSTH_HOME"))
  {
    static IlvIWarner* warner = 0;
    if (!warner) warner =
      new IlvIWarner (display, "Mettre a jour la variable SSTH_HOME.");
    button = (IlvButton*) warner->getObject("apply");
    if (button) button->setLabel("Fermer");
    warner->setTitle("Probleme d'initialisation");
    warner->moveToMouse();
    warner->get();
    delete display;
    IlvExit(0);
  }

  // etat (start/stop, int = start)

  etat = 1;

  // pas de temps en ms

  dt = pasDeTemps;

  // temps passe en ms

  temps = 0.0;

  // DIS

  timeThreshold = 5;		// 5 s
  translationThreshold = 1;	// 1 m
  rotationThreshold = 0.1;	// 0.1 radian
  timeOutInterval = 5;		// 5 s

  IlvPrint("");
  IlvPrint(" Port reseau DIS		: %d", disPort);
  IlvPrint(" Numero d'exercice DIS		: %d", exerciseId);
  IlvPrint(" Numero de site DIS		: %d", siteId);
  IlvPrint(" Numero d'application DIS	: %d", applicationId);
  IlvPrint(" Numero d'entite DIS		: %d", entityId);
  IlvPrint(" Pas de temps			: %f ms", dt);
  IlvPrint(" Seuil temps			: %f ", timeThreshold);
  IlvPrint(" Seuil trans			: %f ", translationThreshold);
  IlvPrint(" Seuil rot			: %f ", rotationThreshold);
  IlvPrint(" Time out			: %f ", timeOutInterval);
  IlvPrint(" ");
  IlvPrint(" Interface reseau		: %s ", INTERF_HELICO);
  IlvPrint(" Adresse multicast		: %s ", ADRESSE_HELICO);
  IlvPrint("");

  // on cree et initialise les objets DIS : exercise

  exercise = new DisExercise (disPort, exerciseId, siteId, applicationId, INTERF_HELICO, ADRESSE_HELICO);

  if (exercise->creationOK() == FALSE)
  {
    static IlvIWarner* warner = 0;
    if (!warner) warner =
      new IlvIWarner (display, "Port DIS deja utilise ?");
    button = (IlvButton*) warner->getObject("apply");
    if (button) button->setLabel("Fermer");
    warner->setTitle("Probleme d'initialisation");
    warner->moveToMouse();
    warner->get();
    delete display;
    IlvExit(0);
  }

  exercise->setTimeThreshold(timeThreshold);
  exercise->setTranslationThreshold(translationThreshold);
  exercise->setRotationThreshold(rotationThreshold);

  exercise->detonationCB = &DetonationCB;

  // initialisation du compteur des identifiants des projectiles
  cpt = 500 + 50 * entityId;

  remoteEntities = new DisRemoteEntities (exercise);

  remoteEntities->setTimeOutInterval(timeOutInterval);
  remoteEntities->setAddEntity(&EntityAddedCB);
  remoteEntities->setDeleteEntity(&RemoveAndDeleteCB);

  helicoId.address.site = siteId;
  helicoId.address.host = applicationId;
  helicoId.entity = entityId;

  dra = getalgo()->whichSelected() + 1;

  force = ForceID_Friendly;

  // Gazelle

  helicoType.entity_kind = 1;
  helicoType.domain = 2;
  helicoType.country = 71;
  helicoType.category = 20;
  helicoType.subcategory = 2;
  helicoType.specific = 2;
  helicoType.extra = 0;

  monHelico = new DisLocalEntity (exercise, &helicoId, dra, force, &helicoType);

  x =  290850.000;
  y = 4792870.000;
  z =     20.000;

  xx = x;
  yy = y;
  zz = z;

  v = getvitesse()->getValue () / 3.6;
  direction = getorientation ()->getValue () * 3.14159 / 180.0;
  alti = getaltitude ()->getValue ();

  monHelico->setLocation (x, y, z);

  monHelico->setVelocity (0.0, 0.0, 0.0);

  monHelico->setAcceleration (0.0, 0.0, 0.0);

  monHelico->setOrientation (0.0, 0.0, 0.0);

  monHelico->setAngularVelocity (0.0, 0.0, 0.0);

  // Munition

  tempsDeVol = -1;

  // pour les calbacks

  monIHM = this;
  monRemote = remoteEntities;

  // on cree le timer pour l'interrogation reguliere du reseau DIS

  timer = new IlvTimer (display, 0, dt, MiseAJour, this);

  // on se met a l'ecoute de DIS

  timer->run();

  // on prend en compte les ajouts en redessinant

  draw();
}


/************************************************************************/
/*									*/
/* Nom: algo								*/
/*									*/
/* Role: maj de l'algo de DR						*/
/*									*/
/************************************************************************/

void
HloHelico::algo (IlvGraphic*)
{
  dra = getalgo()->whichSelected() + 1;
  monHelico->setDeadReckAlgorithm(dra);
}


/************************************************************************/
/*									*/
/* Nom: orientation							*/
/*									*/
/* Role: maj de l'orientation						*/
/*									*/
/************************************************************************/

void
HloHelico::orientation (IlvGraphic*)
{
  direction = getorientation ()->getValue () * 3.14159 / 180.0;
}


/************************************************************************/
/*									*/
/* Nom: vitesse							*/
/*									*/
/* Role: maj de la vitesse						*/
/*									*/
/************************************************************************/

void
HloHelico::vitesse (IlvGraphic*)
{
  char		toto[80];
  int		vite;

  v = getvitesse()->getValue ();

  vite = (int) v;
  sprintf (toto, "%d km/h", vite);
  getvalvitesse ()->setLabel (toto);
  reDrawObj(getvalvitesse ());
  v = v / 3.6;
}


/************************************************************************/
/*									*/
/* Nom: altitude							*/
/*									*/
/* Role: maj de l'altitude						*/
/*									*/
/************************************************************************/

void
HloHelico::altitude (IlvGraphic*)
{
  char		toto[80];
  int		altitu;

  alti = getaltitude ()->getValue ();

  altitu = (int) alti;
  sprintf (toto, "%d m", altitu);
  getvalhauteur ()->setLabel (toto);
  reDrawObj(getvalhauteur ());
}


/************************************************************************/
/*									*/
/* Nom: tir								*/
/*									*/
/* Role: tir								*/
/*									*/
/************************************************************************/

void
HloHelico::tir(IlvGraphic*)
{
 if (!dead)
 {
  EntityLocation	location;
  float			velocity[3];
  float			range;

  // identifiant de la munition

  munitionId.entity = cpt++;
  munitionId.address.site = exercise->getSiteID();
  munitionId.address.host = exercise->getAppNumber();

  // type de la munition = missile HOT

  munitionType.entity_kind = 2;
  munitionType.domain = 2;
  munitionType.country = 71;
  munitionType.category = 1;
  munitionType.subcategory = 3;
  munitionType.specific = 0;
  munitionType.extra = 0;

  // creation de la munition

  maMunition = new DisLocalEntity (exercise, &munitionId, DRAlgo_Static, force, &munitionType);

  // position initiale de la munition : celle de l'helico

  mx = x;
  my = y;
  mz = z;

  // identifiant de la cible

  targetId.entity = targetentityId;
  targetId.address.site = targetsiteId;
  targetId.address.host = targethostId;

  // position finale de la munition : celle de la cible

  double		mfx, mfy, mfz;
  DisRemoteEntity*	cible = remoteEntities->getEntity(targetId);
  if (cible)
  {
    mfx = cible->getLocation().x;
    mfy = cible->getLocation().y;
    mfz = cible->getLocation().z;
  }
  else
  {
    mfx = x;
    mfy = y;
    mfz = z;
  }

  // calcul du temps de vol connaissant la vitesse cste = 240 m/s

  mfx = mfx - mx;
  mfy = mfy - my;
  mfz = mfz - mz;
  tempsDeVol = sqrt(mfx*mfx+mfy*mfy+mfz*mfz) / 300.0;

  // calcul des composantes (x,y,z) de la vitesse

  if (tempsDeVol > 0.0)
  {
    mvx = mfx / tempsDeVol;
    mvy = mfy / tempsDeVol;
    mvz = mfz / tempsDeVol;
  }
  else
  {
    tempsDeVol = 0.0;
    mvx = 0.0;
    mvy = 0.0;
    mvz = 0.0;
  }

  maMunition->setLocation(mx, my, mz);
  maMunition->setVelocity(mvx, mvy, mvz);

  float dir = mvx*mvx+mvy*mvy;
  if (dir > 0.0) 
    dir = 3.14159/2 - acos(mvx/sqrt(dir));
  else dir = 3.14159/2 - direction;

  maMunition->setOrientation (dir, 0.0, 0.0);

  targetId.entity = targetentityId;
  targetId.address.site = targetsiteId;
  targetId.address.host = targethostId;

  eventId.event = exercise->getNextEventID();
  eventId.address.site = exercise->getSiteID();
  eventId.address.host = exercise->getAppNumber();

  // On remplit le PDU Fire

  // missile HOT

  burst.munition.entity_kind = munitionType.entity_kind;
  burst.munition.domain = munitionType.domain;
  burst.munition.country = munitionType.country;
  burst.munition.category = munitionType.category;
  burst.munition.subcategory = munitionType.subcategory;
  burst.munition.specific = munitionType.specific;
  burst.munition.extra = munitionType.extra;

  burst.warhead = WarheadMunition_HighExp;
  burst.fuze = FuzeMunition_Contact;
  burst.quantity = 1;
  burst.rate = 0;

  location.x = x;
  location.y = y;
  location.z = z;

  velocity[0] = 0.0;
  velocity[1] = 0.0;
  velocity[2] = 0.0;

  range = 0.0;

  // Envoie du PDU

  exercise->sendFirePDU(helicoId, targetId, munitionId, eventId, burst,
			location, velocity, range);

  gettir()->setSensitive (IlvFalse);
  reDrawObj(gettir());
 }
}


/************************************************************************/
/*									*/
/* Nom: id								*/
/*									*/
/* Role: designation id cible						*/
/*									*/
/************************************************************************/

void
HloHelico::id(IlvGraphic*)
{
  int			i, j, k;
  char			selected[64];

  i = -1;
  j = -1;
  k = -1;

  strncpy(selected, (char*) getid()->getSelection(), 64);

  sscanf(selected, "%d:%d:%d", &i, &j, &k);

  targetentityId = k;
  targethostId = j;
  targetsiteId = i;

  getcible()->setLabel (selected);
  reDrawObj(getcible());
}

/************************************************************************/
/*									*/
/* Nom: quit								*/
/*									*/
/* Role: sortie de l'application					*/
/*									*/
/************************************************************************/

void
HloHelico::quit(IlvGraphic* g)
{
    IlvContainer* container = IlvContainer::getContainer(g);
    IlvDisplay* display = container->getDisplay();
    IlvButton*		button;

    static IlvIQuestionDialog* questiondialog = 0;
    if (!questiondialog) questiondialog =
      new IlvIQuestionDialog (display, "Voulez-vous vraiment quitter ?");
    questiondialog->setTitle("Confirmation de sortie");
    button = (IlvButton*) questiondialog->getObject("apply");
    if (button) button->setLabel("Oui");
    button = (IlvButton*) questiondialog->getObject("cancel");
    if (button) button->setLabel("Non");
    questiondialog->moveToMouse();
    if (questiondialog->get())
    {
      delete container->getParent();
      delete display;
      IlvExit(0);
    }
}


/************/
/* The End. */
/************/

