/************************************************************************/
/*									*/
/*   Ce programme est un produit de la societe DASSAULT ELECTRONIQUE,	*/
/* protege par les lois sur le droit d'auteur et sur le copyright et	*/
/* transmis en licence dans les conditions et termes specifiques	*/
/* indiques dans l'accord de licence qui l'accompagne. DASSAULT		*/
/* ELECTRONIQUE garde la propriete du programme et toutes les 		*/
/* prerogatives qui l'accompagnent. Ce programme ne peut etre modifie	*/
/* en aucune maniere sans l'autorisation ecrite prealable de DASSAULT	*/
/* ELECTRONIQUE.							*/
/*									*/
/* Nom: DisExercise.h							*/
/*									*/
/* Version: 1.23							*/
/*									*/
/* Role: Connexion a un exercice DIS d'apres DIS-3.0 de la NPS.		*/
/*									*/
/* Historique:								*/
/*      Portage LINUX : B.BRODARD				        */
/*	Date: 97/08/08							*/
/*	Auteur: D.DULAC	(d'apres DIS-3.0 de la NPS)			*/
/*	Date: 97/11/21							*/
/*	Creation: 97/04/10						*/
/*									*/
/************************************************************************/


#ifndef DIS_EXERCISE_H
#define DIS_EXERCISE_H


static char disexercisehsccsid[] = " @(#) DisExercise.h 1.12 97/07/11 - Copyright (c) DE 1997 ";


/***********/
/* INCLUDE */
/***********/

#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <time.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <net/if.h>
#include <arpa/inet.h>		// ajout Benoit
#include <signal.h>		// kill()
#include <unistd.h>
#include <sys/shm.h>            // shared memory, ajout Benoit
#include <sys/sem.h>            // semaphores, ajout Benoit
#include <sys/ioctl.h>		// ajout Benoit

#include <sys/types.h>		// network external representation of pdu
#include <rpc/types.h>		// ajout Benoit
#include <rpc/xdr.h>

//#include <net/soioctl.h>
//#include <ulocks.h>		// arena
//#include <sys/prctl.h>		// sproc()

#include "DisStructure.h"
#include "DisLocalEntities.h"
#include "DisRemoteEntities.h"

/**********/
/* DEFINE */
/**********/

#define IN_ADDR_SIZE    4

#define DEFAULT_BUF_LEN	300

#define BUF1		0
#define BUF2		1


/**************************************/
/* Structure pour la memoire partagee */
/**************************************/

typedef struct {
    int			 receiver_pid;
    int			 application_pid;

    int			 current_net_buf;
			  // PDUs from net go into current buffer; the
			  // application reads PDUs from the other buf

    int			 swap_buf_sema;	// control access to swap_buf_flag
    int			 swap_buf_flag;

    int			 buf1_oldest;
    int			 buf1_newest;
    int			 buf1_wasted;	// overwritten PDUs
    int			 nodes_in_buf1;
    union PDU		*pdu_buf1;	// PDU array; size selected through
					// arg to net_open()

    int			 buf2_oldest;
    int			 buf2_newest;
    int			 buf2_wasted;	// overwritten PDUs
    int			 nodes_in_buf2;
    union PDU		*pdu_buf2;
} PDUarena;


/******************************************/
/* Structure en retour de la methode read */
/******************************************/

struct readstat {
   PDUType	rs_type;
   int		rs_wasted;	// wasted (overwritten) PDUs
   int		rs_swap_buffers_flag;
};



class DisExercise
{
  public:

    DisExercise(int port, int exercise_id, 
		int site_id, int application_num,
		char *interf = "et0", char *adr = "224.68.73.83", int buf_len = DEFAULT_BUF_LEN);

    ~DisExercise();

    int		creationOK (void);

    void	filterPDU (void);
    void	unfilterPDU (void);

    int		isFiltered (PDUType);
    void	filterPDU (PDUType);
    void	unfilterPDU (PDUType);

    void	setTimeThreshold (float);
    void	setTranslationThreshold (float);
    void	setRotationThreshold (float);
    void	setArtPartFractionalThreshold (float);

    float	getTimeThreshold (void);
    float	getTranslationThreshold (void);
    float	getRotationThreshold (void);
    float	getArtPartFractionalThreshold (void);

    int		getExerciseID (void);
    int		getSiteID (void);
    int		getAppNumber (void);

    int		getNextEventID (void);

    union PDU*	read(struct readstat*);
    int		write(char *, PDUType);

    int		drainInput(void);
    int		readDetonationPDU(union PDU*);
    int		readFirePDU(union PDU*);
    int		readStartResumePDU(union PDU*);
    int		readStopFreezePDU(union PDU*);
    int		readCommentPDU(union PDU*);
    int		readActionRequestPDU(union PDU*);
    int		readActionResponsePDU(union PDU*);
    int		readRemoveEntityPDU(union PDU*);
    int		readEntityStatePDU(union PDU*);

    int		sendStartPDU(unsigned short);
    int		sendStopPDU(unsigned short);
    int		sendEndPDU(unsigned short);
    int		sendCommentPDU(unsigned short, char *);
    int		sendActionRequestPDU(unsigned short, unsigned short, unsigned short, unsigned int);
    int		sendActionResponsePDU(unsigned short, unsigned short, unsigned short);
    int		sendRemoveEntityPDU(unsigned short, unsigned short, unsigned short);
    int		sendAcknowledgePDU(EntityID, EntityID, AcknowledgeFlag);
    int		sendFirePDU(EntityID, EntityID, EntityID, EventID, BurstDescriptor, EntityLocation, float [3], float);
    int		sendDetonationPDU(EntityID, EntityID, EntityID, EventID, BurstDescriptor, EntityLocation, VelocityVector, EntityRelativeLoc, DetonationResult);

    void	(*entityStateCB) (EntityStatePDU*);
    void	(*detonationCB) (DetonationPDU*);
    void	(*fireCB) (FirePDU*);
    void	(*startCB) (StartResumePDU*);
    void	(*stopCB) (StopFreezePDU*);
    void	(*commentCB) (CommentPDU*);
    void	(*actionRequestCB) (ActionRequestPDU*);
    void	(*actionResponseCB) (ActionResponsePDU*);
    void	(*removeEntityCB) (RemoveEntityPDU*);

    void	setRemoteEntities(DisRemoteEntities*);

    int         lock(int);
    int         unlock(int);

  protected:

    int			 creationProblem;

    int			 portNumber;
    int			 exerciseId;
    int			 siteId;
    int			 applicationNumber;

    float		 timeThreshold;          /* seconds simTime */
    float		 translationThreshold;   /* meters */
    float		 rotationThreshold;      /* radians */
    float		 artPartFractionalThreshold; 

    int			 nextEventNumber;

    int			 nextRequestNumber;

    DisLocalEntities	*localEntities;
    DisRemoteEntities	*remoteEntities;

    int			 sock_send;
    int			 sock_recv;
    struct sockaddr_in	 dest;
    char		 my_in_addr[IN_ADDR_SIZE];
    unsigned short	 host_id;

    PDUType		 pdulist[MAX_NUM_PDUS];		// PDU types to receive

    int                  shmid_ptr, shmid_buf1, shmid_buf2;

    PDUarena		*PDUarena_ptr;

    int			 pdus_in_buffer;

    // External data representation

    XDR                  xdr_enc;
    XDR                  xdr_dec;
    
    char                 xdr_dectab[1024];
    char                 xdr_enctab[1024];
    
    int			 init_arena(void);
    void		 swap_net_buffers(void);

    friend void		 receiver_process(void *);

};


#endif


/************/
/* The End. */
/************/

