static char disexercisesccsid[] = " @(#) DisExercise.cc 1.29 97/11/14 - Copyright (c) DE 1997 ";
/************************************************************************/
/*									*/
/*   Ce programme est un produit de la societe DASSAULT ELECTRONIQUE,	*/
/* protege par les lois sur le droit d'auteur et sur le copyright et	*/
/* transmis en licence dans les conditions et termes specifiques	*/
/* indiques dans l'accord de licence qui l'accompagne. DASSAULT		*/
/* ELECTRONIQUE garde la propriete du programme et toutes les 		*/
/* prerogatives qui l'accompagnent. Ce programme ne peut etre modifie	*/
/* en aucune maniere sans l'autorisation ecrite prealable de DASSAULT	*/
/* ELECTRONIQUE.							*/
/*									*/
/* Nom: DisExercise.cc							*/
/*									*/
/* Version: 1.29							*/
/*									*/
/* Historique:								*/
/*      Portage LINUX : B.BRODARD				        */
/*	Date: 97/08/08							*/
/*	Auteur: D.DULAC	(d'apres DIS-3.0 de la NPS)			*/
/*	Date: 97/11/14							*/
/*	Creation: 97/04/10						*/
/*									*/
/************************************************************************/

/***********/
/* INCLUDE */
/***********/

#include <string.h>		// strcmp()
#include <bstring.h>		// bcopy()
#include <unistd.h>             // getpid()
#include "DisStructure.h"
#include "DisTime.h"
#include "DisExercise.h"
#include "DisRemoteEntity.h"
#include "DisLocalEntity.h"


/************************************/
/* Mode d'estampillage des PDU :    */
/*                                  */
/* 0 pour mode relatif (OK sur LAN) */
/* 1 pour mode absolu (OK sur WAN)  */
/*                                  */
/************************************/

int TIME_STAMP_MODE = 1;


/************************************************************************/
/*									*/
/* Nom: DisExercise							*/
/*									*/
/* Role: Constructeur 							*/
/*									*/
/************************************************************************/

DisExercise::DisExercise (int port, int exId, int sitId, int app, char *interf, char *mc_addr, int buf_len)
{
    int			i, on = 1;
    int			valid_interface = FALSE;
    char		buf[BUFSIZ];
    struct sockaddr_in	sin_send, sin_recv, *in_addr;
    struct ifconf	ifc;
    struct ifreq	*ifr;

    // Multicast
    unsigned long int   mc_addr_bin = 0;
    unsigned char       ttl = 64, on_c =1;
    struct ip_mreq      imr;

    creationProblem = 0;

    portNumber = port;
    exerciseId = exId;
    siteId = sitId;
    applicationNumber = app;

    timeThreshold = 5.0;
    translationThreshold = 1.0;
    rotationThreshold = 3.0;
    artPartFractionalThreshold = 1.0;

    nextEventNumber = 1;

    nextRequestNumber = 1;

    localEntities = new DisLocalEntities();
    remoteEntities = 0;

    entityStateCB = 0;
    detonationCB = 0;
    fireCB = 0;
    startCB = 0;
    stopCB = 0;
    commentCB = 0;
    actionRequestCB = 0;
    actionResponseCB = 0;
    removeEntityCB = 0;

    // PDUs we want to receive; all others will be filtered out
    pdulist[0] = StartResumePDU_Type;
    pdulist[1] = StopFreezePDU_Type;
    pdulist[2] = AcknowledgePDU_Type;
    pdulist[3] = EntityStatePDU_Type;
    pdulist[4] = FirePDU_Type;
    pdulist[5] = DetonationPDU_Type;
    pdulist[6] = CommentPDU_Type;
    pdulist[7] = ActionRequestPDU_Type;
    pdulist[8] = ActionResponsePDU_Type;
    pdulist[9] = RemoveEntityPDU_Type;
    pdulist[10] = (PDUType) 0;	// NULL terminate list

    // Set up arena
    pdus_in_buffer = buf_len;
    if (init_arena() == FALSE)
    {
      perror("DisExercise : init_arena");
      creationProblem = 1;
    }

    // Create sockets
    if ((sock_send = socket(AF_INET, SOCK_DGRAM, 0)) == -1)
    {
      perror("DisExercise : socket(sock_send)");
      creationProblem = 1;
    }
    if ((sock_recv = socket(AF_INET, SOCK_DGRAM, 0)) == -1)
    {
      perror("DisExercise : socket(sock_recv)");
      creationProblem = 1;
    }

    // Get InterFace CONFig
    ifc.ifc_len = sizeof(buf);
    ifc.ifc_buf = buf;
    if (ioctl(sock_send, SIOCGIFCONF, (char *) &ifc) == -1)
    {
      perror("DisExercise : ioctl(SIOCGIFCONF)");
      creationProblem = 1;
    }

    // Check interfaces (assumes same interface for sender and receiver)
    ifr = ifc.ifc_req;		// ptr to interface structure
    for (i = 0; i < (ifc.ifc_len / sizeof(struct ifreq)); i++, ifr++)
    {
      if (ifr->ifr_addr.sa_family != AF_INET)	// Internet only
         continue;

      // Get InterFace FLAGS
      if (ioctl(sock_send, SIOCGIFFLAGS, (char *) ifr) == -1)
      {
         perror("DisExercise : ioctl(SIOCGIFFLAGS)");
         creationProblem = 1;
      }

      // Skip boring cases
      if ((ifr->ifr_flags & IFF_UP) == 0 ||		// interface down?
          (ifr->ifr_flags & IFF_LOOPBACK) ||		// local loopback?
          (ifr->ifr_flags & IFF_MULTICAST) == 0 ||	// no multicast? 
          (ifr->ifr_flags & IFF_BROADCAST) == 0) {	// no broadcast?
         continue;
      }

      // Get and save InterFace ADDRess
      if (ioctl(sock_send, SIOCGIFADDR, (char *) ifr) == -1)
      {
        perror("DisExercise : ioctl(SIOCGIFADDR)");
        creationProblem = 1;
      }
      in_addr = (struct sockaddr_in *) &(ifr->ifr_addr);
      bcopy((char *) &(in_addr->sin_addr), (char *) my_in_addr, IN_ADDR_SIZE);
      host_id = (unsigned short) my_in_addr[3];    // unique on subnet

      // Assign destination port
      mc_addr_bin = inet_addr(mc_addr);
      bcopy((char *) &mc_addr_bin, (char *) &(dest.sin_addr), sizeof(mc_addr_bin));
      dest.sin_port = htons(port);
      dest.sin_family = AF_INET;

      // Interface we want?
      if (strcmp(interf, ifr->ifr_name) == 0)
      {
         valid_interface = TRUE;
         break;
      }
    }

    if (valid_interface == FALSE)
    {
      printf("DisExercise : No valid interface found\n");
    }

    // Sender
    if(setsockopt(sock_send, SOL_SOCKET, SO_REUSEADDR, (char *)&on, 
		  sizeof(on)) != 0)
    {
      perror("DisExercise : SO_REUSEADDR\n");
      creationProblem = 1;
    }
   
#ifdef SO_REUSEPORT
    // For n applications on the same port of the same machine
    if(setsockopt(sock_send, SOL_SOCKET, SO_REUSEPORT, (char *)&on, 
		  sizeof(on)) != 0)
    {
      perror("DisExercise : SO_REUSEPORT\n");
      creationProblem = 1;
    }

    if(setsockopt(sock_recv, SOL_SOCKET, SO_REUSEPORT, (char *)&on, 
		  sizeof(on)) != 0)
    {
      perror("DisExercise : SO_REUSEPORT\n");
      creationProblem = 1;
    }
#endif
   
    // Bind port numbers to sockets
    sin_send.sin_family = AF_INET;
    sin_send.sin_addr.s_addr = htonl(INADDR_ANY);
    sin_send.sin_port = htons(port - 1);

    if (bind(sock_send, (struct sockaddr *) &sin_send, sizeof(sin_send)) == -1)
    {
      perror("DisExercise : bind(sock_send)");
      creationProblem = 1;
    }
   
    // Multicast stuff

    if(setsockopt(sock_send, IPPROTO_IP, IP_MULTICAST_LOOP, (char*)&on_c, sizeof(on_c)) < 0 )
    {
      perror("DisExercise : IP_MULTICAST_LOOP");
      creationProblem = 1;
    }

    if(setsockopt(sock_send, IPPROTO_IP, IP_MULTICAST_IF, (char*)my_in_addr, IN_ADDR_SIZE) < 0 )
    {
      perror("DisExercise : IP_MULTICAST_IF");
      printf("DisExercise : IP_MULTICAST_IF : %8X\n", *((unsigned int*)my_in_addr));
      creationProblem = 1;
    }

    if(setsockopt(sock_send, IPPROTO_IP, IP_MULTICAST_TTL, (char *)&ttl, sizeof(ttl)) < 0 )
    {
      perror("DisExercise : IP_MULTICAST_TTL");
      creationProblem = 1;
    }        
   
    // Receiver
    if(setsockopt(sock_recv, SOL_SOCKET, SO_REUSEADDR, (char *)&on, 
		  sizeof(on)) != 0) 
    {
      perror("DisExercise : SO_REUSEADDR\n");
      creationProblem = 1;
    }

    // Mark send socket for broadcasting
    if (setsockopt(sock_send, SOL_SOCKET, SO_BROADCAST, &on, sizeof(on)) == -1)
    {
      perror("DisExercise : setsockopt(SO_BROADCAST)");
      creationProblem = 1;
    }

    sin_recv.sin_family = AF_INET;
    sin_recv.sin_addr.s_addr = htonl(INADDR_ANY);
    sin_recv.sin_port = htons(port);

    if (bind(sock_recv, (struct sockaddr *) &sin_recv, sizeof(sin_recv)) == -1)
    {
      perror("DisExercise : bind(sock_recv)");
      creationProblem = 1;
    }

    if(setsockopt(sock_recv, IPPROTO_IP, IP_MULTICAST_LOOP, (char*)&on_c, sizeof(on_c)) < 0 )
    {
      perror("DisExercise : IP_MULTICAST_LOOP");
      creationProblem = 1;
    }

    if(setsockopt(sock_recv, IPPROTO_IP, IP_MULTICAST_IF, (char*)my_in_addr, IN_ADDR_SIZE) < 0 )
    {
      perror("DisExercise : IP_MULTICAST_IF");
      creationProblem = 1;
    }
   
    if(setsockopt(sock_recv, IPPROTO_IP, IP_MULTICAST_TTL, (char *)&ttl, sizeof(ttl)) < 0 )
    {
      perror("DisExercise : IP_MULTICAST_TTL");
      creationProblem = 1;
    }
   
    // Multicast Join
    imr.imr_multiaddr.s_addr = mc_addr_bin;
    imr.imr_interface.s_addr = *((unsigned long int *)my_in_addr);
   
    if(setsockopt(sock_recv, IPPROTO_IP, IP_ADD_MEMBERSHIP, (char *)&imr, 
		  sizeof(struct ip_mreq)) < 0)
    {
      perror("DisExercise : join group");
      creationProblem = 1;
    }

    // Save PID
    PDUarena_ptr->application_pid = getpid();

    // XDR Stuff
    xdrmem_create(&xdr_enc, xdr_enctab, 1024, XDR_ENCODE);
    xdrmem_create(&xdr_dec, xdr_dectab, 1024, XDR_DECODE);

   // Fork the process
   if ((PDUarena_ptr->receiver_pid = fork()) == -1) 
   { // Error on fork()
     perror("DisExercise : fork()");
     creationProblem = 1;
   } 
   else if (!PDUarena_ptr->receiver_pid) 
   {  // Child
     receiver_process((void *)this);
   }
};


/************************************************************************/
/*									*/
/* Nom: DisExercice							*/
/*									*/
/* Role: Destructeur 							*/
/*									*/
/************************************************************************/

DisExercise::~DisExercise ()
{
   union semun sem_buf;

   // Remove semaphore set
   semctl(PDUarena_ptr->swap_buf_sema, 0, IPC_RMID, sem_buf);

   kill(PDUarena_ptr->receiver_pid, SIGINT);

   close(sock_send);
   close(sock_recv);
};


/************************************************************************/
/*									*/
/* Nom: creationOK							*/
/*									*/
/* Role: Interrogateur 							*/
/*									*/
/************************************************************************/

int
DisExercise::creationOK ()
{
  if (creationProblem == 1)
    return FALSE;
  else
    return TRUE;
}


/************************************************************************/
/*									*/
/* Nom: isFiltered							*/
/*									*/
/* Role: Dis si un type de PDU est filtre. 				*/
/*									*/
/************************************************************************/

int
DisExercise::isFiltered (PDUType type)
{
  int	found = -1;

  // on cherche dans la liste

  for (int i = 0; i < MAX_NUM_PDUS; i++)
  {
    if (pdulist[i] == (PDUType) 0)
    {
      i = MAX_NUM_PDUS;
    }
    else if (pdulist[i] == type)
    {
      found = i;
    }
  }

  if (found == -1)
    return 0;
  else
    return 1;
}


/************************************************************************/
/*									*/
/* Nom: filterPDU							*/
/*									*/
/* Role: Filtre tous les PDUs par type. 				*/
/*									*/
/************************************************************************/

void
DisExercise::filterPDU ()
{
  // we want to filter all PDUs

  pdulist[0] = (PDUType) 0;	// NULL terminate list
}


/************************************************************************/
/*									*/
/* Nom: unfilterPDU							*/
/*									*/
/* Role: Ne filtre plus les PDUs par type. 				*/
/*									*/
/************************************************************************/

void
DisExercise::unfilterPDU ()
{
  // we want to receive all PDUs

  for (int i = 0; i < MAX_NUM_PDUS; i++)
  {
    pdulist[i] = i+1;
  }
  pdulist[MAX_NUM_PDUS-1] = (PDUType) 0;	// NULL terminate list
}


/************************************************************************/
/*									*/
/* Nom: filterPDU							*/
/*									*/
/* Role: Filtre un type de PDU particulier. 				*/
/*									*/
/************************************************************************/

void
DisExercise::filterPDU (PDUType type)
{
  int	found = -1;
  int	last = -1;

  // on cherche dans la liste

  for (int i = 0; i < MAX_NUM_PDUS; i++)
  {
    if (pdulist[i] == (PDUType) 0)
    {
      last = i;
      i = MAX_NUM_PDUS;
    }
    else if (pdulist[i] == type)
    {
      found = i;
    }
  }

  // si il n'y est pas, on l'ajoute a la fin

  if (found == -1)
  {
    pdulist[last] = type;
    pdulist[last+1] = (PDUType) 0;
  }
}


/************************************************************************/
/*									*/
/* Nom: unfilterPDU							*/
/*									*/
/* Role: Ne filtre plus un type de PDU. 				*/
/*									*/
/************************************************************************/

void
DisExercise::unfilterPDU (PDUType type)
{
  int	found = -1;

  // on cherche dans la liste

  for (int i = 0; i < MAX_NUM_PDUS; i++)
  {
    if (pdulist[i] == type)
    {
      found = i;
      i = MAX_NUM_PDUS;
    }
  }

  // si il y est, on le supprime en decalant

  if (found != -1)
  {
    for (i = found; i < MAX_NUM_PDUS-1; i++)
      pdulist[i] = pdulist[i+1];
  }
}


/************************************************************************/
/*									*/
/* Nom: setRemoteEntities						*/
/*									*/
/* Role: Modificateur 							*/
/*									*/
/************************************************************************/

void
DisExercise::setRemoteEntities (DisRemoteEntities* rem)
{
  remoteEntities = rem;
}


/************************************************************************/
/*									*/
/* Nom: setTimeThreshold						*/
/*									*/
/* Role: Modificateur 							*/
/*									*/
/************************************************************************/

void
DisExercise::setTimeThreshold (float threshold)
{
  timeThreshold = threshold;
}


/************************************************************************/
/*									*/
/* Nom: setTranslationThreshold						*/
/*									*/
/* Role: Modificateur 							*/
/*									*/
/************************************************************************/

void
DisExercise::setTranslationThreshold (float threshold)
{
  translationThreshold = threshold;
}


/************************************************************************/
/*									*/
/* Nom: setRotationThreshold						*/
/*									*/
/* Role: Modificateur 							*/
/*									*/
/************************************************************************/

void
DisExercise::setRotationThreshold (float threshold)
{
  rotationThreshold = threshold;
}


/************************************************************************/
/*									*/
/* Nom: setArtPartFractionalThreshold					*/
/*									*/
/* Role: Modificateur 							*/
/*									*/
/************************************************************************/

void
DisExercise::setArtPartFractionalThreshold (float threshold)
{
  artPartFractionalThreshold = threshold;
}


/************************************************************************/
/*									*/
/* Nom: getTimeThreshold						*/
/*									*/
/* Role: Interrogateur 							*/
/*									*/
/************************************************************************/

float
DisExercise::getTimeThreshold ()
{
  return timeThreshold;
}


/************************************************************************/
/*									*/
/* Nom: getTranslationThreshold						*/
/*									*/
/* Role: Interrogateur 							*/
/*									*/
/************************************************************************/

float
DisExercise::getTranslationThreshold ()
{
  return translationThreshold;
}


/************************************************************************/
/*									*/
/* Nom: getRotationThreshold						*/
/*									*/
/* Role: Interrogateur 							*/
/*									*/
/************************************************************************/

float
DisExercise::getRotationThreshold ()
{
  return rotationThreshold;
}


/************************************************************************/
/*									*/
/* Nom: getArtPartFractionalThreshold					*/
/*									*/
/* Role: Interrogateur 							*/
/*									*/
/************************************************************************/

float
DisExercise::getArtPartFractionalThreshold ()
{
  return artPartFractionalThreshold;
}


/************************************************************************/
/*									*/
/* Nom: getExerciseID							*/
/*									*/
/* Role: Observateur 							*/
/*									*/
/************************************************************************/

int
DisExercise::getExerciseID ()
{
  return exerciseId;
}


/************************************************************************/
/*									*/
/* Nom: getSiteID							*/
/*									*/
/* Role: Observateur 							*/
/*									*/
/************************************************************************/

int
DisExercise::getSiteID ()
{
  return siteId;
}


/************************************************************************/
/*									*/
/* Nom: getAppNumber							*/
/*									*/
/* Role: Observateur 							*/
/*									*/
/************************************************************************/

int
DisExercise::getAppNumber ()
{
  return applicationNumber;
}


/************************************************************************/
/*									*/
/* Nom: getNextEventID							*/
/*									*/
/* Role: Observateur 							*/
/*									*/
/************************************************************************/

int
DisExercise::getNextEventID ()
{
  return nextEventNumber++;
}


/************************************************************************/
/*									*/
/* Nom: lock							        */
/*									*/
/* Role: a priori lock semaphore, demander a Benoit ...			*/
/*									*/
/************************************************************************/

int
DisExercise::lock(int sid)
{
  struct sembuf sem_lock = {0, -1, 0};
      
  if((semop(sid, &sem_lock, 1)) == -1)
  {
    perror("DisExercise : lock : semop");
    return (FALSE);
  }
   
  return(TRUE);
}


/************************************************************************/
/*									*/
/* Nom: unlock							        */
/*									*/
/* Role: a priori unlock semaphore, demander a Benoit ...		*/
/*									*/
/************************************************************************/

int
DisExercise::unlock(int sid)
{
  struct sembuf sem_unlock = {0, 1, 0};
   
  if((semop(sid, &sem_unlock, 1)) == -1)
  {
    perror("DisExercise : unlock : semop");
    return (FALSE);
  }
   
  return(TRUE);
}


/************************************************************************/
/*									*/
/* Nom: init_arena							*/
/*									*/
/* Role: Initialisation	de la zone de memoire partagee			*/
/*									*/
/************************************************************************/

int
DisExercise::init_arena()
{
   int		arenasize, fudge;
   key_t        ipc_key;
   union semun  semopts;
   struct shmid_ds shm_buf;
   
   // Init IPC key
   ipc_key = ftok(".", 'a');

   ipc_key += (key_t) 4*getpid();

   // Set arena size
   fudge = (1024 * 10);	// fudge factor
   arenasize =
         (2 * pdus_in_buffer * sizeof(union PDU)) + sizeof(PDUarena) + fudge;

   // Get a arena id
   if ((shmid_ptr = shmget(ipc_key, sizeof(PDUarena), 
		       IPC_CREAT | IPC_EXCL | 0660 )) == -1)
   {
      perror("DisExercise : init_arena : shmget");
      return (FALSE);
   }

   PDUarena_ptr = (PDUarena *) shmat(shmid_ptr, 0, 0);

   // BUF1
   if ((shmid_buf1 = shmget(ipc_key + 1, (sizeof(union PDU)*pdus_in_buffer), 
		       IPC_CREAT | IPC_EXCL | 0660 )) == -1) {
      perror("DisExercise : init_arena : shmget");
      return (FALSE);
   }
   
   PDUarena_ptr->pdu_buf1 = (union PDU *)shmat(shmid_buf1, 0, 0);

   // BUF2
   if ((shmid_buf2 = shmget(ipc_key + 2, (sizeof(union PDU)*pdus_in_buffer), 
		       IPC_CREAT | IPC_EXCL | 0660 )) == -1) {
      perror("DisExercise : init_arena : shmget");
      return (FALSE);
   }
   
   PDUarena_ptr->pdu_buf2 = (union PDU *)shmat(shmid_buf2, 0, 0);

   // Schedule for deletion when no longer used
   shmctl(shmid_ptr, IPC_RMID, &shm_buf);
   shmctl(shmid_buf1, IPC_RMID, &shm_buf);
   shmctl(shmid_buf2, IPC_RMID, &shm_buf);   

   // Init semaphore
   if ((PDUarena_ptr->swap_buf_sema = semget(ipc_key + 3, 1, IPC_CREAT | IPC_EXCL | 0660)) == -1)
   {
      perror("DisExercise : init_arena  : semget");
      return (FALSE);
   }

   semopts.val = 1;   
   semctl(PDUarena_ptr->swap_buf_sema, 0, SETVAL, semopts); // Init to 1

   // Data initializations
   PDUarena_ptr->current_net_buf = BUF1;
   PDUarena_ptr->swap_buf_flag = FALSE;
   PDUarena_ptr->buf1_oldest = 0;
   PDUarena_ptr->buf1_newest = 0;
   PDUarena_ptr->nodes_in_buf1 = 0;
   PDUarena_ptr->buf2_oldest = 0;
   PDUarena_ptr->buf2_newest = 0;
   PDUarena_ptr->nodes_in_buf2 = 0;

   return (TRUE);

} // init_arena()


/************************************************************************/
/*									*/
/* Nom: receiver_process						*/
/*									*/
/* Role: Process forke bouclant en reception sur les PDU...		*/
/*									*/
/************************************************************************/

void
receiver_process (void *pt)
{
   DisExercise		*exo = (DisExercise*) pt;
   int			 i, bytes_read;
   register int		 buf_dimension;
   struct sockaddr_in	 from;
   int			 len = sizeof(from);
   int			 oldest = 0, newest = 0;	// array indexes
   int			 circled = FALSE;
   union PDU		*curr_buf;
   PDUType               type;


   // Initialize local vars
   buf_dimension = (exo->pdus_in_buffer-1);
   if (exo->lock(exo->PDUarena_ptr->swap_buf_sema) == TRUE) { // acquire semaphore
      switch (exo->PDUarena_ptr->current_net_buf) {
         // get pointer to the correct buffer
         case (BUF1):
            // pointer to current buffer; must be handled
            //   as local var (i.e. not in arena) in case application
            //   swaps buffers between reading the packet
            curr_buf = (union PDU *) exo->PDUarena_ptr->pdu_buf1;
            break;
         case (BUF2):
            curr_buf = (union PDU *) exo->PDUarena_ptr->pdu_buf2;
            break;
         default:
            // shouldn't get here
            printf("Invalid net buffer.\n");
            fflush(stdout);
      }
   }
   exo->unlock(exo->PDUarena_ptr->swap_buf_sema); // release semaphore


   // NETWORK READ LOOP
   while (TRUE) {
top_of_loop:

      // XDR stream at position 0
      xdr_setpos(&(exo->xdr_dec), 0);

      //   Read packet off network into temp buffer
      //   Net read must be done while semaphore is released to prevent
      //   hanging application while no packets are incoming
      if ((bytes_read = recvfrom(exo->sock_recv, (void *) exo->xdr_dectab,
				 1024, 0, (struct sockaddr *) &from, &len)) == -1)
      { // FIXME size
        perror("DisExercise : receiver_process : recvfrom()");
      }

      // Reject our own broadcasts
      // BB
      //if (bcmp((void *) &(from.sin_addr), (void *) exo->my_in_addr,
      //                                                 IN_ADDR_SIZE) == 0) {
      //   continue;	// don't process packet further
      //}

      // XDR decode PDUHeader
      if ((xdr_PDUType(&(exo->xdr_dec), &type) == FALSE))
      {
        goto top_of_loop;
      }

      // Is it a PDU on the PDUs-to-receive list?
      for (i = 0; i < MAX_NUM_PDUS; i++) {
         if (exo->pdulist[i] == type)   // A match -- proceed
            break;
         if (exo->pdulist[i] == (PDUType) 0) {  // End of receive list -- no match
            goto top_of_loop;
         }
      }

      //   Save packet, update buffer indexes
      //   (this must be done after acquiring semaphore to block
      //    buffer swap by application)
      if (exo->lock(exo->PDUarena_ptr->swap_buf_sema) == TRUE) { // acquire semaphore
         // Swap buffers?
         if (exo->PDUarena_ptr->swap_buf_flag == TRUE) {
            switch (exo->PDUarena_ptr->current_net_buf) {	// BUF1 or BUF2
               // get pointer to the correct buffer
               case (BUF1):
                  curr_buf = (union PDU *) exo->PDUarena_ptr->pdu_buf1;
                  exo->PDUarena_ptr->nodes_in_buf1 = 0;
                  exo->PDUarena_ptr->buf1_wasted = 0;
                  break;
               case (BUF2):
                  curr_buf = (union PDU *) exo->PDUarena_ptr->pdu_buf2;
                  exo->PDUarena_ptr->nodes_in_buf2 = 0;
                  exo->PDUarena_ptr->buf2_wasted = 0;
                  break;
               default:
                  // booboo time
                  printf("Invalid net buffer.\n");
                  fflush(stdout);
            }
            // Buffers swapped so start at beginning of buf
            oldest = newest = 0;
            circled = FALSE;
            //
            exo->PDUarena_ptr->swap_buf_flag = FALSE;
         }

         // Copy new packet to open slot in current buffer
	 switch(type) {
	 case EntityStatePDU_Type:
	    xdr_EntityStatePDU(&(exo->xdr_dec), (EntityStatePDU *) &(curr_buf[newest]));
	    break;
	 case FirePDU_Type:
	    xdr_FirePDU(&(exo->xdr_dec), (FirePDU *) &(curr_buf[newest]));
	    break;
	 case DetonationPDU_Type:
	    xdr_DetonationPDU(&(exo->xdr_dec), (DetonationPDU *) &(curr_buf[newest]));
	    break;
	 case CollisionPDU_Type:
	    xdr_CollisionPDU(&(exo->xdr_dec), (CollisionPDU *) &(curr_buf[newest]));
	    break;
	 case ServiceRequestPDU_Type:
	    xdr_ServiceRequestPDU(&(exo->xdr_dec), (ServiceRequestPDU *) &(curr_buf[newest]));
	    break;
	 case ResupplyOfferPDU_Type:
	    xdr_ResupplyOfferPDU(&(exo->xdr_dec), (ResupplyOfferPDU *) &(curr_buf[newest]));
	    break;
	 case ResupplyReceivedPDU_Type:
	    xdr_ResupplyReceivedPDU(&(exo->xdr_dec), (ResupplyReceivedPDU *) &(curr_buf[newest]));
	    break;
	 case ResupplyCancelPDU_Type:
	    xdr_ResupplyCancelPDU(&(exo->xdr_dec), (ResupplyCancelPDU *) &(curr_buf[newest]));
	    break;
	 case RepairCompletePDU_Type:
	    xdr_RepairCompletePDU(&(exo->xdr_dec), (RepairCompletePDU *) &(curr_buf[newest]));
	    break;
	 case RepairResponsePDU_Type:
	    xdr_RepairResponsePDU(&(exo->xdr_dec), (RepairResponsePDU *) &(curr_buf[newest]));
	    break;
	 case CreateEntityPDU_Type:
	    xdr_CreateEntityPDU(&(exo->xdr_dec), (CreateEntityPDU *) &(curr_buf[newest]));
	    break;
	 case RemoveEntityPDU_Type:
	    xdr_RemoveEntityPDU(&(exo->xdr_dec), (RemoveEntityPDU *) &(curr_buf[newest]));
	    break;
	 case StartResumePDU_Type:
	    xdr_StartResumePDU(&(exo->xdr_dec), (StartResumePDU *) &(curr_buf[newest]));
	    break;
	 case StopFreezePDU_Type:
	    xdr_StopFreezePDU(&(exo->xdr_dec), (StopFreezePDU *) &(curr_buf[newest]));
	    break;
	 case AcknowledgePDU_Type:
	    xdr_AcknowledgePDU(&(exo->xdr_dec), (AcknowledgePDU *) &(curr_buf[newest]));
	    break;
	 case ActionRequestPDU_Type:
	    xdr_ActionRequestPDU(&(exo->xdr_dec), (ActionRequestPDU *) &(curr_buf[newest]));
	    break;
	 case ActionResponsePDU_Type:
	    xdr_ActionResponsePDU(&(exo->xdr_dec), (ActionResponsePDU *) &(curr_buf[newest]));
	    break;
	 case DataQueryPDU_Type:
	    xdr_DataQueryPDU(&(exo->xdr_dec), (DataQueryPDU *) &(curr_buf[newest]));
	    break;
	 case SetDataPDU_Type:
	    xdr_SetDataPDU(&(exo->xdr_dec), (SetDataPDU *) &(curr_buf[newest]));
	    break;
	 case DataPDU_Type:
	    xdr_DataPDU(&(exo->xdr_dec), (DataPDU *) &(curr_buf[newest]));
	    break;
	 case EventReportPDU_Type:
	    xdr_EventReportPDU(&(exo->xdr_dec), (EventReportPDU *) &(curr_buf[newest]));
	    break;
	 case CommentPDU_Type:
	    xdr_CommentPDU(&(exo->xdr_dec), (CommentPDU *) &(curr_buf[newest]));
	    break;
	 case EmissionPDU_Type:
	    xdr_EmissionPDU(&(exo->xdr_dec), (EmissionPDU *) &(curr_buf[newest]));
	    break;
	 case DesignatorPDU_Type:
	    xdr_DesignatorPDU(&(exo->xdr_dec), (DesignatorPDU *) &(curr_buf[newest]));
	    break;
	 case TransmitterPDU_Type:
	    xdr_TransmitterPDU(&(exo->xdr_dec), (TransmitterPDU *) &(curr_buf[newest]));
	    break;
	 case SignalPDU_Type:
	    xdr_SignalPDU(&(exo->xdr_dec), (SignalPDU *) &(curr_buf[newest]));
	    break;
	 case ReceiverPDU_Type:
	    xdr_ReceiverPDU(&(exo->xdr_dec), (ReceiverPDU *) &(curr_buf[newest]));
	    break;
	 default:
	    printf("PDU not found in decoding case...\n");
	 }

#ifdef DEBUG2
         printPDU((char *) &(curr_buf[newest]));
         fflush(stdout);
#endif
#ifdef DEBUG2
         j++;
         printf("%d:oldest,newest = %d,%d\n", j, oldest, newest);
         fflush(stdout);
#endif

         // Save buffer state in case swap occurs
         if (exo->PDUarena_ptr->current_net_buf == BUF1) {
            exo->PDUarena_ptr->buf1_oldest = oldest;
            exo->PDUarena_ptr->buf1_newest = newest;
         } else {
            // BUF2
            exo->PDUarena_ptr->buf2_oldest = oldest;
            exo->PDUarena_ptr->buf2_newest = newest;
         }

         //   Update oldest and newest node values of circular buffer for next
         //   packet
         newest++;
         if (!circled) {	// first pass through buf is the special case
            if (exo->PDUarena_ptr->current_net_buf == BUF1) {
               exo->PDUarena_ptr->nodes_in_buf1++;
            } else {
               // BUF2
               exo->PDUarena_ptr->nodes_in_buf2++;
            }
            if (newest > buf_dimension) { // back to beginning
               newest = 0, oldest = 1;
               circled = TRUE;
            }
         } else {	// buf is full; all but first pass
            oldest = newest + 1;	// chasing our tail now
            if (oldest > buf_dimension)
               oldest = 0;
            if (newest > buf_dimension)
               newest = 0, oldest = 1;
            // track overwritten PDUs
            if (exo->PDUarena_ptr->current_net_buf == BUF1) {
               exo->PDUarena_ptr->buf1_wasted++;
            } else {
               exo->PDUarena_ptr->buf2_wasted++;
            }
         }

#ifdef DEBUG2
         if (exo->PDUarena_ptr->current_net_buf == BUF1)
            printf("nodes_in_buf1 = %d\n", exo->PDUarena_ptr->nodes_in_buf1);
         else
            printf("nodes_in_buf2 = %d\n", exo->PDUarena_ptr->nodes_in_buf2);
         fflush(stdout);
#endif
      } // end processing of single packet
      exo->unlock(exo->PDUarena_ptr->swap_buf_sema); // release semaphore

   } // end while(TRUE)

} // receiver_process()


/************************************************************************/
/*									*/
/* Nom: swap_net_buffers						*/
/*									*/
/* Role: Bascule sur les buffers lecture/ecriture			*/
/*									*/
/************************************************************************/

void
DisExercise::swap_net_buffers()
{
   // Simply switch current buffer var
   if (lock(PDUarena_ptr->swap_buf_sema) == TRUE)
   { // acquire semaphore
#ifdef DEBUG2
      printf("Swapping buffers\n");
      fflush(stdout);
#endif
      if (PDUarena_ptr->current_net_buf == BUF1) {
         // switch to buf2
         PDUarena_ptr->current_net_buf = BUF2;
      }
      else
      {
         // switch to buf1
         PDUarena_ptr->current_net_buf = BUF1;
      }
      PDUarena_ptr->swap_buf_flag = TRUE;
   }
   unlock(PDUarena_ptr->swap_buf_sema); // release semaphore
}


/************************************************************************/
/*									*/
/* Nom: read								*/
/*									*/
/* Role: Lecture 							*/
/*       Return pointer to oldest currently available PDU; fill rstat	*/
/*       with status on individual PDU and buffer state; request buffer	*/
/*       swap when buffer is emptied or for other reasons.		*/
/*									*/
/************************************************************************/

union PDU *
DisExercise::read (struct readstat* rstat)
{
   union PDU	*tmp_ptr;
   PDUHeader	*header;

   // Force buffer swap
   if (rstat->rs_swap_buffers_flag == TRUE)
   {
      swap_net_buffers();
      rstat->rs_swap_buffers_flag = FALSE;
   }

   // Use the buffer not in use by receiver_process()
   if (PDUarena_ptr->current_net_buf == BUF1) {
      // Any PDUs available?
      if (PDUarena_ptr->nodes_in_buf2 == 0) {
         // BUF2 empty
         swap_net_buffers();
         if (PDUarena_ptr->nodes_in_buf1 == 0) {
            // both buffers empty
            return (NULL);
         } else {
            // PDUs available in BUF1
            tmp_ptr = &(PDUarena_ptr->pdu_buf1[PDUarena_ptr->buf1_oldest]);
         }
      } else {
         // PDUs available in BUF2
         tmp_ptr = &(PDUarena_ptr->pdu_buf2[PDUarena_ptr->buf2_oldest]);
      }
   } else { // (PDUarena_ptr->current_net_buf == BUF2)
      // Any PDUs available?
      if (PDUarena_ptr->nodes_in_buf1 == 0) {
         // BUF1 empty
         swap_net_buffers();
         if (PDUarena_ptr->nodes_in_buf2 == 0) {
            // both buffers empty
            return (NULL);
         } else {
            // PDUs available in BUF2
            tmp_ptr = &(PDUarena_ptr->pdu_buf2[PDUarena_ptr->buf2_oldest]);
         }
      } else {
         // PDUs available in BUF1
         tmp_ptr = &(PDUarena_ptr->pdu_buf1[PDUarena_ptr->buf1_oldest]);
      }
   }

   // Now we have a ptr to buffer with nodes; update buffer state
   if (PDUarena_ptr->current_net_buf == BUF1) {
      rstat->rs_wasted = PDUarena_ptr->buf2_wasted;
      PDUarena_ptr->nodes_in_buf2--;
      if (PDUarena_ptr->nodes_in_buf2 == 0) {
         // plan ahead for next net_read()
         swap_net_buffers();
      } else {
         // update buffer state
         PDUarena_ptr->buf2_oldest++;
         if (PDUarena_ptr->buf2_oldest > (pdus_in_buffer-1))
            // circle the buffer
            PDUarena_ptr->buf2_oldest = 0;
      }
   } else { // (PDUarena_ptr->current_net_buf == BUF2)
      rstat->rs_wasted = PDUarena_ptr->buf1_wasted;
      PDUarena_ptr->nodes_in_buf1--;
      if (PDUarena_ptr->nodes_in_buf1 == 0) {
         // plan ahead for next net_read()
         swap_net_buffers();
      } else {
         // update buffer state
         PDUarena_ptr->buf1_oldest++;
         if (PDUarena_ptr->buf1_oldest > (pdus_in_buffer-1))
            // circle the buffer
            PDUarena_ptr->buf1_oldest = 0;
      }
   }
   
   // Fill read status structure
   header = (PDUHeader *) tmp_ptr;
   rstat->rs_type = header->type;

   return (tmp_ptr);
}


/************************************************************************/
/*									*/
/* Nom: write								*/
/*									*/
/* Role: Ecriture 							*/
/*									*/
/************************************************************************/

int
DisExercise::write(char *pdu, PDUType type)
{
   int				length, bytes_sent;
   PDUHeader			*header;
   EntityStatePDU		*ESpdu;
   DetonationPDU		*Dpdu;
   ServiceRequestPDU		*SRpdu;
   ResupplyOfferPDU		*ROpdu;
   ResupplyReceivedPDU		*RRpdu;

   // XDRification
   // XDR stream encoding position set @ 0
   xdr_setpos(&xdr_enc, 0);
   xdr_PDUType(&xdr_enc, &type);

   // Fill in header data
   header = (PDUHeader *) pdu;
   header->protocol_version = IEEE_1278_1_1995;
   header->exercise_ident = exerciseId;
   header->type = type;

   // calculate length
   switch (type) {

   case (EntityStatePDU_Type):
      header->family = Family_InformationInteraction;
      ESpdu = (EntityStatePDU *) pdu;
      length = sizeof(EntityStatePDU);	// max
      length -= (sizeof(ArticulatParams) * MAX_ARTICULAT_PARAMS); // base
      length += (sizeof(ArticulatParams) * ESpdu->num_articulat_params);
      if (length > sizeof(PDU))
	 length = sizeof(PDU);
      header->length = length;
      header->time_stamp = (unsigned int) getDisTime();
      xdr_EntityStatePDU(&xdr_enc, (EntityStatePDU *)pdu);
      length = xdr_getpos(&xdr_enc);
      break;

   case (FirePDU_Type):
      header->family = Family_Warfare;
      length = sizeof(FirePDU);
      if (length > sizeof(PDU))
	 length = sizeof(PDU);
      header->length = length;
      header->time_stamp = (unsigned int) getDisTime();
      xdr_FirePDU(&xdr_enc, (FirePDU *)pdu);
      length = xdr_getpos(&xdr_enc);
      break;

   case (DetonationPDU_Type):
      header->family = Family_Warfare;
      Dpdu = (DetonationPDU *) pdu;
      length = sizeof(DetonationPDU);	// max
      length -= (sizeof(ArticulatParams) * MAX_ARTICULAT_PARAMS); // base
      length += (sizeof(ArticulatParams) * Dpdu->num_articulat_params);
      if (length > sizeof(PDU))
	 length = sizeof(PDU);
      header->length = length;
      header->time_stamp = (unsigned int) getDisTime();
      xdr_DetonationPDU(&xdr_enc, (DetonationPDU *)pdu);
      length = xdr_getpos(&xdr_enc);
      break;

   case (CollisionPDU_Type):
      header->family = Family_InformationInteraction;
      length = sizeof(CollisionPDU);
      if (length > sizeof(PDU))
	 length = sizeof(PDU);
      header->length = length;
      header->time_stamp = (unsigned int) getDisTime();
      xdr_CollisionPDU(&xdr_enc, (CollisionPDU *)pdu);
      length = xdr_getpos(&xdr_enc);
      break;

   case (ServiceRequestPDU_Type):
      header->family = Family_Logistics;
      SRpdu = (ServiceRequestPDU *) pdu;
      length = sizeof(ServiceRequestPDU);	// max
      length -= (sizeof(SupplyQuantity) * MAX_SUPPLY_QTY); // base
      length += (sizeof(SupplyQuantity) * SRpdu->num_supply_types);
      if (length > sizeof(PDU))
	 length = sizeof(PDU);
      header->length = length;
      header->time_stamp = (unsigned int) getDisTime();
      xdr_ServiceRequestPDU(&xdr_enc, (ServiceRequestPDU *)pdu);
      length = xdr_getpos(&xdr_enc);
      break;

   case (ResupplyOfferPDU_Type):
      header->family = Family_Logistics;
      ROpdu = (ResupplyOfferPDU *) pdu;
      length = sizeof(ResupplyOfferPDU);	// max
      length -= (sizeof(SupplyQuantity) * MAX_SUPPLY_QTY); // base
      length += (sizeof(SupplyQuantity) * ROpdu->num_supply_types);
      if (length > sizeof(PDU))
	 length = sizeof(PDU);
      header->length = length;
      header->time_stamp = (unsigned int) getDisTime();
      xdr_ResupplyOfferPDU(&xdr_enc, (ResupplyOfferPDU *)pdu);
      length = xdr_getpos(&xdr_enc);
      break;

   case (ResupplyReceivedPDU_Type):
      header->family = Family_Logistics;
      RRpdu = (ResupplyReceivedPDU *) pdu;
      length = sizeof(ResupplyReceivedPDU);	// max
      length -= (sizeof(SupplyQuantity) * MAX_SUPPLY_QTY); // base
      length += (sizeof(SupplyQuantity) * RRpdu->num_supply_types);
      if (length > sizeof(PDU))
	 length = sizeof(PDU);
      header->length = length;
      header->time_stamp = (unsigned int) getDisTime();
      xdr_ResupplyReceivedPDU(&xdr_enc, (ResupplyReceivedPDU *)pdu);
      length = xdr_getpos(&xdr_enc);
      break;

   case (ResupplyCancelPDU_Type):
      header->family = Family_Logistics;
      length = sizeof(ResupplyCancelPDU);
      if (length > sizeof(PDU))
	 length = sizeof(PDU);
      header->length = length;
      header->time_stamp = (unsigned int) getDisTime();
      xdr_ResupplyCancelPDU(&xdr_enc, (ResupplyCancelPDU *)pdu);
      length = xdr_getpos(&xdr_enc);
      break;

   case (RepairCompletePDU_Type):
      header->family = Family_Logistics;
      length = sizeof(RepairCompletePDU);
      if (length > sizeof(PDU))
	 length = sizeof(PDU);
      header->length = length;
      header->time_stamp = (unsigned int) getDisTime();
      xdr_RepairCompletePDU(&xdr_enc, (RepairCompletePDU *)pdu);
      length = xdr_getpos(&xdr_enc);
      break;

   case (RepairResponsePDU_Type):
      header->family = Family_Logistics;
      length = sizeof(RepairResponsePDU);
      if (length > sizeof(PDU))
	 length = sizeof(PDU);
      header->length = length;
      header->time_stamp = (unsigned int) getDisTime();
      xdr_RepairResponsePDU(&xdr_enc, (RepairResponsePDU *)pdu);
      length = xdr_getpos(&xdr_enc);
      break;

   case(CommentPDU_Type):
      header->family = Family_SimulationManagement;
      // Calculate length
      length = sizeof(CommentPDU);	// max
      if (length > sizeof(PDU))
	 length = sizeof(PDU);
      header->length = length;
      header->time_stamp = (unsigned int) getDisTime();
      xdr_CommentPDU(&xdr_enc, (CommentPDU *)pdu);
      length = xdr_getpos(&xdr_enc);
      break;

   case(ActionRequestPDU_Type):
      header->family = Family_SimulationManagement;
      // Calculate length
      length = sizeof(ActionRequestPDU);	// max
      if (length > sizeof(PDU))
	 length = sizeof(PDU);
      header->length = length;
      header->time_stamp = (unsigned int) getDisTime();
      xdr_ActionRequestPDU(&xdr_enc, (ActionRequestPDU *)pdu);
      length = xdr_getpos(&xdr_enc);
      break;

   case(ActionResponsePDU_Type):
      header->family = Family_SimulationManagement;
      // Calculate length
      length = sizeof(ActionResponsePDU);	// max
      if (length > sizeof(PDU))
	 length = sizeof(PDU);
      header->length = length;
      header->time_stamp = (unsigned int) getDisTime();
      xdr_ActionResponsePDU(&xdr_enc, (ActionResponsePDU *)pdu);
      length = xdr_getpos(&xdr_enc);
      break;
   
   case(RemoveEntityPDU_Type):
      header->family = Family_SimulationManagement;
      // Calculate length
      length = sizeof(RemoveEntityPDU);	// max
      if (length > sizeof(PDU))
	 length = sizeof(PDU);
      header->length = length;
      header->time_stamp = (unsigned int) getDisTime();
      xdr_RemoveEntityPDU(&xdr_enc, (RemoveEntityPDU *)pdu);
      length = xdr_getpos(&xdr_enc);
      break;
      
   case(AcknowledgePDU_Type):
      header->family = Family_SimulationManagement;
      // Calculate length
      length = sizeof(AcknowledgePDU);	// max
      if (length > sizeof(PDU))
	 length = sizeof(PDU);
      header->length = length;
      header->time_stamp = (unsigned int) getDisTime();
      xdr_AcknowledgePDU(&xdr_enc, (AcknowledgePDU *)pdu);
      length = xdr_getpos(&xdr_enc);
      break;
      
   default:
      header->family = Family_Other;
      header->time_stamp = (unsigned int) getDisTime();
      length = sizeof(PDU);
      if (length > sizeof(PDU))
	 length = sizeof(PDU);
      header->length = length;
      printf("DisExercise : write(): Invalid PDU Type %d\n", type);
      return (FALSE);
   }

   // Actually send it
   if ((bytes_sent = sendto(sock_send, xdr_enctab, length, 0,
			    (struct sockaddr *) &dest, sizeof(dest))) == -1) {
      perror("DisExercise : sendto()");
      return (FALSE);
   }

   return (TRUE);
}

/************************************************************************/
/*									*/
/* Nom: drainInput							*/
/*									*/
/* Role: Lecture 							*/
/*									*/
/************************************************************************/

int
DisExercise::drainInput ()
{
    PDUHeader		*header;
    int			 time_config;
    struct readstat	 rstat;	// read() status return
    union PDU		*pdu;
    int			 rep = 0;

    /* read new incoming PDUs */

    while ((pdu = read(&rstat)) != NULL)
    {
      header = (PDUHeader *) pdu;

      /* Filter PDUs by version */

      if ( header->protocol_version != IEEE_1278_1_1995 )
        if ( header->protocol_version != 4 )
          continue;

      /* Filter PDUs by exercise */

      if ( header->exercise_ident != exerciseId )
        continue;
    
      /* Get time configuration (absolute or relative) */

      time_config = header->time_stamp % 2;

      /* if relative mode, replace the time stamp with reception time */

      if ( time_config == 0 )
      {
        //BUG, on est toujours en relatif alors que l'on veut absolu=>commente
        //header->time_stamp = (unsigned int) getDisTime();
      }

      switch  (header->type)
      {
	    case EntityStatePDU_Type :
                rep = readEntityStatePDU(pdu);
		break;

	    case CollisionPDU_Type :
		break;

	    case DetonationPDU_Type : 
                rep = readDetonationPDU(pdu);
		break;

	    case FirePDU_Type : 
                rep = readFirePDU(pdu);
		break;

	    case CreateEntityPDU_Type : 
		break;

	    case RemoveEntityPDU_Type : 
                rep = readRemoveEntityPDU(pdu);
		break;

	    case StartResumePDU_Type : 
                rep = readStartResumePDU(pdu);
		break;

	    case StopFreezePDU_Type : 
                rep = readStopFreezePDU(pdu);
		break;

	    case CommentPDU_Type : 
                rep = readCommentPDU(pdu);
		break;

	    case ActionRequestPDU_Type : 
                rep = readActionRequestPDU(pdu);
		break;

	    case ActionResponsePDU_Type : 
                rep = readActionResponsePDU(pdu);
		break;

	    case AcknowledgePDU_Type : 
		break;

	    case SetDataPDU_Type : 
		break;

	    case DataQueryPDU_Type : 
		break;

	    case DataPDU_Type : 
		break;

	    case EventReportPDU_Type : 
		break;

	    case ServiceRequestPDU_Type :
		break;

	    case ResupplyOfferPDU_Type :
		break;

	    case ResupplyReceivedPDU_Type :
		break;

	    case ResupplyCancelPDU_Type :
		break;

	    case RepairCompletePDU_Type :
		break;

	    case RepairResponsePDU_Type :
		break;

	    case EmissionPDU_Type :
		break;

	    case DesignatorPDU_Type :
		break;

	    case TransmitterPDU_Type :
		break;

	    case ReceiverPDU_Type :
		break;

	    case SignalPDU_Type :
		break;

	    case OtherPDU_Type :
		break;

	    default:
		break;
      }
    }

    if (remoteEntities)
      remoteEntities->checkTimeOutAllEntities();

    return (rep);
};


/************************************************************************/
/*									*/
/* Nom: readDetonationPDU						*/
/*									*/
/* Role: Traitement a reception d'un PDU Detonation 			*/
/*									*/
/************************************************************************/

int
DisExercise::readDetonationPDU (union PDU *pdu)
{
    int			 status = 0;

    if (detonationCB) (*detonationCB)((DetonationPDU*) pdu);

    return (status);
}


/************************************************************************/
/*									*/
/* Nom: readFirePDU							*/
/*									*/
/* Role: Traitement a reception d'un PDU Fire	 			*/
/*									*/
/************************************************************************/

int
DisExercise::readFirePDU (union PDU *pdu)
{
    int			 status = 0;

    if (fireCB) (*fireCB)((FirePDU*) pdu);

    return (status);
}


/************************************************************************/
/*									*/
/* Nom: readStartResumePDU						*/
/*									*/
/* Role: Traitement a reception d'un PDU Start	 			*/
/*									*/
/************************************************************************/

int
DisExercise::readStartResumePDU (union PDU *pdu)
{
    int			 status = 0;

    if (startCB) (*startCB)((StartResumePDU*) pdu);

    return (status);
}


/************************************************************************/
/*									*/
/* Nom: readStopFreezePDU						*/
/*									*/
/* Role: Traitement a reception d'un PDU Stop	 			*/
/*									*/
/************************************************************************/

int
DisExercise::readStopFreezePDU (union PDU *pdu)
{
    int			 status = 0;

    if (stopCB) (*stopCB)((StopFreezePDU*) pdu);

    return (status);
}


/************************************************************************/
/*									*/
/* Nom: readCommentPDU							*/
/*									*/
/* Role: Traitement a reception d'un PDU Comment 			*/
/*									*/
/************************************************************************/

int
DisExercise::readCommentPDU (union PDU *pdu)
{
    int			 status = 0;

    if (commentCB) (*commentCB)((CommentPDU*) pdu);

    return (status);
}


/************************************************************************/
/*									*/
/* Nom: readActionRequestPDU						*/
/*									*/
/* Role: Traitement a reception d'un PDU ActionRequest 			*/
/*									*/
/************************************************************************/

int
DisExercise::readActionRequestPDU (union PDU *pdu)
{
    int			 status = 0;

    if (actionRequestCB) (*actionRequestCB)((ActionRequestPDU*) pdu);

    return (status);
}


/************************************************************************/
/*									*/
/* Nom: readActionResponsePDU						*/
/*									*/
/* Role: Traitement a reception d'un PDU ActionResponse 		*/
/*									*/
/************************************************************************/

int
DisExercise::readActionResponsePDU (union PDU *pdu)
{
    int			 status = 0;

    if (actionResponseCB) (*actionResponseCB)((ActionResponsePDU*) pdu);

    return (status);
}


/************************************************************************/
/*									*/
/* Nom: readRemoveEntityPDU						*/
/*									*/
/* Role: Traitement a reception d'un PDU RemoveEntity	 		*/
/*									*/
/************************************************************************/

int
DisExercise::readRemoveEntityPDU (union PDU *pdu)
{
    int			 status = 0;

    if (removeEntityCB) (*removeEntityCB)((RemoveEntityPDU*) pdu);

    return (status);
}


/************************************************************************/
/*									*/
/* Nom: readEntityStatePDU						*/
/*									*/
/* Role: Traitement a reception d'un PDU Entity State 			*/
/*									*/
/************************************************************************/

int
DisExercise::readEntityStatePDU (union PDU *pdu)
{
    int			 status = 0;
    int			 found = 0;
    EntityStatePDU	*ESpdu;
    DisRemoteEntity	*entity;
    DisLocalEntity	*ent;

    ESpdu = (EntityStatePDU*) pdu;

    /* Scan DisRemoteEntities and updates */

    if (remoteEntities)
      entity = remoteEntities->first();
    else
      entity = 0;

    while (entity)
    {
      if ( (entity->getID().address.site == ESpdu->entity_id.address.site) &&
           (entity->getID().address.host == ESpdu->entity_id.address.host) &&
           (entity->getID().entity == ESpdu->entity_id.entity) )
      {
        /* If the deactivated bit of the PDU is set to 1 */
        /* call removeAndDelete                          */

        if ( (ESpdu->entity_appearance & Appearance_Deactivated) == Appearance_Deactivated )
        {
          remoteEntities->removeAndDelete(entity);
          return (status);
        }
        else
        {
          entity->update(ESpdu);
          entity = 0;
          found = 1;
        }
      }
      else
        entity = entity->next();
    }

    /* If new, create and call entityAdded */

    if ((found == 0) && (remoteEntities))
    {
      entity = new DisRemoteEntity (remoteEntities, ESpdu);
      remoteEntities->entityAdded(entity);
    }

    /* Call associated callback if exists */

    if (entityStateCB) (*entityStateCB) (ESpdu);

    /* Scan DisLocalEntities and call associated callback if exists */

    ent = localEntities->first();
    while (ent)
    {
      if ( (ent->getID().address.site == ESpdu->entity_id.address.site) &&
           (ent->getID().address.host == ESpdu->entity_id.address.host) &&
           (ent->getID().entity == ESpdu->entity_id.entity) )
      {
        if (ent->entityStateCB)
        {
          (*(ent->entityStateCB)) (ESpdu);
        }
        ent = 0;
      }
      else
        ent = ent->next();
    }

    return (status);
};


/************************************************************************/
/*									*/
/* Nom: sendStartPDU							*/
/*									*/
/* Role: Envoie d'un PDU Start a tout le monde	 			*/
/*									*/
/************************************************************************/

int
DisExercise::sendStartPDU (unsigned short sender)
{
   int				 length, bytes_sent;
   StartResumePDU		*pdu;
   PDUType type = StartResumePDU_Type;
      
   pdu = (StartResumePDU*) new StartResumePDU;

   // Fill in header data
   pdu->start_resume_header.protocol_version = IEEE_1278_1_1995;
   pdu->start_resume_header.exercise_ident = exerciseId;
   pdu->start_resume_header.type = type;
   pdu->start_resume_header.family = Family_SimulationManagement;

   // Calculate length
   length = sizeof(StartResumePDU);	// max

   // Time stamping
   pdu->start_resume_header.time_stamp = (unsigned int) getDisTime();

   if (length > sizeof(PDU))
      length = sizeof(PDU);
   pdu->start_resume_header.length = length;

   // Fill in other things
   pdu->originating_entity.address.site = siteId;
   pdu->originating_entity.address.host = applicationNumber;
   pdu->originating_entity.entity = sender;

   pdu->receiving_entity.address.site = EVERYBODY_ID;
   pdu->receiving_entity.address.host = EVERYBODY_ID;
   pdu->receiving_entity.entity = EVERYBODY_ID;

   pdu->real_world_time.hour = 0;
   pdu->real_world_time.time_past_hour = 0;

   pdu->simulation_time.hour = 0;
   pdu->simulation_time.time_past_hour = 0;

   pdu->request_id = nextRequestNumber++;

   // Actually send it
   // XDR stream encoding position set @ 0
   xdr_setpos(&xdr_enc, 0);
   xdr_PDUType(&xdr_enc, &type);
   xdr_StartResumePDU(&xdr_enc, pdu);
   length = xdr_getpos(&xdr_enc);
   if ((bytes_sent = sendto(sock_send, xdr_enctab, length, 0,
                             (struct sockaddr *) &dest, sizeof(dest))) == -1)
   {
      perror("DisExercise : sendto()");
      return (FALSE);
   }

   return (TRUE);
}


/************************************************************************/
/*									*/
/* Nom: sendStopPDU							*/
/*									*/
/* Role: Envoie d'un PDU Stop a tout le monde	 			*/
/*									*/
/************************************************************************/

int
DisExercise::sendStopPDU (unsigned short sender)
{
   int				 length, bytes_sent;
   StopFreezePDU		*pdu;
   PDUType type = StopFreezePDU_Type;
   
   pdu = (StopFreezePDU*) new StopFreezePDU;

   // Fill in header data
   pdu->stop_freeze_header.protocol_version = IEEE_1278_1_1995;
   pdu->stop_freeze_header.exercise_ident = exerciseId;
   pdu->stop_freeze_header.type = type;
   pdu->stop_freeze_header.family = Family_SimulationManagement;

   // Calculate length
   length = sizeof(StopFreezePDU);	// max
   if (length > sizeof(PDU))
      length = sizeof(PDU);
   pdu->stop_freeze_header.length = length;

   // Fill in other things
   pdu->originating_entity.address.site = siteId;
   pdu->originating_entity.address.host = applicationNumber;
   pdu->originating_entity.entity = sender;

   pdu->receiving_entity.address.site = EVERYBODY_ID;
   pdu->receiving_entity.address.host = EVERYBODY_ID;
   pdu->receiving_entity.entity = EVERYBODY_ID;

   pdu->real_world_time.hour = 0;
   pdu->real_world_time.time_past_hour = 0;

   pdu->stop_reason = StopReason_Recess;
   pdu->frozen_behavior = Behavior_RunInternalClock;
   pdu->request_id = nextRequestNumber++;

   // Time stamping
   pdu->stop_freeze_header.time_stamp = (unsigned int) getDisTime();

   // Actually send it
   // XDR stream encoding position set @ 0
   xdr_setpos(&xdr_enc, 0);
   xdr_PDUType(&xdr_enc, &type);
   xdr_StopFreezePDU(&xdr_enc, pdu);
   length = xdr_getpos(&xdr_enc);
   if ((bytes_sent = sendto(sock_send, xdr_enctab, length, 0,
                             (struct sockaddr *) &dest, sizeof(dest))) == -1)
   {
      perror("DisExercise : sendto()");
      return (FALSE);
   }
   return (TRUE);
}


/************************************************************************/
/*									*/
/* Nom: sendEndPDU							*/
/*									*/
/* Role: Envoie d'un PDU Stop/End a tout le monde 			*/
/*									*/
/************************************************************************/

int
DisExercise::sendEndPDU (unsigned short sender)
{
   int				 length, bytes_sent;
   StopFreezePDU		*pdu;
   PDUType type = StopFreezePDU_Type;
   
   pdu = (StopFreezePDU*) new StopFreezePDU;

   // Fill in header data
   pdu->stop_freeze_header.protocol_version = IEEE_1278_1_1995;
   pdu->stop_freeze_header.exercise_ident = exerciseId;
   pdu->stop_freeze_header.type = type;
   pdu->stop_freeze_header.family = Family_SimulationManagement;

   // Calculate length
   length = sizeof(StopFreezePDU);	// max
   if (length > sizeof(PDU))
      length = sizeof(PDU);
   pdu->stop_freeze_header.length = length;

   // Fill in other things
   pdu->originating_entity.address.site = siteId;
   pdu->originating_entity.address.host = applicationNumber;
   pdu->originating_entity.entity = sender;

   pdu->receiving_entity.address.site = EVERYBODY_ID;
   pdu->receiving_entity.address.host = EVERYBODY_ID;
   pdu->receiving_entity.entity = EVERYBODY_ID;

   pdu->real_world_time.hour = 0;
   pdu->real_world_time.time_past_hour = 0;

   pdu->stop_reason = StopReason_Termination;
   pdu->frozen_behavior = Behavior_RunInternalClock;
   pdu->request_id = nextRequestNumber++;

   // Time stamping
   pdu->stop_freeze_header.time_stamp = (unsigned int) getDisTime();

   // Actually send it
   // XDR stream encoding position set @ 0
   xdr_setpos(&xdr_enc, 0);
   xdr_PDUType(&xdr_enc, &type);
   xdr_StopFreezePDU(&xdr_enc, pdu);
   length = xdr_getpos(&xdr_enc);
   if ((bytes_sent = sendto(sock_send, xdr_enctab, length, 0,
                             (struct sockaddr *) &dest, sizeof(dest))) == -1)
   {
      perror("DisExercise : sendto()");
      return (FALSE);
   }

   return (TRUE);
}

/************************************************************************/
/*									*/
/* Nom: sendCommentPDU							*/
/*									*/
/* Role: Envoie d'un PDU Comment a tout le monde 			*/
/*									*/
/************************************************************************/

int
DisExercise::sendCommentPDU (unsigned short sender, char * message)
{
   CommentPDU			*pdu;

   pdu = (CommentPDU*) new CommentPDU;

   // Fill in things
   pdu->originating_entity.address.site = siteId;
   pdu->originating_entity.address.host = applicationNumber;
   pdu->originating_entity.entity = sender;

   pdu->receiving_entity.address.site = EVERYBODY_ID;
   pdu->receiving_entity.address.host = EVERYBODY_ID;
   pdu->receiving_entity.entity = EVERYBODY_ID;

   pdu->num_variable_datum = 1;

   for (int i = 0; i < 127; i++)
     pdu->comment[i] = message[i];
   pdu->comment[127] = '\n';

   return (write((char *)pdu, CommentPDU_Type));
}


/************************************************************************/
/*									*/
/* Nom: sendActionRequestPDU						*/
/*									*/
/* Role: Envoie d'un PDU ActionRequest		 			*/
/*									*/
/************************************************************************/

int
DisExercise::sendActionRequestPDU (unsigned short sender, unsigned short receiver_host, unsigned short receiver_id, unsigned int speed)
{
   ActionRequestPDU		*pdu;

   pdu = (ActionRequestPDU*) new ActionRequestPDU;

   // Fill in things
   pdu->originating_entity.address.site = siteId;
   pdu->originating_entity.address.host = applicationNumber;
   pdu->originating_entity.entity = sender;

   pdu->receiving_entity.address.site = EVERYBODY_ID;
   pdu->receiving_entity.address.host = receiver_host;
   pdu->receiving_entity.entity = receiver_id;

   pdu->request_id = nextRequestNumber++;
   pdu->action_id = speed;
   pdu->num_fixed_datum = 0;
   pdu->num_variable_datum = 0;

   return (write((char *)pdu, ActionRequestPDU_Type));
}


/************************************************************************/
/*									*/
/* Nom: sendActionResponsePDU						*/
/*									*/
/* Role: Envoie d'un PDU ActionResponse		 			*/
/*									*/
/************************************************************************/

int
DisExercise::sendActionResponsePDU (unsigned short sender, unsigned short receiver_host, unsigned short receiver_id)
{
   ActionResponsePDU		*pdu;

   pdu = (ActionResponsePDU*) new ActionResponsePDU;

   // Fill in things
   pdu->originating_entity.address.site = siteId;
   pdu->originating_entity.address.host = applicationNumber;
   pdu->originating_entity.entity = sender;

   pdu->receiving_entity.address.site = EVERYBODY_ID;
   pdu->receiving_entity.address.host = receiver_host;
   pdu->receiving_entity.entity = receiver_id;

   pdu->request_id = nextRequestNumber++;
   pdu->request_status = ActionReqStat_Complete;
   pdu->num_fixed_datum = 0;
   pdu->num_variable_datum = 0;

   return (write((char *)pdu, ActionResponsePDU_Type));
}


/************************************************************************/
/*									*/
/* Nom: sendRemoveEntityPDU						*/
/*									*/
/* Role: Envoie d'un PDU RemoveEntity		 			*/
/*									*/
/************************************************************************/

int
DisExercise::sendRemoveEntityPDU (unsigned short sender, unsigned short receiver_host, unsigned short receiver_id)
{
   RemoveEntityPDU		*pdu;

   pdu = (RemoveEntityPDU*) new RemoveEntityPDU;

   // Fill in other things
   pdu->originating_entity.address.site = siteId;
   pdu->originating_entity.address.host = applicationNumber;
   pdu->originating_entity.entity = sender;

   pdu->receiving_entity.address.site = EVERYBODY_ID;
   pdu->receiving_entity.address.host = receiver_host;
   pdu->receiving_entity.entity = receiver_id;

   pdu->request_id = nextRequestNumber++;

   return (write((char *)pdu, RemoveEntityPDU_Type));
}


/************************************************************************/
/*									*/
/* Nom: sendAcknowledgePDU						*/
/*									*/
/* Role: Envoie d'un PDU Acknowledge		 			*/
/*									*/
/************************************************************************/

int
DisExercise::sendAcknowledgePDU (EntityID sender, EntityID receiver, AcknowledgeFlag flag)
{
   AcknowledgePDU		*pdu;

   pdu = (AcknowledgePDU*) new AcknowledgePDU;

   // Fill in things
   pdu->originating_entity.address.site = sender.address.site;
   pdu->originating_entity.address.host = sender.address.host;
   pdu->originating_entity.entity = sender.entity;

   pdu->receiving_entity.address.site = receiver.address.site;
   pdu->receiving_entity.address.host = receiver.address.host;
   pdu->receiving_entity.entity = receiver.entity;

   pdu->acknowledge_flag = flag;

   pdu->response_flag = AckRes_Able;

   pdu->request_id = nextRequestNumber++;

   return (write((char *)pdu, AcknowledgePDU_Type));
}


/************************************************************************/
/*									*/
/* Nom: sendFirePDU							*/
/*									*/
/* Role: Envoie d'un PDU Fire			 			*/
/*									*/
/************************************************************************/

int
DisExercise::sendFirePDU (EntityID attacker, EntityID target, EntityID munition, EventID eventId, BurstDescriptor burst, EntityLocation location, float linVelocity[3], float range)
{
   FirePDU		*pdu;

   pdu = (FirePDU*) new FirePDU;

   // Fill in other things
   pdu->firing_entity_id.address.site = attacker.address.site;
   pdu->firing_entity_id.address.host = attacker.address.host;
   pdu->firing_entity_id.entity = attacker.entity;

   pdu->target_entity_id.address.site = target.address.site;
   pdu->target_entity_id.address.host = target.address.host;
   pdu->target_entity_id.entity = target.entity;

   pdu->munition_id.address.site = munition.address.site;
   pdu->munition_id.address.host = munition.address.host;
   pdu->munition_id.entity = munition.entity;

   pdu->event_id.address.site = eventId.address.site;
   pdu->event_id.address.host = eventId.address.host;
   pdu->event_id.event = eventId.event;

   pdu->location_in_world.x = location.x;
   pdu->location_in_world.y = location.y;
   pdu->location_in_world.z = location.z;

   pdu->burst_descriptor.munition.entity_kind = burst.munition.entity_kind;
   pdu->burst_descriptor.munition.domain = burst.munition.domain;
   pdu->burst_descriptor.munition.country = burst.munition.country;
   pdu->burst_descriptor.munition.category = burst.munition.category;
   pdu->burst_descriptor.munition.subcategory = burst.munition.subcategory;
   pdu->burst_descriptor.munition.specific = burst.munition.specific;
   pdu->burst_descriptor.munition.extra = burst.munition.extra;
   pdu->burst_descriptor.warhead = burst.warhead;
   pdu->burst_descriptor.fuze = burst.fuze;
   pdu->burst_descriptor.quantity = burst.quantity;
   pdu->burst_descriptor.rate = burst.rate;

   pdu->velocity.x = linVelocity[0];
   pdu->velocity.y = linVelocity[1];
   pdu->velocity.z = linVelocity[2];

   pdu->range = range;

   return (write((char *)pdu, FirePDU_Type));
}


/************************************************************************/
/*									*/
/* Nom: sendDetonationPDU						*/
/*									*/
/* Role: Envoie d'un PDU Detonation		 			*/
/*									*/
/************************************************************************/

int
DisExercise::sendDetonationPDU (EntityID attacker, EntityID target, EntityID munition, EventID eventId, BurstDescriptor burst, EntityLocation location, VelocityVector linVelocity, EntityRelativeLoc location_in_entity, DetonationResult detonation_result)
{
   DetonationPDU	*pdu;

   pdu = (DetonationPDU*) new DetonationPDU;

   // Fill in other things
   pdu->firing_entity_id.address.site = attacker.address.site;
   pdu->firing_entity_id.address.host = attacker.address.host;
   pdu->firing_entity_id.entity = attacker.entity;

   pdu->target_entity_id.address.site = target.address.site;
   pdu->target_entity_id.address.host = target.address.host;
   pdu->target_entity_id.entity = target.entity;

   pdu->munition_id.address.site = munition.address.site;
   pdu->munition_id.address.host = munition.address.host;
   pdu->munition_id.entity = munition.entity;

   pdu->event_id.address.site = eventId.address.site;
   pdu->event_id.address.host = eventId.address.host;
   pdu->event_id.event = eventId.event;

   pdu->velocity.x = linVelocity.x;
   pdu->velocity.y = linVelocity.y;
   pdu->velocity.z = linVelocity.z;

   pdu->location_in_world.x = location.x;
   pdu->location_in_world.y = location.y;
   pdu->location_in_world.z = location.z;

   pdu->burst_descriptor.munition.entity_kind = burst.munition.entity_kind;
   pdu->burst_descriptor.munition.domain = burst.munition.domain;
   pdu->burst_descriptor.munition.country = burst.munition.country;
   pdu->burst_descriptor.munition.category = burst.munition.category;
   pdu->burst_descriptor.munition.subcategory = burst.munition.subcategory;
   pdu->burst_descriptor.munition.specific = burst.munition.specific;
   pdu->burst_descriptor.munition.extra = burst.munition.extra;
   pdu->burst_descriptor.warhead = burst.warhead;
   pdu->burst_descriptor.fuze = burst.fuze;
   pdu->burst_descriptor.quantity = burst.quantity;
   pdu->burst_descriptor.rate = burst.rate;

   pdu->location_in_entity.x = location_in_entity.x;
   pdu->location_in_entity.y = location_in_entity.y;
   pdu->location_in_entity.z = location_in_entity.z;

   pdu->detonation_result = detonation_result;

   pdu->num_articulat_params = 0;

   return (write((char *)pdu, DetonationPDU_Type));
}


/************/
/* The End. */
/************/

