static char analysesccsid[] = " @(#) analyse.cc 1.4 97/11/21  - Copyright (c) DE 1997 ";
/************************************************************************/
/*									*/
/*   Ce programme est un produit de la societe DASSAULT ELECTRONIQUE,	*/
/* protege par les lois sur le droit d'auteur et sur le copyright et	*/
/* transmis en licence dans les conditions et termes specifiques	*/
/* indiques dans l'accord de licence qui l'accompagne. DASSAULT		*/
/* ELECTRONIQUE garde la propriete du programme et toutes les 		*/
/* prerogatives qui l'accompagnent. Ce programme ne peut etre modifie	*/
/* en aucune maniere sans l'autorisation ecrite prealable de DASSAULT	*/
/* ELECTRONIQUE.							*/
/*									*/
/* Nom: analyse.cc							*/
/*									*/
/* Version: 1.4								*/
/*									*/
/* Historique:								*/
/*	Auteur: D.DULAC							*/
/*	Date: 97/11/21							*/
/*	Creation: 97/05/14						*/
/*									*/
/************************************************************************/

/***********/
/* INCLUDE */
/***********/

#include "AnaAnalyse.h"

/***********/
/* GLOBALE */
/***********/

int disPort = 3002;
int exerciseId = 1;
int siteId = 1;
int applicationId = 4;

char* VERSION_ANALYSE = "Version 1.4";
char* INTERF_ANALYSE;
char* ADRESSE_ANALYSE;


static void ILVCALLBACK
Quit (IlvView* top, IlvAny)
{
  ((AnaAnalyse*) top)->quit (((AnaAnalyse*) top)->getport());
}


main(int argc, char* argv[])
{

    INTERF_ANALYSE = 0;
    ADRESSE_ANALYSE = 0;

    int c;
    while ((c = getopt(argc, argv, "P:E:S:A:F:M:h:H")) != -1) {
	switch (c) {
	  case 'P':
	    disPort = atoi(optarg);
	    break;
	  case 'E':
	    exerciseId = atoi(optarg);
	    break;
	  case 'S':
	    siteId = atoi(optarg);
	    break;
	  case 'A':
	    applicationId = atoi(optarg);
	    break;
	  case 'F':
	    INTERF_ANALYSE = new char[strlen (optarg) + 1];
            strcpy (INTERF_ANALYSE, optarg);
	    break;
	  case 'M':
	    ADRESSE_ANALYSE = new char[strlen (optarg) + 1];
            strcpy (ADRESSE_ANALYSE, optarg);
	    break;
	  case 'h':
	  case 'H':
	  default:
	    fprintf(stderr, "usage:	analyse [-P port] [-E exercice id] [-S site id] [-A application id]\n	[-F interface] [-M adresse multicast]\n");
	    exit(1);
	    break;
	}
    }

    if (INTERF_ANALYSE == 0)
    {
      INTERF_ANALYSE = new char[strlen ("ec0") + 1];
      strcpy (INTERF_ANALYSE, "ec0");
    }

    if (ADRESSE_ANALYSE == 0)
    {
      ADRESSE_ANALYSE = new char[strlen ("224.68.73.83") + 1];
      strcpy (ADRESSE_ANALYSE, "224.68.73.83");
    }

    IlvDisplay* display = new IlvDisplay("SSTH Analyse", 0, argc, argv);
    if (!display || display->isBad()) {
        IlvFatalError("Probleme d'ouverture du display");
        delete display;
        return -1;
    }

    IlvRect taille (50, 50, 825, 700);
    AnaAnalyse* top =
	new AnaAnalyse(display, "SSTH Analyse", "SSTH Analyse", &taille);

    top->setDestroyCallback(Quit, 0);

    top->show();

    IlvMainLoop();

    return 0;

}

