static char anaanalysesccsid[] = " @(#) AnaAnalyse.cc 1.33 97/08/20 - Copyright (c) DE 1997 ";
/************************************************************************/
/*									*/
/*   Ce programme est un produit de la societe DASSAULT ELECTRONIQUE,	*/
/* protege par les lois sur le droit d'auteur et sur le copyright et	*/
/* transmis en licence dans les conditions et termes specifiques	*/
/* indiques dans l'accord de licence qui l'accompagne. DASSAULT		*/
/* ELECTRONIQUE garde la propriete du programme et toutes les 		*/
/* prerogatives qui l'accompagnent. Ce programme ne peut etre modifie	*/
/* en aucune maniere sans l'autorisation ecrite prealable de DASSAULT	*/
/* ELECTRONIQUE.							*/
/*									*/
/* Nom: AnaAnalyse.cc							*/
/*									*/
/* Version: 1.33							*/
/*									*/
/* Historique:								*/
/*	Auteur: D.DULAC							*/
/*	Date: 97/08/20							*/
/*	Creation: 97/04/10						*/
/*									*/
/************************************************************************/

/***********/
/* INCLUDE */
/***********/

#include <stdlib.h>
#include <stream.h>
#include <string.h>

#include <fstream.h>
#include <iostream.h>
#include <time.h>

#include <ilviews/stdialog.h>

#include "AnaFiltre.h"
#include "AnaListe.h"
#include "AnaApropos.h"
#include "AnaEditeur.h"
#include "AnaAnalyse.h"
#include "AnaDicoSite.h"
#include "AnaDicoApp.h"


/**********/
/* EXTERN */
/**********/

extern char* VERSION_ANALYSE;
extern char* INTERF_ANALYSE;
extern char* ADRESSE_ANALYSE;

extern int disPort;
extern int exerciseId;
extern int siteId;
extern int applicationId;


/************************************************************************/
/*									*/
/* Nom: MiseAJour							*/
/*									*/
/* Role: Callback appelee regulierement et mettant a jour le tableau	*/
/*       des PDU DIS recus.						*/
/*									*/
/************************************************************************/

static void ILVCALLBACK
MiseAJour (IlvTimer*, IlvAny arg)
{
  AnaAnalyse*		analyse = (AnaAnalyse*) arg;
  DisExercise*		exercise = analyse->exercise;
  struct readstat	rstat;	// read() status return
  union PDU*		pdu_ptr;
  PDUHeader*		header;

  {
    char		*ptr;
    char		 date[48];
    char		 timec[64];
    FILE		*datum;
    datum = popen("date '+le %d/%m/%y a %H:%M:%S'", "r");
    fgets(date,48,datum);
    if ((ptr = strrchr(date, '\n')) != NULL) *ptr = '\0';
    pclose(datum);

    sprintf(timec, "%c%c:%c%c:%c%c", date[14], date[15], date[17], date[18], date[20], date[21]);
    analyse->getcourant()->setLabel(timec);
    analyse->reDrawObj(analyse->getcourant());
  }

  analyse->temps = analyse->temps + analyse->dt;

  for (int i = 1; i < MAX_NUM_PDUS; i++)
  {
    analyse->pdu[i].initFrequenceInst(analyse->aquiletour);
  }

  while ((pdu_ptr = exercise->read(&rstat)) != NULL)
  {
    header = (PDUHeader *) pdu_ptr;
    analyse->pdu[header->type].miseAJour(header->length, analyse->aquiletour);
    analyse->cptPDU++;
    analyse->volPDU += header->length;

    if (header->type == EntityStatePDU_Type)
    {
      EntityStatePDU*	statePdu = (EntityStatePDU *) pdu_ptr;

      analyse->majListeEntites(statePdu->entity_id);
      analyse->majListeApplications(statePdu->entity_id);
      analyse->majListeSites(statePdu->entity_id);
    }
  }

  analyse->calcTableau();

  analyse->majTableau();

  analyse->majCourbe();

  analyse->reDrawObj(analyse->gettableau());

  if (analyse->aquiletour == ECHANTILLON-1)
    analyse->aquiletour = 0;
  else
    analyse->aquiletour++;
}


/************************************************************************/
/*									*/
/* Nom: AnaAnalyse							*/
/*									*/
/* Role: Constructeur 							*/
/*									*/
/************************************************************************/

AnaAnalyse::AnaAnalyse (IlvDisplay* display, const char* name, const char* title,
	     IlvRect* size, IlvBoolean useAccelerators,
	     IlvBoolean visible)
 : Analyse (display, name, title, size, useAccelerators, visible)
{
  initialize (display);
}

/************************************************************************/
/*									*/
/* Nom: AnaAnalyse							*/
/*									*/
/* Role: Constructeur 							*/
/*									*/
/************************************************************************/

AnaAnalyse::AnaAnalyse(IlvCompositeAbstractView* aview, IlvRect* size)
 : Analyse (aview, size)
{
  initialize (aview->getDisplay());
}


/************************************************************************/
/*									*/
/* Nom: AnaAnalyse							*/
/*									*/
/* Role: Destructeur 							*/
/*									*/
/************************************************************************/

AnaAnalyse::~AnaAnalyse()
{
  delete exercise;
  delete timer;
  //delete courbe1;
}

/************************************************************************/
/*									*/
/* Nom: initialize							*/
/*									*/
/* Role: initialisation dans les constructeurs				*/
/*									*/
/************************************************************************/

void
AnaAnalyse::initialize(IlvDisplay* display)
{
  IlvButton*		button;
  float			timeThreshold;
  float			translationThreshold;
  float			rotationThreshold;
  float			timeOutInterval;
  char			number[8];
  char			path[128];
  int			i;

  // ENVIRONNEMENT

  if (!getenv("SSTH_HOME"))
  {
    static IlvIWarner* warner = 0;
    if (!warner) warner =
      new IlvIWarner (display, "Mettre a jour la variable SSTH_HOME.");
    button = (IlvButton*) warner->getObject("apply");
    if (button) button->setLabel("Fermer");
    warner->setTitle("Probleme d'initialisation");
    warner->moveToMouse();
    warner->get();
    delete display;
    IlvExit(0);
  }

  {
    char		*ptr;
    char		 date[48];
    char		 timec[64];
    FILE		*datum;
    datum = popen("date '+le %d/%m/%y a %H:%M:%S'", "r");
    fgets(date,48,datum);
    if ((ptr = strrchr(date, '\n')) != NULL) *ptr = '\0';
    pclose(datum);

    sprintf(timec, "%c%c:%c%c:%c%c", date[14], date[15], date[17], date[18], date[20], date[21]);
    getinitial()->setLabel(timec);
    getcourant()->setLabel(timec);
  }

  cptPDU = 0;
  freqPDU = 0.0;
  freqInstPDU = 0.0;

  aquiletour = 0;

  IlvLabelMatrixItem* item;

  item = new IlvLabelMatrixItem("Type de PDU");
  gettableau()->set(0, 0, item);
  item = new IlvLabelMatrixItem("Nombre de PDU");
  gettableau()->set(1, 0, item);
  item = new IlvLabelMatrixItem("Pourcentage");
  gettableau()->set(2, 0, item);
  item = new IlvLabelMatrixItem("Frequence (PDU/s)");
  gettableau()->set(3, 0, item);
  item = new IlvLabelMatrixItem("Volume (bits)");
  gettableau()->set(4, 0, item);
  item = new IlvLabelMatrixItem("% de volume");
  gettableau()->set(5, 0, item);
  item = new IlvLabelMatrixItem("Frequence inst.");
  gettableau()->set(6, 0, item);

  gettableau()->setItemRelief(0, 0);
  gettableau()->setItemRelief(1, 0);
  gettableau()->setItemRelief(2, 0);
  gettableau()->setItemRelief(3, 0);
  gettableau()->setItemRelief(4, 0);
  gettableau()->setItemRelief(5, 0);
  gettableau()->setItemRelief(6, 0);

  for (i = 1; i < MAX_NUM_PDUS; i++)
  {
    pdu[i].initialise(PDUName[i]);
    item = new IlvLabelMatrixItem(PDUName[i]);
    gettableau()->set(0, i, item);
    gettableau()->setItemRelief(0, i);
  }

  item = new IlvLabelMatrixItem("Total");
  gettableau()->set(0, MAX_NUM_PDUS, item);

  gettableau()->setItemRelief(0, MAX_NUM_PDUS);
  gettableau()->setItemRelief(1, MAX_NUM_PDUS);
  gettableau()->setItemRelief(2, MAX_NUM_PDUS);
  gettableau()->setItemRelief(3, MAX_NUM_PDUS);
  gettableau()->setItemRelief(4, MAX_NUM_PDUS);
  gettableau()->setItemRelief(5, MAX_NUM_PDUS);
  gettableau()->setItemRelief(6, MAX_NUM_PDUS);

  majTableau();

  setDoubleBuffering(IlvTrue);

  cptSite = 0;
  cptApplication = 0;
  cptEntite = 0;

  // pas de temps en ms

  dt = 100.0;

  // temps passe en ms

  temps = 0.0;

  // DIS

  timeThreshold = 5;
  translationThreshold = 0.1;
  rotationThreshold = 3;
  timeOutInterval = 5;

  IlvPrint("");
  IlvPrint(" Port reseau DIS		: %d", disPort);
  IlvPrint(" Numero d'exercice DIS		: %d", exerciseId);
  IlvPrint(" Numero de site DIS		: %d", siteId);
  IlvPrint(" Numero d'application DIS	: %d", applicationId);
  IlvPrint(" Pas de temps			: %f ms", dt);
  IlvPrint(" Seuil temps			: %f ", timeThreshold);
  IlvPrint(" Seuil trans			: %f ", translationThreshold);
  IlvPrint(" Seuil rot			: %f ", rotationThreshold);
  IlvPrint(" Time out			: %f ", timeOutInterval);
  IlvPrint("");
  IlvPrint(" Interface reseau		: %s ", INTERF_ANALYSE);
  IlvPrint(" Adresse multicast		: %s ", ADRESSE_ANALYSE);
  IlvPrint("");

  sprintf(number, "%d", disPort);
  getport()->setLabel(number);
  sprintf(number, "%d", exerciseId);
  getexercice()->setLabel(number);

  // on cree et initialise les objets DIS : exercise

  exercise = new DisExercise (disPort,exerciseId,siteId,applicationId, INTERF_ANALYSE);

  if (exercise->creationOK() == FALSE)
  {
    static IlvIWarner* warner = 0;
    if (!warner) warner =
      new IlvIWarner (display, "Port DIS deja utilise ?");
    button = (IlvButton*) warner->getObject("apply");
    if (button) button->setLabel("Fermer");
    warner->setTitle("Probleme d'initialisation");
    warner->moveToMouse();
    warner->get();
    delete display;
    IlvExit(0);
  }

  exercise->unfilterPDU();

  exercise->setTimeThreshold(timeThreshold);
  exercise->setTranslationThreshold(translationThreshold);
  exercise->setRotationThreshold(rotationThreshold);

  // on cree la courbe

  courbe1 = new AnaCourbe (display, "Debit instantane ES PDU", "Debit instantane ES PDU");

  // on cree la courbe

  //graphe = new AnaGraphe (display, "Courbe d'analyse", "Courbe d'analyse");
  //graphe->hide();

  // on initialise les dictionnaires

  sprintf(path, "%s/DATA/dicos/sites.dico", getenv ("SSTH_HOME"));
  dicoSites.read(path);

  sprintf(path, "%s/DATA/dicos/applis.dico", getenv ("SSTH_HOME"));
  dicoApps.read(path);

  // on cree le timer pour l'interrogation reguliere du reseau DIS

  timer = new IlvTimer (display, 0, dt, MiseAJour, this);

  // on se met a l'ecoute de DIS

  timer->run();

  // on prend en compte les ajouts en redessinant

  draw();
}



/************************************************************************/
/*									*/
/* Nom: majListeEntites							*/
/*									*/
/* Role: mise a jour de la liste des entites de l'exercice analyse	*/
/*									*/
/************************************************************************/

void
AnaAnalyse::majListeEntites(EntityID entityId)
{
  int	trouve = 0;

  for (int i = 0; i < cptEntite; i++)
  {
    if ( (entityId.entity == lEntite[i].getId()) &&
         (entityId.address.site == lEntite[i].getSite()) &&
         (entityId.address.host == lEntite[i].getHost()) )
    {
      trouve = 1;
    }
  }

  if (trouve == 0)
  {
    if (cptEntite < NBMAXENTITE)
    {
      // on ajoute a la liste des entites

      lEntite[cptEntite].set(entityId.entity, entityId.address.host, entityId.address.site);
      cptEntite++;
    }
    else
    {
      IlvPrint("Ajout d'entite a la liste : plus de place !");
    }
  }
}


/************************************************************************/
/*									*/
/* Nom: majListeApplications						*/
/*									*/
/* Role: mise a jour de la liste des applications de l'exercice analyse	*/
/*									*/
/************************************************************************/

void
AnaAnalyse::majListeApplications(EntityID entityId)
{
  int	trouve = 0;

  for (int i = 0; i < cptApplication; i++)
  {
    if ( (entityId.address.host == lApplication[i].getId()) &&
         (entityId.address.site == lApplication[i].getSite()) )
    {
      trouve = 1;
    }
  }

  if (trouve == 0)
  {
    if (cptApplication < NBMAXAPPLI)
    {
      // on ajoute a la liste des applications

      lApplication[cptApplication].set(entityId.address.host, entityId.address.site);
      cptApplication++;
    }
    else
    {
      IlvPrint("Ajout d'application a la liste : plus de place !");
    }
  }
}


/************************************************************************/
/*									*/
/* Nom: majListeSites							*/
/*									*/
/* Role: mise a jour de la liste des sites de l'exercice analyse	*/
/*									*/
/************************************************************************/

void
AnaAnalyse::majListeSites(EntityID entityId)
{
  int	trouve = 0;

  for (int i = 0; i < cptSite; i++)
  {
    if (entityId.address.site == lSite[i].getId())
    {
      trouve = 1;
    }
  }

  if (trouve == 0)
  {
    if (cptSite < NBMAXSITE)
    {
      // on ajoute a la liste des sites

      lSite[cptSite].set(entityId.address.site);
      cptSite++;
    }
    else
    {
      IlvPrint("Ajout de site a la liste : plus de place !");
    }
  }
}


/************************************************************************/
/*									*/
/* Nom: calcTableau							*/
/*									*/
/* Role: calcul des nouvelles donnees du tableau			*/
/*									*/
/************************************************************************/

void
AnaAnalyse::calcTableau()
{
  int			i;

  // mise a jour pour chaque type de PDU du nouveau pourcentage

  if (cptPDU != 0)
  {
    for (i = 1; i < MAX_NUM_PDUS; i++)
    {
      pdu[i].calcPourcentage(cptPDU);
    }
  }

  // mise a jour pour chaque type de PDU de la nouvelle frequence

  if (temps != 0.0)
  {
    for (i = 1; i < MAX_NUM_PDUS; i++)
    {
      pdu[i].calcFrequence(temps);
    }
  }

  // mise a jour pour chaque type de PDU du nouveau pourcentage de volume

  if (cptPDU != 0)
  {
    for (i = 1; i < MAX_NUM_PDUS; i++)
    {
      pdu[i].calcPourcentageVolume(volPDU);
    }
  }

  // mise a jour pour chaque type de PDU de la nouvelle frequence instantanee

  for (i = 1; i < MAX_NUM_PDUS; i++)
  {
    pdu[i].calcFrequenceInst(dt);
  }

  // mise a jour pour le total de PDU de la nouvelle frequence

  freqPDU = (float) (1000.0*cptPDU)/temps;
  freqPDU /= 2.0;

  // mise a jour de la nouvelle frequence instantanee

  freqInstPDU = 0.0;
  for (i = 1; i < MAX_NUM_PDUS; i++)
  {
    freqInstPDU += pdu[i].FrequenceInst();
  }
  freqInstPDU /= MAX_NUM_PDUS;
}


/************************************************************************/
/*									*/
/* Nom: majTableau							*/
/*									*/
/* Role: mise a jour de l'affichage du tableau				*/
/*									*/
/************************************************************************/

void
AnaAnalyse::majTableau()
{
  IlvIntMatrixItem*	utem;
  IlvFloatMatrixItem*	ytem;
  int			i;

  // mise a jour pour chaque type de PDU

  for (i = 1; i < MAX_NUM_PDUS; i++)
  {
    utem = new IlvIntMatrixItem(pdu[i].Quantite());
    gettableau()->set(1, i, utem);
    ytem = new IlvFloatMatrixItem(pdu[i].Pourcentage());
    gettableau()->set(2, i, ytem);
    ytem = new IlvFloatMatrixItem(pdu[i].Frequence());
    gettableau()->set(3, i, ytem);
    utem = new IlvIntMatrixItem(pdu[i].Volume());
    gettableau()->set(4, i, utem);
    ytem = new IlvFloatMatrixItem(pdu[i].PourcentageVolume());
    gettableau()->set(5, i, ytem);
    ytem = new IlvFloatMatrixItem(pdu[i].FrequenceInst());
    gettableau()->set(6, i, ytem);
  }

  // mise a jour de la ligne des totaux

  utem = new IlvIntMatrixItem(cptPDU);
  gettableau()->set(1, MAX_NUM_PDUS, utem);
  ytem = new IlvFloatMatrixItem(100.0);		// la somme des % = 100 !
  gettableau()->set(2, MAX_NUM_PDUS, ytem);
  ytem = new IlvFloatMatrixItem(freqPDU);
  gettableau()->set(3, MAX_NUM_PDUS, ytem);
  utem = new IlvIntMatrixItem(volPDU);
  gettableau()->set(4, MAX_NUM_PDUS, utem);
  ytem = new IlvFloatMatrixItem(100.0);
  gettableau()->set(5, MAX_NUM_PDUS, ytem);
  ytem = new IlvFloatMatrixItem(freqInstPDU);
  gettableau()->set(6, MAX_NUM_PDUS, ytem);
}

/************************************************************************/
/*									*/
/* Nom: majCourbe							*/
/*									*/
/* Role: mise a jour de l'affichage de la courbe			*/
/*									*/
/************************************************************************/

void
AnaAnalyse::majCourbe()
{
  static float v1 = 0.0;
  static float v2 = 0.0;
  static float v3 = 0.0;
  static float v4 = 0.0;
  static float v5 = 0.0;
  static float v6 = 0.0;
  static float v7 = 0.0;
  static float v8 = 0.0;
  static float v9 = 0.0;

  courbe1->setData(pdu[EntityStatePDU_Type].NbInst(aquiletour), v1, v2, v3, v4, v5, v6, v7, v8, v9);

  v9 = v8;
  v8 = v7;
  v7 = v6;
  v6 = v5;
  v5 = v4;
  v4 = v3;
  v3 = v2;
  v2 = v1;
  v1 = pdu[EntityStatePDU_Type].NbInst(aquiletour);

  courbe1->reDraw();
}


/************************************************************************/
/*									*/
/* Nom: genereRapport							*/
/*									*/
/* Role: genere le rapport en HTML					*/
/*									*/
/************************************************************************/

void
AnaAnalyse::genereRapport(const char* nomFichier, const char* commentaire)
{
  char		*ptr;
  char		 la_date[48];
  FILE		*datum;
  ofstream	 file;
  int		 i;
  char		 path[256];

  sprintf(path, "%s/DATA/rapport", getenv("SSTH_HOME"));

  // Pour recuperer la date de la facon la plus portable possible ...

  datum = popen("date '+le %d/%m/%y &agrave; %Hh%Mmin.'", "r");
  fgets(la_date,48,datum);
  if ((ptr = strrchr(la_date, '\n')) != NULL) *ptr = '\0';
  pclose(datum);

  // Ouverture du fichier
  // --------------------

  file.open (nomFichier);

  file << "<HTML>" << endl;

  file << "	<HEAD><TITLE>SSTH Analyse</TITLE></HEAD>" << endl;

  file << endl;

  file << "	<BODY>" << endl;

  file << endl;

  file << "		<BODY BACKGROUND = \"../images/greypapr.gif\">" << endl;

  file << endl;

  file << "		Rapport d'analyse SSTH DIS sauv&eacute; " << la_date << endl;

  file << endl;

  file << "		<H1>Param&egrave;tres de l'exercice analys&eacute; :</H1>" << endl;

  file << "			<DL>" << endl;
  file << "			<DT>Port r&eacute;seau       : " << disPort << "</DT>" << endl;
  file << "			<DT>Num&eacute;ro d'exercice : " << exerciseId << "</DT>" << endl;
  file << "			<DT>Pas de temps (ms) : " << dt << "</DT>" << endl;
  file << "			<DT> </DT>" << endl;
  file << "			<DT>Analyse commenc&eacute;e &agrave; " << getinitial()->getLabel() << "</DT>" << endl;
  file << "			<DT>Analyse termin&eacute;e &agrave; " << getcourant()->getLabel() << "</DT>" << endl;
  file << "			<DT> </DT>" << endl;
  file << "			</DL>" << endl;

  file << endl;

  if (commentaire)
  {
    file << "		<H1>Commentaires :</H1>" << endl;

    file << endl;

    file << commentaire << endl;

    file << endl;
  }

  file << "		<H1>R&eacute;sultats :</H1>" << endl;

  file << endl;

  file << "		<TABLE border=3 cellspacing=2 cellpadding=10>" << endl;
  file << "			<CAPTION align=\"bottom\">" << endl;
  file << "				<B>Tableau d'analyse des PDU DIS</B>" << endl;
  file << "			</CAPTION>" << endl;

  file << "			<TR>" << endl;
  file << "				<TD>Type de PDU</TD>" << endl;
  file << "				<TD>Nombre de PDU</TD>" << endl;
  file << "				<TD>Pourcentage</TD>" << endl;
  file << "				<TD>Frequence (PDU/s)</TD>" << endl;
  file << "				<TD>Volume (bits)</TD>" << endl;
  file << "				<TD>% de volume</TD>" << endl;
  file << "				<TD>Frequence inst.</TD>" << endl;
  file << "			</TR>" << endl;

  for (i = 1; i < MAX_NUM_PDUS; i++)
  {
    file << "			<TR>" << endl;
    file << "				<TD>" << pdu[i].Nom() << "</TD>" << endl;
    file << "				<TD>" << pdu[i].Quantite() << "</TD>" << endl;
    file << "				<TD>" << pdu[i].Pourcentage() << "</TD>" << endl;
    file << "				<TD>" << pdu[i].Frequence() << "</TD>" << endl;
    file << "				<TD>" << pdu[i].Volume() << "</TD>" << endl;
    file << "				<TD>" << pdu[i].PourcentageVolume() << "</TD>" << endl;
    file << "				<TD>" << pdu[i].FrequenceInst() << "</TD>" << endl;
    file << "			</TR>" << endl;
  }

  file << "			<TR>" << endl;
  file << "				<TD>Total</TD>" << endl;
  file << "				<TD>" << cptPDU << "</TD>" << endl;
  file << "				<TD>100.0</TD>" << endl;
  file << "				<TD>" << freqPDU << "</TD>" << endl;
  file << "				<TD>" << volPDU << "</TD>" << endl;
  file << "				<TD>100.0</TD>" << endl;
  file << "				<TD>" << freqInstPDU << "</TD>" << endl;
  file << "			</TR>" << endl;
  file << "		</TABLE>" << endl;

  file << endl;

  file << "		<HR SIZE=3 WIDTH=80%>" << endl;

  file << endl;

  file << "		<CENTER><P ALIGN=\"CENTER\"><IMG SRC=\"../courbe/" << (nomFichier+strlen(path)+1) << ".gif\"></P></CENTER>" << endl;
  file << "		<CENTER><B>Courbe de synth&egrave;se</B></CENTER>" << endl;

  file << endl;

  file << "		<HR SIZE=3 WIDTH=80%>" << endl;

  file << endl;

  file << "		<CENTER><A HREF=\"../rapport\">Retour sur la liste des rapports</A></CENTER>" << endl;

  file << endl;

  file << "	</BODY>" << endl;

  file << "</HTML>" << endl;


  // On ferme le fichier
  // -------------------

  file.close();

}


/************************************************************************/
/*									*/
/* Nom: filtre								*/
/*									*/
/* Role: 								*/
/*									*/
/************************************************************************/

void
AnaAnalyse::filtre(IlvGraphic* g)
{
  IlvContainer*		container = IlvContainer::getContainer(g);
  IlvDisplay*		display = container->getDisplay();

  AnaFiltre* filtre =
    new AnaFiltre (display, "Filtre sur type de PDU", "Filtre sur type de PDU");
  filtre->setExercise(exercise);
  filtre->moveToMouse();
  filtre->show();
}


/************************************************************************/
/*									*/
/* Nom: dico_enregistre							*/
/*									*/
/* Role: 								*/
/*									*/
/************************************************************************/

void
AnaAnalyse::dico_enregistre(IlvGraphic*)
{
  char			path[128];

  // on sauvegarde les dictionnaires

  sprintf(path, "%s/DATA/dicos/sites.dico", getenv ("SSTH_HOME"));
  dicoSites.write(path);
  dicoSites.pretty();

  sprintf(path, "%s/DATA/dicos/applis.dico", getenv ("SSTH_HOME"));
  dicoApps.write(path);
  dicoApps.pretty();
}


/************************************************************************/
/*									*/
/* Nom: dico_site							*/
/*									*/
/* Role: 								*/
/*									*/
/************************************************************************/

void
AnaAnalyse::dico_site(IlvGraphic* g)
{
  IlvContainer*		container = IlvContainer::getContainer(g);
  IlvDisplay*		display = container->getDisplay();

  AnaDicoSite* dico =
    new AnaDicoSite (display, "Dictionnaire", "Dictionnaire");
  dico->setDico(&dicoSites);
  dico->afficheListe();
  dico->moveToMouse();
  dico->show();
}

/************************************************************************/
/*									*/
/* Nom: dico_appli							*/
/*									*/
/* Role: 								*/
/*									*/
/************************************************************************/

void
AnaAnalyse::dico_appli(IlvGraphic* g)
{
  IlvContainer*		container = IlvContainer::getContainer(g);
  IlvDisplay*		display = container->getDisplay();

  AnaDicoApp* dico =
    new AnaDicoApp (display, "Dictionnaire", "Dictionnaire");
  dico->setDico(&dicoApps);
  dico->afficheListe();
  dico->moveToMouse();
  dico->show();
}

/************************************************************************/
/*									*/
/* Nom: exercice							*/
/*									*/
/* Role: 								*/
/*									*/
/************************************************************************/

void
AnaAnalyse::exercice(IlvGraphic*)
{
}

/************************************************************************/
/*									*/
/* Nom: version								*/
/*									*/
/* Role: 								*/
/*									*/
/************************************************************************/

void
AnaAnalyse::version(IlvGraphic* g)
{
  IlvContainer*		container = IlvContainer::getContainer(g);
  IlvDisplay*		display = container->getDisplay();

  AnaApropos* propos =
    new AnaApropos (display, "Version", "Version");
  propos->moveToMouse();
  propos->legende("SSTH Analyse", VERSION_ANALYSE);
  propos->show();
}

/************************************************************************/
/*									*/
/* Nom: port								*/
/*									*/
/* Role: 								*/
/*									*/
/************************************************************************/

void
AnaAnalyse::port(IlvGraphic*)
{
}

/************************************************************************/
/*									*/
/* Nom: aide								*/
/*									*/
/* Role: 								*/
/*									*/
/************************************************************************/

void
AnaAnalyse::aide(IlvGraphic* g)
{
  char			fichier[256];
  IlvContainer*		container = IlvContainer::getContainer(g);
  IlvDisplay*		display = container->getDisplay();

  sprintf(fichier, "%s/DATA/aide/analyse.txt", getenv("SSTH_HOME"));

  AnaEditeur* editeur =
    new AnaEditeur (display, "Aide du poste analyse", "Aide du poste analyse");
  ifstream	file(fichier);
  char		ligne[256];

  if (!file)
    IlvPrint("Impossible d'ouvrir le fichier : %s", fichier);
  else
    while (file.getline(ligne, 80, '\n'))
    {
      editeur->gettext()->addLabel(ligne);
    }
  editeur->moveToMouse();
  editeur->show();
}

/************************************************************************/
/*									*/
/* Nom: browser								*/
/*									*/
/* Role: 								*/
/*									*/
/************************************************************************/

void
AnaAnalyse::browser(IlvGraphic*)
{
  char	commande[128];
  sprintf(commande, "%s/HTML/bin/viewer&", getenv("SSTH_HOME"));
  system (commande);
}

/************************************************************************/
/*									*/
/* Nom: tableau								*/
/*									*/
/* Role: 								*/
/*									*/
/************************************************************************/

void
AnaAnalyse::tableau(IlvGraphic*)
{
}

/************************************************************************/
/*									*/
/* Nom: site								*/
/*									*/
/* Role: 								*/
/*									*/
/************************************************************************/

void
AnaAnalyse::site(IlvGraphic* g)
{
  IlvContainer*		container = IlvContainer::getContainer(g);
  IlvDisplay*		display = container->getDisplay();
  IlvButton*		button;
  char			nom[32];

  if (cptSite  == 0)
  {
    static IlvIWarner* warner = 0;
    if (!warner) warner =
      new IlvIWarner (display, "Pas de site actuellement.");
    button = (IlvButton*) warner->getObject("apply");
    if (button) button->setLabel("Fermer");
    warner->setTitle("Message");
    warner->moveToMouse();
    warner->get();
  }
  else
  {
    char	buf[32];

    AnaListe* liste =
      new AnaListe (display, "Liste des sites", "Liste des sites");
    if (cptSite == 1)
      sprintf(buf, "%d site", cptSite);
    else
      sprintf(buf, "%d sites", cptSite);
    liste->setMessage(buf);
    liste->setType(TYPE_SITE);
    liste->moveToMouse();

    for (int i = 0; i < cptSite; i++)
    {
      if (dicoSites.getName(lSite[i].getId()))
      {
        sprintf(nom, "site %d : %s", lSite[i].getId(), dicoSites.getName(lSite[i].getId()));
        liste->ajoute_element(nom);
        liste->ajoute_comment(dicoSites.getComment(lSite[i].getId()));
      }
      else
      {
        sprintf(nom, "site %d", lSite[i].getId());
        liste->ajoute_element(nom);
      }
    }

    liste->show();
  }
}

/************************************************************************/
/*									*/
/* Nom: application							*/
/*									*/
/* Role: 								*/
/*									*/
/************************************************************************/

void
AnaAnalyse::application(IlvGraphic* g)
{
  IlvContainer*		container = IlvContainer::getContainer(g);
  IlvDisplay*		display = container->getDisplay();
  IlvButton*		button;
  char			nom[32];

  if (cptApplication  == 0)
  {
    static IlvIWarner* warner = 0;
    if (!warner) warner =
      new IlvIWarner (display, "Pas d'application actuellement.");
    button = (IlvButton*) warner->getObject("apply");
    if (button) button->setLabel("Fermer");
    warner->setTitle("Message");
    warner->moveToMouse();
    warner->get();
  }
  else
  {
    char	buf[32];

    AnaListe* liste =
      new AnaListe (display, "Applications", "Applications");
    if (cptApplication == 1)
      sprintf(buf, "%d application", cptApplication);
    else
      sprintf(buf, "%d applications", cptApplication);
    liste->setMessage(buf);
    liste->setType(TYPE_APPLI);
    liste->moveToMouse();

    for (int i = 0; i < cptApplication; i++)
    {
      if (dicoApps.getName(lApplication[i].getSite(), lApplication[i].getId()))
      {
        sprintf(nom, "appli %d:%d : %s", lApplication[i].getSite(), lApplication[i].getId(), dicoApps.getName(lApplication[i].getSite(), lApplication[i].getId()));
        liste->ajoute_element(nom);
        liste->ajoute_comment(dicoApps.getComment(lApplication[i].getSite(), lApplication[i].getId()));
      }
      else
      {
        sprintf(nom, "%d:%d", lApplication[i].getSite(), lApplication[i].getId());
        liste->ajoute_element(nom);
      }
    }

    liste->show();
  }
}

/************************************************************************/
/*									*/
/* Nom: entite								*/
/*									*/
/* Role: 								*/
/*									*/
/************************************************************************/

void
AnaAnalyse::entite(IlvGraphic* g)
{
  IlvContainer*		container = IlvContainer::getContainer(g);
  IlvDisplay*		display = container->getDisplay();
  IlvButton*		button;
  char			nom[32];

  if (cptEntite  == 0)
  {
    static IlvIWarner* warner = 0;
    if (!warner) warner =
      new IlvIWarner (display, "Pas d'entite actuellement.");
    button = (IlvButton*) warner->getObject("apply");
    if (button) button->setLabel("Fermer");
    warner->setTitle("Message");
    warner->moveToMouse();
    warner->get();
  }
  else
  {
    char	buf[32];

    AnaListe* liste =
      new AnaListe (display, "Liste des entites", "Liste des entites");
    if (cptEntite == 1)
      sprintf(buf, "%d entite", cptEntite);
    else
      sprintf(buf, "%d entites", cptEntite);
    liste->setMessage(buf);
    liste->setType(TYPE_ENTITE);
    liste->moveToMouse();

    for (int i = 0; i < cptEntite; i++)
    {
      sprintf(nom, "%d:%d:%d", lEntite[i].getSite(), lEntite[i].getHost(), lEntite[i].getId());
      liste->ajoute_element(nom);
    }

    liste->show();
  }
}

/************************************************************************/
/*									*/
/* Nom: init								*/
/*									*/
/* Role: 								*/
/*									*/
/************************************************************************/

void
AnaAnalyse::init(IlvGraphic*)
{
    char		*ptr;
    char		 date[48];
    char		 timec[64];
    FILE		*datum;
    int			 i;

    datum = popen("date '+le %d/%m/%y a %H:%M:%S'", "r");
    fgets(date,48,datum);
    if ((ptr = strrchr(date, '\n')) != NULL) *ptr = '\0';
    pclose(datum);

    sprintf(timec, "%c%c:%c%c:%c%c", date[14], date[15], date[17], date[18], date[20], date[21]);
    getinitial()->setLabel(timec);
    reDrawObj(getinitial());

    temps = 0.0;

    cptPDU = 0;

    freqPDU = 0.0;

    volPDU = 0;

    freqInstPDU = 0.0;

    for (i = 1; i < MAX_NUM_PDUS; i++)
    {
      pdu[i].initialise();
    }
}

/************************************************************************/
/*									*/
/* Nom: courant								*/
/*									*/
/* Role: 								*/
/*									*/
/************************************************************************/

void
AnaAnalyse::courant(IlvGraphic*)
{
}

/************************************************************************/
/*									*/
/* Nom: rapport								*/
/*									*/
/* Role: 								*/
/*									*/
/************************************************************************/

void
AnaAnalyse::rapport(IlvGraphic* g)
{
  char			gifName[512];
  char			commande[512];
  char			path[256];
  IlvContainer*		container = IlvContainer::getContainer(g);
  IlvDisplay*		display = container->getDisplay();
  const char*		fileName;
  const char*		comment;
  IlvIFileSelector*	selecteur;
  IlvIPromptString*	prompt;
  IlvButton*		button;
  IlvMessageLabel*	label;

  sprintf(path, "%s/DATA/rapport", getenv("SSTH_HOME"));
  selecteur = new IlvIFileSelector (display, path, "*.html");
  selecteur->setTitle("Choix de nom de rapport");

  // francisation

  label = (IlvMessageLabel*) selecteur->getObject("dirtitle");
  if (label) label->setLabel("Filtre");
  label = (IlvMessageLabel*) selecteur->getObject("title");
  if (label) label->setLabel("Choix");
  button = (IlvButton*) selecteur->getObject("ok");
  if (button) button->setLabel("Oui");
  button = (IlvButton*) selecteur->getObject("reset");
  if (button) button->setLabel("Efface");
  button = (IlvButton*) selecteur->getObject("cancel");
  if (button) button->setLabel("Annule");

  selecteur->moveToMouse();
  fileName = selecteur->get();
  if (fileName)
  {
    prompt = new IlvIPromptString (display);
    prompt->setTitle("Commentaire sur le rapport");
    prompt->setString("Commentaire");
    button = (IlvButton*) prompt->getObject("apply");
    if (button) button->setLabel("Integre");
    button = (IlvButton*) prompt->getObject("cancel");
    if (button) button->setLabel("Oublie");
    prompt->moveToMouse();
    comment = prompt->get();
    if (comment)
    {
      sprintf(gifName, "%s.gif", fileName);
      genereRapport(fileName, comment);
      courbe1->dumpGif (gifName, display);
      sprintf(commande, "mv %s %s/../courbe", gifName, path);
      system (commande);
    }
    else
    {
      sprintf(gifName, "%s.gif", fileName);
      genereRapport(fileName);
      courbe1->dumpGif (gifName, display);
      sprintf(commande, "mv %s %s/../courbe", gifName, path);
      system (commande);
    }
    delete prompt;
  }
  delete selecteur;
}

/************************************************************************/
/*									*/
/* Nom: courbe								*/
/*									*/
/* Role: 								*/
/*									*/
/************************************************************************/

void
AnaAnalyse::courbe(IlvGraphic*)
{
  static int i = 0;

  if (i == 0)
  {
    //graphe->moveToMouse();
    //graphe->show();
    i = 1;
  }
  else
  {
    //graphe->moveToMouse();
    //graphe->hide();
    i = 0;
  }

  courbe1->moveToMouse();
  courbe1->show();
}

/************************************************************************/
/*									*/
/* Nom: initial								*/
/*									*/
/* Role: 								*/
/*									*/
/************************************************************************/

void
AnaAnalyse::initial(IlvGraphic*)
{
}

/************************************************************************/
/*									*/
/* Nom: quit								*/
/*									*/
/* Role: sortie de l'application					*/
/*									*/
/************************************************************************/

void
AnaAnalyse::quit(IlvGraphic* g)
{
    IlvContainer* container = IlvContainer::getContainer(g);
    IlvDisplay* display = container->getDisplay();
    IlvButton*		button;

    static IlvIQuestionDialog* questiondialog = 0;
    if (!questiondialog) questiondialog =
      new IlvIQuestionDialog (display, "Voulez-vous vraiment quitter ?");
    questiondialog->setTitle("Confirmation de sortie");
    button = (IlvButton*) questiondialog->getObject("apply");
    if (button) button->setLabel("Oui");
    button = (IlvButton*) questiondialog->getObject("cancel");
    if (button) button->setLabel("Non");
    questiondialog->moveToMouse();
    if (questiondialog->get())
    {
      char			path[128];

      // on sauvegarde les dictionnaires

      sprintf(path, "%s/DATA/dicos/sites.dico", getenv ("SSTH_HOME"));
      dicoSites.write(path);

      sprintf(path, "%s/DATA/dicos/applis.dico", getenv ("SSTH_HOME"));
      dicoApps.write(path);

      delete container->getParent();
      delete display;
      IlvExit(0);
    }
}


/************/
/* The End. */
/************/

