/**************************************************************************\
*          Copyright (c) 1997 INRIA Sophia Antipolis, FRANCE.              *
*                                                                          *
* Permission to use, copy, modify, and distribute this material for any    *
* purpose and without fee is hereby granted, provided that the above       *
* copyright notice and this permission notice appear in all copies.        *
* WE MAKE NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS     *
* MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS   *
* OR IMPLIED WARRANTIES.                                                   *
\**************************************************************************/
/**************************************************************************\
*  File    :             	                			   *
*  Date    : 1997/02/12		           				   *
*  Author  : Martin May         					   *
*--------------------------------------------------------------------------*
*  Description :                                                           *
*                                                                          *
*                                                                          *
*                                                                          *
*--------------------------------------------------------------------------*
*        Name	        |    Date   |          Modification                *
*--------------------------------------------------------------------------*
*                       |           |                                      *
*                       |           |                                      *
\**************************************************************************/
/*
         header
        +-----+
        | hd  |------------------+
        +-----+                  V
        |count|               +-----+
        +-----+     +---------+prev |<---------+ 
                    | +------>| next+--------+ |
                    | |       +-----+        | |
                    | |                      | |
                    V |                      V |
                  +---+-+                  +---+-+
                  |     |                  |     |
                  |     |                  |     |
                  +-+---+                  +-+---+
                    | ^                      | ^
                    | |                      | |
                    | |       +-----+        | |
                    | +-------+     |<-------+ |
                    +-------->|     +----------+
                              +-----+

*/


/* #include <net/tc_hash.h>*/
#include <net/tc_queue.h>
#include <linux/string.h>
#include <linux/malloc.h>

/*
 * enqueuef(head,e): enqueue the element e AS THE FIRST one of the queue
 * headed by head.
 */
struct elemq_t *enqueuef(head, e)
    struct headq_t *head;
    struct elemq_t *e;
{
    if (head->hd) {
	e->next = head->hd;
	e->prev = head->hd->prev;
	head->hd = e->prev->next = e->next->prev = e;
	head->count++;
    } else {
	head->hd = e->next = e->prev = e;
	head->count=1;
    }
    return(e);
}


/*
 * enqueuel(head,e): enqueue the element e AS THE LAST one of the queue
 * headed by head.
 */
struct elemq_t *enqueuel(head, e)
    struct headq_t *head;
    struct elemq_t *e;
{
    register struct elemq_t *p;

    if (head->hd) {
	p=head->hd->prev;
	e->next = p->next;
	e->prev = p;
	p->next->prev=e;
	p->next=e;
	head->count++;
    } else {
	head->hd = e->next = e->prev = e;
	head->count=1;
    }
    return(e);
}

/*
 * enqueuep(head,p,e): enqueue the element e AFTER the ELEMENT p of the queue
 * headed by head.
 */
struct elemq_t *enqueuep(head, p, e)
    struct headq_t *head;
    struct elemq_t *p;
    struct elemq_t *e;
{
    if (head->hd) {
	e->next = p->next;
	e->prev = p;
	p->next->prev=e;
	p->next=e;
	head->count++;
    } else {
	head->hd = e->next = e->prev = e;
	head->count=1;
    }
    return(e);
}

/*
 * dequeuep(head,e): dequeue the element e from the queue headed by head.
 *
 * WARNING: It is assumed head is a no-NULL pointer (non empty queue).
 */
struct elemq_t *dequeuep(head, e)
    struct headq_t *head;
    struct elemq_t *e;
{
    register struct elemq_t *p, *n;

    if (e) {
	n = e->next;
	p = e->prev;
	if (e != n) { /* there are more than 1 elements */
	    p->next = n;
	    n->prev = p;
	    if (head->hd == e)
		head->hd = n;
	    head->count--;
	} else {/* queue will be left empty */
	    head->hd = (struct elemq_t *)0;
	    head->count=0;
	}
	e->next=e->prev = (struct elemq_t *)0; /* safer */
    }
    return(e);
}

/*
 * WARNING: It is assumed that e belongs to that queue.
 */
struct elemq_t *queue_up(head, e)
    struct headq_t *head;
    struct elemq_t *e;
{
    register struct elemq_t *p, *n;

    if (head->hd != e) { /* Certainly we have more than 1 element */
	n = e->next;
	p = e->prev;

	p->next = n;
	n->prev = p;

	e->next = head->hd;
	e->prev = head->hd->prev;
	head->hd = e->prev->next = e->next->prev = e;
    }
    return(e);
}

struct elemq_t *in_queue(head,e)
    struct headq_t *head;
    struct elemq_t *e;
{
    int i;
    struct elemq_t *e_aux;

    for(i=head->count,e_aux=head->hd;i;i--,e_aux=e_aux->next)
	if (e==e_aux)
	    return(e);

    return((struct elemq_t *)0);
}
