/**************************************************************************\
*          Copyright (c) 1997 INRIA Sophia Antipolis, FRANCE.              *
*                                                                          *
* Permission to use, copy, modify, and distribute this material for any    *
* purpose and without fee is hereby granted, provided that the above       *
* copyright notice and this permission notice appear in all copies.        *
* WE MAKE NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS     *
* MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS   *
* OR IMPLIED WARRANTIES.                                                   *
\**************************************************************************/
/**************************************************************************\
*  File    :             	                			   *
*  Date    : 1997/11/02		           				   *
*  Author  : Martin May           					   *
*--------------------------------------------------------------------------*
*  Description :                                                           *
*                                                                          *
*                                                                          *
*                                                                          *
*--------------------------------------------------------------------------*
*        Name	        |    Date   |          Modification                *
*--------------------------------------------------------------------------*
*                       |           |                                      *
* Laurent Pautet        | 1998/02/04| Adding IPv6 management for T.C.      *
\**************************************************************************/

#include <net/tc_global.h>
#include <net/tc_hash.h>
#include <net/tc_types.h>
#include <net/tc_queue.h>

#include <linux/string.h>
#include <linux/malloc.h>

static struct headh_t *malloc_hash(int n);
static void free_hash(struct headh_t *hash);

u_int32 fss_key(char *src,char *src2)
{
    register int i;
    char res[4];

    *(__u32*)res=0;
    for(i=0;i<8;i++) {
	res[0]^=src[i];
	if (i&1) res[1]^=src[i];
	else     res[2]^=src[i];
    }
    for(i=0;i<4;i++) {
	res[0]^=src2[i];
	if (i&1) res[1]^=src2[i];
	else     res[2]^=src2[i];
    }
    res[3]=src[0] ^ src[3] ^ src[4] ^ src[5] ^ src2[0];

    return(*(__u32*)res);
}


/****************************************************
 * This is the H-function for generating key0       *
 * when dealing with ipv6 Protocol                  *
 ****************************************************/
u_int32 fss_key6(char *src,char *src2) {
  
    register int i;
    char res[4];
#ifdef DEBUG_HASH
    __u32 *addr6,*vrprf6;
#endif
    char ctmp;

#ifdef DEBUG_HASH
    addr6=(__u32*) src;
    vrprf6=(__u32*) src2;
    printk (KERN_WARNING "TC_HASH [VRPRF]-=-> %x\n",*vrprf6);   
    printk (KERN_WARNING "TC_HASH [SRC]-=-> ");
    for (i=0;i<4;i++) {

      printk (KERN_WARNING "%x:",addr6[i]);
    }
    printk (KERN_WARNING "\n");
    printk (KERN_WARNING "TC_HASH [DST]-=-> ");    
    for (i=4;i<8;i++) {
      printk (KERN_WARNING "%x:",addr6[i]);
    }
    printk (KERN_WARNING "\n");
#endif
    *(__u32*)res=0;
    for(i=0;i<32;i++) { 
      /* XOR of src & dst adresses ( 2 * 16 bytes ) */     
      res[0]^=src[i]; 
      if (i&1) res[1]^=src[i];
      else     res[2]^=src[i];
    }
    for(i=0;i<4;i++) {
      /* Flow Label with version and priority (first 4 bytes ) */ 
      res[0]^=src2[i];
      if (i&1) res[1]^=src2[i];
      else     res[2]^=src2[i];
    }
    res[3]=src[0] ^ src[3] ^ src[4] ^ src[5] ^ src2[0];    
#ifdef DEBUG_HASH
    printk (KERN_WARNING "TC_HASH [return]--> %x\n",*(__u32*) res);
#endif
    return(*(__u32*)res); 
}


/*
 * State information is returned in stat:
 * big endian:
 *     u_int32 other:16;      used in other levels (cache.c/lookup_wphs())
 *     u_int32 count1:8;      count0 hits
 *     u_int32 count0:8;      count1 hits
 *
 * COLLISIONS: I don't care about collisions in SSRC provided
 *             the colliding srcs have different IP addr, because
 *             I return always the first session that matches both
 *             SSRC and IP addr. The exception is when key==0, in such
 *             a case I return the first session with the requested SSRC
 */
struct elemh_t *hash_lookup(root,key0,key1,stat)
    struct headh_t *root;
    u_int32 key0;  /* XOR of src & dst addresses as well as src & dst ports */
    u_int32 key1;  /* src & dst ports */
    u_int32 *stat;
{
    u_int8 count0;
    u_int8 count1;
    int level;
    int i;
    struct elemh_t *elem;
    register u_int32 skey;
    register struct elemh_t *e;

    for(count0=count1=level=0,elem=(struct elemh_t *)0,skey=key0;
	level<HASH_MAX_LEVEL;
	level++,skey>>=HASH_WIDTH) {
	if (!root->size) {
	    /* let's look in a normal queue */
	    for(i=root->count,e=(struct elemh_t *)root->hd;
		i;
		i--,e=e->next) {
		if (e->key0==key0) {
		    count0++;
		    if (e->key1==key1) {
			count1++;
			if (!elem)
			    elem=e;
		    }
		}
	    }
	    break;
	} else {
	    /* go deeper in the hash tables */
	    root=&root->hd[skey&HASH_MASK];
	}
    }

#ifdef DEBUG_HASH
    if (count1>1)
	printk(KERN_WARNING "hash_lookup: collision (%d,%d)\n",
	       (int)count0,(int)count1);
#endif
    
    *stat|=(count1<<8)|count0;

    return(elem);
}

/*
 * WARNING: hash_insert() don't verify for collisions in the key. 
 */
struct elemh_t *hash_insert(root,elem)
    struct headh_t *root;
    struct elemh_t *elem;
{
    int level;
    struct headh_t *hash;
    u_int32 skey;

    printk(KERN_WARNING "TC: hash_insert  \n");
    if (!root->size)
       printk(KERN_WARNING "key2 = %d \n",elem->key0);
    
    for(level=0,skey=elem->key0;
	level<HASH_MAX_LEVEL;
	level++,skey>>=HASH_WIDTH) {
	if (!root->size) {
	    /* a normal queue */
	    if (root->count<HASH_MAX_LINEAR || level==HASH_MAX_LEVEL-1) {
		/* we can still keep the normal queue */
		enqueuel((struct headq_t *)root,(struct elemq_t *)elem);
	    } else {
		/* we must expand the hash table */
		if ( (hash=malloc_hash(HASH_MAX)) ) {
		    register struct elemh_t *e;
		    register struct elemh_t *next;
		    int i,s;

#ifdef DEBUG_HASH
		    printk(KERN_WARNING "hash_insert: expanding queue to hash"
			   " with L=%d, %d\n",level,root->count);
#endif
		    s=level*HASH_WIDTH;
		    /* pass all elems in the normal queue to the new hash */
		    for(i=root->count,next=(struct elemh_t *)root->hd;i;i--) {
			e=next;
			next=e->next;
			enqueuel((struct headq_t *)&hash[(e->key0>>s)&HASH_MASK],
				 (struct elemq_t *)e);
		    }
		    /* insert the new element */
		    enqueuel((struct headq_t *)&hash[(elem->key0>>s)&HASH_MASK],
			     (struct elemq_t *)elem);
		    /* update root to keep the new hash table */
		    root->hd=hash;
		    root->count++;
		    root->size=HASH_MAX;/* hash table's size */
		} else {
		    /* in the case malloc() failed, insert in queue :-( */
		    enqueuel((struct headq_t *)root,(struct elemq_t *)elem);
		}
	    }
	    break;
	} else {
	    root->count++;
	    root=&root->hd[skey&HASH_MASK];
	}
    }

    if (level>=HASH_MAX_LEVEL)
	elem=(struct elemh_t *)0;

    return(elem);
}

/*
 * WARNING: the element about to be deleted MUST exist, other way
 * I don't know what can result.
 */
void hash_delete(root,elem,key)
    struct headh_t *root;
    struct elemh_t *elem;
    u_int32 key;
{
    if (!root->size) {
	/* normal queue */
	dequeuep((struct headq_t *)root,(struct elemq_t *)elem);
    } else {
	/* we have another level of hash tables */
	hash_delete(&root->hd[key&HASH_MASK],elem,key>>HASH_WIDTH);
	if (--root->count<=0) {
	    /* frees the hash table */
#ifdef DEBUG_HASH
	    printk(KERN_WARNING "hash_delete: contracting hash to queue\n");
#endif
	    free_hash(root->hd);
	    root->hd=(struct headh_t *)0;
	    root->count=root->size=0;
	}
    }
}

static struct headh_t *malloc_hash(n)
    int n;
{
    struct headh_t *hash;
    if ( (hash=(struct headh_t *)new_kmem_zalloc(n*sizeof(struct headh_t),GFP_KERNEL)) )
	bzero((char *)hash,n*sizeof(struct headh_t));
    else
	printk(KERN_WARNING "malloc_hash: malloc failed\n");
    return(hash);
}

static void free_hash(hash)
    struct headh_t *hash;
{
    kmem_free(hash,M_DEVBUF);
}
