/**************************************************************************\
*          Copyright (c) 1995 INRIA Sophia Antipolis, FRANCE.              *
*                                                                          *
* Permission to use, copy, modify, and distribute this material for any    *
* purpose and without fee is hereby granted, provided that the above       *
* copyright notice and this permission notice appear in all copies.        *
* WE MAKE NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS     *
* MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS   *
* OR IMPLIED WARRANTIES.                                                   *
\**************************************************************************/
/**************************************************************************\
*  File    :             	                			   *
*  Date    : 1997/01/31		           				   *
*  Author  : Martin May  						   *
*--------------------------------------------------------------------------*
*  Description : generic Traffic Control kernel for Linux. Catch the ioctl *
*  passed from the user space and make the modifications for the           *
*  scheduler.                                                              *
*                                                                          *
*--------------------------------------------------------------------------*
*        Name	        |    Date   |          Modification                *
*--------------------------------------------------------------------------*
*  tc_class.c           |           |   Maud'Dib                           *
* Laurent Pautet        | 1998/02/04| Adding IPv6 management for T.C.      *
*                       |           |                                      *
\**************************************************************************/


#include <sys/param.h>
#include <sys/socket.h>
#include <sys/errno.h>
#include <sys/time.h>
#include <linux/time.h>
#include <linux/sockios.h>
#include <linux/kernel.h>
#include <linux/if_ether.h>
#include <linux/netdevice.h>
#include <linux/skbuff.h>

#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>

#include <syslog.h>

#include <net/tc_global.h>
#include <net/tc_wfq.h>

void tc_classify_cbq(struct tc_ifdat *tcdp, struct sk_buff *skb)
{
   struct iphdr   *iph;
   struct ipv6hdr *iph6;
   __u32          fs_stat=0;
   struct elemh_t *fss;
   
   switch (ntohs(skb->protocol)){
   case ETH_P_IP:{
      __u32          key0,key1;
      char           *data0, *data1;
      
      /*      tcdp->ip++; */  /* packet counter */
      
      iph = (struct iphdr *) (skb->nh.iph);
      
      data0=(char*)&iph->saddr;/* src & dst IP addresses */
      /* printk(KERN_WARNING "CBQCLASS: data0 %p \n", data0);*/
      data1=(char*)((__u32*)iph+iph->ihl);
      /* printk(KERN_WARNING "CBQCLASS: data1 %p \n", data1);*/
      
      key0=fss_key(data0,data1);
      key1=*((__u32*)data1);
      if ( (fss=hash_lookup(&tcdp->rooth,key0,key1,&fs_stat)) ) {
	 printk(KERN_WARNING "CBQCLASS: reserved cl=%p \n", fss->tccp);
	 /*fss=(struct elemh_t *) ((char *)fss - sizeof(void *)*2);*/
	 rmc_queue_packet(fss->tccp,skb);
      } else {
	 rmc_queue_packet(tcdp->defaultclass, skb);
      }
      break;
   }
   case ETH_P_IPV6:{
      __u32          key0, key1;
      char           *data0, *data1;

      printk(KERN_WARNING "CBQCLASS: IPv6 Packet \n");
      /*tcdp->ip6++;*/

      iph6 =  skb->nh.ipv6h;
      printk(KERN_WARNING "CBQ_CLASS: vrprflow=%x\n",iph6->vrprflow);
      
      data0=(char*) (iph6->saddr.s6_addr32) ; /* src & dst IP6 addresses */
      /* printk(KERN_WARNING "CBQCLASS: data0 %p \n", data0);*/
      data1=(char*)((__u32*) iph6); /* flow ID with version and priority */
      /*printk(KERN_WARNING "CBQCLASS: data1 %p \n", data1);*/
      
      key0=fss_key6(data0,data1);
      key1=*((__u32*)data1);
      printk(KERN_WARNING "CBQ_CLASS: key0=%x key1=%x\n",key0,key1);
      if ( (fss=hash_lookup(&tcdp->rooth,key0,key1,&fs_stat)) ) {
	printk(KERN_WARNING "CBQCLASS: IPv6 reserved cl=%p \n", fss->tccp);
	/*fss=(struct elemh_t *) ((char *)fss - sizeof(void *)*2);*/
	rmc_queue_packet(fss->tccp,skb);
      } else {
	printk(KERN_WARNING "CBQCLASS: IPv6 default class \n");
	rmc_queue_packet(tcdp->defaultclass, skb);
      }
      break;
   }
   case ETH_P_ARP:{
      /*      tcdp->arp++;*/
      rmc_queue_packet(tcdp->defaultclass, skb);
      break;
   }
   default:{
      printk(KERN_WARNING "CBQCLASS: unknown packet type \n");
      /*      tcdp->others++;*/
      rmc_queue_packet(tcdp->defaultclass, skb);
      break;
   }
   }
}


struct fs_ses_t *tc_classify_wfq(struct fs_ctx_t *fsc, struct sk_buff *skb)
{
   struct fs_ses_t *fss;

   switch (ntohs(skb->protocol)){
   case ETH_P_IP:{
      struct iphdr *iph;

      /*      fsc->ip++;*/
      iph = (struct iphdr *) (skb->nh.iph);
      
      if (iph->tos != IPTOS_WFQ){
	 fss = (struct fs_ses_t *)fsc->fifoses;
	 return (fss);
      }
      else {
	 fss = (struct fs_ses_t *) fq_lookup(fsc, skb);
	 return (fss);
      }
      break;
   }
   case ETH_P_IPV6:{
      struct ipv6hdr *iph;
      
      printk(KERN_WARNING "WFQCLASS: IPv6 Packet \n");
      /*      fsc->ip6++;*/
      iph = (struct ipv6hdr *) (skb->nh.ipv6h);
      fss = (struct fs_ses_t *)fsc->fifoses;
      return (fss);
      break;
   }
   case ETH_P_ARP:{
      printk(KERN_WARNING "WFQCLASS: ARP Packet\n");
      /*fsc->arp++;*/
      if (fsc->fifoses == NULL){
	 printk(KERN_WARNING "WFQCLASS:class fifosess  ==  NULL\n");
	 fss = (struct fs_ses_t *) 0;
      }
      else
	 fss = (struct fs_ses_t *)fsc->fifoses;
      return (fss);
      break;
   }

   default:{
      /*      fsc->others++;*/
      printk(KERN_WARNING "WFQCLASS: unknown packet type \n");
      fss = (struct fs_ses_t *)fsc->fifoses;
      return (fss);
   }
   }
}


int
tc_classify_1bit(struct device *dev, struct sk_buff *skb)
{
   struct sk_buff_head *list;

   switch (ntohs(skb->protocol)){
   case ETH_P_IP:{
      struct iphdr *iph;
      iph = (struct iphdr *) (skb->nh.iph);
      if (iph != NULL){
	 /*	 if ( ((unsigned int)skb->nh.iph & 0xff000000) != 0xc0000000){*/
	 if ((iph->tos & IPTOS_WFQ) == IPTOS_WFQ){
	    list = dev->buffs ;
	    if (skb_queue_len(list) < TC_MAX_K) {
	       cli();
	       __skb_queue_tail(list, skb);
	    }
	    skb->priority = 0;
	    /*	    printk(KERN_WARNING "CLASS_1BIT %p \n", skb); */
	    
	 }
	 else {
	    list = dev->buffs + 1;
	    if (skb_queue_len(list) < TC_MAX_QUEUE_LEN) {
	       cli();
	       __skb_queue_tail(list, skb);
	    }
	    skb->priority = 1;
	    /*	    printk(KERN_WARNING "CLASS_1BIT  normal %p %p \n", skb,list); */

	 }
      }
      break;
   }
   case ETH_P_ARP:{
      printk(KERN_WARNING "CLASS_1BIT: ARP Packet\n");
      list = dev->buffs+1;
      if (skb_queue_len(list) < TC_MAX_QUEUE_LEN) {
	 cli();
	 __skb_queue_tail(list, skb);
      }
      skb->priority = 1;
      return 0;
   }
   default:{
      printk(KERN_WARNING "CLASS_1Bit: unknown packet type \n");
      list = dev->buffs+1;
      if (skb_queue_len(list) < TC_MAX_QUEUE_LEN) {
	 cli();
	 __skb_queue_tail(list, skb);
      }
      skb->priority = 1;
      return 0;
   }
      
   }
   return 0;
}

void
tc_classify_test(struct tc_ifdat *tcdp, struct sk_buff *skb)
{
   switch (ntohs(skb->protocol)){
   case ETH_P_IP:{
      struct iphdr *iph;
      int a;
      iph = (struct iphdr *) (skb->nh.iph);
      if (iph != NULL){
	 if ( ((unsigned int)skb->nh.iph & 0xff000000) != 0xc0000000){
	    printk(KERN_WARNING "[classify_test] nh.iph %p\n", iph);
	    printk(KERN_WARNING "TEST %p \n", skb); 
	 }
	 /* printk(KERN_WARNING "TEST skb %p\n",skb); */
	 /* printk(KERN_WARNING "TEST %d\n",iph->tos );  */
	 a = iph->tos;
      }
      break;
   }
   case ETH_P_ARP:{
      printk(KERN_WARNING "TEST: ARP Packet\n");
   }
   default:{
      printk(KERN_WARNING "TEST: unknown packet type \n");
      
   }
   }
}


