/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

   TABLE MANAGEMENT

   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
/*--START FUNCTION--(nd_add_1)--------------------------------------------
 |
 | Adds a route to a destination *addr.
 |
 | Input: an ipv6 address *addr.
 |        its prefix length
 |        a route destination structure.
 | Return: 0
 |
 ------------------------------------------------------------------------ */
static int nd_add_1(struct in6_addr *addr, struct neighbor *n)
{
   struct rt_neigh *fn;
   struct rt_neigh *pn = NULL;
   struct rt_neigh *in;
   struct rt_neigh *ln;
   __u32 bit;
   __u32 dir = 0;
   int plen = 128;
   unsigned long flags;

#ifdef IPV6_DEBUG_ND_1
   printk(KERN_DEBUG "[ND]nd_add_1: IN\n");
#endif
   fn = &nd_root;		/* fn points to root */
   for (;;) {
      if (fn == NULL) {
#ifdef IPV6_DEBUG_ND_1
	 printk(KERN_DEBUG "[ND]nd_add_1: fn==NULL\n");
#endif
	 ln = kmalloc(sizeof(struct rt_neigh), GFP_ATOMIC);
	 if (ln == NULL)
	    return (-ENOMEM);

	 memset(ln, 0, sizeof(struct rt_neigh));
	 ln->rn_bit = NEIGHBOR_PLEN;

	 ln->parent = pn;
	 ln->leaf = n;
	 n->main_node = ln;
	 ln->rn_flags = RTN_BACKTRACK;

	 if (dir)
	    pn->right = ln;
	 else
	    pn->left = ln;
#ifdef IPV6_DEBUG_ND_1
	 printk(KERN_DEBUG "[ND]nd_add_1: OUT\n");
#endif
	 atomic_inc(&nd_entries);
	 return (0);
      }
      /*
       * fn!= NULL
       */
      if (plen >= fn->rn_bit &&
	  pfx_match(&fn->leaf->naddr, addr, fn->rn_bit)) {
	 if (plen == fn->rn_bit) {
#ifdef IPV6_DEBUG_ND_1
	    printk(KERN_DEBUG "[ND]nd_add_1: plen==fn->rn_bit && ....%d\n", plen);
#endif
	    /* clean up an intermediate node */
	    if ((fn->rn_flags & RTN_BACKTRACK) == 0) {
	       save_flags(flags);
	       cli();
	       neighbor_release(fn->leaf);
	       restore_flags(flags);
	       fn->leaf = NULL;
	       fn->rn_flags |= RTN_BACKTRACK;
	    }
	    n->next = fn->leaf;
	    fn->leaf = n;
#ifdef IPV6_DEBUG_ND_1
	    printk(KERN_DEBUG "[ND]nd_add_1: OUT\n");
#endif
	    return 0;
	 }
	 /* plen > ref. bit, 
	  * input addr does match leaf addr up to ref bit
	  */
#ifdef IPV6_DEBUG_ND_1
	 printk(KERN_DEBUG "[ND]nd_add_1: plen>fn->rn_bit &&.... %d \n", plen);
#endif
	 /* walk down on tree */
	 pn = fn;
	 dir = naddr_bit(addr, fn->rn_bit);
	 fn = dir ? fn->right : fn->left;
#ifdef IPV6_DEBUG_ND_1	 
	 printk(KERN_DEBUG "[ND]nd_add_1: dir:%d\n", dir);
#endif
	 continue;
      }
      /*
       * don't have a common prefix anymore
       */
      pn = fn->parent;
      bit = naddr_diff(addr, &fn->leaf->naddr, pn->rn_bit);
      /*
       * We must have plen > bit since NEIGHBOR_PLEN = 128...
       * 0< bit < 127
       */
      /*           (pn)
       *           / or\ 
       *          (in)  ...
       *         /    \
       *       (ln)   (fn) 
       */
      /* allocate new rt_neigh */
      in = kmalloc(sizeof(struct rt_neigh), GFP_ATOMIC);
      if (in == NULL)
	 return (-ENOMEM);
      atomic_inc(&nd_entries);
      memset(in, 0, sizeof(struct rt_neigh));

      /* 
       * new intermediate node. 
       * RTN_BACKTRACK will be off since that an address 
       * that chooses one of the branches would not match 
       * less specific routes in the other branch
       */
      in->rn_bit = bit;		/* diff btw addr & fn->... */
      in->parent = pn;
      in->leaf = n;		/* connect neighbor input param. */
      atomic_inc(&n->refcnt);

      /* update parent pointer */
      if (dir)
	 pn->right = in;
      else
	 pn->left = in;

      /* leaf node */
      ln = kmalloc(sizeof(struct rt_neigh), GFP_ATOMIC);
      if (ln == NULL) {
	 kfree(in);
	 return (-ENOMEM);
      }
      atomic_inc(&nd_entries);
      memset(ln, 0, sizeof(struct rt_neigh));
      ln->rn_bit = NEIGHBOR_PLEN;
      /* We may backtrack and find a less specific route */
      ln->rn_flags = RTN_BACKTRACK;

      ln->parent = in;
      fn->parent = in;

      ln->leaf = n;
      n->main_node = ln;

      if (naddr_bit(addr, bit)) {
	 in->right = ln;
	 in->left = fn;
      } else {
	 in->left = ln;
	 in->right = fn;
      }
#ifdef IPV6_DEBUG_ND_1
      printk(KERN_DEBUG "[ND]nd_add_1: OUT with success new int.: %d %d\n", bit, plen);
#endif
      return 0;
   }
#ifdef IPV6_DEBUG_ND_1
   printk(KERN_DEBUG "[ND]nd_add_1: OUT with failure\n");
#endif
   return (-1);			/* failed to add a rt_neigh */
}
/*--END FUNCTION--(nd_add_1)-----------------------------------------------*/
