/*
 * DRET-IPv6  An implementation of the TCP/IP protocol suite for the LINUX
 *              operating system.  INET6 is implemented using the BSD Socket
 *              interface as the means of communication with the user level.
 *
 * Contacts:    
 *              INRIA      <Christophe.Diot@sophia.inria.fr>
 *              MASI       <Eric.Horlait@masi.ibp.fr>
 *              This software has been developped with the financial support
 *              of DRET (French Military Research Agency).
 *
 * Version:    $Id$ 
 *      
 * Authors:     
 *              name    <E_mail>
 *
 *
 * Fixes:
 *
 *
 * Description:
 *
 *
 *              This program is free software; you can redistribute it and/or
 *              modify it under the terms of the GNU General Public License
 *              as published by the Free Software Foundation; either version
 *              2 of the License, or (at your option) any later version.
 *              This notice must be copied with the distributed package.
 *
 *              Portions of the software are derived from  various 
 *              networking code publicly available, mainly:
 *                      NRL IPv6 code 
 *                      NetBSD code from INRIA (Francis.Dupont@inria.fr)
 *                      Pedro Roque's Linux version (Roque@di.fc.up.pt)
 *
 */

/*---------- Contents ----------------------------------------------------
|
|  Function_name
|
-------------------------------------------------------------------------*/
#include <linux/config.h>
#include <linux/skbuff.h>
#include <linux/route.h>
#include <linux/socket.h>
#include <linux/in.h>
#include <linux/netdevice.h>
#include <net/netlink.h>

#include <linux/dret/in6.h>

#ifdef CONFIG_NET_RTNETLINK6
#define IPV6_DEBUG_NETLINK6

/*
 *      Netlink hooks for IPv6
 */
void ipv6_netlink_msg(unsigned long msg, struct in6_addr *d, struct in6_addr *gw, unsigned long plen, short flags, short metric, char *name) {

   struct sk_buff *skb = alloc_skb(sizeof(struct netlink_rtinfo), GFP_ATOMIC);
   struct netlink_rtinfo *nrt;
   struct sockaddr_in6 *s;
   struct device *dev = dev_get(name);

#ifdef IPV6_DEBUG_NETLINK6
   printk(KERN_DEBUG "[NETLINK6]ipv6_netlink_msg: IN %s\n", name);
#endif
 
   if (!skb || !dev)
      return;

   /* skb->free = 1; */
   nrt = (struct netlink_rtinfo *) skb_put(skb, sizeof(struct netlink_rtinfo));
   if (!nrt)
      return;

   memset(nrt, 0, sizeof(*nrt));
   nrt->rtmsg_type = msg;
   nrt->rtmsg_family = AF_INET6;
   nrt->rtmsg_index = dev->ifindex;
   /* Protocol dependent information */
   s = (struct sockaddr_in6 *) &nrt->rtmsg_dst6;
   s->sin6_family = AF_INET6;
   if (d)
      COPY_ADDR6(s->sin6_addr, *d);
   s = (struct sockaddr_in6 *) &nrt->rtmsg_gw6;
   s->sin6_family = AF_INET6;
   if (gw)
      COPY_ADDR6(s->sin6_addr, *gw);
   nrt->rtmsg_plen6 = plen;
/*--------------------------------*/
   nrt->rtmsg_flags = flags;
   nrt->rtmsg_metric = metric;
   strcpy(nrt->rtmsg_device, name);

   netlink_post(NETLINK_ROUTE, skb);
   
#ifdef IPV6_DEBUG_NETLINK6
   printk(KERN_DEBUG "[NETLINK6]ipv6_netlink_msg: OUT\n");
#endif
}

#endif

