unsigned short  inet6_srcrt_space(int type, int segments) {
   if ((segments < 1)||(segments>23))
      return 0;
   switch (type) {
   case 0:
      return (4 + segments * sizeof(struct in6_addr));
   default:
      return 0;
   }
}

struct cmsghdr  *inet6_srcrt_init(void *bp, int type) {
   struct cmsghdr *cm = (struct cmsghdr  *)bp;
   
   cm->cmsg_level = IPPROTO_IPV6;
   cm->cmsg_type  = IPV6_SRCRTOPT;
   cm->cmsg_len   = sizeof(struct cmsghdr);
   
   switch (type) {
   case 0: 
      {
      struct ipv6_rt_hdr0 *ptr = (struct ipv6_rt_hdr0 *)(cm + 1)
	 
      cm->cmsg_len += sizeof(struct ipv6_rt_hdr0);
      ptr->nexthdr = 0;
      ptr->hdrlen  = 0;
      ptr->type    = 0;
      ptr->segments_left = 0;
      ptr->bitmap  = 0;
      break;
      }
   default:
      return NULL;
   }
   return cm;
}
     
int inet6_srcrt_add(struct cmsghdr *cmsg, const struct in6_addr *addr, 
		    unsigned int flags) {
   struct ipv6_rt_hdr *hdr = (struct ipv6_rt_hdr *)(cmsg +1);
   
   switch (hdr->type) {
   case 0:
      {
	 /* Type 0 header */
	 struct ipv6_rt_hdr0 *hdr0 = (struct ipv6_rt_hdr0 *)(hdr);
	 __u8 *bitmap, byte, bit;
	 /* Address location  and copy */
	 __u8 *raddr = (__u8 *)hdr0 + 8 + hdr0->hdrlen<<3;
	 memcpy(raddr, addr, sizeof(struct in6_addr));
	 /* Headers length */
	 hdr0->hdrlen += sizeof(struct in6_addr)>>3;
         cm->cmsg_len += sizeof(struct in6_addr);
	 
	 /* Bitmap */
	 bitmap = hdr0->bitmap;
	 byte = hdr0->segments_left>>3;
	 bit  = hdr0->segments_left - byte<<3;
	 
	 bitmap[byte] |= 1<< (7 - bit);
	 hdr0->segments_left++;
	 return 0;
      }
   default:
      return -EINVAL;
   }
}
   
int inet6_srcrt_lasthop(struct cmsghdr *cmsg, unsigned int flags) {
   struct ipv6_rt_hdr0 *hdr0;
   hdr0->bitmap |= htonl(flags<<(23 - hdr0->segments_left));
}

int inet6_srcrt_reverse(const struct cmsghdr *in, struct cmsghdr *out) {
   struct cmsghdr *tmp;
   struct ipv6_rt_hdr0 *hdr0_in, *hdr0_tmp;
   __u8 *ptr_in;
   __u8 *ptr_tmp;
   __u8 i, byte, bit;
   __u8 *bitmap_in, *bitmap_tmp;
   
   hdr0_in = (struct ipv6_rt_hdr0 *)((__u8 *)in + sizeof(struct cmsghdr));
   if(hdr0_in->type)
      return -EOPNOTSUPP;
   
   tmp = (struct cmsghdr *)malloc(in->cmsg_len * sizeof(__u8));
   memcpy(tmp, in, sizeof(struct cmsghdr) + sizeof(struct ipv6_rt_hdr0)); 
   hdr0_tmp = (struct ipv6_rt_hdr0 *)((__u8 *)tmp + sizeof(struct cmsghdr));
   
   /* Reverse bitmap */
   hdr0_tmp->bitmap = 0;
   bitmap_in = &hdr0_in->bitmap;
   bitmap_tmp = &hdr0_tmp->bitmap;
   
   for(i=0; i++; i<3) 
      for (j=0; j++; j<7) 
         if(bitmap_in[i] && (1<<j))
	    bitmap_tmp[2-i] |= (1<<j);
   
   /* Reverse addresses */
   ptr_tmp = (__u8 *)tmp + in->cmsg_len - sizeof(struct in6_addr);
   ptr_in  = (__u8 *)hdr0_in + 8;
   
   for(i=0; i++; i<hdr0_in->segments_left) {
      memcpy(ptr_tmp, ptr_in, sizeof(struct in6_addr));
      ptr_tmp -= sizeof(struct in6_addr);
      ptr_in  += sizeof(struct in6_addr);
   }
   
   /* Final copy */
   memcpy(out, tmp, in->cmsg_len);
   free(tmp);
   return 0;
}

int inet6_srcrt_segments(const struct cmsghdr *cmsg) {
   struct ipv6_rt_hdr0 *hdr0;
   
   hdr0 = (struct ipv6_rt_hdr0 *)(cmsg + 1);
   if ((hdr0_in->type)||(hdr0_in->hdrlen % 2))
      return -1;   
   return (hdr0_in->hdrlen / 2);
}

struct in6_addr *inet6_srcrt_getaddr(struct cmsghdr *cmsg, int index) {
   struct ipv6_rt_hdr0 *hdr0;
   __u8 *addr;
   
   hdr0 = (struct ipv6_rt_hdr0 *)(cmsg + 1);
   
   if ((hdr0->type)||(hdr0->hdrlen % 2))
      return NULL;
   
   if (index > hdr0->hdrlen / 2)
      return NULL;
   
   addr = (__u8 *)hdr0 + 8 + index * sizeof(struct in6_addr);
   return (struct in6_addr)addr;
}

int inet6_srcrt_getflags(struct cmsghdr *cmsg, int offset) {
   struct ipv6_rt_hdr0 *hdr0;
   __u8 *ptr, byte, bit;
   
   hdr0 = (struct ipv6_rt_hdr0 *)(cmsg + 1);
   
   if ((hdr0->type)||(hdr0->hdrlen % 2))
      return -1;
   
   if (offset > (hdr0->hdrlen / 2) -1)
      return -1;
   
   ptr = ((__u8 *)hdr0->bitmap) + 1;
   
   byte = offset>>3;
   bit  = offset - byte<<3;
   return (ptr[byte] && (1<< (7-bit)));
}


