/* net/atm/static.c - Staticly allocated resources */

/* Written 1995,1996 by Werner Almesberger, EPFL LRC */


#include <linux/ctype.h>
#include <linux/string.h>
#include <linux/atmdev.h>
#include <asm/segment.h> /* for get_fs_long and put_fs_long */
#include <asm/uaccess.h>
#include "static.h"


#ifndef NULL
#define NULL 0
#endif


struct atm_dev atm_dev[MAX_ATM_ITF];
struct atm_vcc atm_vcc[MAX_ATM_VCC];


void atm_static_init(void)
{
	int i;

	for (i = 0; i < MAX_ATM_ITF; i++) atm_dev[i].ops = NULL;
	for (i = 0; i < MAX_ATM_VCC; i++) atm_vcc[i].family = 0;
}


struct atm_dev *alloc_atm_dev(const char *type)
{
	static int curr_dev = 0;
	int last_dev;

	last_dev = curr_dev;
	do {
		if (!atm_dev[curr_dev].ops) {
			memset(&atm_dev[curr_dev],0,sizeof(struct atm_dev));
			atm_dev[curr_dev].type = type;
			return atm_dev+curr_dev;
		}
		if (++curr_dev == MAX_ATM_ITF) curr_dev = 0;
	}
	while (last_dev != curr_dev);
	return NULL;
}


struct atm_vcc *alloc_atm_vcc(void)
{
	static int curr_vcc = 0;
	int last_vcc;

	last_vcc = curr_vcc;
	do {
		if (!atm_vcc[curr_vcc].family) return atm_vcc+curr_vcc;
		if (++curr_vcc == MAX_ATM_VCC) curr_vcc = 0;
	}
	while (last_vcc != curr_vcc);
	return NULL;
}


void free_atm_dev(struct atm_dev *dev)
{
	dev->ops = NULL;
}


void free_atm_vcc(struct atm_vcc *vcc)
{
	vcc->family = 0;
}


struct atm_dev *atm_find_dev(int number)
{
	int i;

	for (i = 0; i < MAX_ATM_ITF; i++)
		if (atm_dev[i].ops && atm_dev[i].number == number)
			return &atm_dev[i];
	return NULL;
}


int atm_dev_list(int *buffer,int *u_length)
{
	int length,left,i;

	get_user(length, (int *)u_length);
	left = length/sizeof(int);
	if (!left) return -EINVAL;
	for (i = 0; i < MAX_ATM_ITF; i++)
		if (atm_dev[i].ops) {
			if (!left) break;
			put_user(atm_dev[i].number,buffer);
			buffer++;
			left--;
		}
	put_user(length-(length/sizeof(int)-left)*sizeof(int),u_length);
	return length/sizeof(int)-left;
}


void for_all_vccs(void (*fn)(struct atm_vcc *vcc))
{
	int i;

	for (i = 0; i < MAX_ATM_VCC; i++)
		if (atm_vcc[i].family) fn(atm_vcc+i);
}
