/* net/atm/ipcommon.h - Common items for all ways of doing IP over ATM */

/* Written 1996 by Werner Almesberger, EPFL LRC */


#ifndef NET_ATM_IPCOMMON_H
#define NET_ATM_IPCOMMON_H


#include <linux/string.h>
#include <linux/skbuff.h>
#include <linux/netdevice.h>
#include <linux/atmdev.h>
#include <linux/atmclip.h>


extern const unsigned char llc_oui[6];
extern struct device *clip_devs;


#define CLIP(dev) ((struct clip_priv *) ((struct device *) (dev)+1))


struct clip_priv {
	char name[8];			/* interface name */
	int number;			/* for convenience ... */
	struct atm_vcc *vcc;
	struct enet_statistics stats;
	struct clip_priv *next;		/* next CLIP interface */
};


extern struct clip_priv *old_clip_devs;


static inline void ipcom_push(struct sk_buff *skb)
{
   skb->mac.raw = skb->data;
   printk("dev = %s\n", skb->dev->name);
   if (!skb->dev->hard_header_len) {
/*
#if defined(__LITTLE_ENDIAN_BITFIELD)
	   if((skb->data[0] & 0xF) == 0x6) {
#elif defined (__BIG_ENDIAN_BITFIELD)	
*/
      if (((skb->data)[0] & 0xF0) == 0x60) { /* IPv6 */
	 skb->protocol = htons(ETH_P_IPV6);
	 printk(KERN_DEBUG "Proto = ETH_P_IPV6 %X\n", ((unsigned short *) skb->data)[0]);
      } else {
	 skb->protocol = htons(ETH_P_IP);
	 printk(KERN_DEBUG "Proto = ETH_P_IP %X\n", ((unsigned short *) skb->data)[0]);
      }
   } else if (skb->len < RFC1483LLC_LEN || 
	      memcmp(skb->data,llc_oui, sizeof(llc_oui))) {
      skb->protocol = 0; /* probably wrong encap ... */
      printk(KERN_DEBUG "Proto = 0\n");
   } else {
      skb->protocol = ((unsigned short *) skb->data)[3];
      printk(KERN_DEBUG "Proto = %X\n", ((unsigned short *) skb->data)[3]);
      skb_pull(skb,RFC1483LLC_LEN);
   }
   skb->h.raw = skb->nh.iph = skb->data;
   CLIP(skb->dev)->stats.rx_packets++;
   printk(KERN_DEBUG "Proto = %X
\n",   skb->protocol);
   netif_rx(skb);
}


static inline void ipcom_xmit(struct device *dev,struct atm_vcc *vcc,
    struct sk_buff *skb)
{
   if (dev->hard_header_len) {
      printk(KERN_DEBUG "DHHL: %d %d Version1 = %X\n", dev->hard_header_len, RFC1483LLC_LEN, skb->data[RFC1483LLC_LEN]);
      memcpy(skb->data,llc_oui,sizeof(llc_oui));
      /* IPv6 */
      printk(KERN_DEBUG "Version1bis = %X\n", skb->data[RFC1483LLC_LEN]);
      printk(KERN_DEBUG "Version1bis = %X\n", (skb->data[RFC1483LLC_LEN] & 0xF));
      printk(KERN_DEBUG "Version1bis = %X\n", (skb->data[RFC1483LLC_LEN] & 0xF0));
      /*      
#if defined(__LITTLE_ENDIAN_BITFIELD)
      if((skb->data[RFC1483LLC_LEN] & 0xF) == 0x6) {
#elif defined (__BIG_ENDIAN_BITFIELD)
*/
      if((skb->data[RFC1483LLC_LEN] & 0xF0) == 0x60) { /* IPv6 */        
	 printk(KERN_DEBUG "Sending IPv6\n");
	 ((unsigned short *) skb->data)[3] = htons(ETH_P_IPV6); /* hack */
      } else {
	 printk(KERN_DEBUG "Sending IPv4\n");
	 ((unsigned short *) skb->data)[3] = htons(ETH_P_IP); /* hack */
      }
   } else {
      printk(KERN_DEBUG "Version2 = %X\n", skb->data[0]); 
   }
   atomic_add(skb->truesize,&vcc->tx_inuse);
   skb->atm.iovcnt = 0;
   vcc->dev->ops->send(vcc,skb);
}


struct sk_buff *atm_peek_clip(struct atm_vcc *vcc,unsigned long pdu_size,
    __u32 (*fetch)(struct atm_vcc *vcc,int i));
void atm_pop_clip(struct atm_vcc *vcc,struct sk_buff *skb);
void ipcom_init(struct device *dev,
    int (*hard_start_xmit)(struct sk_buff *skb,struct device *dev),
    unsigned short extra_flags);
int ipcom_pick_number(int number);

#endif
