/* net/atm/dev.c - ATM device registeration */

/* Written 1995,1996 by Werner Almesberger, EPFL LRC */


#include <linux/atmdev.h>
#include <linux/kernel.h>
#include <linux/uio.h>

#include "static.h"


struct atm_dev *atm_dev_register(const char *type,const struct atmdev_ops *ops,
    unsigned long flags)
{
	volatile struct atm_dev *dev; /* need volatile to ensure sequence */

	dev = alloc_atm_dev(type);
	if (!dev) {
		printk(KERN_ERR "atm_dev_register: no space for dev %s\n",
		    type);
		return NULL;
	}
	dev->number = 0;
	while (atm_find_dev(dev->number)) dev->number++;
	dev->vccs = dev->last = NULL;
	dev->dev_data = NULL;
	dev->ops = ops;
	dev->flags = flags;
	memset((void *) &dev->stats,0,sizeof(struct atm_dev_stats));
	return (struct atm_dev *) dev;
}


void atm_dev_deregister(struct atm_dev *dev)
{
	free_atm_dev(dev);
}
