/* net/atm/common.h - ATM sockets (common part for PVC and SVC) */
 
/* Written 1995 by Werner Almesberger, EPFL LRC */


#ifndef NET_ATM_COMMON_H
#define NET_ATM_COMMON_H

#include <linux/net.h>

int atm_create(struct socket *sock,int protocol);
int atm_release(struct socket *sock,struct socket *peer);
int atm_connect(struct socket *sock,int itf,short vpi,int vci);
int atm_recvmsg(struct socket *sock,struct msghdr *m,int total_len,
    int flags, struct scm_cookie *scm);
int atm_sendmsg(struct socket *sock,struct msghdr *m,int total_len,
  struct scm_cookie *scm);
unsigned int atm_select(struct socket *sock,poll_table *wait);
int atm_ioctl(struct socket *sock,unsigned int cmd,unsigned long arg);
int atm_setsockopt(struct socket *sock,int level,int optname,char *optval,
    int optlen);
int atm_getsockopt(struct socket *sock,int level,int optname,char *optval,
    int *optlen);

int atm_release_vcc(struct atm_vcc *vcc,int free_vcc);

/* SVC */

int copy_svc_addr(struct sockaddr_atmsvc *to,struct sockaddr_atmsvc *from);
void svc_callback(struct atm_vcc *vcc);

#endif
