/* net/atm/clip.c - Classical IP over ATM */
 
/* Written 1995-1997 by Werner Almesberger, EPFL LRC */


#include <linux/config.h>
#include <linux/string.h>
#include <linux/kernel.h>
#include <linux/errno.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/skbuff.h>
#include <linux/errno.h>
#include <linux/skbuff.h>
#include <linux/in.h>
#include <linux/mmuio.h>
#include <linux/atmdev.h>
#include <linux/atmclip.h>
#include <net/sock.h>
#include <netinet/in.h>

#include "protocols.h"
#include "common.h"
#include "ipcommon.h"


#if 1
#define DPRINTK(format,args...) printk(KERN_DEBUG format,##args)
#else
#define DPRINTK(format,args...)
#endif


struct clip_priv *old_clip_devs;


/*static*/ void atm_push_clip(struct atm_vcc *vcc,struct sk_buff *skb)
{
	DPRINTK("clip push\n");
	if (!skb) {
		printk(KERN_ALERT "ARGL!\n");
		unregister_netdev((struct device *) vcc->proto_data);
		vcc->proto_data = NULL;
		return;
	}
	skb->dev = vcc->proto_data;
	ipcom_push(skb);
}


static int clip_xmit(struct sk_buff *skb,struct device *dev)
{
	DPRINTK("clip xmit\n");
	if (!CLIP(dev)->vcc) return -ENOTCONN; /* @@@ discard skb ? */
	ipcom_xmit(dev,CLIP(dev)->vcc,skb);
	CLIP(dev)->stats.tx_packets++;
	return 0;
}


#if 0
static int clip_sg_xmit(struct sk_buff *skb,struct device *dev)
{
/*
struct iovec *iov;
int i;

iov = (struct iovec *) skb->data;
for (i = 0; i < skb->atm.iovcnt; i++)
  printk("[%d] 0x%p + %d\n",i,iov[i].iov_base,iov[i].iov_len);

	printk("clip *DIRECT* xmit (iovcnt: %d)\n",skb->atm.iovcnt);
*/
	CLIP(dev)->vcc->dev->ops->send(CLIP(dev)->vcc,skb);
	CLIP(dev)->stats.tx_packets++;
	return 0;
}
#endif


static int clip_init(struct device *dev)
{
	ipcom_init(dev,clip_xmit,0);
	return 0;
}



int atm_init_clip(struct atm_vcc *vcc)
{
	struct device *dev;

	DPRINTK("atm_init_clip\n");
	if (!suser()) return -EPERM;
	vcc->aal = ATM_AAL5;
	vcc->push = atm_push_clip;
	vcc->peek = atm_peek_clip;
	vcc->pop = atm_pop_clip;
	vcc->push_oam = NULL;
	vcc->proto_data = dev = kmalloc(sizeof(struct device)+
	    sizeof(struct clip_priv),GFP_KERNEL);
	if (!dev) return -ENOMEM;
	memset(dev,0,sizeof(struct device)+sizeof(struct clip_priv));
	dev->name = CLIP(dev)->name;
	CLIP(dev)->number = ipcom_pick_number(-1);
	sprintf(dev->name,"atm%d",CLIP(dev)->number);
	dev->init = clip_init;
	CLIP(dev)->vcc = vcc;
	if (register_netdev(dev)) return -EIO;
		/* if register_netdev can sleep, we race on ->number */
	CLIP(dev)->next = old_clip_devs;
	old_clip_devs = CLIP(dev);
	DPRINTK("registered %s,0x%p\n",dev->name,vcc);
	return CLIP(dev)->number;
}
