/**************************************************************************\
*          Copyright (c) 1995 INRIA Sophia Antipolis, FRANCE.              *
*                                                                          *
* Permission to use, copy, modify, and distribute this material for any    *
* purpose and without fee is hereby granted, provided that the above       *
* copyright notice and this permission notice appear in all copies.        *
* WE MAKE NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS     *
* MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS   *
* OR IMPLIED WARRANTIES.                                                   *
\**************************************************************************/
/**************************************************************************\
*  File    :             	                			   *
*  Date    : 1995/11/16		           				   *
*  Author  : Andres Vega-Garcia						   *
*--------------------------------------------------------------------------*
*  Description : Second version                                            *
*                                                                          *
*                                                                          *
*                                                                          *
*--------------------------------------------------------------------------*
*        Name	        |    Date   |          Modification                *
*--------------------------------------------------------------------------*
*                       |           |                                      *
*                       |           |                                      *
\**************************************************************************/
#ifndef _fair_sch_h_
#define _fair_sch_h_

#define fs_free(ptr,type) free(ptr,type)
/* #define fs_gettime() time.tv_sec */

/*
 * Hack to allow droping packets in the output buffer 
 * and avoid the uncontrolled droping in 
 * the ip_output.c/ip_output() routine.
 *
 * Replace IF_QFULL in if_ethersubr.c and if_ppp.c
 */
#define	IF_FS_QFULL(ifq)	((ifq)->ifq_len >= IFQ_MAXLEN*9/10)


#include <net/tc_global.h>
#include <net/tc_hash.h>
#include <net/tc_queue.h>

#define MAX_FS_CTX 32
#define MAX_FS_SES 64

#define MAX_FS_TAG (1<<(sizeof(int)*8-2))	/* 2^(bits-2) */
#define FS_MAGIC  0x4ef6755d

#define FS_PKT_LEN (sizeof(fs_pkt_t))

#define FS_OLDP   (5*60) /* seconds */
#define FS_CYCLE   17    /* seconds */
#define FS_UP_MASK 0xf   /* packets received */

#define fg_par(l)   (1<<(l))
#define fg_tst(f,l) ((f) &  fg_par(l))
#define fg_set(f,l) ((f) |= fg_par(l))
#define fg_rst(f,l) ((f) &=~fg_par(l))
#define fg_inv(f,l) ((f) = (f) ^ fg_par(l))

#define fs_tst(f) fg_tst(fsc->fsc_flag,f)
#define fs_set(f) fg_set(fsc->fsc_flag,f)
#define fs_rst(f) fg_rst(fsc->fsc_flag,f)
#define fs_inv(f) fg_inv(fsc->fsc_flag,f)

/* A per session structure (Fair Scheduling Session - fss) */
struct fs_ses_t {
    struct fs_ses_t *next;     /* Next context while queueing */
    struct fs_ses_t *prev;     /* Prev context while queueing */

    struct fs_ses_t *nexth;    /* Next context while hashing */
    struct fs_ses_t *prevh;    /* Prev context while hashing */
    u_int32 key0;               /* Primary key */
    u_int32 key1;               /* Secondary key */
   
    struct tc_class *tccp;
    struct fs_ses_t *fss;
   
    u_int id;                   /* Session ID */

    char af_family;             /* Address family for this session */
    char proto;                 /* Protocol for INET */
    u_int16 fss_flag;           /* Flags */

    char data[12];              /* Information data (e.g. src & dst IP addr) */

    /* Uping the session */
    u_int fss_n;                /* Total packets enqueued in this session */

    /* Counters */
    u_int fss_npkts;            /* Packets sent in this session */
    u_int fss_nbytes;           /* Bytes sent in this session */
    u_int fss_drop;             /* Number of packets droped in queue */
    u_int fss_dropl;            /* Number of packets droped as last */

    /* Algorithm information */
    u_int fss_F_1;		/* Tag of last packet from this session */
    long fss_last;              /* Last time (s) this session had traffic */
};

/* A per interface structure (Fair Scheduling Context - fsc)*/
struct fs_ctx_t {
    /* General information */

    struct headq_t headq;              /* All its sessions in a circular queue */
    struct headh_t rooth;              /* All its sessions in a hash */
    struct fs_ses_t *fifoses;          /* Session for FIFO traffic */


    struct fs_pkt_t *fs_head;  /* Points to the head of the fs packet list */
    struct fs_pkt_t *fs_tail;  /* Points to the tail of the fs packet list */
   
    /* Algorithm */
    /*int fsc_k; Current number of sessions is obteined with headq.count */
    u_int fsc_v;                /* Packet being transmited's tag (t) */

    long fsc_last;              /* Last time we did session aging */

    /* Counters */
    u_int fsc_nrst;		/* Number of reset's to the virtual time v(t)*/
    u_int fsc_free_lru;		/* LRU sessions freed */
    u_int fsc_collision;	/* Hash collisions counter */
    u_int fsc_last_error;       /* Remembers the last error ocurred */
    enum {
	EFS_NOMORESCHS=1,       /* No more free fs_ses_t structures */
	EFS_COLLISION,          /* Hash collision */
	EFS_FREELRU             /* LRU sessions freed */
    };

   /* packet counters */
   long ip;
   long ip6;
   long arp;
   long others;
   
    /* Context parameters */
    u_int fsc_npkts;     /* # of Packets in all Queues */
   
    u_int fsc_ses_id;    /* For allocating session's ID */
    int   fsc_policy;    /* Current policy */
    u_int fsc_max_ses;   /* Max sessions allowed in this context */
    long  fsc_cycle;     /* How often verify aging with fs_oldp */
    long  fsc_oldp;      /* Period to discard old sessions */
    u_int fsc_up_mask;   /* How many packet recived to up-ing the session */
    u_int fsc_flag;      /* Some global flags */
    int fsc_next_policy; /* Next policy to install when DEBUG_SET_POLICY */
    u_int fsc_max_dump;  /* Max number of items to dump from ifq */
    u_int fsc_usr0;
    u_int fsc_usr1;
    enum {
	DEBUG_USER,
	DEBUG_DROP,
	DEBUG_KEY,
	DEBUG_LOOKUP,

	DEBUG_TAG,
	DEBUG_HOUSEK,
	DEBUG_ENQUEUE,
	DEBUG_DEQUEUE,

	DEBUG_SET_POLICY
    };
    enum { /* !!!! Order here MUST match order in this structure !!!! */
	ST_FSC_POLICY,
	ST_FSC_MAX_SES,
	ST_FSC_CYCLE,
	ST_FSC_OLDP,
	ST_FSC_UP_MASK,
	ST_FSC_FLAG,
	ST_FSC_NEXT_POLICY,
	ST_FSC_MAX_DUMP,
	ST_FSC_USR0,
	ST_FSC_USR1,
	ST_FSC_LAST
    };
   struct device *fsc_dev;    /* Points to its network device structure */
};

/* A per packet structure */
struct fs_pkt_t {	/* A per mbuf chain (packet) structure */
    u_int fsp_magic;		/* Identification tag */
    u_int fsp_F;		/* Packet's tag */
    u_int fsp_F_1;              /* Previous packet's tag */
    struct fs_pkt_t *next;
    struct fs_pkt_t *prev;
    struct sk_buff *skbp;    /* Previous packet in ifqueue (circular queue) */
    struct fs_ses_t *fsp_fss;		/* Owner session of this packet */
};

/* The global Fair Scheduling parameters */
struct fsched_t {
    int fs_max_ctx; /* Max number of Fair Scheduling context */
    int fs_max_ses; /* Max number of Fair Scheduling sessions */
    int fs_max_policy;/* Number of policies */
    long  fs_ctime;   /* The current time */
    enum { /* !!!! Order here MUST match order in this structure !!!! */
	PAR_FS_MAX_CTX,
	PAR_FS_CTX_ID,
	PAR_FS_MAX_SES,
	PAR_FS_MAX_POLICY,
	PAR_LAST
    };
};

struct fs_desc_t_ {
    int policy;
    enum { /* Assigned IDs to the different policies */
	GLOB_FS_POLICY_FIFO,
	GLOB_FS_POLICY_FQ
    };
    void (*install)(struct fs_ctx_t *);
};

int fs_install(struct fs_ctx_t *fsc);
struct fs_ses_t *fs_malloc_ses(void);
void fs_free_ses(struct fs_ses_t *fss);

#endif
extern struct fs_ses_t *fq_lookup(struct fs_ctx_t *fsc,struct sk_buff *m);
