/**************************************************************************\
*          Copyright (c) 1995 INRIA Sophia Antipolis, FRANCE.              *
*                                                                          *
* Permission to use, copy, modify, and distribute this material for any    *
* purpose and without fee is hereby granted, provided that the above       *
* copyright notice and this permission notice appear in all copies.        *
* WE MAKE NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS     *
* MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS   *
* OR IMPLIED WARRANTIES.                                                   *
\**************************************************************************/
/**************************************************************************\
*  File    :             	                			   *
*  Date    : 1995/04/20		           				   *
*  Author  : Andres Vega-Garcia						   *
*--------------------------------------------------------------------------*
*  Description :                                                           *
*                                                                          *
*                                                                          *
*                                                                          *
*--------------------------------------------------------------------------*
*        Name	        |    Date   |          Modification                *
*--------------------------------------------------------------------------*
*                       |           |                                      *
*                       |           |                                      *
\**************************************************************************/
#ifndef _tc_queue_h_
#define _tc_queue_h_

/*
 * WARNING: pay attention to the fact that the hash and queue
 * structures are closely related.
 */

struct elemq_t {
    struct elemq_t *next;
    struct elemq_t *prev;
};

struct headq_t {
    struct elemq_t *hd;
    int count;
    int dummy;
} ;

#define inithdrq(hq) (hq)->hq=(headq_p)0,);(hq)->count=0
#define emptyq(hq) (!(hq)->count)

struct elemq_t *enqueuef(struct headq_t *head, struct elemq_t *e);
struct elemq_t *enqueuel(struct headq_t *hd,   struct elemq_t *e);
struct elemq_t *enqueuep(struct headq_t *head, struct elemq_t *p, struct elemq_t *e);
#define enqueue(hd,e) enqueuel((hd),(e))
struct elemq_t *dequeuep(struct headq_t *head, struct elemq_t *e);
#define dequeuef(hq) dequeuep((hq),(hq)->hd)
#define dequeuel(hq) dequeuep((hq),(hq)->hd->prev)
#define dequeue(hq) dequeuef((hq))
struct elemq_t *queue_up(struct headq_t *head, struct elemq_t *e);
struct elemq_t *in_queue(struct headq_t *head, struct elemq_t *e);

#endif
