/**************************************************************************\
*          Copyright (c) 1997 INRIA Sophia Antipolis, FRANCE.              *
*                                                                          *
* Permission to use, copy, modify, and distribute this material for any    *
* purpose and without fee is hereby granted, provided that the above       *
* copyright notice and this permission notice appear in all copies.        *
* WE MAKE NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS     *
* MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS   *
* OR IMPLIED WARRANTIES.                                                   *
\**************************************************************************/
/**************************************************************************\
*  File    :             	                			   *
*  Date    : 1997/02/11		           				   *
*  Author  : Martin May           					   *
*--------------------------------------------------------------------------*
*  Description :                                                           *
*                                                                          *
*                                                                          *
*                                                                          *
*--------------------------------------------------------------------------*
*        Name	        |    Date   |          Modification                *
*--------------------------------------------------------------------------*
*                       |           |                                      *
*                       |           |                                      *
\**************************************************************************/
#ifndef _tc_hash_h_
#define _tc_hash_h_

#include <net/tc_types.h>

#define HASH_WIDTH       4 /* hash table's size is 2**HASH_WIDTH */
#define HASH_MAX_LINEAR  8
#define HASH_MAX         (1<<HASH_WIDTH)
#define HASH_MASK        (HASH_MAX-1)
#define HASH_MAX_LEVEL   (sizeof(u_int32)*8/HASH_WIDTH)

/*
 * WARNING: pay attention to the fact that the hash and queue
 * structures are closely related.
 */

struct elemh_t {
   struct elemh_t *next;
   struct elemh_t *prev;
   u_int32 key0;
   u_int32 key1;
   struct tc_class *tccp;
   struct fs_ses_t *fss;
};

struct headh_t {
    struct headh_t *hd;
    int count;   /* when this is a normal queue, the element's number */
    int size;    /* the hash table's size, 0 if normal queue */
};

struct elemh_t *hash_lookup(struct headh_t *root,
			    u_int32 key0,
			    u_int32 key1,
			    u_int32 *stat);

struct elemh_t *hash_insert(struct headh_t *root,struct elemh_t *elem);
void hash_delete(struct headh_t *root,struct elemh_t *elem,u_int32 key);

#define hash_insert_tc(root,_fss) hash_insert(root, \
					      (struct elemh_t *)&((_fss)->nexth))
#define hash_delete_tc(root,_fss) hash_delete(root, \
					      (struct elemh_t *)&((_fss)->nexth), \
					      (_fss)->key0)
     
     /*     extern struct elemh_t *hash_insert(struct headh_t *root, struct elemh_t *elem);*/
     
#endif /* _tc_hash_h_ */
