/**************************************************************************\
*          Copyright (c) 1997 INRIA Sophia Antipolis, FRANCE.              *
*                                                                          *
* Permission to use, copy, modify, and distribute this material for any    *
* purpose and without fee is hereby granted, provided that the above       *
* copyright notice and this permission notice appear in all copies.        *
* WE MAKE NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS     *
* MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS   *
* OR IMPLIED WARRANTIES.                                                   *
\**************************************************************************/
/**************************************************************************\
*  File    :             	                			   *
*  Date    : 1997/11/02		           				   *
*  Author  : Martin May           					   *
*--------------------------------------------------------------------------*
*  Description :                                                           *
*                                                                          *
*                                                                          *
*                                                                          *
*--------------------------------------------------------------------------*
*        Name	        |    Date   |          Modification                *
*--------------------------------------------------------------------------*
*                       |           |                                      *
* Laurent Pautet        | 1998/02/08| Adding IPv6 management for T.C.      *
\**************************************************************************/

#ifndef _net_cbq_h
#define _net_cbq_h

#include <linux/socket.h>
#include <linux/skbuff.h>
#include <linux/in.h>
#include <linux/time.h>
#include <linux/malloc.h>
#include <linux/mm.h>
#include <net/tc_types.h>
#include <net/tc_hash.h>
#include <net/tc_wfq.h>


#define RM_MAXPRIO       8	/* priorities run 0..7 */
#define RM_FILTER_GAIN   5	/* log2 of gain, e.g., 5 => 31/32 */
#define TC_MAX_QUEUE_LEN 100
#define TC_MAX_K         64

#define DEBUG_HASH
#define DEBUG_FS
#define FS_DEBUG


#define FREE_READ 1


/* added by Martin */
#define new_kmem_zalloc(size,flag) kmalloc(size,flag)
#define kmem_free(x,size) kfree_skb(x, FREE_READ);

#define KMEM_SLEEP 0x0001       /* instead M_NOWAIT */
/* end add*/

struct tc_class {
	struct sk_buff *tail;		/* tail of circularly linked output q */
	struct timeval	last;		/* time last packet sent */
	struct timeval	undertime;	/* time can next send */
	int	sleeping;		/* != 0 if delaying */
	int	qcnt;			/* # packets in queue */
	int	avgidle;

	int	npackets;		/* packets sent in this class */
	int	nbytes;			/* bytes sent in this class */
	int	over;			/* # times went over limit */
	int	borrows;		/* # times tried to borrow */
	int	drops;			/* # times dropped packets */
	int	overactions;		/* # times invoked overlimit action */

	struct tc_class *peer;
	struct tc_class *borrow;
	struct tc_class *parent;
	struct tc_ifdat *ifdat;
	int	priority;
	int	maxidle;
	int	offtime;
	int	qmax;
	void	(*overlimit)(struct tc_class *cl);
	int	len2time[1536];		/*XXX - should be based on if mtu */
        struct tc_flow_info *flow;
};

struct tc_ifdat {
   int	queued;		           /* # packets queued downstream */
   
   int  queued7;
   int  queued6;
   int  queued5;
   int  queued4;
   int  queued3;
   int  queued2;
   int  queued1;
   int  queued0;
   int	csum;
   struct tc_class *class;	   /* class we're currently sending */
   int	curlen;		           /* size of packet we're sending */
   struct tc_class *defaultclass;  /* added by Martin */ 
   struct tc_class *rootclass;     /* Rootclass */
   struct device *dev;
   void	(*restart)(struct tc_class *cl);
   int	maxqueued;	           /* max packets we can queue downstream */
   struct tc_class *classlist[RM_MAXPRIO];
   int	activecnt[RM_MAXPRIO];
   struct tc_class *classes[RM_MAXPRIO];
   /* tc state information */
   int drops7;
   int drops6;
   int drops5;
   int drops4;
   int drops3;
   int drops2;
   int drops1;
   int drops0;
   int nr_of_classes;
   int nr_of_flows;
   u_long  bandwidth;
   u_long  filter_handels;
   /* the class table with pointers to all classes */
   struct tc_class      **class_table;
   
   struct tc_share *tc_share;
   struct headh_t rooth; 
};

extern u_char rmc_mask2pri[];

extern struct tc_class *rmc_newclass(int pri,struct tc_ifdat *ifdat,
				     u_int nsecPerByte,void (*action)(struct tc_class *cl),
				     int maxq,struct tc_class *parent,struct tc_class *borrow,
				     u_int maxidle,u_int offtime);
extern void rmc_init(struct device *ifp,struct tc_ifdat *ifdat,
		     u_int nsecPerByte,void (*restart)(struct tc_class *cl),
		     int maxq, int maxqueued);
extern int rmc_under_limit(struct tc_class *cl);
extern struct sk_buff *rmc_dequeue_next(struct tc_ifdat *ifd);
extern void rmc_queue_packet(struct tc_class *cl,struct sk_buff* m);
extern void rmc_update_util(struct tc_ifdat *ifd);
extern void rmc_drop_action(struct tc_class *cl);
extern void rmc_delay_action(struct tc_class *cl);
extern void rmc_restart(struct tc_class *cl);
void tc_classify_cbq(struct tc_ifdat *tcdp, struct sk_buff *skb);

#endif /* _net_cbq_h */

#ifndef _net_tc_h
#define _net_tc_h

/* Packet filter descriptor - describes packets belonging to a flow. 
 */


typedef struct _filt tc_filt_t;
struct _filt {
  int f_pf;				/* Family (only PF_INET now) */
  union {
    struct {
      __u32 _f_srcaddr;	          /* IP source address */
      __u32 _f_destaddr;	  /* IP dest address */
      __u16 _f_srcport;	          /* TCP/UDP source port */
      __u16 _f_destport;	  /* TCP/UDP dest port */
      __u8  _f_protocol;	  /* Xport protocol (IPPROTO_UDP, etc) */
    } _f_ipv4;
    struct {
      __u32 _f_vrprflow;          /* IPv6 flowlabel + version + priority */
      struct in6_addr _f_srcaddr; /* IPv6 source address */      
      struct in6_addr _f_destaddr;/* IPv6 dest address */
      __u8  _f_protocol;	  /* Xport protocol (IPPROTO_UDP, etc) */
    } _f_ipv6;
  } _f_spec;
};

#define f_ipv4_srcaddr	_f_spec._f_ipv4._f_srcaddr
#define f_ipv4_destaddr	_f_spec._f_ipv4._f_destaddr
#define f_ipv4_srcport	_f_spec._f_ipv4._f_srcport
#define f_ipv4_destport	_f_spec._f_ipv4._f_destport
#define f_ipv4_protocol	_f_spec._f_ipv4._f_protocol

#define f_ipv6_destaddr	_f_spec._f_ipv6._f_destaddr
#define f_ipv6_srcaddr	_f_spec._f_ipv6._f_srcaddr
#define f_ipv6_vrprflow _f_spec._f_ipv6._f_vrprflow
#define f_ipv6_protocol	_f_spec._f_ipv6._f_protocol

/* Service specification ("flowspec") - describes quality of service
 * desired for a flow.
 */

/* Basic type of service: determines scheduling algorithm */
typedef enum {
    TOS_GUARANTEED = 1,
    TOS_PREDICTIVE,
    TOS_GXLOAD,
    TOS_CLOAD,
    TOS_DATAGRAM,
} tc_tos_t;


/* Per-service RSPEC definitions */
typedef struct {
    __u32 g_rate;		/* GUARANTEED: flow rate parameter	*/
} g_rspec_t;

typedef struct {
    __u32 p_dly;		/* PREDICTIVE: delay target parameter	*/
    				/* May also be used as priority..	*/
} p_rspec_t;

typedef union {
    g_rspec_t rs_g;	/* TOS_ST_GUARANTEED			*/
    p_rspec_t rs_p;	/* TOS_ST_PREDICTIVE			*/
    p_rspec_t rs_cl;    /* TOS_ST_CONTROLLED_LOAD               */
} rspec_t;

/* Traffic spec (TSPEC) definitions */
typedef struct {
    __u32 tbf_bkt;		/* tbf bucket size: bits		*/
    __u32 tbf_rate;		/* tbf rate: bits/sec			*/
    __u32 tbf_buf;		/* tbf reshaping buffer size (currently MBZ)*/
} tbf_t;

typedef struct {
    tbf_t ts_tb;
} tspec_t;

/* Policing/reshaping algorithm selector */
typedef enum {
    PLC_NONE,			/* No policing				*/
    PLC_TBF2,			/* Two-parameter token bucket filter	*/
    PLC_TBF3,			/* Three-param TBF -unimplemented-	*/
} plc_t;

/* 
 * Missing: PSPEC.  At the moment TSPEC information is used both to
 * drive admission control and to drive policing and reshaping. This
 * is almost certainly incorrect, and a new PSPEC structure will
 * eventually be required...
 */


/* Overall flow spec passed to scheduler. */
typedef struct {
    tc_tos_t fs_tos;	/* service type				*/
    rspec_t fs_rspec;	/* rspec parameters for requested svc	*/
    tspec_t fs_tspec;	/* policing parameters			*/
    plc_t fs_plc;       /* policing algorithm selector		*/
    long fs_handle;	/* handle of share tree node associated */
			/*   with this flow			*/
} tc_fs_t;

typedef struct {
   int  tc_prio;        
   long tc_bandwidth;  
   long tc_off;
   long tc_maxidle;
} tc_clval;

#define IFNAMSIZ 16

struct tcreq {
   char iq_name[IFNAMSIZ];		/* if name, e.g. "en0"       */
   short iq_function;			/* function code             */
   short iq_flags;			/* further info about fcn    */
   long iq_handle;		 /* call/ret - object handle  */
   long iq_fhdl;		 /* filter handle	     */
   union {
      tc_clval   _iq_clval;
      tc_fs_t    _iq_fs;
      tc_filt_t  _iq_filt;
   } _iq_union;
};

#define iq_fs    _iq_union._iq_fs
#define iq_filt  _iq_union._iq_filt
#define iq_clval _iq_union._iq_clval

/* Definitions for iq_handle */
#define TC_CBQ          0x01
#define TC_WFQ          0x02
#define TC_WFQ2         0x09
#define TC_PRICING      0x03
#define TC_1BIT         0x04
#define TC_2BIT         0x05
#define TC_TEST         0x0a

/* Definitions for IP-Type of Service fields */
#define  IPTOS_WFQ      0x20


/* Functions (in iq_function) */
#define IF_ENABLE	0x01	/* enable TC for interface      	*/
#define	IF_DISABLE	0x02	/* disable TC for interface      	*/
#define	IF_ADDCLS	0x03	/* add predictive svc  class		*/
#define	IF_DELCLS	0x04	/* delete predictive svc class		*/
#define	IF_ADDSHARE	0x05	/* add share tree node			*/
#define	IF_DELSHARE	0x06	/* delete share tree node		*/
#define	IF_ADDFLOW	0x07	/* add flow				*/
#define	IF_DELFLOW	0x08	/* delete flow				*/
#define	IF_MODFLOW	0x09	/* modify existing flow's parameters	*/
#define	IF_ADDFILT	0x0a	/* set packet filter for flow		*/
#define IF_DELFILT	0x0b	/* delete filter from flow		*/
#define IF_ASKSTATE	0x0c    /* ask for tc state                     */
#define IF_ISTAT        0x0d    /* interface statistics                 */
#define IF_RESET        0x0e    /* reset reservation state		*/


/* struct fs_ses_t *tc_classify_wfq(struct fs_ctx_t *fsc, struct sk_buff *skb);*/
/* void tc_classify_test(struct tc_ifdat *tcdp, struct sk_buff *skb);*/

extern __u32 fss_key(char *src,char *src2);

#endif /* _net_tc_h*/


