#include  <net/tc_global.h>

#define   MAXQ            50      /* Max allowed queue length */
#define   MAXQUEUED       1       /* Max allowed downstream queue */
#define   ENABLE          0x01
#define   DISABLE         0x00
#define   TC_MAX_CLASS    256
#define   NS_PER_SEC 1000000000
#define   NS_PER_MS  1000000

#define   NULL_CLASS_HANDLE    0xffffffff
#define   DEFAULT_CLASS_HANDLE 0xfffffffe
#define   ROOT_CLASS_HANDLE    0xfffffffd



struct tc_share{
   struct tc_share *next;
   u_long           handle;
   u_int            prio;
   u_int            bandwidth;
   u_int       	    allocated;
   u_int	    maxdelay;
   u_int            maxburst;
   u_int            av_pkt_size;
   struct tc_flow_info *flinfo;
};

struct tc_flow_info{
   struct isps_flow_info *next;
   tc_tos_t              type;
   u_long                bandwidth;
   u_int32_t             tbf_bkt;
   u_int32_t             tbf_rate;
   u_int32_t             tbf_buf;
   u_long                handle;
   u_long                num_filt;
   struct tc_filterinfo *finfo;
};

struct tc_filterinfo {
   struct tc_filterinfo *next;
   long         filter_handle;
   __u32        key0;
   __u32        key1;
};

