/*
 * DRET-IPv6	An implementation of the TCP/IP protocol suite for the LINUX
 *		operating system.  INET6 is implemented using the BSD Socket
 *		interface as the means of communication with the user level.
 *
 * Contacts:	
 *              INRIA      <Christophe.Diot@sophia.inria.fr>
 *              MASI       <Eric.Horlait@masi.ibp.fr>
 *              This software has been developped with the financial support
 *              of DRET (French Military Research Agency).
 *
 * Version:    $Id: udp6.h,v 1.8 1997/03/10 16:10:10 pan Exp $ 
 *	
 * Authors:	
 *	        name	<E_mail>
 *
 *
 * Fixes:
 *
 *
 * Description:
 *
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 *              This notice must be copied with the distributed package.
 *
 *		Portions of the software are derived from  various 
 *		networking code publicly available, mainly:
 *			NRL IPv6 code 
 *			NetBSD code from INRIA (Francis.Dupont@inria.fr)
 *			Pedro Roque's Linux version (Roque@di.fc.up.pt)
 *
 */		
#ifndef _UDP6_H
#define _UDP6_H

#include <linux/udp.h>

#include <net/dret/protocol6.h>

extern struct proto udp6_prot;


/* Store info to compute checksum */
struct udp6_fake_header {
	struct in6_addr *daddr;  /* destination address */
	struct udphdr uh;        /* UDP header */
	struct iovec *iov;       /* the stored message */
	int len;                 /* total length of message */
	unsigned short csum;     
};

extern int udp6_rcv(struct sk_buff *skb, 
		    struct device *dev,		     
		    struct in6_addr *saddr,
		    struct in6_addr *daddr,
		    struct options *opt,
		    unsigned short len, 		    
		    int redo, 
		    struct inet6_protocol *protocol);

extern void udp6_err(int type, int code, unsigned char *buff, __u32 info,
	       struct in6_addr *saddr, struct in6_addr *daddr,
	       struct inet6_protocol *protocol);
	       
extern void udp6_init(struct net_proto_family *ops);

#endif	/* _UDP6_H */
	
