/*
 *	TCP over IPv6
 *	Linux INET6 implementation 
 *
 *	Authors:
 *	Pedro Roque		<roque@di.fc.ul.pt>	
 *
 *	Id: tcp6.c,v 1.7 1997/01/26 07:14:57 davem Exp 
 *
 *	Based on: 
 *	linux/net/ipv4/tcp.c
 *	linux/net/ipv4/tcp_input.c
 *	linux/net/ipv4/tcp_output.c
 *
 *	This program is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU General Public License
 *      as published by the Free Software Foundation; either version
 *      2 of the License, or (at your option) any later version.
 */
#ifndef _DRET_NET_TCP6_H
#define _DRET_NET_TCP6_H


#include <net/tcp.h>


extern struct proto tcp6_prot;


struct tcp6_open_req {
        struct open_request     req;
        struct in6_addr         loc_addr;
        struct in6_addr         rmt_addr;
        struct options          *opt;
        struct device           *dev;
};


#ifdef __KERNEL__
/*
 * Functions in inet6_protocol
 */
extern int tcp6_rcv(struct sk_buff *skb, 
		    struct device *dev,
		    struct in6_addr *saddr, 
		    struct in6_addr *daddr,
		    struct options *opt, 
		    unsigned short len,
		    int redo, 
		    struct inet6_protocol *protocol);

extern void tcp6_err(int type, 
		     int code, 
		     unsigned char *header, 
		     __u32 info,
		     struct in6_addr *saddr, 
		     struct in6_addr *daddr,
		     struct inet6_protocol *protocol);

extern void tcp6_init(struct net_proto_family *ops);

#endif

#endif
