#ifndef _LINUX_TABLE_TOOLS_H_
#define _LINUX_TABLE_TOOLS_H_
/*--START FUNCTION--(pfx_match)--------------------------------------------
 |
 | Input:   2 ipv6 addresses
 |          a prefix length
 |
 | Returns: 1 if addresses match
 |          0 if addresses mismatch.
 -------------------------------------------------------------------------*/
extern __inline__ int pfx_match(struct in6_addr *a1, struct in6_addr *a2,
				int prefixlen)
{
   int pdw;
   int pbi;

#ifdef IPV6_DEBUG_ROUTE_2
   printk(KERN_DEBUG "[ROUTE]pfx_match: IN, pfx length: %d\n", prefixlen);
   PRINT_ADDR(a1);
   PRINT_ADDR(a2);
#endif
   pdw = prefixlen >> 0x05;	/* # of whole __u32 in prefix */
   pbi = prefixlen & 0x1f;	/* #  of bits in incomplete __u32 in pfx */

   if (pdw) {
      /* Compare prefixes ( 4*pwd bytes) */
      if (memcmp(a1, a2, pdw << 2))
#ifdef IPV6_DEBUG_ROUTE_2
	 printk(KERN_DEBUG "[ROUTE]No match - OUT\n");
#endif 	 
      return 0;
   }
   
   if (pbi) {
      __u32 w1, w2;
      __u32 mask;

      w1 = a1->s6_addr32[pdw];
      w2 = a2->s6_addr32[pdw];

      mask = htonl((0xffffffff) << (0x20 - pbi));
      if ((w1 ^ w2) & mask) {
#ifdef IPV6_DEBUG_ROUTE_2
	 printk(KERN_DEBUG "[ROUTE]No match - OUT\n");
#endif	 
	 return 0;
      }
#ifdef IPV6_DEBUG_ROUTE_2
	 printk(KERN_DEBUG "[ROUTE]Match - OUT\n");
#endif
   }
   return 1;
}
/*--START FUNCTION--(addr_bit)-----------------------------------------
 |
 | Input: an ipv6 address, (in network order)
 |        an integer.
 |
 | Returns: !0 if bit #bit is set in the address, 0 otherwise.
 |
 -------------------------------------------------------------------------*/
extern __inline__ int addr_bit(struct in6_addr *addr, int bit)
{
   int dw;
   __u32 b1;
   __u32 mask;

   /* Find corresponding byte */
   dw = bit >> 0x05;		/* dw = offset of bit's __u32 */
   b1 = addr->s6_addr32[dw];	/* b1 = bit's __u32           */
   mask = htonl((1 << (0x1f - (bit & 0x1f))));	/* bit's position in b1 */
   return (b1 & mask);
}

/*--END FUNCTION--(addr_bit)---------------------------------------------*/

/*--START FUNCTION--(addr_diff)-----------------------------------------------
 |
 | Input: 2 ipv6 addresses,
 |        an int indicating where to start the comparison from.
 |  
 | Returns: the position of the first mismatching bit after start.
 |          (in network order)
 |
 ---------------------------------------------------------------------------*/
extern __inline__ int addr_diff(struct in6_addr *a1, struct in6_addr *a2,
			 int start)
{
   int dw;
   int i;

   dw = start >> 0x5;		/* byte offset of bit 'start' */
   for (i = dw; i < 4; i++) {
      __u32 b1, b2;
      __u32 xb;

      b1 = a1->s6_addr32[i];
      b2 = a2->s6_addr32[i];

      if ((xb = (b1 ^ b2))) {	/* b1 XOR b2 */
	 int res = 0x20;	/* 32 */

	 xb = htonl(xb);	/* xb put in network order */
	 while (xb) {		/* shift right til 0 */
	    res--;
	    xb >>= 1;
	 }
	 return (i << 5) + res;
      }
   }
   return 128;			/* full match */
}
/*--END FUNCTION--(addr_diff)---------------------------------------------*/
#endif
