/*
 * DRET-IPv6	An implementation of the TCP/IP protocol suite for the LINUX
 *		operating system.  INET6 is implemented using the BSD Socket
 *		interface as the means of communication with the user level.
 *
 * Contacts:	
 *              INRIA      <Christophe.Diot@sophia.inria.fr>
 *              MASI       <Eric.Horlait@masi.ibp.fr>
 *              This software has been developped with the financial support
 *              of DRET (French Military Research Agency).
 *
 * Version:    $Id: sit.h,v 1.1 1997/02/12 14:37:22 eh Exp $ 
 *	
 * Authors:	
 *	        name	<E_mail>
 *
 *
 * Fixes:
 *
 *
 * Description:
 *
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 *              This notice must be copied with the distributed package.
 *
 *		Portions of the software are derived from  various 
 *		networking code publicly available, mainly:
 *			NRL IPv6 code 
 *			NetBSD code from INRIA (Francis.Dupont@inria.fr)
 *			Pedro Roque's Linux version (Roque@di.fc.up.pt)
 *
 */				
#ifndef _NET_SIT_H
#define _NET_SIT_H

#include <linux/config.h>

#ifdef CONFIG_NET_IPV6_DIM

struct sit_dev_info {
	__u32			addr;		/* IPv4 destination	*/
        struct device           *dev;           /* sit device           */
        struct sit_dev_info     *next;          /* next tunnel info     */
};

struct sit_mtu_info {
	__u32			addr;		/* IPv4 destination	*/
	unsigned long		tstamp;		/* last use tstamp	*/
	__u32			mtu;		/* Path MTU		*/
	struct sit_mtu_info	*next;
};

extern int				sit_init(void);
extern void				sit_cleanup(void);
extern __u32                            get_sit_end_point(struct device *dev);
extern int                              ipv6_add_tunnel(struct device *dev, 
							struct in6_addr *a);
extern int                              ipv6_del_tunnel(struct device *dev, 
							struct in6_addr *a);

extern struct device sit0_dev;

#define SIT_GC_TIMEOUT		(3*60*HZ)
#define SIT_GC_FREQUENCY	(2*60*HZ)


#endif /* CONFIG_NET_IPV6_DIM */


#endif




