/*
 * DRET-IPv6	An implementation of the TCP/IP protocol suite for the LINUX
 *		operating system.  INET6 is implemented using the BSD Socket
 *		interface as the means of communication with the user level.
 *
 * Contacts:	
 *              INRIA      <Christophe.Diot@sophia.inria.fr>
 *              MASI       <Eric.Horlait@masi.ibp.fr>
 *              This software has been developped with the financial support
 *              of DRET (French Military Research Agency).
 *
 * Version:    $Id: route6.h,v 1.3 1997/03/05 20:46:15 pan Exp $ 
 *	
 * Authors:	
 *	        name	<E_mail>
 *
 *
 * Fixes:
 *
 *
 * Description:
 *
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 *              This notice must be copied with the distributed package.
 *
 *		Portions of the software are derived from  various 
 *		networking code publicly available, mainly:
 *			NRL IPv6 code 
 *			NetBSD code from INRIA (Francis.Dupont@inria.fr)
 *			Pedro Roque's Linux version (Roque@di.fc.up.pt)
 *
 */				
#ifndef _ROUTE6_H
#define _ROUTE6_H

#include <linux/config.h>

#ifdef CONFIG_NET_IPV6_DIM

#include <linux/route.h>
#include <linux/dret/route6.h>
#include <linux/dret/ipv6.h>

#ifdef __KERNEL__

extern atomic_t	table_lock;
extern unsigned table_bh_mask;
extern void table_run_bh(void);

extern __inline__ void table_fast_lock(struct gen_table *table)
{
	atomic_inc(&(table->gt_lock));
}

extern __inline__ void table_fast_unlock(struct gen_table *table)
{
	atomic_dec(&(table->gt_lock));
}

extern __inline__ void table_unlock(struct gen_table *table)
{
	if (atomic_dec_and_test(&(table->gt_lock)) && table_bh_mask)
		table_run_bh();
}


/*
 *     Prototypes
 */
/*
 *     check/obtain destination cache from routing table
 */

extern struct rt_dest * rt_lookup_1(struct in6_addr *addr);
extern struct rt_dest * rt_lookup(struct in6_addr *addr, int local);

extern int ipv6_route_add(struct in6_rtmsg *rtmsg);
extern int ipv6_route_del(struct in6_rtmsg *rtmsg);
extern int ipv6_route_ioctl(unsigned int cmd, void *arg);
extern void ipv6_route_init(void);

extern struct destination * dcache_check(struct destination *dest,
				                struct in6_addr *d, int local);
extern struct destination * route_check(struct in6_addr *d, int local);
extern struct destination * mcast_check(struct device *dev,struct in6_addr *d);
extern void ipv6_dst_unlock(struct destination *dest);
extern void dec_route_use(struct destination * rt);
#endif /* _KERNEL_ */  

#endif

#endif /* _ROUTE6_H */














