/*
 * DRET-IPv6	An implementation of the TCP/IP protocol suite for the LINUX
 *		operating system.  INET6 is implemented using the BSD Socket
 *		interface as the means of communication with the user level.
 *
 * Contacts:	
 *              INRIA      <Christophe.Diot@sophia.inria.fr>
 *              MASI       <Eric.Horlait@masi.ibp.fr>
 *              This software has been developped with the financial support
 *              of DRET (French Military Research Agency).
 *
 * Version:    $Id: raw6.h,v 1.3 1997/03/04 11:42:11 eh Exp $ 
 *	
 * Authors:	
 *	        name	<E_mail>
 *
 *
 * Fixes:
 *
 *
 * Description:
 *
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 *              This notice must be copied with the distributed package.
 *
 *		Portions of the software are derived from  various 
 *		networking code publicly available, mainly:
 *			NRL IPv6 code 
 *			NetBSD code from INRIA (Francis.Dupont@inria.fr)
 *			Pedro Roque's Linux version (Roque@di.fc.up.pt)
 *
 */				
#ifndef _RAW6_H
#define _RAW6_H

#include <linux/config.h>

#ifdef CONFIG_NET_IPV6_DIM

extern struct proto raw6_prot;

extern int  raw6_rcv(struct sock *sk, struct sk_buff *skb);
extern void raw6_init(struct net_proto_family *ops);

/* Store info to compute checksum */
struct raw6_fake_header {
	struct in6_addr daddr;  /* destination address */
	struct iovec *iov;      /* the stored message */
	struct sock *sk;        /* the socket */
	__u32 len;              /* total length of message */
	__u32 csum;             /* checksum (0 means not computed yet) */
	__u32 protocol;         /* protocol number */
};

extern struct sock *get_sock_raw6(struct sock *sk, 
				  unsigned short num,
				  struct in6_addr *raddr,
				  struct in6_addr *laddr);

extern int raw6_rcv_skb(struct sock * sk, struct sk_buff * skb);	

#endif

#endif	/* _RAW6_H */
	






