/*
 * DRET-IPv6	An implementation of the TCP/IP protocol suite for the LINUX
 *		operating system.  INET6 is implemented using the BSD Socket
 *		interface as the means of communication with the user level.
 *
 * Contacts:	
 *              INRIA      <Christophe.Diot@sophia.inria.fr>
 *              MASI       <Eric.Horlait@masi.ibp.fr>
 *              This software has been developped with the financial support
 *              of DRET (French Military Research Agency).
 *
 * Version:    $Id: protocol6.h,v 1.4 1997/03/04 11:42:11 eh Exp $ 
 *	
 * Authors:	
 *	        franck Zago	<zago@masi.ibp.fr>
 *
 *
 * Fixes:
 *		Pascal Anelli   :       Added a info parameter in err_handler
 *
 * Description:
 *		Definitions for the protocol dispatcher.
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 *              This notice must be copied with the distributed package.
 *
 *		Portions of the software are derived from  various 
 *		networking code publicly available, mainly:
 *			NRL IPv6 code 
 *			NetBSD code from INRIA (Francis.Dupont@inria.fr)
 *			Pedro Roque's Linux version (Roque@di.fc.up.pt)
 *
 */				
#ifndef _PROTOCOL6_H
#define _PROTOCOL6_H

#include <linux/config.h>

#ifdef CONFIG_NET_IPV6_DIM

#include <linux/in.h>
#include <net/dret/ipv6.h>

#define MAX_INET_PROTOS	32		/* Must be a power of 2		*/

/* This is used to register protocols. */
struct inet6_protocol {
	int (*handler)(struct sk_buff *skb, 
		       struct device *dev,
		       struct in6_addr *saddr,
		       struct in6_addr *daddr,
		       struct options *opt,
		       unsigned short len, 		       
		       int redo, 
		       struct inet6_protocol *protocol);
	
	void (*err_handler)(int type, 
			    int code, 
			    unsigned char *header,
  			    __u32 info,
			    struct in6_addr *saddr,
			    struct in6_addr *daddr,
			    struct inet6_protocol *protocol);

	void (*proto_init)(struct net_proto_family *ops);
	
	struct inet6_protocol *next;
        unsigned char		protocol;
	unsigned char		copy:1;
	void			*data;
	const char		*name;
};


extern struct inet6_protocol *inet6_protocol_base;
extern struct inet6_protocol *inet6_protos[MAX_INET_PROTOS];


extern void		inet6_add_protocol(struct inet6_protocol *prot);
extern int		inet6_del_protocol(struct inet6_protocol *prot);


#endif

#endif	/* _PROTOCOL_H */

