/*
 * DRET-IPv6	An implementation of the TCP/IP protocol suite for the LINUX
 *		operating system.  INET6 is implemented using the BSD Socket
 *		interface as the means of communication with the user level.
 *
 * Contacts:	
 *              INRIA      <Christophe.Diot@sophia.inria.fr>
 *              MASI       <Eric.Horlait@masi.ibp.fr>
 *              This software has been developped with the financial support
 *              of DRET (French Military Research Agency).
 *
 * Version:    $Id: proc6.h,v 1.3 1997/03/10 16:10:08 pan Exp $ 
 *	
 * Authors:	
 *	        name	<E_mail>
 *
 *
 * Fixes:
 *
 *
 * Description:
 *
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 *              This notice must be copied with the distributed package.
 *
 *		Portions of the software are derived from  various 
 *		networking code publicly available, mainly:
 *			NRL IPv6 code 
 *			NetBSD code from INRIA (Francis.Dupont@inria.fr)
 *			Pedro Roque's Linux version (Roque@di.fc.up.pt)
 *
 */
#ifndef _NET_DRET_PROC6_H_
#define _NET_DRET_PROC6_H_


/* MIB entries in /proc */

extern int snmp6_get_info(char *, char **, off_t, int, int);

extern int afinet6_get_info(char *, char **, off_t, int, int);

extern int raw6_get_info(char *buffer, char **start, off_t offset, int length, int dummy);

extern int udp6_get_info(char *buffer, char **start, off_t offset, int length, int dummy);

extern int tcp6_get_info(char *buffer, char **start, off_t offset, int length, int dummy);

extern int route6_get_info(char *buffer, char **start, off_t offset, int length, int dummy);

extern int igmpv6_procinfo(char *buffer, char **start, off_t offset, int length, int dummy);

extern int ndcache_procinfo(char *buffer, char **start, off_t offset, int length, int dummy);

#endif






