/*
 * DRET-IPv6	An implementation of the TCP/IP protocol suite for the LINUX
 *		operating system.  INET6 is implemented using the BSD Socket
 *		interface as the means of communication with the user level.
 *
 * Contacts:	
 *              INRIA      <Christophe.Diot@sophia.inria.fr>
 *              MASI       <Eric.Horlait@masi.ibp.fr>
 *              This software has been developped with the financial support
 *              of DRET (French Military Research Agency).
 *
 * Version:    $Id: nd.h,v 1.3 1997/03/05 20:46:15 pan Exp $ 
 *	
 * Authors:	
 *	        name	<E_mail>
 *
 *
 * Fixes:
 *
 *
 * Description:
 *
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 *              This notice must be copied with the distributed package.
 *
 *		Portions of the software are derived from  various 
 *		networking code publicly available, mainly:
 *			NRL IPv6 code 
 *			NetBSD code from INRIA (Francis.Dupont@inria.fr)
 *			Pedro Roque's Linux version (Roque@di.fc.up.pt)
 *
 */				

#ifndef _ND_H
#define _ND_H

#include <linux/config.h>

#ifdef CONFIG_NET_IPV6_DIM

#include <asm/atomic.h>
#include <linux/in.h>
#include <linux/skbuff.h>
#include <linux/netdevice.h>
#include <linux/dret/icmpv6.h>
#include <linux/dret/nd.h>

extern __inline__ void nd_fast_lock(void)
{
	atomic_inc(&nd_lock);
}

extern __inline__ void nd_fast_unlock(void)
{
	atomic_dec(&nd_lock);
}

extern __inline__ void nd_unlock(void)
{
	if (atomic_dec_and_test(&nd_lock) && nd_bh_mask)
	  /*	nd_run_bh();*/ {}
}

/*--------------------------------------------------------------------------

                     PROTOTYPES

----------------------------------------------------------------------------*/
#ifdef __KERNEL__  /* not compiled as module */

extern struct neighbor *nd_get_neighbor(struct device *dev, 
					struct in6_addr *addr);

extern int nd_eth_resolve(unsigned char *eth_dest, 
			  struct device *dev, 
			  struct sk_buff *skb);

extern int nd_event_rcv(struct sk_buff *skb, 
			struct device *dev, 
                        struct in6_addr *s, 
			struct in6_addr *d, 
                        struct options *opt, 
			unsigned len);

extern void  nd_init(void);

extern void nd_event_send_packet(struct neighbor *n);

#endif /* __KERNEL__ */
#endif

#endif /* _ND_H_ */








