/*
 * DRET-IPv6	An implementation of the TCP/IP protocol suite for the LINUX
 *		operating system.  INET6 is implemented using the BSD Socket
 *		interface as the means of communication with the user level.
 *
 * Contacts:	
 *              INRIA      <Christophe.Diot@sophia.inria.fr>
 *              MASI       <Eric.Horlait@masi.ibp.fr>
 *              This software has been developped with the financial support
 *              of DRET (French Military Research Agency).
 *
 * Version:    $Id: ipv6_route.h,v 1.1 1997/02/12 14:37:22 eh Exp $ 
 *	
 * Authors:	
 *	        name	<E_mail>
 *
 *
 * Fixes:
 *
 *
 * Description:
 *
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 *              This notice must be copied with the distributed package.
 *
 *		Portions of the software are derived from  various 
 *		networking code publicly available, mainly:
 *			NRL IPv6 code 
 *			NetBSD code from INRIA (Francis.Dupont@inria.fr)
 *			Pedro Roque's Linux version (Roque@di.fc.up.pt)
 *
 */				
#ifndef _NET_IPV6_ROUTE_H
#define _NET_IPV6_ROUTE_H

#include <linux/config.h>

#ifdef CONFIG_NET_IPV6_DIM

#include <net/dret/nd.h>



/* Routing functions */

/* Check dce coherency with given daddr (ipv6_output()) */
struct destination * ipv6_check_dce(struct destination *dst, struct in6_addr *d);

/* Find out destination cache entry for given daddr d */
struct destination * ip6_check_dest(struct in6_addr * d, unsigned char local);


#endif /* CONFIG_NET_IPV6_DIM */

#endif






